/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.iotdb.IoTDBPrivilegeInfo;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBAbstractUser;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBPrivilege;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBRelationalUser;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBUser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(IoTDBDataSource.class);
    private List<IoTDBAbstractUser> users;
    private final boolean isTree;
    private List<IoTDBPrivilege> privileges;

    public IoTDBDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, boolean tree) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new GenericSQLDialect());
        this.isTree = tree;
    }

    public List<IoTDBAbstractUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        if (this.users == null) {
            this.users = this.loadUsers(monitor);
        }
        return this.users;
    }

    private List<IoTDBAbstractUser> loadUsers(DBRProgressMonitor monitor) throws DBException {
        JDBCResultSet rs;
        JDBCStatement stmt;
        Object sql;
        JDBCSession session;
        Object var6_10;
        ArrayList<IoTDBAbstractUser> userList = new ArrayList<IoTDBAbstractUser>();
        String currentUserName = null;
        boolean hasManageUserPrivilege = false;
        try {
            Throwable throwable = null;
            var6_10 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Show Current User & Check Privileges");
                try {
                    sql = "show current_user";
                    stmt = session.createStatement();
                    rs = stmt.executeQuery((String)sql);
                    while (rs.next()) {
                        currentUserName = rs.getString("CurrentUser");
                        IoTDBAbstractUser user = this.isTree ? new IoTDBUser(this, currentUserName) : new IoTDBRelationalUser(this, currentUserName, monitor);
                        userList.add(user);
                    }
                    sql = "list privileges of user " + currentUserName;
                    stmt = session.createStatement();
                    rs = stmt.executeQuery((String)sql);
                    while (rs.next()) {
                        if (!rs.getString("Privileges").equals("MANAGE_USER")) continue;
                        hasManageUserPrivilege = true;
                        break;
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error showing current user or checking privileges", (Throwable)e);
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this);
        }
        if (!hasManageUserPrivilege) {
            return userList;
        }
        try {
            Throwable e = null;
            var6_10 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load Users");
                try {
                    sql = "list user";
                    stmt = session.createStatement();
                    rs = stmt.executeQuery((String)sql);
                    while (rs.next()) {
                        String tmpUserName = rs.getString("User");
                        if (tmpUserName.equals(currentUserName)) continue;
                        IoTDBAbstractUser user = this.isTree ? new IoTDBUser(this, tmpUserName) : new IoTDBRelationalUser(this, tmpUserName, monitor);
                        userList.add(user);
                    }
                    return userList;
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading users", (Throwable)e);
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this);
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.users = this.loadUsers(monitor);
        return this;
    }

    public List<IoTDBPrivilege> getAllPrivileges() {
        if (this.privileges == null) {
            this.generatePrivilegesList();
        }
        return this.privileges;
    }

    public List<IoTDBPrivilege> getPrivilegesByKind(boolean isGlobal) {
        ArrayList<IoTDBPrivilege> privs = new ArrayList<IoTDBPrivilege>();
        IoTDBPrivilegeInfo.Kind k = isGlobal ? IoTDBPrivilegeInfo.Kind.GLOBAL : (this.isTree ? IoTDBPrivilegeInfo.Kind.SERIES : IoTDBPrivilegeInfo.Kind.DATABASE);
        for (IoTDBPrivilege priv : this.getAllPrivileges()) {
            if (priv.getKind() != k) continue;
            privs.add(priv);
        }
        return privs;
    }

    public void generatePrivilegesList() {
        String[] globalPrivileges = this.isTree ? IoTDBPrivilegeInfo.treeGlobalPrivileges : IoTDBPrivilegeInfo.tableGlobalPrivileges;
        String[] dbPrivileges = this.isTree ? IoTDBPrivilegeInfo.treeSeriesPrivileges : IoTDBPrivilegeInfo.tableDatabasePrivileges;
        ArrayList<IoTDBPrivilege> newPrivileges = new ArrayList<IoTDBPrivilege>();
        String[] stringArray = globalPrivileges;
        int n = globalPrivileges.length;
        int n2 = 0;
        while (n2 < n) {
            String privilege = stringArray[n2];
            newPrivileges.add(new IoTDBPrivilege(this, privilege, IoTDBPrivilegeInfo.Kind.GLOBAL));
            ++n2;
        }
        IoTDBPrivilegeInfo.Kind kind = this.isTree ? IoTDBPrivilegeInfo.Kind.SERIES : IoTDBPrivilegeInfo.Kind.DATABASE;
        String[] stringArray2 = dbPrivileges;
        int n3 = dbPrivileges.length;
        n = 0;
        while (n < n3) {
            String privilege = stringArray2[n];
            newPrivileges.add(new IoTDBPrivilege(this, privilege, kind));
            ++n;
        }
        this.privileges = newPrivileges;
    }

    public IoTDBPrivilege getPrivilege(DBRProgressMonitor monitor, String name) throws DBException {
        return (IoTDBPrivilege)DBUtils.findObject(this.getAllPrivileges(), (String)name, (boolean)true);
    }

    public boolean isTree() {
        return this.isTree;
    }

    public boolean isTable() {
        return !this.isTree;
    }
}

