/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.services.IDisposable;

public class SlavePartService
implements IPartService,
IDisposable {
    private final IPartService parent;
    private final ListenerList listeners = new ListenerList(1);

    public SlavePartService(IPartService parentPartService) {
        if (parentPartService == null) {
            throw new IllegalArgumentException("The parent part service cannot be null");
        }
        this.parent = parentPartService;
    }

    @Override
    public void addPartListener(IPartListener listener) {
        this.listeners.add((Object)listener);
        this.parent.addPartListener(listener);
    }

    @Override
    public void addPartListener(IPartListener2 listener) {
        this.listeners.add((Object)listener);
        this.parent.addPartListener(listener);
    }

    @Override
    public IWorkbenchPart getActivePart() {
        return this.parent.getActivePart();
    }

    @Override
    public IWorkbenchPartReference getActivePartReference() {
        return this.parent.getActivePartReference();
    }

    @Override
    public void removePartListener(IPartListener listener) {
        this.listeners.remove((Object)listener);
        this.parent.removePartListener(listener);
    }

    @Override
    public void removePartListener(IPartListener2 listener) {
        this.listeners.remove((Object)listener);
        this.parent.removePartListener(listener);
    }

    @Override
    public void dispose() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IPartListener) {
                this.parent.removePartListener((IPartListener)listener);
            }
            if (listener instanceof IPartListener2) {
                this.parent.removePartListener((IPartListener2)listener);
            }
            ++n2;
        }
        this.listeners.clear();
    }
}

