searchData={"items":[{"type":"module","title":"compile","doc":"Erlang Compiler\n\nThis module provides an interface to the standard Erlang compiler. It can\ngenerate either a file containing the object code or return a binary\nthat can be loaded directly.","ref":"compile.html"},{"type":"module","title":"Default Compiler Options - compile","doc":"The (host operating system) environment variable `ERL_COMPILER_OPTIONS` can be\nused to give default compiler options. Its value must be a valid Erlang term. If\nthe value is a list, it is used as is. If it is not a list, it is put into a\nlist.\n\nThe list is appended to any options given to `file/2`, `forms/2`, and\n[output_generated/2](`output_generated/1`). Use the alternative functions\n`noenv_file/2`, `noenv_forms/2`, or\n[noenv_output_generated/2](`noenv_output_generated/1`) if you do not want the\nenvironment variable to be consulted, for example, if you are calling the\ncompiler recursively from inside a parse transform.\n\nThe list can be retrieved with `env_compiler_options/0`.","ref":"compile.html#module-default-compiler-options"},{"type":"module","title":"Order of Compiler Options - compile","doc":"Options given in the `compile()` attribute in the source code take\nprecedence over options given to the compiler, which in turn take\nprecedence over options given in the environment.\n\nA later compiler option takes precedence over an earlier one in the\noption list. Example:\n\n```\ncompile:file(something, [nowarn_missing_spec,warn_missing_spec]).\n```\n\nWarnings will be emitted for functions without specifications, unless\nthe source code for module `something` contains a `compile(nowarn_missing_spec)`\nattribute.\n\n> #### Change {: .info }\n>\n> In Erlang/OTP 26 and earlier, the option order was the opposite of what\n> is described here.","ref":"compile.html#module-order-of-compiler-options"},{"type":"module","title":"Inlining - compile","doc":"The compiler can do function inlining within an Erlang\nmodule. Inlining means that a call to a function is replaced with the\nfunction body with the arguments replaced with the actual values. The\nsemantics are preserved, except if exceptions are generated in the\ninlined code, in which case exceptions are reported as occurring in\nthe function the body was inlined into. Also, `function_clause`\nexceptions are converted to similar `case_clause` exceptions.\n\nWhen a function is inlined, the original function is kept if it is exported\n(either by an explicit export or if the option `export_all` was given) or if not\nall calls to the function are inlined.\n\nInlining does not necessarily improve running time. For example, inlining can\nincrease Beam stack use, which probably is detrimental to performance for\nrecursive functions.\n\nInlining is never default. It must be explicitly enabled with a compiler option\nor a `-compile()` attribute in the source module.\n\nTo enable inlining, either use the option `inline` to let the compiler decide\nwhich functions to inline, or `{inline,[{Name,Arity},...]}` to have the compiler\ninline all calls to the given functions. If the option is given inside a\n`compile` directive in an Erlang module, `{Name,Arity}` can be written as\n`Name/Arity`.\n\nExample of explicit inlining:\n\n```erlang\n-compile({inline,[pi/0]}).\n\npi() -> 3.1416.\n```\n\nExample of implicit inlining:\n\n```text\n-compile(inline).\n```\n\nThe option `{inline_size,Size}` controls how large functions that are allowed to\nbe inlined. Default is `24`, which keeps the size of the inlined code roughly\nthe same as the un-inlined version (only relatively small functions are\ninlined).\n\nExample:\n\n```erlang\n%% Aggressive inlining - will increase code size.\n-compile(inline).\n-compile({inline_size,100}).\n```","ref":"compile.html#module-inlining"},{"type":"module","title":"Inlining of List Functions - compile","doc":"The compiler can also inline various list manipulation functions from the module\n`list` in STDLIB.\n\nThis feature must be explicitly enabled with a compiler option or a `-compile()`\nattribute in the source module.\n\nTo enable inlining of list functions, use option `inline_list_funcs`.\n\nThe following functions are inlined:\n\n- `lists:all/2`\n- `lists:any/2`\n- `lists:foreach/2`\n- `lists:map/2`\n- `lists:flatmap/2`\n- `lists:filter/2`\n- `lists:foldl/3`\n- `lists:foldr/3`\n- `lists:mapfoldl/3`\n- `lists:mapfoldr/3`","ref":"compile.html#module-inlining-of-list-functions"},{"type":"module","title":"Parse Transformations - compile","doc":"Parse transformations are used when a programmer wants to use Erlang syntax but\nwith different semantics. The original Erlang code is then transformed into\nother Erlang code.\n\nSee `m:erl_id_trans` for an example and an explanation of the function\n`parse_transform_info/0`.","ref":"compile.html#module-parse-transformations"},{"type":"module","title":"See Also - compile","doc":"`m:epp`, `m:erl_expand_records`, `m:erl_id_trans`, `m:erl_lint`, `m:beam_lib`","ref":"compile.html#module-see-also"},{"type":"type","title":"compile.abstract_code/0","doc":"","ref":"compile.html#t:abstract_code/0"},{"type":"type","title":"compile.bin_ret/0","doc":"","ref":"compile.html#t:bin_ret/0"},{"type":"type","title":"compile.comp_ret/0","doc":"","ref":"compile.html#t:comp_ret/0"},{"type":"function","title":"compile.env_compiler_options/0","doc":"Return compiler options given via the environment variable\n`ERL_COMPILER_OPTIONS`. If the value is a list, it is returned as is. If it is\nnot a list, it is put into a list.","ref":"compile.html#env_compiler_options/0"},{"type":"type","title":"compile.err_ret/0","doc":"","ref":"compile.html#t:err_ret/0"},{"type":"type","title":"compile.error_description/0","doc":"","ref":"compile.html#t:error_description/0"},{"type":"type","title":"compile.error_info/0","doc":"","ref":"compile.html#t:error_info/0"},{"type":"type","title":"compile.errors/0","doc":"","ref":"compile.html#t:errors/0"},{"type":"function","title":"compile.file/1","doc":"Is the same as\n[`file(File, [verbose,report_errors,report_warnings])`](`file/2`).","ref":"compile.html#file/1"},{"type":"function","title":"compile.file/2","doc":"Compiles the code in the file `File`, which is an Erlang source code file\nwithout the `.erl` extension.\n\n`Options` determine the behavior of the compiler.\n\nReturns `{ok,ModuleName}` if successful, or `error` if there are errors. An\nobject code file is created if the compilation succeeds without errors. It is\nconsidered to be an error if the module name in the source code is not the same\nas the basename of the output file.\n\nAvailable options:\n\n- **`brief`** - Restricts error and warning messages to a single line\n  of output.  As of Erlang/OTP 24, the compiler will by default also\n  display the part of the source code that the message refers to.\n\n- **`basic_validation`** - This option is a fast way to test whether a module\n  will compile successfully. This is useful for code generators that want to\n  verify the code that they emit. No code is generated. If warnings are enabled,\n  warnings generated by the `erl_lint` module (such as warnings for unused\n  variables and functions) are also returned.\n\n  Use option `strong_validation` to generate all warnings that the compiler\n  would generate.\n\n- **`strong_validation`** - Similar to option `basic_validation`. No code is\n  generated, but more compiler passes are run to ensure that warnings generated\n  by the optimization passes are generated (such as clauses that will not match,\n  or expressions that are guaranteed to fail with an exception at runtime).\n\n- **`no_docs`**{: #no_docs } - The compiler by default extracts\n  [documentation](`e:system:documentation.md`) from\n  [`-doc` attributes](`e:system:modules.md#documentation-attributes`) and places\n  them in the [`Docs` chunk](`t:beam_lib:chunkid/0`) according to\n  [EEP-48](`e:kernel:eep48_chapter.md`).\n\n  This option switches off the placement of\n  [`-doc` attributes](`e:system:modules.md#documentation-attributes`) in the\n  [`Docs` chunk](`t:beam_lib:chunkid/0`).\n\n- **`binary`** - The compiler returns the object code in a binary instead of\n  creating an object file. If successful, the compiler returns\n  `{ok,ModuleName,Binary}`.\n\n- **`bin_opt_info`** - The compiler will emit informational warnings about\n  binary matching optimizations (both successful and unsuccessful). For more\n  information, see the section about\n  [bin_opt_info](`e:system:binaryhandling.md#bin_opt_info`) in the Efficiency\n  Guide.\n\n- **`{compile_info, [{atom(), term()}]}`** - Allows compilers built on top of\n  `compile` to attach extra compilation metadata to the `compile_info` chunk in\n  the generated BEAM file.\n\n  It is advised for compilers to remove all non-deterministic information if the\n  `deterministic` option is supported and it was supplied by the user.\n\n- **`compressed`** - The compiler will compress the generated object code, which\n  can be useful for embedded systems.\n\n- **`debug_info`** - [](){: #debug_info } Includes debug information in the form\n  of [Erlang Abstract Format](`e:erts:absform.md`) in the `debug_info` chunk of\n  the compiled beam module. Tools such as Debugger, Xref, and Cover require the\n  debug information to be included.\n\n  _Warning_: Source code can be reconstructed from the debug information. Use\n  encrypted debug information (`encrypt_debug_info`) to prevent this.\n\n  For details, see [beam_lib(3)](`m:beam_lib#debug_info`).\n\n- **`{debug_info, {Backend, Data}}`** - [](){: #debug_info_backend } Includes\n  custom debug information in the form of a `Backend` module with custom `Data`\n  in the compiled beam module. The given module must implement a `debug_info/4`\n  function and is responsible for generating different code representations, as\n  described in the `debug_info` under [beam_lib(3)](`m:beam_lib#debug_info`).\n\n  _Warning_: Source code can be reconstructed from the debug information. Use\n  encrypted debug information (`encrypt_debug_info`) to prevent this.\n\n- **`{debug_info_key,KeyString}`**\n\n- **`{debug_info_key,{Mode,KeyString}}`** - [](){: #debug_info_key } Includes\n  debug information, but encrypts it so that it cannot be accessed without\n  supplying the key. (To give option `debug_info` as well is allowed, but not\n  necessary.) Using this option is a good way to always have the debug\n  information available during testing, yet protecting the source code.\n\n  `Mode` is the type of crypto algorithm to be used for encrypting the debug\n  information. The default (and currently the only) type is `des3_cbc`.\n\n  For details, see [beam_lib(3)](`m:beam_lib#debug_info`).\n\n- **`encrypt_debug_info`** - [](){: #encrypt_debug_info } Similar to the\n  `debug_info_key` option, but the key is read from an `.erlang.crypt` file.\n\n  For details, see [beam_lib(3)](`m:beam_lib#debug_info`).\n\n- **`deterministic`** - Omit the `options` and `source` tuples in the list\n  returned by `Module:module_info(compile)`, and reduce the paths in stack\n  traces to the module name alone. This option will make it easier to achieve\n  reproducible builds.\n\n- **`{feature, Feature, enable | disable}`** - [](){: #feature-option } Enable\n  (disable) the [feature](`e:system:features.md#features`) `Feature` during\n  compilation. The special feature `all` can be used to enable (disable) all\n  features.\n\n  > #### Note {: .info }\n  >\n  > This option has no effect when used in a `-compile(..)` attribute. Instead,\n  > the `-feature(..)` directive (described next) should be used.\n  >\n  > [](){: #feature-directive } A feature can also be enabled (disabled) using\n  > the `-feature(Feature, enable | disable).` module directive. Note that this\n  > directive can only be present in a prefix of the file, before exports and\n  > function definitions. This is the preferred method of enabling and disabling\n  > features, since it is a local property of a module.\n\n- **`makedep`** - Produces a Makefile rule to track headers dependencies. No\n  object file is produced.\n\n  By default, this rule is written to ` .Pbeam`. However, if option\n  `binary` is set, nothing is written and the rule is returned in `Binary`.\n\n  The output will be encoded in UTF-8.\n\n  For example, if you have the following module:\n\n  ```erlang\n  -module(module).\n\n  -include_lib(\"eunit/include/eunit.hrl\").\n  -include(\"header.hrl\").\n  ```\n\n  The Makefile rule generated by this option looks as follows:\n\n  ```text\n  module.beam: module.erl \\\n    /usr/local/lib/erlang/lib/eunit/include/eunit.hrl \\\n    header.hrl\n  ```\n\n- **`makedep_side_effect`** - The dependencies are created as a side effect to\n  the normal compilation process. This means that the object file will also be\n  produced. This option override the `makedep` option.\n\n- **`{makedep_output, Output}`** - Writes generated rules to `Output` instead of\n  the default ` .Pbeam`. `Output` can be a filename or an `io_device()`. To\n  write to stdout, use `standard_io`. However, if `binary` is set, nothing is\n  written to `Output` and the result is returned to the caller with\n  `{ok, ModuleName, Binary}`.\n\n- **`{makedep_target, Target}`** - Changes the name of the rule emitted to\n  `Target`.\n\n- **`makedep_quote_target`** - Characters in `Target` special to make(1) are\n  quoted.\n\n- **`makedep_add_missing`** - Considers missing headers as generated files and\n  adds them to the dependencies.\n\n- **`makedep_phony`** - Adds a phony target for each dependency.\n\n- **`'P'`** - Produces a listing of the parsed code, after preprocessing and\n  parse transforms, in the file ` .P`. No object file is produced.\n\n- **`'E'`** - Produces a listing of the code, after all source code\n  transformations have been performed, in the file ` .E`. No object file is\n  produced.\n\n- **`'S'`** - Produces a listing of the assembler code in the file ` .S`.\n  No object file is produced.\n\n- **`recv_opt_info`** - The compiler will emit informational warnings about\n  selective `receive` optimizations (both successful and unsuccessful). For more\n  information, see the section about\n  [selective receive optimization](`e:system:eff_guide_processes.md#receiving-messages`)\n  in the Efficiency Guide.\n\n- **`report_errors/report_warnings`** - Causes errors/warnings to be printed as\n  they occur.\n\n- **`report`** - A short form for both `report_errors` and `report_warnings`.\n\n- **`return_errors`** - If this flag is set, `{error,ErrorList,WarningList}` is\n  returned when there are errors.\n\n- **`return_warnings`** - If this flag is set, an extra field, containing\n  `WarningList`, is added to the tuples returned on success.\n\n- **`warnings_as_errors`** - Causes warnings to be treated as errors.\n\n- **`{error_location,line | column}`** - If the value of this flag is `line`,\n  the location [`ErrorLocation`](`m:compile#error_information`) of warnings and\n  errors is a line number. If the value is `column`, `ErrorLocation` includes\n  both a line number and a column number. Default is `column`. This option is\n  supported since Erlang/OTP 24.0.\n\n  If the value of this flag is `column`,\n  [debug information](`m:compile#debug_info`) includes column information.\n\n- **`return`** - A short form for both `return_errors` and `return_warnings`.\n\n- **`verbose`** - Causes more verbose information from the compiler, describing\n  what it is doing.\n\n- **`{source,FileName}`** - Overrides the source file name as presented in\n  `module_info(compile)` and stack traces.\n\n- **`absolute_source`** - Turns the source file name (as presented in\n  `module_info(compile)` and stack traces) into an absolute path, which helps\n  external tools like `perf` and `gdb` find Erlang source code.\n\n- **`{outdir,Dir}`** - Sets a new directory for the object code. The current\n  directory is used for output, except when a directory has been specified with\n  this option.\n\n- **`export_all`** - Causes all functions in the module to be exported.\n\n- **`{i,Dir}`** - Adds `Dir` to the list of directories to be searched when\n  including a file. When encountering an `-include` or `-include_lib` directive,\n  the compiler searches for header files in the following directories:\n\n  1. `\".\"`, the current working directory of the file server\n  1. The base name of the compiled file\n  1. The directories specified using option `i`; the directory specified last is\n     searched first\n\n- **`{d,Macro}`**\n\n- **`{d,Macro,Value}`** - Defines a macro `Macro` to have the value `Value`.\n  `Macro` is of type atom, and `Value` can be any term. The default `Value` is\n  `true`.\n\n- **`{parse_transform,Module}`** - Causes the parse transformation function\n  `Module:parse_transform/2` to be applied to the parsed code before the code is\n  checked for errors.\n\n- **`from_abstr`** - The input file is expected to contain Erlang terms\n  representing forms in abstract format (default file suffix \".abstr\"). Note\n  that the format of such terms can change between releases.\n\n  See also the `no_lint` option.\n\n- **`from_asm`** - The input file is expected to be assembler code (default file\n  suffix \".S\"). Notice that the format of assembler files is not documented, and\n  can change between releases.\n\n- **`from_core`** - The input file is expected to be core code (default file\n  suffix \".core\"). Notice that the format of core files is not documented, and\n  can change between releases.\n\n- **`no_spawn_compiler_process`** - By default, all code is compiled in a\n  separate process which is terminated at the end of compilation. However, some\n  tools, like Dialyzer or compilers for other BEAM languages, may already manage\n  their own worker processes and spawning an extra process may slow the\n  compilation down. In such scenarios, you can pass this option to stop the\n  compiler from spawning an additional process.\n\n- **`no_strict_record_tests`** - This option is not recommended.\n\n  By default, the generated code for operation `Record#record_tag.field`\n  verifies that the tuple `Record` has the correct size for the record, and that\n  the first element is the tag `record_tag`. Use this option to omit the\n  verification code.\n\n- **`no_error_module_mismatch`** - Normally the compiler verifies that\n  the module name given in the source code is the same as the base\n  name of the output file and refuses to generate an output file if\n  there is a mismatch. If there is a good reason for having a module\n  name unrelated to the name of the output file, this option disables\n  that verification (there will not even be a warning if there is a\n  mismatch).\n\n- **`{no_auto_import,[{F,A}, ...]}`** - Makes the function `F/A` no longer being\n  auto-imported from the `erlang` module, which resolves BIF name clashes. This\n  option must be used to resolve name clashes with auto-imported BIFs that existed\n  before Erlang/OTP R14A  when calling a local function with the same name\n  as an auto-imported BIF without module prefix.\n\n  If the BIF is to be called, use the `erlang` module prefix\n  in the call, not `{no_auto_import,[{F,A}, ...]}`.\n\n  If this option is written in the source code, as a `-compile` directive, the\n  syntax `F/A` can be used instead of `{F,A}`. For example:\n\n  ```erlang\n  -compile({no_auto_import,[error/1]}).\n  ```\n\n- **`no_auto_import`** - Do not auto-import any functions from `erlang` module.\n\n- **`no_line_info`** - Omits line number information to produce a slightly\n  smaller output file.\n\n- **`no_lint`** - Skips the pass that checks for errors and warnings. Only\n  applicable together with the `from_abstr` option. This is mainly for\n  implementations of other languages on top of Erlang, which have already done\n  their own checks to guarantee correctness of the code.\n\n  Caveat: When this option is used, there are no guarantees that the code output\n  by the compiler is correct and safe to use. The responsibility for correctness\n  lies on the code or person generating the abstract format. If the code\n  contains errors, the compiler may crash or produce unsafe code.\n\n- **`{extra_chunks, [{binary(), binary()}]}`** - Pass extra chunks to be stored\n  in the `.beam` file. The extra chunks must be a list of tuples with a four\n  byte binary as chunk name followed by a binary with the chunk contents. See\n  `m:beam_lib` for more information.\n\n- **`{check_ssa, Tag :: atom()}`** - Parse and check assertions on the structure\n  and content of the BEAM SSA code produced by the compiler. The `Tag` indicates\n  the set of assertions to check and after which compiler pass the check is\n  performed. This option is internal to the compiler and can be changed or\n  removed at any time without prior warning.\n\n- **`line_coverage`** - [](){: #line_coverage } Instrument the compiled code for\n  line coverage by inserting an `executable_line` instruction for each\n  executable line in the source code. By default, this instruction will be\n  ignored when loading the code.\n\n  To activate the `executable_line` instructions, the runtime system must be\n  started with the option [\\+JPcover](`e:erts:erl_cmd.md#%2BJPcover`) to enable\n  a coverage mode. Alternatively, `code:set_coverage_mode/1` can be used to set\n  a coverage mode before loading the code.\n\n  The coverage information gathered by the instrumented code can be retrieved by\n  calling [code:get_coverage(line, Module)](`code:get_coverage/2`).\n\n- **`force_line_counters`** - [](){: #force_line_counters } When combined with\n  option `line_coverage`, this module will be loaded in the `line_counter`\n  coverage mode, regardless of the current\n  [coverage mode](`code:get_coverage_mode/0`) in the runtime system. This option\n  is used by `m:cover` to load cover-compiled code.\n\nIf warnings are turned on (option `report_warnings` described earlier), the\nfollowing options control what type of warnings that are generated. [](){:\n#erl_lint_options } Except from `{warn_format,Verbosity}`, the following options\nhave two forms:\n\n- A `warn_xxx` form, to turn on the warning.\n- A `nowarn_xxx` form, to turn off the warning.\n\nIn the descriptions that follow, the form that is used to change the default\nvalue are listed.\n\n- **`{warn_format, Verbosity}`** - Causes warnings to be emitted for malformed\n  format strings as arguments to `io:format` and similar functions.\n\n  `Verbosity` selects the number of warnings:\n\n  - `0` = No warnings\n  - `1` = Warnings for invalid format strings and incorrect number of arguments\n  - `2` = Warnings also when the validity cannot be checked, for example, when\n    the format string argument is a variable.\n\n  The default verbosity is `1`. Verbosity `0` can also be selected by option\n  `nowarn_format`.\n\n- **`nowarn_bif_clash`** - This option is removed; it generates a fatal error if\n  used.\n\n  To resolve BIF clashes, use explicit module names or the\n  `{no_auto_import,[F/A]}` compiler directive.\n\n- **`{nowarn_bif_clash, FAs}`** - This option is removed; it generates a fatal\n  error if used.\n\n  To resolve BIF clashes, use explicit module names or the\n  `{no_auto_import,[F/A]}` compiler directive.\n\n- **`nowarn_export_all`** - Turns off warnings for uses of the `export_all`\n  option. Default is to emit a warning if option `export_all` is also given.\n\n- **`warn_export_vars`** - Emits warnings for all implicitly exported variables\n  referred to after the primitives where they were first defined. By default,\n  the compiler only emits warnings for exported variables referred to in a\n  pattern.\n\n- **`nowarn_shadow_vars`** - Turns off warnings for \"fresh\" variables in\n  functional objects or list comprehensions with the same name as some already\n  defined variable. Default is to emit warnings for such variables.\n\n- **`warn_keywords`** - [](){: #warn-keywords } Emits warnings when the code\n  contains atoms that are used as keywords in some\n  [feature](`e:system:features.md#features`). When the feature is enabled, any\n  occurrences will lead to a syntax error. To prevent this, the atom has to be\n  renamed or quoted.\n\n- **`nowarn_unused_function`** - Turns off warnings for unused local functions.\n  Default is to emit warnings for all local functions that are not called\n  directly or indirectly by an exported function. The compiler does not include\n  unused local functions in the generated BEAM file, but the warning is still\n  useful to keep the source code cleaner.\n\n- **`{nowarn_unused_function, FAs}`** - Turns off warnings for unused local\n  functions like `nowarn_unused_function` does, but only for the mentioned local\n  functions. `FAs` is a tuple `{Name,Arity}` or a list of such tuples.\n\n- **`nowarn_deprecated_function`** - Turns off warnings for calls to deprecated\n  functions. Default is to emit warnings for every call to a function known by\n  the compiler to be deprecated. Notice that the compiler does not know about\n  attribute `-deprecated()`, but uses an assembled list of deprecated functions\n  in Erlang/OTP. To do a more general check, the Xref tool can be used. See also\n  [xref(3)](`m:xref#deprecated_function`) and the function `xref:m/1`, also\n  accessible through the function `\\c:xm/1`.\n\n- **`{nowarn_deprecated_function, MFAs}`** - Turns off warnings for calls to\n  deprecated functions like `nowarn_deprecated_function` does, but only for the\n  mentioned functions. `MFAs` is a tuple `{Module,Name,Arity}` or a list of such\n  tuples.\n\n- **`nowarn_deprecated_type`** - Turns off warnings for use of deprecated types.\n  Default is to emit warnings for every use of a type known by the compiler to\n  be deprecated.\n\n- **`nowarn_deprecated_callback`** - Turns off warnings for use of deprecated callbacks.\n  Default is to emit warnings for every use of a callback known by the compiler to\n  be deprecated.\n\n- **`warn_deprecated_catch`** - Enables warnings for use of old style catch\n  expressions of the form `catch Expr` instead of the modern `try ... catch\n  ... end`. You may enable this compiler option on the project level and\n  add `-compile(nowarn_deprecated_catch).` to individual files which still\n  contain old catches in order to prevent new uses from getting added.\n\n- **`nowarn_removed`** - Turns off warnings for calls to functions that have\n  been removed. Default is to emit warnings for every call to a function known\n  by the compiler to have been recently removed from Erlang/OTP.\n\n- **`{nowarn_removed, ModulesOrMFAs}`** - Turns off warnings for calls to\n  modules or functions that have been removed. Default is to emit warnings for\n  every call to a function known by the compiler to have been recently removed\n  from Erlang/OTP.\n\n- **`nowarn_obsolete_guard`** - Turns off warnings for calls to old type testing\n  BIFs, such as `pid/1` and [`list/1`](`t:list/1`). See the\n  [Erlang Reference Manual](`e:system:expressions.md#guards`) for a complete\n  list of type testing BIFs and their old equivalents. Default is to emit\n  warnings for calls to old type testing BIFs.\n\n- **`warn_unused_import`** - Emits warnings for unused imported functions.\n  Default is to emit no warnings for unused imported functions.\n\n- **`nowarn_underscore_match`** - By default, warnings are emitted when a\n  variable that begins with an underscore is matched after being bound. Use this\n  option to turn off this kind of warning.\n\n- **`nowarn_unused_vars`** - By default, warnings are emitted for unused\n  variables, except for variables beginning with an underscore (\"Prolog style\n  warnings\"). Use this option to turn off this kind of warning.\n\n- **`nowarn_unused_record`** - Turns off warnings for unused record definitions.\n  Default is to emit warnings for unused locally defined records.\n\n- **`{nowarn_unused_record, RecordNames}`** - Turns off warnings for unused\n  record definitions. Default is to emit warnings for unused locally defined\n  records.\n\n- **`nowarn_unused_type`** - Turns off warnings for unused type declarations.\n  Default is to emit warnings for unused local type declarations.\n\n- **`nowarn_nif_inline`** - By default, warnings are emitted when inlining is\n  enabled in a module that may load NIFs, as the compiler may inline NIF\n  fallbacks by accident. Use this option to turn off this kind of warnings.\n\n- **`warn_missing_doc` | `warn_missing_doc_functions` | `warn_missing_doc_types` | `warn_missing_doc_callbacks` **{: #warn_missing_doc }  \n  By default, warnings are not emitted when `-doc` attribute for an exported function,\n  callback or type is not given. Use these option to turn on this kind of warning.\n  `warn_missing_doc` is equivalent to setting all of `warn_missing_doc_functions`,\n  `warn_missing_doc_types` and `warn_missing_doc_callbacks`.\n\n- **`nowarn_missing_doc` | `nowarn_missing_doc_functions` | `nowarn_missing_doc_types` | `nowarn_missing_doc_callbacks` **  \n  If warnings are enabled by [`warn_missing_doc`](#warn_missing_doc), then you can use\n  these options turn those warnings off again.\n  `nowarn_missing_doc` is equivalent to setting all of `nowarn_missing_doc_functions`,\n  `nowarn_missing_doc_types` and `nowarn_missing_doc_callbacks`.\n\n- **`nowarn_hidden_doc` | `{nowarn_hidden_doc,NAs}`**{: #nowarn_hidden_doc }  \n  By default, warnings are emitted when `-doc false` attribute is set on a\n  [callback or referenced type](`e:system:documentation.md#what-is-visible-versus-hidden`).\n  You can set `nowarn_hidden_doc` to suppress all those warnings, or `{nowarn_hidden_doc, NAs}`\n  to suppress specific callbacks or types. `NAs` is a tuple `{Name, Arity}` or a\n  list of such tuples.\n\n- **`warn_missing_spec`** - By default, warnings are not emitted when a\n  specification (or contract) for an exported function is not given. Use this\n  option to turn on this kind of warning.\n\n- **`warn_missing_spec_documented`** - By default, warnings are not emitted when a\n  specification (or contract) for a documented function is not given. Use this\n  option to turn on this kind of warning.\n\n- **`warn_missing_spec_all`** - By default, warnings are not emitted when a\n  specification (or contract) for an exported or unexported function is not\n  given. Use this option to turn on this kind of warning.\n\n- **`nowarn_redefined_builtin_type`** - By default, a warning is emitted when a\n  built-in type is locally redefined. Use this option to turn off this kind of\n  warning.\n\n- **`{nowarn_redefined_builtin_type, Types}`** - By default, a warning is\n  emitted when a built-in type is locally redefined. Use this option to turn off\n  this kind of warning for the types in `Types`, where `Types` is a tuple\n  `{TypeName,Arity}` or a list of such tuples.\n\n- **`nowarn_behaviours`** - By default, warnings are emitted for issues\n  with behaviours. Use this option to turn off all warnings of this kind.\n\n- **`nowarn_conflicting_behaviours`** - By default, warnings are emitted when\n  a module opts in to multiple behaviours that share the names of one or more\n  callback functions. Use this option to turn off this kind of warning.\n\n- **`nowarn_undefined_behaviour_func`** - By default, a warning is\n  emitted when a module that uses a behaviour does not export a\n  mandatory callback function required by that behaviour. Use this\n  option to turn off this kind of warning.\n\n- **`nowarn_undefined_behaviour`** - By default, a warning is emitted\n  when a module attempts to us an unknown behaviour. Use this option\n  to turn off this kind of warning.\n\n- **`nowarn_undefined_behaviour_callbacks`** - By default, a warning\n  is emitted when `behaviour_info(callbacks)` in the behaviour module\n  returns `undefined` instead of a list of callback functions. Use this\n  option to turn off this kind of warning.\n\n- **`nowarn_ill_defined_behaviour_callbacks`** - By default, a warning\n  is emitted when `behaviour_info(callbacks)` in the behaviour module\n  returns a badly formed list of functions. Use this option to turn\n  off this kind of warning.\n\n- **`nowarn_ill_defined_optional_callbacks`** - By default, a warning\n  is emitted when `behaviour_info(optional_callbacks)` in the\n  behaviour module returns a badly formed list of functions. Use this\n  option to turn off this kind of warning.\n\nOther kinds of warnings are _opportunistic warnings_. They are generated when\nthe compiler happens to notice potential issues during optimization and code\ngeneration.\n\n> #### Note {: .info }\n>\n> The compiler does not warn for expressions that it does not attempt to\n> optimize. For example, the compiler will emit a warning for `1/0` but not for\n> `X/0`, because `1/0` is a constant expression that the compiler will attempt\n> to evaluate.\n>\n> The absence of warnings does not mean that there are no remaining errors in\n> the code.\n\nOpportunistic warnings can be disabled using the following options:\n\n- **`nowarn_opportunistic`** - Disable all opportunistic warnings.\n\n- **`nowarn_failed`** - Disable warnings for expressions that will always fail\n  (such as `atom+42`).\n\n- **`nowarn_ignored`** - Disable warnings for expressions whose values are\n  ignored.\n\n- **`nowarn_nomatch`** - Disable warnings for patterns that will never match\n  (such as `a=b`) and for guards that always evaluate to `false`.\n\n> #### Note {: .info }\n>\n> All options, except the include path (`{i,Dir}`), can also be given in the\n> file with attribute `-compile([Option,...])`. Attribute `-compile()` is\n> allowed after the function definitions.\n\n> #### Note {: .info }\n>\n> Before Erlang/OTP 22, the option `{nowarn_deprecated_function, MFAs}` was only\n> recognized when given in the file with attribute `-compile()`. (The option\n> `{nowarn_unused_function,FAs}` was incorrectly documented to only work in a\n> file, but it also worked when given in the option list.) Starting from\n> Erlang/OTP 22, all options that can be given in the file can also be given\n> in the option list.\n\nFor debugging of the compiler, or for pure curiosity, the intermediate code\ngenerated by each compiler pass can be inspected. To print a complete list of\nthe options to produce list files, type `compile:options()` at the Erlang shell\nprompt. The options are printed in the order that the passes are executed. If\nmore than one listing option is used, the one representing the earliest pass\ntakes effect.\n\nUnrecognized options are ignored.\n\nBoth `WarningList` and `ErrorList` have the following format:\n\n```text\n[{FileName,[ErrorInfo]}].\n```\n\nThe filename is included here, as the compiler uses the Erlang\npre-processor `epp`, which allows the code to be included in other\nfiles. It is therefore important to know to _which_ file the location\nof an error or a warning refers.\n\n[](){: #error_information }\n\nThe `ErrorInfo` structure has the following format:\n\n```text\n{ErrorLocation, Module, ErrorDescriptor}\n```\n\n`ErrorLocation` is usually the tuple `{Line, Column}`. If option\n`{error_location,line}` has been given, `ErrorLocation` is only the\nline number.  If the error does not correspond to a specific location\n(for example, if the source file does not exist), `ErrorLocation` is\nthe atom `none`.\n\nA string describing the error is obtained with the following call:\n\n```text\nModule:format_error(ErrorDescriptor)\n```","ref":"compile.html#file/2"},{"type":"function","title":"compile.format_error/1","doc":"Uses an `ErrorDescriptor` and returns a deep list of characters that describes\nthe error.\n\nThis function is usually called implicitly when an `ErrorInfo`\nstructure is processed.","ref":"compile.html#format_error/1"},{"type":"type","title":"compile.forms/0","doc":"List of Erlang abstract or Core Erlang format representations, as used by\n`forms/2`.","ref":"compile.html#t:forms/0"},{"type":"function","title":"compile.forms/1","doc":"Is the same as\n[`forms(Forms, [verbose,report_errors,report_warnings])`](`forms/2`).","ref":"compile.html#forms/1"},{"type":"function","title":"compile.forms/2","doc":"Analogous to [`file/1`](`file/1`), but takes a list of forms (in either Erlang\nabstract or Core Erlang format representation) as first argument.\n\nOption `binary` is implicit, that is, no object code file is\nproduced. For options that normally produce a listing file, such as\n'E', the internal format for that compiler pass (an Erlang term,\nusually not a binary) is returned instead of a binary.","ref":"compile.html#forms/2"},{"type":"type","title":"compile.mod_ret/0","doc":"","ref":"compile.html#t:mod_ret/0"},{"type":"function","title":"compile.noenv_file/2","doc":"Works like `file/2`, except that the environment variable `ERL_COMPILER_OPTIONS`\nis not consulted.","ref":"compile.html#noenv_file/2"},{"type":"function","title":"compile.noenv_forms/2","doc":"Works like `forms/2`, except that the environment variable\n`ERL_COMPILER_OPTIONS` is not consulted.","ref":"compile.html#noenv_forms/2"},{"type":"function","title":"compile.noenv_output_generated/1","doc":"Works like `output_generated/1`, except that the environment variable\n`ERL_COMPILER_OPTIONS` is not consulted.","ref":"compile.html#noenv_output_generated/1"},{"type":"type","title":"compile.option/0","doc":"See `file/2` for detailed description.","ref":"compile.html#t:option/0"},{"type":"function","title":"compile.output_generated/1","doc":"Determines whether the compiler generates a BEAM file with the given options.\n\n`true` means that a BEAM file is generated. `false` means that the compiler\ngenerates some listing file, returns a binary, or merely checks the syntax of\nthe source code.","ref":"compile.html#output_generated/1"},{"type":"type","title":"compile.warnings/0","doc":"","ref":"compile.html#t:warnings/0"},{"type":"module","title":"cerl","doc":"Core Erlang abstract syntax trees.\n\n> #### Note {: .info }\n>\n> The public interface of the Erlang compiler can be found in\n> module `m:compile`.\n>\n> This module is an internal part of the compiler. Its API is not guaranteed\n> to remain compatible between releases.\n\nThis module defines an abstract data type for representing Core Erlang source\ncode as syntax trees.\n\nA recommended starting point for the first-time user is the documentation of the\nfunction `type/1`.\n\n> #### Note {: .info }\n>\n> This module deals with the composition and decomposition of _syntactic_ entities\n> (as opposed to semantic ones); its purpose is to hide all direct references to\n> the data structures used to represent these entities. With few exceptions, the\n> functions in this module perform no semantic interpretation of their inputs, and\n> in general, the user is assumed to pass type-correct arguments - if this is not\n> done, the effects are not defined.\n>\n> Currently, the internal data structure used is the same as the record-based data\n> structures used traditionally in the Beam compiler.\n>\n> The internal representations of abstract syntax trees are subject to change\n> without notice, and should not be documented outside this module. Furthermore,\n> we do not give any guarantees on how an abstract syntax tree may or may not be\n> represented, _with the following exceptions_: no syntax tree is represented by a\n> single atom, such as `none`, by a list constructor `[X | Y]`, or by the empty\n> list `[]`. This can be relied on when writing functions that operate on syntax\n> trees.","ref":"cerl.html"},{"type":"function","title":"cerl.abstract/1","doc":"Creates a syntax tree corresponding to an Erlang term.\n\n`Term` must be a literal term, that is, one that can be represented as\na source code literal. Thus, it may not contain a process identifier,\nport, reference, binary or function value as a subterm.\n\nNote: This is a constant time operation.\n\n_See also: _`ann_abstract/2`, `concrete/1`, `is_literal/1`, `is_literal_term/1`.","ref":"cerl.html#abstract/1"},{"type":"function","title":"cerl.add_ann/2","doc":"Appends `Annotations` to the list of user annotations of `Node`.\n\nNote: this is equivalent to\n[`set_ann(Node, Annotations ++ get_ann(Node))`](`set_ann/2`), but potentially\nmore efficient.\n\n_See also: _`get_ann/1`, `set_ann/2`.","ref":"cerl.html#add_ann/2"},{"type":"function","title":"cerl.alias_pat/1","doc":"Returns the pattern subtree of an abstract pattern alias.\n\n_See also: _`c_alias/2`.","ref":"cerl.html#alias_pat/1"},{"type":"function","title":"cerl.alias_var/1","doc":"Returns the variable subtree of an abstract pattern alias.\n\n_See also: _`c_alias/2`.","ref":"cerl.html#alias_var/1"},{"type":"function","title":"cerl.ann_abstract/2","doc":"_See also: _`abstract/1`.","ref":"cerl.html#ann_abstract/2"},{"type":"function","title":"cerl.ann_c_alias/3","doc":"_See also: _`c_alias/2`.","ref":"cerl.html#ann_c_alias/3"},{"type":"function","title":"cerl.ann_c_apply/3","doc":"_See also: _`c_apply/2`.","ref":"cerl.html#ann_c_apply/3"},{"type":"function","title":"cerl.ann_c_atom/2","doc":"_See also: _`c_atom/1`.","ref":"cerl.html#ann_c_atom/2"},{"type":"function","title":"cerl.ann_c_binary/2","doc":"_See also: _`c_binary/1`.","ref":"cerl.html#ann_c_binary/2"},{"type":"function","title":"cerl.ann_c_bitstr/5","doc":"Equivalent to\n[ann_c_bitstr(As, Value, Size, abstract(1), Type, Flags)](`ann_c_bitstr/6`).","ref":"cerl.html#ann_c_bitstr/5"},{"type":"function","title":"cerl.ann_c_bitstr/6","doc":"_See also: _`ann_c_bitstr/5`, `c_bitstr/5`.","ref":"cerl.html#ann_c_bitstr/6"},{"type":"function","title":"cerl.ann_c_call/4","doc":"_See also: _`c_call/3`.","ref":"cerl.html#ann_c_call/4"},{"type":"function","title":"cerl.ann_c_case/3","doc":"_See also: _`c_case/2`.","ref":"cerl.html#ann_c_case/3"},{"type":"function","title":"cerl.ann_c_catch/2","doc":"_See also: _`c_catch/1`.","ref":"cerl.html#ann_c_catch/2"},{"type":"function","title":"cerl.ann_c_char/2","doc":"_See also: _`c_char/1`.","ref":"cerl.html#ann_c_char/2"},{"type":"function","title":"cerl.ann_c_clause/3","doc":"Equivalent to\n[ann_c_clause(As, Patterns, c_atom(true), Body)](`ann_c_clause/4`).\n\n_See also: _`c_clause/3`.","ref":"cerl.html#ann_c_clause/3"},{"type":"function","title":"cerl.ann_c_clause/4","doc":"_See also: _`ann_c_clause/3`, `c_clause/3`.","ref":"cerl.html#ann_c_clause/4"},{"type":"function","title":"cerl.ann_c_cons/3","doc":"_See also: _`c_cons/2`.","ref":"cerl.html#ann_c_cons/3"},{"type":"function","title":"cerl.ann_c_cons_skel/3","doc":"_See also: _`c_cons_skel/2`.","ref":"cerl.html#ann_c_cons_skel/3"},{"type":"function","title":"cerl.ann_c_float/2","doc":"_See also: _`c_float/1`.","ref":"cerl.html#ann_c_float/2"},{"type":"function","title":"cerl.ann_c_fname/3","doc":"Equivalent to [ann_c_var(As, \\{Atom, Arity\\})](`ann_c_var/2`).\n\n_See also: _`c_fname/2`.","ref":"cerl.html#ann_c_fname/3"},{"type":"function","title":"cerl.ann_c_fun/3","doc":"_See also: _`c_fun/2`.","ref":"cerl.html#ann_c_fun/3"},{"type":"function","title":"cerl.ann_c_int/2","doc":"_See also: _`c_int/1`.","ref":"cerl.html#ann_c_int/2"},{"type":"function","title":"cerl.ann_c_let/4","doc":"_See also: _`c_let/3`.","ref":"cerl.html#ann_c_let/4"},{"type":"function","title":"cerl.ann_c_letrec/3","doc":"_See also: _`c_letrec/2`.","ref":"cerl.html#ann_c_letrec/3"},{"type":"function","title":"cerl.ann_c_map/2","doc":"_See also: _`c_map/1`.","ref":"cerl.html#ann_c_map/2"},{"type":"function","title":"cerl.ann_c_map/3","doc":"_See also: _`c_map/2`","ref":"cerl.html#ann_c_map/3"},{"type":"function","title":"cerl.ann_c_map_pair/4","doc":"_See also: _`c_map_pair/2`, `c_map_pair_exact/2`.","ref":"cerl.html#ann_c_map_pair/4"},{"type":"function","title":"cerl.ann_c_map_pattern/2","doc":"_See also: _`c_map_pattern/2`","ref":"cerl.html#ann_c_map_pattern/2"},{"type":"function","title":"cerl.ann_c_module/4","doc":"_See also: _`ann_c_module/5`, `c_module/3`.","ref":"cerl.html#ann_c_module/4"},{"type":"function","title":"cerl.ann_c_module/5","doc":"_See also: _`ann_c_module/4`, `c_module/4`.","ref":"cerl.html#ann_c_module/5"},{"type":"function","title":"cerl.ann_c_nil/1","doc":"_See also: _`c_nil/0`.","ref":"cerl.html#ann_c_nil/1"},{"type":"function","title":"cerl.ann_c_primop/3","doc":"_See also: _`c_primop/2`.","ref":"cerl.html#ann_c_primop/3"},{"type":"function","title":"cerl.ann_c_receive/2","doc":"Equivalent to\n[ann_c_receive(As, Clauses, c_atom(infinity), c_atom(true))](`ann_c_receive/4`).\n\n_See also: _`c_atom/1`, `c_receive/3`.","ref":"cerl.html#ann_c_receive/2"},{"type":"function","title":"cerl.ann_c_receive/4","doc":"_See also: _`ann_c_receive/2`, `c_receive/3`.","ref":"cerl.html#ann_c_receive/4"},{"type":"function","title":"cerl.ann_c_seq/3","doc":"_See also: _`c_seq/2`.","ref":"cerl.html#ann_c_seq/3"},{"type":"function","title":"cerl.ann_c_string/2","doc":"_See also: _`c_string/1`.","ref":"cerl.html#ann_c_string/2"},{"type":"function","title":"cerl.ann_c_try/6","doc":"_See also: _`c_try/5`.","ref":"cerl.html#ann_c_try/6"},{"type":"function","title":"cerl.ann_c_tuple/2","doc":"_See also: _`c_tuple/1`.","ref":"cerl.html#ann_c_tuple/2"},{"type":"function","title":"cerl.ann_c_tuple_skel/2","doc":"_See also: _`c_tuple_skel/1`.","ref":"cerl.html#ann_c_tuple_skel/2"},{"type":"function","title":"cerl.ann_c_values/2","doc":"_See also: _`c_values/1`.","ref":"cerl.html#ann_c_values/2"},{"type":"function","title":"cerl.ann_c_var/2","doc":"_See also: _`c_var/1`.","ref":"cerl.html#ann_c_var/2"},{"type":"function","title":"cerl.ann_make_data/3","doc":"_See also: _`make_data/2`.","ref":"cerl.html#ann_make_data/3"},{"type":"function","title":"cerl.ann_make_data_skel/3","doc":"_See also: _`make_data_skel/2`.","ref":"cerl.html#ann_make_data_skel/3"},{"type":"function","title":"cerl.ann_make_list/2","doc":"Equivalent to  ann_make_list(As, List, none) .","ref":"cerl.html#ann_make_list/2"},{"type":"function","title":"cerl.ann_make_list/3","doc":"_See also: _`ann_make_list/2`, `make_list/2`.","ref":"cerl.html#ann_make_list/3"},{"type":"function","title":"cerl.ann_make_tree/3","doc":"Creates a syntax tree with the given annotations, type and subtrees.\n\nSee [`make_tree/2`](`make_tree/2`) for details.\n\n_See also: _`make_tree/2`.","ref":"cerl.html#ann_make_tree/3"},{"type":"function","title":"cerl.apply_args/1","doc":"Returns the list of argument subtrees of an abstract function application.\n\n_See also: _`apply_arity/1`, `c_apply/2`.","ref":"cerl.html#apply_args/1"},{"type":"function","title":"cerl.apply_arity/1","doc":"Returns the number of argument subtrees of an abstract function application.\n\nNote: this is equivalent to [`length(apply_args(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`apply_args/1`, `c_apply/2`.","ref":"cerl.html#apply_arity/1"},{"type":"function","title":"cerl.apply_op/1","doc":"Returns the operator subtree of an abstract function application.\n\n_See also: _`c_apply/2`.","ref":"cerl.html#apply_op/1"},{"type":"function","title":"cerl.atom_lit/1","doc":"Returns the literal string represented by an abstract atom. This always includes\nsurrounding single-quote characters.\n\nNote that an abstract atom may have several literal representations, and that\nthe representation yielded by this function is not fixed; for example,\n[`atom_lit(c_atom(\"a\\012b\"))`](`atom_lit/1`) could yield the string\n`\"\\'a\\\\nb\\'\"`.\n\n_See also: _`c_atom/1`.","ref":"cerl.html#atom_lit/1"},{"type":"function","title":"cerl.atom_name/1","doc":"Returns the printname of an abstract atom.\n\n_See also: _`c_atom/1`.","ref":"cerl.html#atom_name/1"},{"type":"function","title":"cerl.atom_val/1","doc":"Returns the value represented by an abstract atom.\n\n_See also: _`c_atom/1`.","ref":"cerl.html#atom_val/1"},{"type":"function","title":"cerl.binary_segments/1","doc":"Returns the list of segment subtrees of an abstract binary-template.\n\n_See also: _`c_binary/1`, `c_bitstr/5`.","ref":"cerl.html#binary_segments/1"},{"type":"function","title":"cerl.bitstr_bitsize/1","doc":"Returns the total size in bits of an abstract bit-string template.\n\nIf the size field is an integer literal, the result is the product of\nthe size and unit values; if the size field is the atom literal `all`,\nthe atom `all` is returned.  If the size is not a literal, the atom\n`any` is returned.  If the type of the bit-string segment is one of\n`utf8`, `utf16` or `utf32`, the atom `utf` is returned.\n\n_See also: _`c_bitstr/5`.","ref":"cerl.html#bitstr_bitsize/1"},{"type":"function","title":"cerl.bitstr_flags/1","doc":"Returns the flags subtree of an abstract bit-string template.\n\n_See also: _`c_bitstr/5`.","ref":"cerl.html#bitstr_flags/1"},{"type":"function","title":"cerl.bitstr_size/1","doc":"Returns the size subtree of an abstract bit-string template.\n\n_See also: _`c_bitstr/5`.","ref":"cerl.html#bitstr_size/1"},{"type":"function","title":"cerl.bitstr_type/1","doc":"Returns the type subtree of an abstract bit-string template.\n\n_See also: _`c_bitstr/5`.","ref":"cerl.html#bitstr_type/1"},{"type":"function","title":"cerl.bitstr_unit/1","doc":"Returns the unit subtree of an abstract bit-string template.\n\n_See also: _`c_bitstr/5`.","ref":"cerl.html#bitstr_unit/1"},{"type":"function","title":"cerl.bitstr_val/1","doc":"Returns the value subtree of an abstract bit-string template.\n\n_See also: _`c_bitstr/5`.","ref":"cerl.html#bitstr_val/1"},{"type":"type","title":"cerl.c_alias/0","doc":"","ref":"cerl.html#t:c_alias/0"},{"type":"function","title":"cerl.c_alias/2","doc":"Creates an abstract pattern alias.\n\nThe result represents \"`Variable = Pattern`\".\n\n_See also: _`alias_pat/1`, `alias_var/1`, `ann_c_alias/3`, `c_clause/3`,\n`is_c_alias/1`, `update_c_alias/3`.","ref":"cerl.html#c_alias/2"},{"type":"type","title":"cerl.c_apply/0","doc":"","ref":"cerl.html#t:c_apply/0"},{"type":"function","title":"cerl.c_apply/2","doc":"Creates an abstract function application.\n\nIf `Arguments` is `[A1, ..., An]`, the result represents \"`apply\nOperator(A1, ..., An)`\".\n\n_See also: _`ann_c_apply/3`, `apply_args/1`, `apply_arity/1`, `apply_op/1`,\n`c_call/3`, `c_primop/2`, `is_c_apply/1`, `update_c_apply/3`.","ref":"cerl.html#c_apply/2"},{"type":"function","title":"cerl.c_atom/1","doc":"Creates an abstract atom literal.\n\nThe print name of the atom is the character sequence represented by\n`Name`.\n\nNote: passing a string as argument to this function causes a corresponding atom\nto be created for the internal representation.\n\n_See also: _`ann_c_atom/2`, `atom_lit/1`, `atom_name/1`, `atom_val/1`,\n`is_c_atom/1`.","ref":"cerl.html#c_atom/1"},{"type":"type","title":"cerl.c_binary/0","doc":"","ref":"cerl.html#t:c_binary/0"},{"type":"function","title":"cerl.c_binary/1","doc":"Creates an abstract binary-template.\n\nA binary object is in this context is a sequence of an arbitrary\nnumber of bits. (The number of bits used to be evenly divisible by 8,\nbut after the introduction of bit strings in the Erlang language, the\nchoice was made to use the binary template for all bit strings.)  It\nis specified by zero or more bit-string template _segments_ of\narbitrary lengths (in number of bits).\n\nIf `Segments` is `[S1, ..., Sn]`, the result represents \"`#{S1, ...,\nSn}#`\". All the `Si` must have type `bitstr`.\n\n_See also: _`ann_c_binary/2`, `binary_segments/1`, `c_bitstr/5`,\n`is_c_binary/1`, `update_c_binary/2`.","ref":"cerl.html#c_binary/1"},{"type":"type","title":"cerl.c_bitstr/0","doc":"","ref":"cerl.html#t:c_bitstr/0"},{"type":"function","title":"cerl.c_bitstr/3","doc":"Equivalent to\n[c_bitstr(Value, abstract(all), abstract(1), Type, Flags)](`c_bitstr/5`).","ref":"cerl.html#c_bitstr/3"},{"type":"function","title":"cerl.c_bitstr/4","doc":"Equivalent to  c_bitstr(Value, Size, abstract(1), Type, Flags) .","ref":"cerl.html#c_bitstr/4"},{"type":"function","title":"cerl.c_bitstr/5","doc":"Creates an abstract bit-string template.\n\nThese can only occur as components of an abstract binary-template (see\n`c_binary/1`). The result represents \"`# (Size, Unit, Type,\nFlags)`\", where `Unit` must represent a positive integer constant,\n`Type` must represent a constant atom (one of `'integer'`, `'float'`,\n`'binary'`, `'utf8'`, `'utf16'` or `'utf32'`), and `Flags` must\nrepresent a constant list `\"[F1, ..., Fn]\"` where all the `Fi` are\natoms.\n\n_See also: _`ann_c_bitstr/6`, `bitstr_flags/1`, `bitstr_size/1`,\n`bitstr_type/1`, `bitstr_unit/1`, `bitstr_val/1`, `c_binary/1`, `is_c_bitstr/1`,\n`update_c_bitstr/6`.","ref":"cerl.html#c_bitstr/5"},{"type":"type","title":"cerl.c_call/0","doc":"","ref":"cerl.html#t:c_call/0"},{"type":"function","title":"cerl.c_call/3","doc":"Creates an abstract inter-module call.\n\nIf `Arguments` is `[A1, ..., An]`, the result represents \"`call\nModule:Name(A1, ..., An)`\".\n\n_See also: _`ann_c_call/4`, `c_apply/2`, `c_primop/2`, `call_args/1`,\n`call_arity/1`, `call_module/1`, `call_name/1`, `is_c_call/1`,\n`update_c_call/4`.","ref":"cerl.html#c_call/3"},{"type":"type","title":"cerl.c_case/0","doc":"","ref":"cerl.html#t:c_case/0"},{"type":"function","title":"cerl.c_case/2","doc":"Creates an abstract case-expression.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result represents \"`case Argument\nof C1 ... Cn end`\". `Clauses` must not be empty.\n\n_See also: _`ann_c_case/3`, `c_clause/3`, `case_arg/1`, `case_arity/1`,\n`case_clauses/1`, `is_c_case/1`, `update_c_case/3`.","ref":"cerl.html#c_case/2"},{"type":"type","title":"cerl.c_catch/0","doc":"","ref":"cerl.html#t:c_catch/0"},{"type":"function","title":"cerl.c_catch/1","doc":"Creates an abstract catch-expression.\n\nThe result represents \"`catch Body`\".\n\nNote: catch-expressions can be rewritten as try-expressions, and will eventually\nbe removed from Core Erlang.\n\n_See also: _`ann_c_catch/2`, `c_try/5`, `catch_body/1`, `is_c_catch/1`,\n`update_c_catch/2`.","ref":"cerl.html#c_catch/1"},{"type":"function","title":"cerl.c_char/1","doc":"Creates an abstract character literal.\n\nIf the local implementation of Erlang defines `t:char/0` as a subset\nof `t:integer/0`, this function is equivalent to\n[`c_int/1`](`c_int/1`). Otherwise, if the given value is an integer,\nit will be converted to the character with the corresponding code. The\nlexical representation of a character is \"`$Char`\", where `Char` is a\nsingle printing character or an escape sequence.\n\n_See also: _`ann_c_char/2`, `c_int/1`, `c_string/1`, `char_lit/1`, `char_val/1`,\n`is_c_char/1`, `is_print_char/1`.","ref":"cerl.html#c_char/1"},{"type":"type","title":"cerl.c_clause/0","doc":"","ref":"cerl.html#t:c_clause/0"},{"type":"function","title":"cerl.c_clause/2","doc":"Equivalent to [c_clause(Patterns, c_atom(true), Body)](`c_clause/3`).\n\n_See also: _`c_atom/1`.","ref":"cerl.html#c_clause/2"},{"type":"function","title":"cerl.c_clause/3","doc":"Creates an an abstract clause.\n\nIf `Patterns` is `[P1, ..., Pn]`, the result represents \"`  when Guard -> Body`\".\n\n_See also: _`ann_c_clause/4`, `c_case/2`, `c_clause/2`, `c_receive/3`,\n`clause_arity/1`, `clause_body/1`, `clause_guard/1`, `clause_pats/1`,\n`clause_vars/1`, `is_c_clause/1`, `update_c_clause/4`.","ref":"cerl.html#c_clause/3"},{"type":"type","title":"cerl.c_cons/0","doc":"","ref":"cerl.html#t:c_cons/0"},{"type":"function","title":"cerl.c_cons/2","doc":"Creates an abstract list constructor.\n\nThe result represents \"`[Head | Tail]`\". Note that if both `Head` and\n`Tail` have type `literal`, then the result will also have type\n`literal`, and annotations on `Head` and `Tail` are lost.\n\nRecall that in Erlang, the tail element of a list constructor is not necessarily\na list.\n\n_See also: _`ann_c_cons/3`, `c_cons_skel/2`, `c_nil/0`, `cons_hd/1`,\n`cons_tl/1`, `is_c_cons/1`, `is_c_list/1`, `list_elements/1`, `list_length/1`,\n`make_list/2`, `update_c_cons/3`.","ref":"cerl.html#c_cons/2"},{"type":"function","title":"cerl.c_cons_skel/2","doc":"Creates an abstract list constructor skeleton.\n\nDoes not fold constant literals, that is, the result always has type\n`cons`, representing \"`[Head | Tail]`\".\n\nThis function is occasionally useful when it is necessary to have annotations on\nthe subnodes of a list constructor node, even when the subnodes are constant\nliterals. However, note that [`is_literal/1`](`is_literal/1`) will yield `false`\nand [`concrete/1`](`concrete/1`) will fail if passed the result from this\nfunction.\n\n[`fold_literal/1`](`fold_literal/1`) can be used to revert a node to the\nnormal-form representation.\n\n_See also: _`ann_c_cons_skel/3`, `c_cons/2`, `c_nil/0`, `concrete/1`,\n`fold_literal/1`, `is_c_cons/1`, `is_c_list/1`, `is_literal/1`,\n`update_c_cons_skel/3`.","ref":"cerl.html#c_cons_skel/2"},{"type":"function","title":"cerl.c_float/1","doc":"Creates an abstract floating-point literal.\n\nThe lexical representation is the decimal floating-point numeral of\n`Value`.\n\n_See also: _`ann_c_float/2`, `float_lit/1`, `float_val/1`, `is_c_float/1`.","ref":"cerl.html#c_float/1"},{"type":"function","title":"cerl.c_fname/2","doc":"Equivalent to [c_var(\\{Name, Arity\\})](`c_var/1`).\n\n_See also: _`ann_c_fname/3`, `fname_arity/1`, `fname_id/1`, `is_c_fname/1`,\n`update_c_fname/3`.","ref":"cerl.html#c_fname/2"},{"type":"type","title":"cerl.c_fun/0","doc":"","ref":"cerl.html#t:c_fun/0"},{"type":"function","title":"cerl.c_fun/2","doc":"Creates an abstract fun-expression.\n\nIf `Variables` is `[V1, ..., Vn]`, the result represents \"`fun (V1,\n..., Vn) -> Body`\". All the `Vi` must have type `var`.\n\n_See also: _`ann_c_fun/3`, `fun_arity/1`, `fun_body/1`, `fun_vars/1`,\n`is_c_fun/1`, `update_c_fun/3`.","ref":"cerl.html#c_fun/2"},{"type":"function","title":"cerl.c_int/1","doc":"Creates an abstract integer literal.\n\nThe lexical representation is the canonical decimal numeral of `Value`.\n\n_See also: _`ann_c_int/2`, `c_char/1`, `int_lit/1`, `int_val/1`, `is_c_int/1`.","ref":"cerl.html#c_int/1"},{"type":"type","title":"cerl.c_lct/0","doc":"","ref":"cerl.html#t:c_lct/0"},{"type":"type","title":"cerl.c_let/0","doc":"","ref":"cerl.html#t:c_let/0"},{"type":"function","title":"cerl.c_let/3","doc":"Creates an abstract let-expression.\n\nIf `Variables` is `[V1, ..., Vn]`, the result represents \"`let   = Argument in Body`\". All the `Vi` must have type `var`.\n\n_See also: _`ann_c_let/4`, `is_c_let/1`, `let_arg/1`, `let_arity/1`,\n`let_body/1`, `let_vars/1`, `update_c_let/4`.","ref":"cerl.html#c_let/3"},{"type":"type","title":"cerl.c_letrec/0","doc":"","ref":"cerl.html#t:c_letrec/0"},{"type":"function","title":"cerl.c_letrec/2","doc":"Creates an abstract letrec-expression.\n\nIf `Definitions` is `[{V1, F1}, ..., {Vn, Fn}]`, the result represents\n\"`letrec V1 = F1 ... Vn = Fn in Body`\". All the `Vi` must have type\n`var` and represent function names. All the `Fi` must have type\n`'fun'`.\n\n_See also: _`ann_c_letrec/3`, `is_c_letrec/1`, `letrec_body/1`, `letrec_defs/1`,\n`letrec_vars/1`, `update_c_letrec/3`.","ref":"cerl.html#c_letrec/2"},{"type":"type","title":"cerl.c_literal/0","doc":"","ref":"cerl.html#t:c_literal/0"},{"type":"type","title":"cerl.c_map/0","doc":"","ref":"cerl.html#t:c_map/0"},{"type":"function","title":"cerl.c_map/1","doc":"Creates an abstract map constructor.\n\nIf `Pairs` is `[E1, ..., EN]`, the result represents \"`~{E1, ...,\nEN}~`\" (creating a new map). Note that if all pairs in `Pairs` have\ntype `literal` for both the key and the value, or if `Pairs` is empty,\nthen the result will also have type `literal` and annotations on nodes\nin `Pairs` are lost.\n\nAll `Ei` must be abstract pairs constructed by `c_map_pair/2`.\n\n_See also: _`ann_c_map/2`, `is_c_map/1`, `is_c_map_empty/1`, `is_c_map_pattern/1`,\n`map_es/1`, `c_map_pair/2`, `c_map_pair_exact/2`.","ref":"cerl.html#c_map/1"},{"type":"function","title":"cerl.c_map/2","doc":"Creates an abstract map update expression.\n\nIf `Pairs` is `[E1, ..., EN]`, the result represents \"`~{E1, ..., EN |\nArgument}~`\" (updating an existing map). Note that if `Argument` is a\nliteral and all pairs in `Pairs` have type `literal` for both the key\nand the value, or if `Pairs` is empty, then the result will also have\ntype `literal` and annotations on nodes in `Pairs` are lost.\n\nAll `Ei` must be abstract pairs constructed by either `c_map_pair/2` or\n`c_map_pair_exact/2`.\n\n_See also: _`ann_c_map/2`, `is_c_map/1`, `is_c_map_empty/1`, `is_c_map_pattern/1`,\n`map_es/1`, `c_map_pair/2`, `c_map_pair_exact/2`.","ref":"cerl.html#c_map/2"},{"type":"type","title":"cerl.c_map_pair/0","doc":"","ref":"cerl.html#t:c_map_pair/0"},{"type":"function","title":"cerl.c_map_pair/2","doc":"Creates an abstract map pair using the `assoc` operator.\n\nThese can only occur as components of an abstract map creation\nexpression or an abstract update expression (see `c_map/1` and\n`c_map/2`).\n\nThe result represents \"`Key => Value`\".\n\n_See also: _`map_pair_key/1`, `map_pair_op/1`, `map_pair_val/1`.","ref":"cerl.html#c_map_pair/2"},{"type":"function","title":"cerl.c_map_pair_exact/2","doc":"Creates an abstract map pair using the `exact` operator.\n\nThese can only occur as components of an abstract map update\nexpression or an abstract map pattern (see `c_map/1` and\n`c_map_pattern/1`).\n\nThe result represents \"`Key := Value`\".\n\n_See also: _`map_pair_key/1`, `map_pair_op/1`, `map_pair_val/1`.","ref":"cerl.html#c_map_pair_exact/2"},{"type":"function","title":"cerl.c_map_pattern/1","doc":"Creates an abstract map pattern.\n\nIf `Pairs` is `[E1, ..., EN]`, the result represents\n\"`~{E1, ..., EN}~`\".\n\nAll `Ei` must be abstract pairs constructed by `c_map_pair_exact/2`.\n\n_See also: _`ann_c_map/2`, `is_c_map/1`, `is_c_map_empty/1`, `is_c_map_pattern/1`,\n`map_es/1`, `c_map_pair_exact/2`.","ref":"cerl.html#c_map_pattern/1"},{"type":"type","title":"cerl.c_module/0","doc":"","ref":"cerl.html#t:c_module/0"},{"type":"function","title":"cerl.c_module/3","doc":"Equivalent to  c_module(Name, Exports, [], Definitions) .","ref":"cerl.html#c_module/3"},{"type":"function","title":"cerl.c_module/4","doc":"Creates an abstract module definition.\n\nThe result represents\n\n```text\n    module Name [E1, ..., Ek]\n      attributes [K1 = T1, ...,\n                  Km = Tm]\n      V1 = F1\n      ...\n      Vn = Fn\n    end\n```\n\nif `Exports` = `[E1, ..., Ek]`, `Attributes` = `[{K1, T1}, ..., {Km, Tm}]`, and\n`Definitions` = `[{V1, F1}, ..., {Vn, Fn}]`.\n\n`Name` and all the `Ki` must be atom literals, and all the `Ti` must be constant\nliterals. All the `Vi` and `Ei` must have type `var` and represent function\nnames. All the `Fi` must have type `'fun'`.\n\n_See also: _`ann_c_module/4`, `ann_c_module/5`, `c_atom/1`, `c_fun/2`,\n`c_module/3`, `c_var/1`, `is_literal/1`, `module_attrs/1`, `module_defs/1`,\n`module_exports/1`, `module_name/1`, `module_vars/1`, `update_c_module/5`.","ref":"cerl.html#c_module/4"},{"type":"function","title":"cerl.c_nil/0","doc":"Creates an abstract empty list.\n\nThe result represents \"`[]`\". The empty list is traditionally called\n\"nil\".\n\n_See also: _`ann_c_nil/1`, `c_cons/2`, `is_c_list/1`.","ref":"cerl.html#c_nil/0"},{"type":"type","title":"cerl.c_opaque/0","doc":"","ref":"cerl.html#t:c_opaque/0"},{"type":"type","title":"cerl.c_primop/0","doc":"","ref":"cerl.html#t:c_primop/0"},{"type":"function","title":"cerl.c_primop/2","doc":"Creates an abstract primitive operation call.\n\nIf `Arguments` is `[A1, ..., An]`, the result represents \"`primop\nName(A1, ..., An)`\". `Name` must be an atom literal.\n\n_See also: _`ann_c_primop/3`, `c_apply/2`, `c_call/3`, `is_c_primop/1`,\n`primop_args/1`, `primop_arity/1`, `primop_name/1`, `update_c_primop/3`.","ref":"cerl.html#c_primop/2"},{"type":"type","title":"cerl.c_receive/0","doc":"","ref":"cerl.html#t:c_receive/0"},{"type":"function","title":"cerl.c_receive/1","doc":"Equivalent to\n[c_receive(Clauses, c_atom(infinity), c_atom(true))](`c_receive/3`).\n\n_See also: _`c_atom/1`.","ref":"cerl.html#c_receive/1"},{"type":"function","title":"cerl.c_receive/3","doc":"Creates an abstract receive-expression.\n\nIf `Clauses` is `[C1, ..., Cn]`, the result represents \"`receive C1\n... Cn after Timeout -> Action end`\".\n\n_See also: _`ann_c_receive/4`, `c_receive/1`, `is_c_receive/1`,\n`receive_action/1`, `receive_clauses/1`, `receive_timeout/1`,\n`update_c_receive/4`.","ref":"cerl.html#c_receive/3"},{"type":"type","title":"cerl.c_seq/0","doc":"","ref":"cerl.html#t:c_seq/0"},{"type":"function","title":"cerl.c_seq/2","doc":"Creates an abstract sequencing expression.\n\nThe result represents \"`do Argument Body`\".\n\n_See also: _`ann_c_seq/3`, `is_c_seq/1`, `seq_arg/1`, `seq_body/1`,\n`update_c_seq/3`.","ref":"cerl.html#c_seq/2"},{"type":"function","title":"cerl.c_string/1","doc":"Creates an abstract string literal.\n\nEquivalent to creating an abstract list of the corresponding character\nliterals (cf. [`is_c_string/1`](`is_c_string/1`)), but is typically\nmore efficient. The lexical representation of a string is \"`\"Chars\"`\",\nwhere `Chars` is a sequence of printing characters or spaces.\n\n_See also: _`ann_c_string/2`, `c_char/1`, `is_c_string/1`, `is_print_string/1`,\n`string_lit/1`, `string_val/1`.","ref":"cerl.html#c_string/1"},{"type":"type","title":"cerl.c_try/0","doc":"","ref":"cerl.html#t:c_try/0"},{"type":"function","title":"cerl.c_try/5","doc":"Creates an abstract try-expression.\n\nIf `Variables` is `[V1, ..., Vn]` and `ExceptionVars` is `[X1, ...,\nXm]`, the result represents \"`try Argument of   -> Body\ncatch   -> Handler`\".  All the `Vi` and `Xi` must have\ntype `var`.\n\n_See also: _`ann_c_try/6`, `c_catch/1`, `is_c_try/1`, `try_arg/1`, `try_body/1`,\n`try_vars/1`, `update_c_try/6`.","ref":"cerl.html#c_try/5"},{"type":"type","title":"cerl.c_tuple/0","doc":"","ref":"cerl.html#t:c_tuple/0"},{"type":"function","title":"cerl.c_tuple/1","doc":"Creates an abstract tuple.\n\nIf `Elements` is `[E1, ..., En]`, the result represents \"`{E1, ...,\nEn}`\". Note that if all nodes in `Elements` have type `literal`, or if\n`Elements` is empty, then the result will also have type `literal` and\nannotations on nodes in `Elements` are lost.\n\nRecall that Erlang has distinct 1-tuples, that is, `{X}` is always\ndistinct from `X` itself.\n\n_See also: _`ann_c_tuple/2`, `c_tuple_skel/1`, `is_c_tuple/1`, `tuple_arity/1`,\n`tuple_es/1`, `update_c_tuple/2`.","ref":"cerl.html#c_tuple/1"},{"type":"function","title":"cerl.c_tuple_skel/1","doc":"Creates an abstract tuple skeleton.\n\nDoes not fold constant literals, that is, the result always has type\n`tuple`, representing \"`{E1, ..., En}`\", if `Elements` is `[E1, ...,\nEn]`.\n\nThis function is occasionally useful when it is necessary to have annotations on\nthe subnodes of a tuple node, even when all the subnodes are constant literals.\nHowever, note that [`is_literal/1`](`is_literal/1`) will yield `false` and\n[`concrete/1`](`concrete/1`) will fail if passed the result from this function.\n\n[`fold_literal/1`](`fold_literal/1`) can be used to revert a node to the\nnormal-form representation.\n\n_See also: _`ann_c_tuple_skel/2`, `c_tuple/1`, `concrete/1`, `fold_literal/1`,\n`is_c_tuple/1`, `is_literal/1`, `tuple_es/1`, `update_c_tuple_skel/2`.","ref":"cerl.html#c_tuple_skel/1"},{"type":"type","title":"cerl.c_values/0","doc":"","ref":"cerl.html#t:c_values/0"},{"type":"function","title":"cerl.c_values/1","doc":"Creates an abstract value list.\n\nIf `Elements` is `[E1, ..., En]`, the result represents \"` `\".\n\n_See also: _`ann_c_values/2`, `is_c_values/1`, `update_c_values/2`,\n`values_arity/1`, `values_es/1`.","ref":"cerl.html#c_values/1"},{"type":"type","title":"cerl.c_var/0","doc":"","ref":"cerl.html#t:c_var/0"},{"type":"function","title":"cerl.c_var/1","doc":"Creates an abstract variable.\n\nA variable is identified by its name, given by the `Name` parameter.\n\nIf a name is given by a single atom, it should either be a \"simple\" atom which\ndoes not need to be single-quoted in Erlang, or otherwise its print name should\ncorrespond to a proper Erlang variable, that is, begin with an uppercase character\nor an underscore. Names of the form `{A, N}` represent function name variables\n\"`A/N`\"; these are special variables which may be bound only in the function\ndefinitions of a module or a `letrec`. They may not be bound in `let`\nexpressions and cannot occur in clause patterns. The atom `A` in a function name\nmay be any atom; the integer `N` must be nonnegative. The functions\n[`c_fname/2`](`c_fname/2`) etc. are utilities for handling function name\nvariables.\n\nWhen printing variable names, they must have the form of proper Core Erlang\nvariables and function names. E.g., a name represented by an integer such as\n`42` could be formatted as \"`_42`\", an atom `'Xxx'` simply as \"`Xxx`\", and an\natom `foo` as \"`_foo`\". However, one must assure that any two valid distinct\nnames are never mapped to the same strings. Tuples such as `{foo, 2}`\nrepresenting function names can simply by formatted as \"`'foo'/2`\", with no risk\nof conflicts.\n\n_See also: _`ann_c_var/2`, `c_fname/2`, `c_letrec/2`, `c_module/4`,\n`is_c_var/1`, `update_c_var/2`, `var_name/1`.","ref":"cerl.html#c_var/1"},{"type":"function","title":"cerl.call_args/1","doc":"Returns the list of argument subtrees of an abstract inter-module call.\n\n_See also: _`c_call/3`, `call_arity/1`.","ref":"cerl.html#call_args/1"},{"type":"function","title":"cerl.call_arity/1","doc":"Returns the number of argument subtrees of an abstract inter-module call.\n\nNote: this is equivalent to [`length(call_args(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_call/3`, `call_args/1`.","ref":"cerl.html#call_arity/1"},{"type":"function","title":"cerl.call_module/1","doc":"Returns the module subtree of an abstract inter-module call.\n\n_See also: _`c_call/3`.","ref":"cerl.html#call_module/1"},{"type":"function","title":"cerl.call_name/1","doc":"Returns the name subtree of an abstract inter-module call.\n\n_See also: _`c_call/3`.","ref":"cerl.html#call_name/1"},{"type":"function","title":"cerl.case_arg/1","doc":"Returns the argument subtree of an abstract case-expression.\n\n_See also: _`c_case/2`.","ref":"cerl.html#case_arg/1"},{"type":"function","title":"cerl.case_arity/1","doc":"Equivalent to [`clause_arity(hd(case_clauses(Node)))`](`clause_arity/1`), but\npotentially more efficient.\n\n_See also: _`c_case/2`, `case_clauses/1`, `clause_arity/1`.","ref":"cerl.html#case_arity/1"},{"type":"function","title":"cerl.case_clauses/1","doc":"Returns the list of clause subtrees of an abstract case-expression.\n\n_See also: _`c_case/2`, `case_arity/1`.","ref":"cerl.html#case_clauses/1"},{"type":"function","title":"cerl.catch_body/1","doc":"Returns the body subtree of an abstract catch-expression.\n\n_See also: _`c_catch/1`.","ref":"cerl.html#catch_body/1"},{"type":"type","title":"cerl.cerl/0","doc":"","ref":"cerl.html#t:cerl/0"},{"type":"function","title":"cerl.char_lit/1","doc":"Returns the literal string represented by an abstract character. This includes a\nleading `$` character.\n\nCurrently, all characters that are not in the set of ISO 8859-1\n(Latin-1) \"printing\" characters will be escaped.\n\n_See also: _`c_char/1`.","ref":"cerl.html#char_lit/1"},{"type":"function","title":"cerl.char_val/1","doc":"Returns the value represented by an abstract character literal.\n\n_See also: _`c_char/1`.","ref":"cerl.html#char_val/1"},{"type":"function","title":"cerl.clause_arity/1","doc":"Returns the number of pattern subtrees of an abstract clause.\n\nNote: this is equivalent to [`length(clause_pats(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_clause/3`, `clause_pats/1`.","ref":"cerl.html#clause_arity/1"},{"type":"function","title":"cerl.clause_body/1","doc":"Returns the body subtree of an abstract clause.\n\n_See also: _`c_clause/3`.","ref":"cerl.html#clause_body/1"},{"type":"function","title":"cerl.clause_guard/1","doc":"Returns the guard subtree of an abstract clause.\n\n_See also: _`c_clause/3`.","ref":"cerl.html#clause_guard/1"},{"type":"function","title":"cerl.clause_pats/1","doc":"Returns the list of pattern subtrees of an abstract clause.\n\n_See also: _`c_clause/3`, `clause_arity/1`.","ref":"cerl.html#clause_pats/1"},{"type":"function","title":"cerl.clause_vars/1","doc":"Returns the list of all abstract variables in the patterns of an abstract\nclause.\n\nThe order of listing is not defined.\n\n_See also: _`c_clause/3`, `pat_list_vars/1`.","ref":"cerl.html#clause_vars/1"},{"type":"function","title":"cerl.concrete/1","doc":"Returns the Erlang term represented by a syntax tree.\n\nAn exception is thrown if `Node` does not represent a literal term.\n\nNote: This is a constant time operation.\n\n_See also: _`abstract/1`, `is_literal/1`.","ref":"cerl.html#concrete/1"},{"type":"function","title":"cerl.cons_hd/1","doc":"Returns the head subtree of an abstract list constructor.\n\n_See also: _`c_cons/2`.","ref":"cerl.html#cons_hd/1"},{"type":"function","title":"cerl.cons_tl/1","doc":"Returns the tail subtree of an abstract list constructor.\n\nRecall that the tail does not necessarily represent a proper list.\n\n_See also: _`c_cons/2`.","ref":"cerl.html#cons_tl/1"},{"type":"function","title":"cerl.copy_ann/2","doc":"Copies the list of user annotations from `Source` to `Target`.\n\nNote: this is equivalent to [`set_ann(Target, get_ann(Source))`](`set_ann/2`),\nbut potentially more efficient.\n\n_See also: _`get_ann/1`, `set_ann/2`.","ref":"cerl.html#copy_ann/2"},{"type":"type","title":"cerl.ctype/0","doc":"","ref":"cerl.html#t:ctype/0"},{"type":"function","title":"cerl.data_arity/1","doc":"Returns the number of subtrees of a data constructor node.\n\nThis is equivalent to [`length(data_es(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`data_es/1`, `is_data/1`.","ref":"cerl.html#data_arity/1"},{"type":"function","title":"cerl.data_es/1","doc":"Returns the list of subtrees of a data constructor node.\n\nIf the arity of the constructor is zero, the result is the empty list.\n\nNote: if [`data_type(Node)`](`data_type/1`) is `cons`, the number of subtrees is\nexactly two. If [`data_type(Node)`](`data_type/1`) is `{atomic, Value}`, the\nnumber of subtrees is zero.\n\n_See also: _`data_arity/1`, `data_type/1`, `is_data/1`, `make_data/2`.","ref":"cerl.html#data_es/1"},{"type":"function","title":"cerl.data_type/1","doc":"Returns a type descriptor for a data constructor node. (Cf.\n[`is_data/1`](`is_data/1`).)\n\nThis is mainly useful for comparing types and for constructing new\nnodes of the same type (cf. [`make_data/2`](`make_data/2`)). If `Node`\nrepresents an integer, floating-point number, atom or empty list, the\nresult is `{atomic, Value}`, where `Value` is the value of\n[`concrete(Node)`](`concrete/1`), otherwise the result is either\n`cons` or `tuple`.\n\nType descriptors can be compared for equality or order (in the Erlang term\norder), but remember that floating-point values should in general never be\ntested for equality.\n\n_See also: _`concrete/1`, `is_data/1`, `make_data/2`, `type/1`.","ref":"cerl.html#data_type/1"},{"type":"type","title":"cerl.dtype/0","doc":"","ref":"cerl.html#t:dtype/0"},{"type":"function","title":"cerl.float_lit/1","doc":"Returns the numeral string represented by a floating-point literal node.\n\n_See also: _`c_float/1`.","ref":"cerl.html#float_lit/1"},{"type":"function","title":"cerl.float_val/1","doc":"Returns the value represented by a floating-point literal node.\n\n_See also: _`c_float/1`.","ref":"cerl.html#float_val/1"},{"type":"function","title":"cerl.fname_arity/1","doc":"Returns the arity part of an abstract function name variable.\n\n_See also: _`c_fname/2`, `fname_id/1`.","ref":"cerl.html#fname_arity/1"},{"type":"function","title":"cerl.fname_id/1","doc":"Returns the identifier part of an abstract function name variable.\n\n_See also: _`c_fname/2`, `fname_arity/1`.","ref":"cerl.html#fname_id/1"},{"type":"function","title":"cerl.fold_literal/1","doc":"Ensures that literals have a compact representation.\n\nThis is occasionally useful if\n[`c_cons_skel/2`](`c_cons_skel/2`), [`c_tuple_skel/1`](`c_tuple_skel/1`) or\n[`unfold_literal/1`](`unfold_literal/1`) were used in the construction of\n`Node`, and you want to revert to the normal \"folded\" representation of\nliterals. If `Node` represents a tuple or list constructor, its elements are\nrewritten recursively, and the node is reconstructed using\n[`c_cons/2`](`c_cons/2`) or [`c_tuple/1`](`c_tuple/1`), respectively; otherwise,\n`Node` is not changed.\n\n_See also: _`c_cons/2`, `c_cons_skel/2`, `c_tuple/1`, `c_tuple_skel/1`,\n`is_literal/1`, `unfold_literal/1`.","ref":"cerl.html#fold_literal/1"},{"type":"function","title":"cerl.from_records/1","doc":"Translates an explicit record representation to a corresponding abstract syntax\ntree.\n\nThe records are defined in the file \"`core_parse.hrl`\".\n\n_See also: _`to_records/1`, `type/1`.","ref":"cerl.html#from_records/1"},{"type":"function","title":"cerl.fun_arity/1","doc":"Returns the number of parameter subtrees of an abstract fun-expression.\n\nNote: this is equivalent to [`length(fun_vars(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_fun/2`, `fun_vars/1`.","ref":"cerl.html#fun_arity/1"},{"type":"function","title":"cerl.fun_body/1","doc":"Returns the body subtree of an abstract fun-expression.\n\n_See also: _`c_fun/2`.","ref":"cerl.html#fun_body/1"},{"type":"function","title":"cerl.fun_vars/1","doc":"Returns the list of parameter subtrees of an abstract fun-expression.\n\n_See also: _`c_fun/2`, `fun_arity/1`.","ref":"cerl.html#fun_vars/1"},{"type":"function","title":"cerl.get_ann/1","doc":"Returns the list of user annotations associated with a syntax tree node.\n\nFor a newly created node, this is the empty list. The annotations may\nbe any terms.\n\n_See also: _`set_ann/2`.","ref":"cerl.html#get_ann/1"},{"type":"function","title":"cerl.int_lit/1","doc":"Returns the numeral string represented by an integer literal node.\n\n_See also: _`c_int/1`.","ref":"cerl.html#int_lit/1"},{"type":"function","title":"cerl.int_val/1","doc":"Returns the value represented by an integer literal node.\n\n_See also: _`c_int/1`.","ref":"cerl.html#int_val/1"},{"type":"function","title":"cerl.is_c_alias/1","doc":"Returns `true` if `Node` is an abstract pattern alias, otherwise `false`.\n\n_See also: _`c_alias/2`.","ref":"cerl.html#is_c_alias/1"},{"type":"function","title":"cerl.is_c_apply/1","doc":"Returns `true` if `Node` is an abstract function application, otherwise `false`.\n\n_See also: _`c_apply/2`.","ref":"cerl.html#is_c_apply/1"},{"type":"function","title":"cerl.is_c_atom/1","doc":"Returns `true` if `Node` represents an atom literal, otherwise `false`.\n\n_See also: _`c_atom/1`.","ref":"cerl.html#is_c_atom/1"},{"type":"function","title":"cerl.is_c_binary/1","doc":"Returns `true` if `Node` is an abstract binary-template, otherwise `false`.\n\n_See also: _`c_binary/1`.","ref":"cerl.html#is_c_binary/1"},{"type":"function","title":"cerl.is_c_bitstr/1","doc":"Returns `true` if `Node` is an abstract bit-string template, otherwise `false`.\n\n_See also: _`c_bitstr/5`.","ref":"cerl.html#is_c_bitstr/1"},{"type":"function","title":"cerl.is_c_call/1","doc":"Returns `true` if `Node` is an abstract inter-module call expression, otherwise\n`false`.\n\n_See also: _`c_call/3`.","ref":"cerl.html#is_c_call/1"},{"type":"function","title":"cerl.is_c_case/1","doc":"Returns `true` if `Node` is an abstract case-expression, otherwise `false`.\n\n_See also: _`c_case/2`.","ref":"cerl.html#is_c_case/1"},{"type":"function","title":"cerl.is_c_catch/1","doc":"Returns `true` if `Node` is an abstract catch-expression, otherwise `false`.\n\n_See also: _`c_catch/1`.","ref":"cerl.html#is_c_catch/1"},{"type":"function","title":"cerl.is_c_char/1","doc":"Returns `true` if `Node` may represent a character literal, otherwise `false`.\n\nIf the local implementation of Erlang defines `t:char/0` as a subset of\n`t:integer/0`, then `is_c_int(Node)` will also yield `true`.\n\n_See also: _`c_char/1`, `is_print_char/1`.","ref":"cerl.html#is_c_char/1"},{"type":"function","title":"cerl.is_c_clause/1","doc":"Returns `true` if `Node` is an abstract clause, otherwise `false`.\n\n_See also: _`c_clause/3`.","ref":"cerl.html#is_c_clause/1"},{"type":"function","title":"cerl.is_c_cons/1","doc":"Returns `true` if `Node` is an abstract list constructor, otherwise `false`.","ref":"cerl.html#is_c_cons/1"},{"type":"function","title":"cerl.is_c_float/1","doc":"Returns `true` if `Node` represents a floating-point literal, otherwise `false`.\n\n_See also: _`c_float/1`.","ref":"cerl.html#is_c_float/1"},{"type":"function","title":"cerl.is_c_fname/1","doc":"Returns `true` if `Node` is an abstract function name variable, otherwise\n`false`.\n\n_See also: _`c_fname/2`, `c_var/1`, `var_name/1`.","ref":"cerl.html#is_c_fname/1"},{"type":"function","title":"cerl.is_c_fun/1","doc":"Returns `true` if `Node` is an abstract fun-expression, otherwise `false`.\n\n_See also: _`c_fun/2`.","ref":"cerl.html#is_c_fun/1"},{"type":"function","title":"cerl.is_c_int/1","doc":"Returns `true` if `Node` represents an integer literal, otherwise `false`.\n\n_See also: _`c_int/1`.","ref":"cerl.html#is_c_int/1"},{"type":"function","title":"cerl.is_c_let/1","doc":"Returns `true` if `Node` is an abstract let-expression, otherwise `false`.\n\n_See also: _`c_let/3`.","ref":"cerl.html#is_c_let/1"},{"type":"function","title":"cerl.is_c_letrec/1","doc":"Returns `true` if `Node` is an abstract letrec-expression, otherwise `false`.\n\n_See also: _`c_letrec/2`.","ref":"cerl.html#is_c_letrec/1"},{"type":"function","title":"cerl.is_c_list/1","doc":"Returns `true` if `Node` represents a proper list, otherwise `false`.\n\nA proper list is either the empty list `[]`, or a cons cell `[Head |\nTail]`, where recursively `Tail` is a proper list.\n\nNote: Because `Node` is a syntax tree, the actual run-time values\ncorresponding to its subtrees may often be partially or completely\nunknown. Thus, if `Node` represents for example \"`[... | Ns]`\" (where\n`Ns` is a variable), then the function will return `false`, because it\nis not known whether `Ns` will be bound to a list at run-time. If\n`Node` instead represents for example \"`[1, 2, 3]`\" or \"`[A | []]`\",\nthen the function will return `true`.\n\n_See also: _`c_cons/2`, `c_nil/0`, `list_elements/1`, `list_length/1`.","ref":"cerl.html#is_c_list/1"},{"type":"function","title":"cerl.is_c_map/1","doc":"Returns `true` if `Node` is any kind of abstract map (for constructing,\nupdating or matching), otherwise `false`.\n\n_See also: _`ann_c_map/3`, `c_map/1`, `c_map_pattern/1`.","ref":"cerl.html#is_c_map/1"},{"type":"function","title":"cerl.is_c_map_empty/1","doc":"Returns `true` if `Node` represents an empty abstract map, otherwise `false`.\n\n_See also: _`c_map/1`, `c_map_pattern/1`.","ref":"cerl.html#is_c_map_empty/1"},{"type":"function","title":"cerl.is_c_map_pattern/1","doc":"Returns `true` if `Node` is an abstract map pattern, otherwise `false`.\n\n_See also: _`c_map/1`, `c_map_pattern/1`.","ref":"cerl.html#is_c_map_pattern/1"},{"type":"function","title":"cerl.is_c_module/1","doc":"Returns `true` if `Node` is an abstract module definition, otherwise `false`.\n\n_See also: _`type/1`.","ref":"cerl.html#is_c_module/1"},{"type":"function","title":"cerl.is_c_nil/1","doc":"Returns `true` if `Node` is an abstract empty list, otherwise `false`.","ref":"cerl.html#is_c_nil/1"},{"type":"function","title":"cerl.is_c_primop/1","doc":"Returns `true` if `Node` is an abstract primitive operation call, otherwise\n`false`.\n\n_See also: _`c_primop/2`.","ref":"cerl.html#is_c_primop/1"},{"type":"function","title":"cerl.is_c_receive/1","doc":"Returns `true` if `Node` is an abstract receive-expression, otherwise `false`.\n\n_See also: _`c_receive/3`.","ref":"cerl.html#is_c_receive/1"},{"type":"function","title":"cerl.is_c_seq/1","doc":"Returns `true` if `Node` is an abstract sequencing expression, otherwise\n`false`.\n\n_See also: _`c_seq/2`.","ref":"cerl.html#is_c_seq/1"},{"type":"function","title":"cerl.is_c_string/1","doc":"Returns `true` if `Node` may represent a string literal, otherwise `false`.\n\nStrings are defined as lists of characters; see [`is_c_char/1`](`is_c_char/1`)\nfor details.\n\n_See also: _`c_string/1`, `is_c_char/1`, `is_print_string/1`.","ref":"cerl.html#is_c_string/1"},{"type":"function","title":"cerl.is_c_try/1","doc":"Returns `true` if `Node` is an abstract try-expression, otherwise `false`.\n\n_See also: _`c_try/5`.","ref":"cerl.html#is_c_try/1"},{"type":"function","title":"cerl.is_c_tuple/1","doc":"Returns `true` if `Node` is an abstract tuple, otherwise `false`.\n\n_See also: _`c_tuple/1`.","ref":"cerl.html#is_c_tuple/1"},{"type":"function","title":"cerl.is_c_values/1","doc":"Returns `true` if `Node` is an abstract value list, otherwise `false`.\n\n_See also: _`c_values/1`.","ref":"cerl.html#is_c_values/1"},{"type":"function","title":"cerl.is_c_var/1","doc":"Returns `true` if `Node` is an abstract variable, otherwise `false`.\n\n_See also: _`c_var/1`.","ref":"cerl.html#is_c_var/1"},{"type":"function","title":"cerl.is_data/1","doc":"Returns `true` if `Node` represents a data constructor, otherwise `false`.\n\nData constructors are cons cells, tuples, and atomic literals.\n\n_See also: _`data_arity/1`, `data_es/1`, `data_type/1`.","ref":"cerl.html#is_data/1"},{"type":"function","title":"cerl.is_leaf/1","doc":"Returns `true` if `Node` is a leaf node, otherwise `false`.\n\nThe current leaf node types are `literal` and `var`.\n\nNote: all literals (cf. [`is_literal/1`](`is_literal/1`)) are leaf nodes, even\nif they represent structured (constant) values such as `{foo, [bar, baz]}`. Also\nnote that variables are leaf nodes but not literals.\n\n_See also: _`is_literal/1`, `type/1`.","ref":"cerl.html#is_leaf/1"},{"type":"function","title":"cerl.is_literal/1","doc":"Returns `true` if `Node` represents a literal term, otherwise `false`.\n\nThis function returns `true` if and only if the value of\n[`concrete(Node)`](`concrete/1`) is defined.\n\nNote: This is a constant time operation.\n\n_See also: _`abstract/1`, `concrete/1`, `fold_literal/1`.","ref":"cerl.html#is_literal/1"},{"type":"function","title":"cerl.is_literal_term/1","doc":"Returns `true` if `Term` can be represented as a literal, otherwise `false`.\n\nThis function takes time proportional to the size of `Term`.\n\n_See also: _`abstract/1`.","ref":"cerl.html#is_literal_term/1"},{"type":"function","title":"cerl.is_print_char/1","doc":"Returns `true` if `Node` may represent a \"printing\" character, otherwise\n`false`. (Cf. [`is_c_char/1`](`is_c_char/1`).)\n\nA \"printing\" character has either a given graphical representation, or\na \"named\" escape sequence such as \"`\\n`\".  Currently, only ISO 8859-1\n(Latin-1) character values are recognized.\n\n_See also: _`c_char/1`, `is_c_char/1`.","ref":"cerl.html#is_print_char/1"},{"type":"function","title":"cerl.is_print_string/1","doc":"Returns `true` if `Node` may represent a string literal containing only\n\"printing\" characters, otherwise `false`.\n\nSee [`is_c_string/1`](`is_c_string/1`) and\n[`is_print_char/1`](`is_print_char/1`) for details. Currently, only\nISO 8859-1 (Latin-1) character values are recognized.\n\n_See also: _`c_string/1`, `is_c_string/1`, `is_print_char/1`.","ref":"cerl.html#is_print_string/1"},{"type":"function","title":"cerl.let_arg/1","doc":"Returns the argument subtree of an abstract let-expression.\n\n_See also: _`c_let/3`.","ref":"cerl.html#let_arg/1"},{"type":"function","title":"cerl.let_arity/1","doc":"Returns the number of left-hand side variables of an abstract let-expression.\n\nNote: this is equivalent to [`length(let_vars(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_let/3`, `let_vars/1`.","ref":"cerl.html#let_arity/1"},{"type":"function","title":"cerl.let_body/1","doc":"Returns the body subtree of an abstract let-expression.\n\n_See also: _`c_let/3`.","ref":"cerl.html#let_body/1"},{"type":"function","title":"cerl.let_vars/1","doc":"Returns the list of left-hand side variables of an abstract let-expression.\n\n_See also: _`c_let/3`, `let_arity/1`.","ref":"cerl.html#let_vars/1"},{"type":"function","title":"cerl.letrec_body/1","doc":"Returns the body subtree of an abstract letrec-expression.\n\n_See also: _`c_letrec/2`.","ref":"cerl.html#letrec_body/1"},{"type":"function","title":"cerl.letrec_defs/1","doc":"Returns the list of definitions of an abstract letrec-expression.\n\nIf `Node` represents \"`letrec V1 = F1 ... Vn = Fn in Body`\", the\nreturned value is `[{V1, F1}, ..., {Vn, Fn}]`.\n\n_See also: _`c_letrec/2`.","ref":"cerl.html#letrec_defs/1"},{"type":"function","title":"cerl.letrec_vars/1","doc":"Returns the list of left-hand side function variable subtrees of a\nletrec-expression.\n\nIf `Node` represents§ \"`letrec V1 = F1 ... Vn = Fn in Body`\", the\nreturned value is `[V1, ..., Vn]`.\n\n_See also: _`c_letrec/2`.","ref":"cerl.html#letrec_vars/1"},{"type":"function","title":"cerl.list_elements/1","doc":"Returns the list of element subtrees of an abstract list.\n\n`Node` must represent a proper list. For example, if `Node` represents\n\"`[X1, X2 | [X3, X4 | []]`\", then\n[`list_elements(Node)`](`list_elements/1`) yields the list `[X1, X2,\nX3, X4]`.\n\n_See also: _`c_cons/2`, `c_nil/0`, `is_c_list/1`, `list_length/1`,\n`make_list/2`.","ref":"cerl.html#list_elements/1"},{"type":"function","title":"cerl.list_length/1","doc":"Returns the number of element subtrees of an abstract list.\n\n`Node` must represent a proper list. For example, if `Node` represents\n\"`[X1 | [X2, X3 | [X4, X5, X6]]]`\", then\n[`list_length(Node)`](`list_length/1`) returns the integer 6.\n\nNote: this is equivalent to [`length(list_elements(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_cons/2`, `c_nil/0`, `is_c_list/1`, `list_elements/1`.","ref":"cerl.html#list_length/1"},{"type":"function","title":"cerl.make_data/2","doc":"Creates a data constructor node with the specified type and subtrees. (Cf.\n[`data_type/1`](`data_type/1`).)\n\nAn exception is thrown if the length of `Elements` is invalid for the\ngiven `Type`; see [`data_es/1`](`data_es/1`) for arity constraints on\nconstructor types.\n\n_See also: _`ann_make_data/3`, `data_es/1`, `data_type/1`, `make_data_skel/2`,\n`update_data/3`.","ref":"cerl.html#make_data/2"},{"type":"function","title":"cerl.make_data_skel/2","doc":"Like [`make_data/2`](`make_data/2`), but analogous to\n[`c_tuple_skel/1`](`c_tuple_skel/1`) and [`c_cons_skel/2`](`c_cons_skel/2`).\n\n_See also: _`ann_make_data_skel/3`, `c_cons_skel/2`, `c_tuple_skel/1`,\n`make_data/2`, `update_data_skel/3`.","ref":"cerl.html#make_data_skel/2"},{"type":"function","title":"cerl.make_list/1","doc":"Equivalent to  make_list(List, none) .","ref":"cerl.html#make_list/1"},{"type":"function","title":"cerl.make_list/2","doc":"Creates an abstract list from the elements in `List` and the optional `Tail`.\n\nIf `Tail` is `none`, the result will represent a nil-terminated list,\notherwise it represents \"`[... | Tail]`\".\n\n_See also: _`ann_make_list/3`, `c_cons/2`, `c_nil/0`, `list_elements/1`,\n`update_list/3`.","ref":"cerl.html#make_list/2"},{"type":"function","title":"cerl.make_tree/2","doc":"Creates a syntax tree with the given type and subtrees.\n\n`Type` must be a node type name (cf. [`type/1`](`type/1`)) that does\nnot denote a leaf node type (cf.\n[`is_leaf/1`](`is_leaf/1`)).\n\n`Groups` must be a _nonempty_ list of groups of syntax trees,\nrepresenting the subtrees of a node of the given type, in\nleft-to-right order as they would occur in the printed program text,\ngrouped by category as done by [`subtrees/1`](`subtrees/1`).\n\nThe result of\n[`ann_make_tree(get_ann(Node), type(Node), subtrees(Node))`](`ann_make_tree/3`)\n(cf. [`update_tree/2`](`update_tree/2`)) represents the same source code text as\nthe original `Node`, assuming that [`subtrees(Node)`](`subtrees/1`) yields a\nnonempty list. However, it does not necessarily have the exact same data\nrepresentation as `Node`.\n\n_See also: _`ann_make_tree/3`, `is_leaf/1`, `subtrees/1`, `type/1`,\n`update_tree/2`.","ref":"cerl.html#make_tree/2"},{"type":"function","title":"cerl.map_arg/1","doc":"Returns the argument subtree of an abstract map.\n\n_See also: _`c_map/2`.","ref":"cerl.html#map_arg/1"},{"type":"function","title":"cerl.map_es/1","doc":"Returns the list of map pair subtrees of an abstract map.\n\n_See also: _`c_map/1`.","ref":"cerl.html#map_es/1"},{"type":"type","title":"cerl.map_op/0","doc":"","ref":"cerl.html#t:map_op/0"},{"type":"function","title":"cerl.map_pair_key/1","doc":"Returns the key subtree of an abstract map pair.\n\n_See also: _`c_map_pair/2`, `c_map_pair_exact/2`.","ref":"cerl.html#map_pair_key/1"},{"type":"function","title":"cerl.map_pair_op/1","doc":"Returns the operation subtree of an abstract map pair.\n\n_See also: _`c_map_pair/2`, `c_map_pair_exact/2`.","ref":"cerl.html#map_pair_op/1"},{"type":"function","title":"cerl.map_pair_val/1","doc":"Returns the value subtree of an abstract map pair.\n\n_See also: _`c_map_pair/2`, `c_map_pair_exact/2`.","ref":"cerl.html#map_pair_val/1"},{"type":"function","title":"cerl.meta/1","doc":"Creates a meta-representation of a syntax tree.\n\nThe result represents an Erlang expression \"`MetaTree`\" which, if\nevaluated, will yield a new syntax tree representing the same source\ncode text as `Tree` (although the actual data representation may be\ndifferent). The expression represented by `MetaTree` is\n_implementation independent_ with regard to the data structures used\nby the abstract syntax tree implementation.\n\nAny node in `Tree` whose node type is `var` (cf. [`type/1`](`type/1`)), and\nwhose list of annotations (cf. [`get_ann/1`](`get_ann/1`)) contains the atom\n`meta_var`, will remain unchanged in the resulting tree, except that exactly one\noccurrence of `meta_var` is removed from its annotation list.\n\nThe main use of the function [`meta/1`](`meta/1`) is to transform a data\nstructure `Tree`, which represents a piece of program code, into a form that is\n_representation independent when printed_. E.g., suppose `Tree` represents a\nvariable named \"V\". Then (assuming a function `print/1` for printing syntax\ntrees), evaluating `print(abstract(Tree))` \\- simply using\n[`abstract/1`](`abstract/1`) to map the actual data structure onto a syntax tree\nrepresentation - would output a string that might look something like\n\"`{var, ..., 'V'}`\", which is obviously dependent on the implementation of the\nabstract syntax trees. This could, for example, be useful for caching a syntax tree\nin a file. However, in some situations like in a program generator generator (with\ntwo \"generator\"), it may be unacceptable. Using `print(meta(Tree))` instead\nwould output a _representation independent_ syntax tree generating expression;\nin the above case, something like \"`cerl:c_var('V')`\".\n\nThe implementation tries to generate compact code with respect to literals and\nlists.\n\n_See also: _`abstract/1`, `get_ann/1`, `type/1`.","ref":"cerl.html#meta/1"},{"type":"function","title":"cerl.module_attrs/1","doc":"Returns the list of pairs of attribute key/value subtrees of an abstract module\ndefinition.\n\n_See also: _`c_module/4`.","ref":"cerl.html#module_attrs/1"},{"type":"function","title":"cerl.module_defs/1","doc":"Returns the list of function definitions of an abstract module definition.\n\n_See also: _`c_module/4`.","ref":"cerl.html#module_defs/1"},{"type":"function","title":"cerl.module_exports/1","doc":"Returns the list of exports subtrees of an abstract module definition.\n\n_See also: _`c_module/4`.","ref":"cerl.html#module_exports/1"},{"type":"function","title":"cerl.module_name/1","doc":"Returns the name subtree of an abstract module definition.\n\n_See also: _`c_module/4`.","ref":"cerl.html#module_name/1"},{"type":"function","title":"cerl.module_vars/1","doc":"Returns the list of left-hand side function variable subtrees of an abstract\nmodule definition.\n\n_See also: _`c_module/4`.","ref":"cerl.html#module_vars/1"},{"type":"function","title":"cerl.pat_list_vars/1","doc":"Returns the list of all abstract variables in the given patterns.\n\nAn exception is thrown if some element in `Patterns` does not\nrepresent a well-formed Core Erlang clause pattern. The order of\nlisting is not defined.\n\n_See also: _`clause_vars/1`, `pat_vars/1`.","ref":"cerl.html#pat_list_vars/1"},{"type":"function","title":"cerl.pat_vars/1","doc":"Returns the list of all abstract variables in a pattern.\n\nAn exception is thrown if `Node` does not represent a well-formed Core\nErlang clause pattern. The order of listing is not defined.\n\n_See also: _`clause_vars/1`, `pat_list_vars/1`.","ref":"cerl.html#pat_vars/1"},{"type":"function","title":"cerl.primop_args/1","doc":"Returns the list of argument subtrees of an abstract primitive operation call.\n\n_See also: _`c_primop/2`, `primop_arity/1`.","ref":"cerl.html#primop_args/1"},{"type":"function","title":"cerl.primop_arity/1","doc":"Returns the number of argument subtrees of an abstract primitive operation call.\n\nNote: this is equivalent to [`length(primop_args(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_primop/2`, `primop_args/1`.","ref":"cerl.html#primop_arity/1"},{"type":"function","title":"cerl.primop_name/1","doc":"Returns the name subtree of an abstract primitive operation call.\n\n_See also: _`c_primop/2`.","ref":"cerl.html#primop_name/1"},{"type":"function","title":"cerl.receive_action/1","doc":"Returns the action subtree of an abstract receive-expression.\n\n_See also: _`c_receive/3`.","ref":"cerl.html#receive_action/1"},{"type":"function","title":"cerl.receive_clauses/1","doc":"Returns the list of clause subtrees of an abstract receive-expression.\n\n_See also: _`c_receive/3`.","ref":"cerl.html#receive_clauses/1"},{"type":"function","title":"cerl.receive_timeout/1","doc":"Returns the timeout subtree of an abstract receive-expression.\n\n_See also: _`c_receive/3`.","ref":"cerl.html#receive_timeout/1"},{"type":"function","title":"cerl.seq_arg/1","doc":"Returns the argument subtree of an abstract sequencing expression.\n\n_See also: _`c_seq/2`.","ref":"cerl.html#seq_arg/1"},{"type":"function","title":"cerl.seq_body/1","doc":"Returns the body subtree of an abstract sequencing expression.\n\n_See also: _`c_seq/2`.","ref":"cerl.html#seq_body/1"},{"type":"function","title":"cerl.set_ann/2","doc":"Sets the list of user annotations of `Node` to `Annotations`.\n\n_See also: _`add_ann/2`, `copy_ann/2`, `get_ann/1`.","ref":"cerl.html#set_ann/2"},{"type":"function","title":"cerl.string_lit/1","doc":"Returns the literal string represented by an abstract string. This includes\nsurrounding double-quote characters `\"...\"`.\n\nCurrently, characters that are not in the set of ISO 8859-1 (Latin-1)\n\"printing\" characters will be escaped, except for spaces.\n\n_See also: _`c_string/1`.","ref":"cerl.html#string_lit/1"},{"type":"function","title":"cerl.string_val/1","doc":"Returns the value represented by an abstract string literal.\n\n_See also: _`c_string/1`.","ref":"cerl.html#string_val/1"},{"type":"function","title":"cerl.subtrees/1","doc":"Returns the grouped list of all subtrees of a node.\n\nIf `Node` is a leaf node (cf. [`is_leaf/1`](`is_leaf/1`)), this is the\nempty list, otherwise the result is always a nonempty list, containing\nthe lists of subtrees of `Node`, in left-to-right order as they occur\nin the printed program text, and grouped by category. Often, each\ngroup contains only a single subtree.\n\nDepending on the type of `Node`, the size of some groups may be\nvariable (for example, the group consisting of all the elements of a\ntuple), while others always contain the same number of elements -\nusually exactly one (for example, the group containing the argument\nexpression of a case-expression). Note, however, that the exact\nstructure of the returned list (for a given node type) should in\ngeneral not be depended upon, since it might be subject to change\nwithout notice.\n\nThe function [`subtrees/1`](`subtrees/1`) and the constructor functions\n[`make_tree/2`](`make_tree/2`) and [`update_tree/2`](`update_tree/2`) can be a\ngreat help if one wants to traverse a syntax tree, visiting all its subtrees,\nbut treat nodes of the tree in a uniform way in most or all cases. Using these\nfunctions makes this simple, and also assures that your code is not overly\nsensitive to extensions of the syntax tree data type, because any node types not\nexplicitly handled by your code can be left to a default case.\n\nFor example:\n\n```text\n    postorder(F, Tree) ->\n        F(case subtrees(Tree) of\n            [] -> Tree;\n            List -> update_tree(Tree,\n                                [[postorder(F, Subtree)\n                                  || Subtree <- Group]\n                                 || Group <- List])\n          end).\n\n```\n\nmaps the function `F` on `Tree` and all its subtrees, doing a post-order\ntraversal of the syntax tree. (Note the use of\n[`update_tree/2`](`update_tree/2`) to preserve annotations.) For a simple\nfunction like:\n\n```text\n    f(Node) ->\n        case type(Node) of\n            atom -> atom(\"a_\" ++ atom_name(Node));\n            _ -> Node\n        end.\n\n```\n\nthe call `postorder(fun f/1, Tree)` will yield a new representation of `Tree` in\nwhich all atom names have been extended with the prefix \"a\\_\", but nothing else\n(including annotations) has been changed.\n\n_See also: _`is_leaf/1`, `make_tree/2`, `update_tree/2`.","ref":"cerl.html#subtrees/1"},{"type":"function","title":"cerl.to_records/1","doc":"Translates an abstract syntax tree to a corresponding explicit record\nrepresentation.\n\nThe records are defined in the file \"`cerl.hrl`\".\n\n_See also: _`from_records/1`, `type/1`.","ref":"cerl.html#to_records/1"},{"type":"function","title":"cerl.try_arg/1","doc":"Returns the expression subtree of an abstract try-expression.\n\n_See also: _`c_try/5`.","ref":"cerl.html#try_arg/1"},{"type":"function","title":"cerl.try_body/1","doc":"Returns the success body subtree of an abstract try-expression.\n\n_See also: _`c_try/5`.","ref":"cerl.html#try_body/1"},{"type":"function","title":"cerl.try_evars/1","doc":"Returns the list of exception variable subtrees of an abstract try-expression.\n\n_See also: _`c_try/5`.","ref":"cerl.html#try_evars/1"},{"type":"function","title":"cerl.try_handler/1","doc":"Returns the exception body subtree of an abstract try-expression.\n\n_See also: _`c_try/5`.","ref":"cerl.html#try_handler/1"},{"type":"function","title":"cerl.try_vars/1","doc":"Returns the list of success variable subtrees of an abstract try-expression.\n\n_See also: _`c_try/5`.","ref":"cerl.html#try_vars/1"},{"type":"function","title":"cerl.tuple_arity/1","doc":"Returns the number of element subtrees of an abstract tuple.\n\nNote: this is equivalent to [`length(tuple_es(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_tuple/1`, `tuple_es/1`.","ref":"cerl.html#tuple_arity/1"},{"type":"function","title":"cerl.tuple_es/1","doc":"Returns the list of element subtrees of an abstract tuple.\n\n_See also: _`c_tuple/1`.","ref":"cerl.html#tuple_es/1"},{"type":"function","title":"cerl.type/1","doc":"Returns the type tag of `Node`.\n\nCurrent node types are:\n\n- `alias`\n- `apply`\n- `binary`\n- `bitstr`\n- `call`\n- `case`\n- `catch`\n- `clause`\n- `cons`\n- `fun`\n- `let`\n- `letrec`\n- `literal`\n- `map`\n- `map_pair`\n- `module`\n- `opaque`\n- `primop`\n- `receive`\n- `seq`\n- `try`\n- `tuple`\n- `values`\n- `var`\n\n> #### Note {: .info }\n> The name of the primary constructor function for a node type is always the\n> name of the type itself, prefixed by \"`c_`\"; recognizer predicates are\n> correspondingly prefixed by \"`is_c_`\". Furthermore, to simplify preservation of\n> annotations (cf. [`get_ann/1`](`get_ann/1`)), there are analogous constructor\n> functions prefixed by \"`ann_c_`\" and \"`update_c_`\", for setting the annotation\n> list of the new node to either a specific value or to the annotations of an\n> existing node, respectively.\n\nThe only purpose of the `opaque` type is to facilitate testing of the compiler.\n\n_See also: _`abstract/1`, `c_alias/2`, `c_apply/2`, `c_binary/1`, `c_bitstr/5`,\n`c_call/3`, `c_case/2`, `c_catch/1`, `c_clause/3`, `c_cons/2`, `c_fun/2`,\n`c_let/3`, `c_letrec/2`, `c_module/3`, `c_primop/2`, `c_receive/1`, `c_seq/2`,\n`c_try/5`, `c_tuple/1`, `c_values/1`, `c_var/1`, `data_type/1`,\n`from_records/1`, `get_ann/1`, `meta/1`, `subtrees/1`, `to_records/1`.","ref":"cerl.html#type/1"},{"type":"function","title":"cerl.unfold_literal/1","doc":"Ensures that literals have a fully expanded representation.\n\nIf `Node` represents a literal tuple or list constructor, its elements\nare rewritten recursively, and the node is reconstructed using\n[`c_cons_skel/2`](`c_cons_skel/2`) or\n[`c_tuple_skel/1`](`c_tuple_skel/1`), respectively; otherwise, `Node`\nis not changed. The `fold_literal/1` can be used to revert to the\nnormal compact representation.\n\n_See also: _`c_cons/2`, `c_cons_skel/2`, `c_tuple/1`, `c_tuple_skel/1`,\n`fold_literal/1`, `is_literal/1`.","ref":"cerl.html#unfold_literal/1"},{"type":"function","title":"cerl.update_c_alias/3","doc":"_See also: _`c_alias/2`.","ref":"cerl.html#update_c_alias/3"},{"type":"function","title":"cerl.update_c_apply/3","doc":"_See also: _`c_apply/2`.","ref":"cerl.html#update_c_apply/3"},{"type":"function","title":"cerl.update_c_binary/2","doc":"_See also: _`c_binary/1`.","ref":"cerl.html#update_c_binary/2"},{"type":"function","title":"cerl.update_c_bitstr/5","doc":"Equivalent to\n[update_c_bitstr(Node, Value, Size, abstract(1), Type, Flags)](`update_c_bitstr/6`).","ref":"cerl.html#update_c_bitstr/5"},{"type":"function","title":"cerl.update_c_bitstr/6","doc":"_See also: _`c_bitstr/5`, `update_c_bitstr/5`.","ref":"cerl.html#update_c_bitstr/6"},{"type":"function","title":"cerl.update_c_call/4","doc":"_See also: _`c_call/3`.","ref":"cerl.html#update_c_call/4"},{"type":"function","title":"cerl.update_c_case/3","doc":"_See also: _`c_case/2`.","ref":"cerl.html#update_c_case/3"},{"type":"function","title":"cerl.update_c_catch/2","doc":"_See also: _`c_catch/1`.","ref":"cerl.html#update_c_catch/2"},{"type":"function","title":"cerl.update_c_clause/4","doc":"_See also: _`c_clause/3`.","ref":"cerl.html#update_c_clause/4"},{"type":"function","title":"cerl.update_c_cons/3","doc":"_See also: _`c_cons/2`.","ref":"cerl.html#update_c_cons/3"},{"type":"function","title":"cerl.update_c_cons_skel/3","doc":"_See also: _`c_cons_skel/2`.","ref":"cerl.html#update_c_cons_skel/3"},{"type":"function","title":"cerl.update_c_fname/2","doc":"Like [`update_c_fname/3`](`update_c_fname/3`), but takes the arity from `Node`.\n\n_See also: _`c_fname/2`, `update_c_fname/3`.","ref":"cerl.html#update_c_fname/2"},{"type":"function","title":"cerl.update_c_fname/3","doc":"Equivalent to [update_c_var(Old, \\{Atom, Arity\\})](`update_c_var/2`).\n\n_See also: _`c_fname/2`, `update_c_fname/2`.","ref":"cerl.html#update_c_fname/3"},{"type":"function","title":"cerl.update_c_fun/3","doc":"_See also: _`c_fun/2`.","ref":"cerl.html#update_c_fun/3"},{"type":"function","title":"cerl.update_c_let/4","doc":"_See also: _`c_let/3`.","ref":"cerl.html#update_c_let/4"},{"type":"function","title":"cerl.update_c_letrec/3","doc":"_See also: _`c_letrec/2`.","ref":"cerl.html#update_c_letrec/3"},{"type":"function","title":"cerl.update_c_map/3","doc":"_See also: _`c_map/1`, `c_map_pattern/1`.","ref":"cerl.html#update_c_map/3"},{"type":"function","title":"cerl.update_c_map_pair/4","doc":"_See also: _`c_map_pair/2`, `c_map_pair_exact/2`.","ref":"cerl.html#update_c_map_pair/4"},{"type":"function","title":"cerl.update_c_module/5","doc":"_See also: _`c_module/4`.","ref":"cerl.html#update_c_module/5"},{"type":"function","title":"cerl.update_c_primop/3","doc":"_See also: _`c_primop/2`.","ref":"cerl.html#update_c_primop/3"},{"type":"function","title":"cerl.update_c_receive/4","doc":"_See also: _`c_receive/3`.","ref":"cerl.html#update_c_receive/4"},{"type":"function","title":"cerl.update_c_seq/3","doc":"_See also: _`c_seq/2`.","ref":"cerl.html#update_c_seq/3"},{"type":"function","title":"cerl.update_c_try/6","doc":"_See also: _`c_try/5`.","ref":"cerl.html#update_c_try/6"},{"type":"function","title":"cerl.update_c_tuple/2","doc":"_See also: _`c_tuple/1`.","ref":"cerl.html#update_c_tuple/2"},{"type":"function","title":"cerl.update_c_tuple_skel/2","doc":"_See also: _`c_tuple_skel/1`.","ref":"cerl.html#update_c_tuple_skel/2"},{"type":"function","title":"cerl.update_c_values/2","doc":"_See also: _`c_values/1`.","ref":"cerl.html#update_c_values/2"},{"type":"function","title":"cerl.update_c_var/2","doc":"_See also: _`c_var/1`.","ref":"cerl.html#update_c_var/2"},{"type":"function","title":"cerl.update_data/3","doc":"_See also: _`make_data/2`.","ref":"cerl.html#update_data/3"},{"type":"function","title":"cerl.update_data_skel/3","doc":"_See also: _`make_data_skel/2`.","ref":"cerl.html#update_data_skel/3"},{"type":"function","title":"cerl.update_list/2","doc":"Equivalent to  update_list(Old, List, none) .","ref":"cerl.html#update_list/2"},{"type":"function","title":"cerl.update_list/3","doc":"_See also: _`make_list/2`, `update_list/2`.","ref":"cerl.html#update_list/3"},{"type":"function","title":"cerl.update_tree/2","doc":"Creates a syntax tree with the given subtrees, and the same type and annotations\nas the node `Node`.\n\nThis is equivalent to [`ann_make_tree(get_ann(Node), type(Node),\nGroups)`](`ann_make_tree/3`), but potentially more efficient.\n\n_See also: _`ann_make_tree/3`, `get_ann/1`, `type/1`, `update_tree/3`.","ref":"cerl.html#update_tree/2"},{"type":"function","title":"cerl.update_tree/3","doc":"Creates a syntax tree with the given type and subtrees, and the same annotations\nas the node `Node`.\n\nThis is equivalent to\n[`ann_make_tree(get_ann(Node), Type, Groups)`](`ann_make_tree/3`), but\npotentially more efficient.\n\n_See also: _`ann_make_tree/3`, `get_ann/1`, `update_tree/2`.","ref":"cerl.html#update_tree/3"},{"type":"type","title":"cerl.value/0","doc":"","ref":"cerl.html#t:value/0"},{"type":"function","title":"cerl.values_arity/1","doc":"Returns the number of element subtrees of an abstract value list.\n\nNote: This is equivalent to [`length(values_es(Node))`](`length/1`), but\npotentially more efficient.\n\n_See also: _`c_values/1`, `values_es/1`.","ref":"cerl.html#values_arity/1"},{"type":"function","title":"cerl.values_es/1","doc":"Returns the list of element subtrees of an abstract value list.\n\n_See also: _`c_values/1`, `values_arity/1`.","ref":"cerl.html#values_es/1"},{"type":"type","title":"cerl.var_name/0","doc":"","ref":"cerl.html#t:var_name/0"},{"type":"function","title":"cerl.var_name/1","doc":"Returns the name of an abstract variable.\n\n_See also: _`c_var/1`.","ref":"cerl.html#var_name/1"},{"type":"module","title":"cerl_clauses","doc":"Utility functions for Core Erlang case/receive clauses.\n\n> #### Note {: .info }\n>\n> The documentation of the public interface for the Erlang compiler can be\n> found in module `m:compile`.\n>\n> This module is an internal part of the compiler. Its API is not guaranteed\n> to remain compatible between releases.\n\nSyntax trees are defined in the module `m:cerl`.","ref":"cerl_clauses.html"},{"type":"function","title":"cerl_clauses.any_catchall/1","doc":"Returns `true` if any of the abstract clauses in the list is a catch-all,\notherwise `false`.\n\nSee [`is_catchall/1`](`is_catchall/1`) for details.\n\nNote: each node in `Clauses` must have type `clause`.\n\n_See also: _`is_catchall/1`.","ref":"cerl_clauses.html#any_catchall/1"},{"type":"type","title":"cerl_clauses.bindings/0","doc":"","ref":"cerl_clauses.html#t:bindings/0"},{"type":"type","title":"cerl_clauses.cerl/0","doc":"","ref":"cerl_clauses.html#t:cerl/0"},{"type":"function","title":"cerl_clauses.eval_guard/1","doc":"Tries to reduce a guard expression to a single constant value, if possible.\n\nThe returned value is `{value, Term}` if the guard expression `Expr`\nalways yields the constant value `Term`, and is otherwise `none`.\n\nNote that although guard expressions should only yield boolean values, this\nfunction does not guarantee that `Term` is either `true` or `false`. Also note\nthat only simple constructs like let-expressions are examined recursively;\ngeneral constant folding is not performed.\n\n_See also: _`is_catchall/1`.","ref":"cerl_clauses.html#eval_guard/1"},{"type":"type","title":"cerl_clauses.expr/0","doc":"","ref":"cerl_clauses.html#t:expr/0"},{"type":"function","title":"cerl_clauses.is_catchall/1","doc":"Returns `true` if an abstract clause is a catch-all, otherwise `false`.\n\nA clause is a catch-all if all its patterns are variables, and its\nguard expression always evaluates to `true`;\ncf. [`eval_guard/1`](`eval_guard/1`).\n\nNote: `Clause` must have type `clause`.\n\n_See also: _`any_catchall/1`, `eval_guard/1`.","ref":"cerl_clauses.html#is_catchall/1"},{"type":"function","title":"cerl_clauses.match/2","doc":"Matches a pattern against an expression.\n\nThe returned value is `none` if a match is impossible, `{true,\nBindings}` if `Pattern` definitely matches `Expr`, and `{false,\nBindings}` if a match is not definite, but cannot be excluded.\n`Bindings` is then a list of pairs `{Var, SubExpr}`, associating each\nvariable in the pattern with either the corresponding subexpression of\n`Expr`, or with the atom `any` if no matching subexpression\nexists. (Recall that variables may not be repeated in a Core Erlang\npattern.) The list of bindings is given in innermost-first order; this\nshould only be of interest if `Pattern` contains one or more alias\npatterns. If the returned value is `{true, []}`, it implies that the\npattern and the expression are syntactically identical.\n\nInstead of a syntax tree, the atom `any` can be passed for `Expr` (or, more\ngenerally, be used for any subtree of `Expr`, in as much the abstract syntax\ntree implementation allows it); this means that it cannot be decided whether the\npattern will match or not, and the corresponding variable bindings will all map\nto `any`. The typical use is for producing bindings for `receive` clauses.\n\nNote: Binary-syntax patterns are never structurally matched against\nbinary-syntax expressions by this function.\n\nExamples:\n\n- Matching a pattern \"`{X, Y}`\" against the expression \"`{foo, f(Z)}`\" yields\n  `{true, Bindings}` where `Bindings` associates \"`X`\" with the subtree \"`foo`\"\n  and \"`Y`\" with the subtree \"`f(Z)`\".\n- Matching pattern \"`{X, {bar, Y}}`\" against expression \"`{foo, f(Z)}`\" yields\n  `{false, Bindings}` where `Bindings` associates \"`X`\" with the subtree \"`foo`\"\n  and \"`Y`\" with `any` (because it is not known if \"`{foo, Y}`\" might match the\n  run-time value of \"`f(Z)`\" or not).\n- Matching pattern \"`{foo, bar}`\" against expression \"`{foo, f()}`\" yields\n  `{false, []}`, telling us that there might be a match, but we cannot deduce\n  any bindings.\n- Matching `{foo, X = {bar, Y}}` against expression \"`{foo, {bar, baz}}`\" yields\n  `{true, Bindings}` where `Bindings` associates \"`Y`\" with \"`baz`\", and \"`X`\"\n  with \"`{bar, baz}`\".\n- Matching a pattern \"`{X, Y}`\" against `any` yields `{false, Bindings}` where\n  `Bindings` associates both \"`X`\" and \"`Y`\" with `any`.","ref":"cerl_clauses.html#match/2"},{"type":"function","title":"cerl_clauses.match_list/2","doc":"Like [`match/2`](`match/2`), but matching a sequence of patterns against a\nsequence of expressions.\n\nPassing an empty list for `Exprs` is equivalent to passing a list of\n`any` atoms of the same length as `Patterns`.\n\n_See also: _`match/2`.","ref":"cerl_clauses.html#match_list/2"},{"type":"type","title":"cerl_clauses.match_ret/0","doc":"","ref":"cerl_clauses.html#t:match_ret/0"},{"type":"function","title":"cerl_clauses.reduce/1","doc":"Equivalent to [reduce(Cs, [])](`reduce/2`).","ref":"cerl_clauses.html#reduce/1"},{"type":"function","title":"cerl_clauses.reduce/2","doc":"Selects a single clause, if possible, or otherwise reduces the list of\nselectable clauses.\n\nThe input is a list `Clauses` of abstract clauses (i.e.,\nsyntax trees of type `clause`), and a list of switch expressions `Exprs`. The\nfunction tries to uniquely select a single clause or discard unselectable\nclauses, with respect to the switch expressions. All abstract clauses in the\nlist must have the same number of patterns. If `Exprs` is not the empty list, it\nmust have the same length as the number of patterns in each clause; see\n[`match_list/2`](`match_list/2`) for details.\n\nA clause can only be selected if its guard expression always yields the atom\n`true`, and a clause whose guard expression always yields the atom `false` can\nnever be selected. Other guard expressions are considered to have unknown value;\ncf. [`eval_guard/1`](`eval_guard/1`).\n\nIf a particular clause can be selected, the function returns\n`{true, {Clause, Bindings}}`, where `Clause` is the selected clause and\n`Bindings` is a list of pairs `{Var, SubExpr}` associating the variables\noccurring in the patterns of `Clause` with the corresponding subexpressions in\n`Exprs`. The list of bindings is given in innermost-first order; see the\n[`match/2`](`match/2`) function for details.\n\nIf no clause could be definitely selected, the function returns\n`{false, NewClauses}`, where `NewClauses` is the list of entries in `Clauses`\nthat remain after eliminating unselectable clauses, preserving the relative\norder.\n\n_See also: _`eval_guard/1`, `match/2`, `match_list/2`.","ref":"cerl_clauses.html#reduce/2"},{"type":"module","title":"cerl_trees","doc":"Basic functions on Core Erlang abstract syntax trees.\n\n> #### Note {: .info }\n>\n> The public interface of the Erlang compiler can be found in\n> module `m:compile`.\n>\n> This module is an internal part of the compiler. Its API is not guaranteed\n> to remain compatible between releases.\n\nSyntax trees are defined in the module `m:cerl`.","ref":"cerl_trees.html"},{"type":"type","title":"cerl_trees.cerl/0","doc":"","ref":"cerl_trees.html#t:cerl/0"},{"type":"function","title":"cerl_trees.depth/1","doc":"Returns the length of the longest path in the tree.\n\nA leaf node has depth zero, the tree representing \"`{foo, bar}`\" has\ndepth one, and so on.","ref":"cerl_trees.html#depth/1"},{"type":"function","title":"cerl_trees.fold/3","doc":"Does a fold operation over the nodes of the tree.\n\nThe result is the value of `Function(X1, Function(X2, ... Function(Xn,\nUnit) ... ))`, where `X1, ..., Xn` are the nodes of `Tree` in a\npost-order traversal.\n\n_See also: _`mapfold/3`.","ref":"cerl_trees.html#fold/3"},{"type":"function","title":"cerl_trees.free_variables/1","doc":"Like [`variables/1`](`variables/1`), but only includes variables that are free\nin the tree.\n\n_See also: _`next_free_variable_name/1`, `variables/1`.","ref":"cerl_trees.html#free_variables/1"},{"type":"function","title":"cerl_trees.get_label/1","doc":"Retrieves the label for `Tree`.\n\nAn exception is thrown if `Tree` does not have a label, or if `Tree`\ndoes not represent a well-formed Core Erlang syntax tree.","ref":"cerl_trees.html#get_label/1"},{"type":"function","title":"cerl_trees.label/1","doc":"Equivalent to [label(Tree, 0)](`label/2`).","ref":"cerl_trees.html#label/1"},{"type":"function","title":"cerl_trees.label/2","doc":"Labels each expression in the tree.\n\nA term `{label, L}` is prefixed to the annotation list of each\nexpression node, where L is a unique number for every node, except for\nvariables (and function name variables) which get the same label if\nthey represent the same variable. Constant literal nodes are not\nlabeled.\n\nThe returned value is a tuple `{NewTree, Max}`, where `NewTree` is the labeled\ntree and `Max` is 1 plus the largest label value used. All previous annotation\nterms of the form `{label, X}` are deleted.\n\nThe values of L used in the tree is a dense range from `N` to `Max - 1`, where\n`N =< Max =< N + size(Tree)`. Note that it is possible that no labels are used\nat all, i.e., `N = Max`.\n\nNote: All instances of free variables will be given distinct labels.\n\n_See also: _`label/1`, `size/1`.","ref":"cerl_trees.html#label/2"},{"type":"function","title":"cerl_trees.map/2","doc":"Maps a function onto the nodes of a tree.\n\nThis replaces each node in the tree by the result of applying the\ngiven function on the original node, bottom-up.\n\n_See also: _`mapfold/3`.","ref":"cerl_trees.html#map/2"},{"type":"function","title":"cerl_trees.mapfold/3","doc":"Does a combined map/fold operation on the nodes of the tree.\n\nThis is similar to [`map/2`](`map/2`), but also propagates a value\nfrom each application of `Function` to the next, starting with the\ngiven value `Initial`, while doing a post-order traversal of the tree,\nmuch like [`fold/3`](`fold/3`).\n\nThis is equivalent to `mapfold/4` with an identity function as the\npre-operation.\n\n_See also:_ `fold/3`, `map/2`, `mapfold/4`.","ref":"cerl_trees.html#mapfold/3"},{"type":"function","title":"cerl_trees.mapfold/4","doc":"Does a combined map/fold operation on the nodes of the tree.\n\nIt begins by calling `Pre` on the tree, using the `Initial`\nvalue. `Pre` must either return a tree with an updated accumulator or\nthe atom `skip`.\n\nIf a tree is returned, this function deconstructs the top node of the returned\ntree and recurses on the children, using the returned value as the new initial\nand carrying the returned values from one call to the next. Finally it\nreassembles the top node from the children, calls `Post` on it and returns the\nresult.\n\nIf `skip` is returned, it returns the tree and accumulator as is.","ref":"cerl_trees.html#mapfold/4"},{"type":"function","title":"cerl_trees.next_free_variable_name/1","doc":"Returns a integer variable name higher than any other integer variable name in\nthe syntax tree.\n\nAn exception is thrown if `Tree` does not represent a well-formed Core\nErlang syntax tree.\n\n_See also: _`free_variables/1`, `variables/1`.","ref":"cerl_trees.html#next_free_variable_name/1"},{"type":"function","title":"cerl_trees.size/1","doc":"Returns the number of nodes in `Tree`.","ref":"cerl_trees.html#size/1"},{"type":"function","title":"cerl_trees.variables/1","doc":"Returns an ordered-set list of the names of all variables in the syntax tree\n(including function-name variables.)\n\nAn exception is thrown if `Tree` does not represent a well-formed Core\nErlang syntax tree.\n\n_See also: _`free_variables/1`, `next_free_variable_name/1`.","ref":"cerl_trees.html#variables/1"},{"type":"extras","title":"Compiler Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Compiler Release Notes\n\nThis document describes the changes made to the Compiler application.","ref":"notes.html"},{"type":"extras","title":"Compiler 9.0.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-9-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a compiler crash caused by patch order in destructive update.\n\n  Own Id: OTP-19660 Aux Id: [GH-9903], [PR-9909]\n\n- Fixed a compiler crash in `beam_ssa_pre_codegen` caused by wrong handling of multiple phi patches in the destructive update pass.\n\n  Own Id: OTP-19689 Aux Id: [GH-9987], [PR-9990]\n\n- Fixed a crash when a zip generator contains a map pattern.\n\n  Own Id: OTP-19693 Aux Id: [PR-10009], [GH-10002]\n\n- In rare circumstances, the compiler could crash when compiling code using bit syntax construction.\n\n  Own Id: OTP-19722 Aux Id: [GH-10077], [PR-10090]\n\n- A few minor bugs that could affect the `beam_debug_info` option were fixed.\n\n  Own Id: OTP-19758 Aux Id: [PR-10153]\n\n[GH-9903]: https://github.com/erlang/otp/issues/9903\n[PR-9909]: https://github.com/erlang/otp/pull/9909\n[GH-9987]: https://github.com/erlang/otp/issues/9987\n[PR-9990]: https://github.com/erlang/otp/pull/9990\n[PR-10009]: https://github.com/erlang/otp/pull/10009\n[GH-10002]: https://github.com/erlang/otp/issues/10002\n[GH-10077]: https://github.com/erlang/otp/issues/10077\n[PR-10090]: https://github.com/erlang/otp/pull/10090\n[PR-10153]: https://github.com/erlang/otp/pull/10153","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Compiler 9.0.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-9-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that could cause empty bitstring matches to always succeed, even when they should not.\n\n  Own Id: OTP-19711 Aux Id: [GH-10047], [PR-10048]\n\n[GH-10047]: https://github.com/erlang/otp/issues/10047\n[PR-10048]: https://github.com/erlang/otp/pull/10048","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Compiler 9.0 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-9-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler will now emit warnings when some map patterns cannot possibly match because a previous clauses matches the same pattern. For example:\n  \n  ```erlang\n  mm_1(#{}) -> a;\n  mm_1(#{b := B}) -> {b,B}.\n  \n  mm_2(#{a := A}) -> {a,A};\n  mm_2(#{a := A, b := B}) -> {b,A,B}.\n  ```\n  \n  The second clause of these function can never match and the compiler will now emit a warning for both of them.\n  \n  Note that the compiler is not guaranteed to emit warnings for every possible map pattern that cannot match.\n\n  Own Id: OTP-19141 Aux Id: [GH-8558], [PR-8600]\n\n- The size of an atom in the Erlang source code was limited to 255 bytes in previous releases, meaning that an atom containing only emojis could contain only 63 emojis.\n  \n  While atoms are still only allowed to contain 255 characters, the number of bytes is no longer limited.\n  \n  External tools that parse the `AtU8` chunk of a BEAM file directly need to be updated. Tools that use [`beam_lib:chunks(Beam, [atoms])`](`beam_lib:chunks/2`) to read the atom table will continue to work.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19285 Aux Id: [PR-8913]\n\n- The literals chunk in BEAM is no longer compressed, resulting in slightly smaller BEAM files when a BEAM file is stripped using `beam_lib:strip_files/1`.\n  \n  This is a potential incompatibility for tools that read and interpret the contents of the literal chunk. One way to update such tools to work with the new format is to retrieve the chunk using [`beam_lib:chunks(Beam, [literals])`](`beam_lib:chunks/2`).\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19323 Aux Id: [GH-8967], [PR-8988]\n\n- The final validation step in the compiler will now reject modules containing functions with more than 255 arguments. No impact is expected as the emulator has always refused to load these modules.\n\n  Own Id: OTP-19376 Aux Id: [GH-9113], [PR-9121]\n\n- Replaced calls to deprecated `crypto:start()` with `application:start(crypto)`.\n\n  Own Id: OTP-19485 Aux Id: [PR-8592]\n\n- Refactor code to not rely on `+nowarn_shadow_vars`.\n\n  Own Id: OTP-19574 Aux Id: [PR-9678]\n\n[GH-8558]: https://github.com/erlang/otp/issues/8558\n[PR-8600]: https://github.com/erlang/otp/pull/8600\n[PR-8913]: https://github.com/erlang/otp/pull/8913\n[GH-8967]: https://github.com/erlang/otp/issues/8967\n[PR-8988]: https://github.com/erlang/otp/pull/8988\n[GH-9113]: https://github.com/erlang/otp/issues/9113\n[PR-9121]: https://github.com/erlang/otp/pull/9121\n[PR-8592]: https://github.com/erlang/otp/pull/8592\n[PR-9678]: https://github.com/erlang/otp/pull/9678","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The EEP-48 doc chunk embedded into `.beam` files by the compiler is now `compressed` and `deterministic`.\n\n  Own Id: OTP-19096 Aux Id: [PR-8494]\n\n- Provided that the map argument for a `maps:put/3` call is known to the compiler to be a map, the compiler will replace such calls with the corresponding update using the map syntax.\n\n  Own Id: OTP-19115 Aux Id: [PR-8540]\n\n- For various error types, the compiler now tries to suggest potential fixes by adding \"did you mean ...?\" at the end of error messages.\n  \n  When a function is used with wrong arity, the compiler will try to suggest a defined function with the same name but a different arity. For example, given the following module:\n  \n  ````\n  -module(typos).\n  -export([t/0]).\n  bar(A) -> A.\n  bar(A,A,A) -> A.\n  bar(A,A,A,A) -> A.\n  t() -> bar(0, 0).\n  ````\n  \n  The compiler will emit the following message:\n  \n  ````\n  typo.erl:6:12: function bar/2 undefined, did you mean bar/1,3,4?\n  %   6|     t() -> bar(0, 0).\n  %    |            ^\n  ````\n  \n  For compiler errors that can easily be caused by typos, the compiler will try to suggest what the correct variable or function name, could be. For example, given the following module:\n  \n  ```\n  -module(typos).\n  -export([bar/2]).\n  \n  bar(A0, B0) ->\n      A + B.\n  ```\n  the compiler will emit the following error messages:\n  \n  ```\n  typos.erl:5:5: variable 'A' is unbound, did you mean 'A0'?\n  %    5|     A + B.\n  %     |     ^\n  \n  typos.erl:5:9: variable 'B' is unbound, did you mean 'B0'?\n  %    5|     A + B.\n  %     |         ^\n  ```\n  \n  Error types that now suggest correct arities: `bad_inline`, `undefined_nif`, `bad_nowarn_unused_function`, `bad_nowarn_bif_clash`, `undefined_function`.\n  \n  Error types that now suggest correct names: `bad_inline`, `undefined_nif`, `bad_nowarn_unused_function`, `undefined_on_load`, `undefined_function`, `undefined_record`, `undefined_field`, `unbound_var`.\n  \n  Using a function with wrong arity has higher precedence than having a typo in the function name. If the compiler can find a defined function with the same name but a different arity, it will not suggest a defined function with a close-enough name, regardless of arity.\n\n  Own Id: OTP-19180 Aux Id: [PR-8699], [PR-9094]\n\n- Comprehensions have been extended with zip generators  according to [EEP 73](https://www.erlang.org/eeps/eep-0073). \n  \n  Example:\n  \n  ```\n  1> [A+B || A <- [1,2,3] && B <- [4,5,6]].\n  [5,7,9]\n  ```\n\n  Own Id: OTP-19184 Aux Id: [PR-8926]\n\n- Documentation chunks (EEP-48) has been updated to include the following reserved metadata fields: `behaviours`, `group`, `source_path`, and `source_annos`. The compiler has also been updated to emit this metadata. See the [EEP-48 documentation](`e:kernel:eep48_chapter.md`) for more details.\n\n  Own Id: OTP-19306 Aux Id: [PR-8945], [PR-8975]\n\n- New strict generators have been added for comprehensions.\n  \n  The currently existing generators are \"relaxed\": they ignore terms in the\n  right-hand side expression that do not match the left-hand side pattern.\n  \n  The new strict generators fail with exception `badmatch` if a pattern doesn't match.\n  \n  Examples:\n  \n  Using the current relaxed generator operator `<-`, any element not matching\n  the pattern `{_,_}` will be silently discarded:\n  \n  ```\n  1> [T || {_,_}=T <- [{ok,1},ok,{error,2}]].\n  [{ok,1},{error,2}]\n  ```\n  If the intention is that all lists processed by a list comprehension must only\n  contain tuples of size two, using the new strict version of the operator ensures\n  that term not matching will cause a crash:\n  \n  ```\n  2> [T || {_,_}=T <:- [{ok,1},ok,{error,2}]].\n  ** exception error: no match of right hand side value ok\n  ```\n  Using the strict generator operator to mark the intention that all list elements must match the pattern could help finding mistakes quicker if something unpexected is added to the list processed by the generator.\n  \n  The strict version for bitstring generators is `<:=`.\n\n  Own Id: OTP-19317 Aux Id: [PR-8625]\n\n- New options for suppressing behaviour warnings have been added:\n  \n  * `nowarn_conflicting_behaviours`\n  * `nowarn_undefined_behaviour_func`\n  * `nowarn_undefined_behaviour`\n  * `nowarn_undefined_behaviour_callbacks`\n  * `nowarn_ill_defined_behaviour_callbacks`\n  * `nowarn_ill_defined_optional_callbacks`\n\n  Own Id: OTP-19334 Aux Id: [GH-8985], [PR-9020]\n\n- Some BIFs with side-effects are optimized in `try`/`catch` in the same way as guard BIFs in order to gain performance.\n  \n  The following BIFs that are optimized in this way: `binary_to_atom/1`,\n  `binary_to_atom/2`, `binary_to_existing_atom/1`, `list_to_atom/1`, and\n  `list_to_existing_atom/1`.\n\n  Own Id: OTP-19339 Aux Id: [PR-9042], [PR-9122]\n\n- The compiler now converts known documentation attribute metadata entries from `t:unicode:chardata/0` to `t:unicode:unicode_binary/0`.\n\n  Own Id: OTP-19394 Aux Id: [PR-9192]\n\n- The `warn_deprecated_catch` option enables warnings for use of old-style catch expressions on the form `catch Expr` instead of the modern `try ... catch ... end`. To prevent new uses of uses of old catches to be added, this compiler option can be enabled on the project level and `-compile(nowarn_deprecated_catch).` added to individual files that still contain old catches.\n\n  Own Id: OTP-19425 Aux Id: [PR-9154]\n\n- Defining a fun in terms of an imported function is not allowed. Before this release, the compiler would not catch this kind of error if the name of the imported function happened to be a BIF.  Consider this example:\n  \n  ```\n  -module(fun_example).\n  -export([foo/0, bar/0]).\n  -import(m, [max/2, not_a_bif/0]).\n  \n  foo() ->\n      fun max/2.\n  \n  bar() ->\n      fun not_a_bif/0.\n  ```\n  \n  The compiler in Erlang/OTP 27 would generate the following messages:\n  \n  ```text\n  fun_example.erl:9:5: function not_a_bif/0 undefined\n  %    9|     fun not_a_bif/0.\n  %     |     ^\n  \n  fun_example.erl:3:2: Warning: import directive overrides auto-imported BIF max/2 --\n  use \"-compile({no_auto_import,[max/2]}).\" to resolve name clash\n  %    3| -import(m, [max/2, not_a_bif/0]).\n  %     |  ^\n  ```\n  \n  That is, there would be a (cryptic) error for `fun not_a_bif/0`, but only a warning for `fun max/2`.\n  \n  When compiling with this release, both attempts to create a fun will result in error messages (as well as a warning):\n  \n  ```text\n  fun_example.erl:6:5: creating a fun from imported name max/2 is not allowed\n  %    6|     fun max/2.\n  %     |     ^\n  \n  fun_example.erl:9:5: creating a fun from imported name not_a_bif/0 is not allowed\n  %    9|     fun not_a_bif/0.\n  %     |     ^\n  \n  fun_example.erl:3:2: Warning: import directive overrides auto-imported BIF max/2 --\n  use \"-compile({no_auto_import,[max/2]}).\" to resolve name clash\n  %    3| -import(m, [max/2, not_a_bif/0]).\n  %     |  ^\n  ```\n  \n  Also, attempting to call a local function having the same name as auto-imported BIF would result in an error if the BIF was added to Erlang/OTP before R14, and a warning for newer BIFs. This has been changed to always emit a warning. For example:\n  \n  ```\n  -module(bif_example).\n  -export([bar/1]).\n  \n  bar(B) ->\n      is_boolean(B).\n  \n  is_boolean(B) ->\n          B =:= true orelse B =:= false.\n  ```\n  will now result in the following warning instead of an error:\n  \n  ```text\n  if_example.erl:5:5: Warning: ambiguous call of overridden auto-imported BIF is_boolean/1 --\n  use erlang:is_boolean/1 or \"-compile({no_auto_import,[is_boolean/1]}).\" to resolve name clash\n  %    5|     is_boolean(B).\n  %     |     ^\n  ```\n\n  Own Id: OTP-19432 Aux Id: [PR-9246]\n\n- The compiler’s alias analysis pass is now both faster and less conservative, allowing optimizations of records and binary construction to be applied in more cases.\n\n  Own Id: OTP-19502 Aux Id: [PR-8695]\n\n- BEAM files no longer include a `Meta` chunk if there are no features used. That slightly decreases the size of BEAM files, and it also ensures that `m(Module)` and `beam_lib:md5(Beam)` will match for preloaded modules.\n\n  Own Id: OTP-19524 Aux Id: [PR-9517]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n- An  **experimental** API for a native debugger has been added. The main components are the following:\n  \n  * A new compiler option `beam_debug_info` for the Erlang compiler. When given, most optimizations are disabled and debug information suitable for the native debugger are added to generated BEAM files.\n  \n  * A new `+D` emulator flag. When given, the VM becomes \"debuggable\", which means that when modules that been compiled with the `beam_debug_info` option are loaded, the code is instrumented so that one can enable and disable breakpoints on executable lines.\n  \n  * An experimental `erl_debugger` module with a new debugging API. Essentially, it allows a single, local, process to be registered as the \"debugger\" process for the node. This process is the one that will receive messages notifying that a process hit a breakpoint. This way, the front-end implementation of a debugger (such as [edb from WhatApp](https://github.com/WhatsApp/edb)) can be decoupled from OTP.\n  \n  * The `erl_debugger` module also exposes new BIFs to inspect `X` and `Y` registers of a suspended process. Together with new code-information BIFs, this let's a debugger show the values of variables in scope for a suspended process.\n\n  Own Id: OTP-19609 Aux Id: [PR-8670], [PR-9334], [PR-9604]\n\n[PR-8494]: https://github.com/erlang/otp/pull/8494\n[PR-8540]: https://github.com/erlang/otp/pull/8540\n[PR-8699]: https://github.com/erlang/otp/pull/8699\n[PR-9094]: https://github.com/erlang/otp/pull/9094\n[PR-8926]: https://github.com/erlang/otp/pull/8926\n[PR-8945]: https://github.com/erlang/otp/pull/8945\n[PR-8975]: https://github.com/erlang/otp/pull/8975\n[PR-8625]: https://github.com/erlang/otp/pull/8625\n[GH-8985]: https://github.com/erlang/otp/issues/8985\n[PR-9020]: https://github.com/erlang/otp/pull/9020\n[PR-9042]: https://github.com/erlang/otp/pull/9042\n[PR-9122]: https://github.com/erlang/otp/pull/9122\n[PR-9192]: https://github.com/erlang/otp/pull/9192\n[PR-9154]: https://github.com/erlang/otp/pull/9154\n[PR-9246]: https://github.com/erlang/otp/pull/9246\n[PR-8695]: https://github.com/erlang/otp/pull/8695\n[PR-9517]: https://github.com/erlang/otp/pull/9517\n[PR-9670]: https://github.com/erlang/otp/pull/9670\n[PR-8670]: https://github.com/erlang/otp/pull/8670\n[PR-9334]: https://github.com/erlang/otp/pull/9334\n[PR-9604]: https://github.com/erlang/otp/pull/9604","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Compiler 8.6.1.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-6-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstances, the compiler could crash when compiling code using bit syntax construction.\n\n  Own Id: OTP-19722 Aux Id: [GH-10077], [PR-10090]\n\n[GH-10077]: https://github.com/erlang/otp/issues/10077\n[PR-10090]: https://github.com/erlang/otp/pull/10090","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Compiler 8.6.1.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-6-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that could cause empty bitstring matches to always succeed, even when they should not.\n\n  Own Id: OTP-19711 Aux Id: [GH-10047], [PR-10048]\n\n[GH-10047]: https://github.com/erlang/otp/issues/10047\n[PR-10048]: https://github.com/erlang/otp/pull/10048","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Compiler 8.6.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fix the compiler crash when the inner-most tuple in a nested tuple with 3 layers is updated.\n\n  Own Id: OTP-19561 Aux Id: ERIERL-1208, ERIERL-1210, [PR-9650]\n\n[PR-9650]: https://github.com/erlang/otp/pull/9650","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Compiler 8.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-6"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The `beam_validator` pass in the compiler that validates generated BEAM now does stronger checks for binary syntax matching.\n\n  Own Id: OTP-19449 Aux Id: [PR-9338]\n\n[PR-9338]: https://github.com/erlang/otp/pull/9338","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Compiler 8.5.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Eliminated a bug in the alias analysis pass that could potentially cause unsafe optimizations of binary construction or record updates.\n\n  Own Id: OTP-19455 Aux Id: [PR-9356]\n\n[PR-9356]: https://github.com/erlang/otp/pull/9356","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Compiler 8.5.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a crash in the common sub-expression elimination pass.\n\n  Own Id: OTP-19243 Aux Id: [GH-8818], [PR-8838]\n\n- Fixed a bug where bogus code was generated for consecutive calls to `erlang:setelement/2`, potentially crashing the runtime system.\n\n  Own Id: OTP-19270 Aux Id: [GH-8783], [PR-8898]\n\n- When the `line_coverage` option was used, exceptions could show the wrong line for where the exception was raised.\n\n  Own Id: OTP-19282 Aux Id: [PR-8907]\n\n- The `line_coverage` option would be ignored if given in a `compile()` attribute within a module.\n\n  Own Id: OTP-19309 Aux Id: [GH-8942], [PR-8970]\n\n- A segment matching a float in a binary generator will now skip any invalid float (such as a NaN) and continue matching the rest of the binary. Before this correction, the comprehension would stop as soon as an invalid float was encountered.\n  \n  Example:\n  \n  ```\n  1> BadFloat = <<-1:64>>.\n  <<\"ÿÿÿÿÿÿÿÿ\">>\n  2> [X || < > <= <<0.0/float,BadFloat/binary,42.0/float>>].\n  [0.0,42.0]\n  ```\n\n  Own Id: OTP-19331 Aux Id: [PR-8978]\n\n[GH-8818]: https://github.com/erlang/otp/issues/8818\n[PR-8838]: https://github.com/erlang/otp/pull/8838\n[GH-8783]: https://github.com/erlang/otp/issues/8783\n[PR-8898]: https://github.com/erlang/otp/pull/8898\n[PR-8907]: https://github.com/erlang/otp/pull/8907\n[GH-8942]: https://github.com/erlang/otp/issues/8942\n[PR-8970]: https://github.com/erlang/otp/pull/8970\n[PR-8978]: https://github.com/erlang/otp/pull/8978","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Compiler 8.5.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstances, the destructive tuple update optimization could be applied when it was unsafe.\n\n  Own Id: OTP-19340 Aux Id: [GH-9014], [PR-9024]\n\n- In rare circumstances involving appending to multiple binaries, the compile could emit unsafe code that would crash the runtime system.\n\n  Own Id: OTP-19374 Aux Id: [GH-9100], [PR-9111]\n\n[GH-9014]: https://github.com/erlang/otp/issues/9014\n[PR-9024]: https://github.com/erlang/otp/pull/9024\n[GH-9100]: https://github.com/erlang/otp/issues/9100\n[PR-9111]: https://github.com/erlang/otp/pull/9111","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Compiler 8.5.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a crash in an optimization pass relating to appending binaries.\n\n  Own Id: OTP-19168 Aux Id: [GH-8630]\n\n- Fixed a bug in the compiler's alias analysis pass that could make it emit unsafe code.\n\n  Own Id: OTP-19178 Aux Id: [PR-8686]\n\n[GH-8630]: https://github.com/erlang/otp/issues/8630\n[PR-8686]: https://github.com/erlang/otp/pull/8686","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Compiler 8.5.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- One of the compiler's optimization passes would get very slow when compiling certain modules. The compiler will now automatically disable that pass for input that would trigger the slowdown.\n\n  Own Id: OTP-19131 Aux Id: [PR-8567]\n\n- Fix `+deterministic` to work properly with documentation attributes.\n\n  Own Id: OTP-19142 Aux Id: [PR-8585], [GH-8579]\n\n[PR-8567]: https://github.com/erlang/otp/pull/8567\n[PR-8585]: https://github.com/erlang/otp/pull/8585\n[GH-8579]: https://github.com/erlang/otp/issues/8579","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Compiler 8.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Generators for binary comprehensions could be evaluated before it was known that they would be needed. That could result in a binary comprehensions failing if a generator that should not be evaluated until later failed.\n  \n  As an example, consider this module:\n  \n  ```erlang\n  -module(t).\n  -export([f/0]).\n  \n  f() ->\n      <<0 || _ <- [], _ <- ok, false>>.\n  ```\n  \n  In Erlang/OTP 26 it would fail like so:\n  \n  ```erlang\n  1> t:f().\n  ** exception error: bad generator ok\n       in function  t:f/0 (t.erl, line 6)\n  ```\n  \n  In Erlang/OTP 27 it returns an empty binary:\n  \n  ```erlang\n  1> t:f().\n  <<>>\n  ```\n\n  Own Id: OTP-18703 Aux Id: [GH-7494], [PR-7538]\n\n- The documentation for the preprocessor now mentions that `defined(Name)` can be called in the condition for an `-if` or `-elif` directive to test whether `Name` is the name of a defined macro. (This feature was implemented in OTP 21.)\n  \n  If a function call in an `-if` or `-elif` with a name that is not the name of a guard BIF, there would not be a compilation error, but would instead cause the lines following the directive to be skipped. This has now been changed to be a compilation error.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18784 Aux Id: [GH-7706], [PR-7726]\n\n[GH-7494]: https://github.com/erlang/otp/issues/7494\n[PR-7538]: https://github.com/erlang/otp/pull/7538\n[GH-7706]: https://github.com/erlang/otp/issues/7706\n[PR-7726]: https://github.com/erlang/otp/pull/7726","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler now emits nicer error message for function head mismatches.\n  For example, given:\n  \n  ```erlang\n  a() -> ok;\n  a(_) -> error.\n  ```\n  \n  Erlang/OTP 26 and earlier would emit a diagnostic similar to:\n  \n  ```text\n  t.erl:6:1: head mismatch\n  %    6| a(_) -> error.\n  %     | ^\n  ```\n  \n  while in Erlang/OTP 27 the diagnostic is similar to:\n  \n  ```text\n  t.erl:6:1: head mismatch: function a with arities 0 and 1 is regarded as two distinct functions. Is the number of arguments incorrect or is the semicolon in a/0 unwanted?\n  %    6| a(_) -> error.\n  %     | ^\n  ```\n\n  Own Id: OTP-18648 Aux Id: [PR-7383]\n\n- The compiler now optimizes creation of binaries that are known to be constant.\n  \n  Consider this example:\n  \n  ```erlang\n  bin() ->\n      C = char(),\n      < >.\n  \n  char() -> $*.\n  ```\n  \n  Essentially, the compiler rewrites the example to the slightly more efficient:\n  \n  ```erlang\n  bin() ->\n      _ = char(),\n      <<$*>>.\n  \n  char() -> $*.\n  ```\n\n  Own Id: OTP-18673 Aux Id: [PR-7474], ERIERL-964\n\n- The compiler will now merge consecutive updates of the same record.\n  \n  As an example, the body of the following function will be combined into a single tuple creation instruction:\n  \n  ```erlang\n  -record(r, {a,b,c,d}).\n  \n  update(Value) ->\n      R0 = #r{},\n      R1 = R0#r{a=Value},\n      R2 = R1#r{b=2},\n      R2#r{c=3}.\n  ```\n\n  Own Id: OTP-18680 Aux Id: [PR-7491], [PR-8086], ERIERL-967\n\n- Improved the performance of the alias analysis pass.\n\n  Own Id: OTP-18714 Aux Id: [PR-7528], [GH-7432]\n\n- `-spec` attributes are now used for documentation.\n\n  Own Id: OTP-18801 Aux Id: [PR-7739]\n\n- Native coverage support has been implemented in the JIT. It will  automatically be used by the `m:cover` tool to reduce the execution overhead when running cover-compiled code.\n  \n  There are also new APIs to support native coverage without using the `cover` tool.\n  \n  To instrument code for native coverage it must be compiled with the [`line_coverage`](`m:compile#line_coverage`) option.\n  \n  To enable native coverage in the runtime system, start it like so:\n  \n  ```text\n  $ erl +JPcover true\n  ```\n  \n  There are also the following new functions for supporting native coverage:\n  \n  * `code:coverage_support/0`\n  * `code:get_coverage/2`\n  * `code:reset_coverage/1`\n  * `code:get_coverage_mode/0`\n  * `code:get_coverage_mode/1`\n  * `code:set_coverage_mode/1`\n\n  Own Id: OTP-18856 Aux Id: [PR-7856]\n\n- [EEP-59 - Documentation Attributes](https://www.erlang.org/eeps/eep-0059) has been implemented.\n  \n  Documentation attributes can be used to document functions, types, callbacks, and modules.\n  The keyword `-moduledoc \"Documentation here\".` is used to document modules, while `-doc \"Documentation here\".` can be used on top of functions, types, and callbacks to document them, respectively.\n  \n  * Types, callbacks, and function documentation can be set to `hidden` either via `-doc false` or `-doc hidden`. When documentation attributes mark a type as hidden, they will not be part of the documentation.\n  \n  * The documentation from `moduledoc` and `doc` gets added by default to the binary beam file, following the format of [EEP-48](https://www.erlang.org/eeps/eep-0048).\n  \n  * Using the compiler flag `warn_missing_doc` will raise a warning when\n  `-doc` attributes are missing in exported functions, types, and callbacks.\n  \n  * Using the compiler flag `warn_missing_spec_documented` will raise a warning when\n  spec attributes are missing in documented functions, types, and callbacks.\n  \n  * `moduledoc`s and `doc`s may refer to external files to be embedded, such as `-doc {file, \"README.md\"}.`, which refers to the file `README.md` found in the current working directory.\n  \n  * The compiler warns about exported functions whose specs refer to hidden types. Thus, there will be warnings when a hidden type (meaning, the type is not part of the documentation) gets used in an exported function.\n\n  Own Id: OTP-18916 Aux Id: [PR-7936]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- The order in which the compiler looks up options has changed.\n  \n  When there is a conflict in the compiler options given in the `-compile()` attribute and options given to the compiler, the options given in the `-compile()` attribute overrides the option given to the compiler, which in turn overrides options given in the `ERL_COMPILER_OPTIONS` environment variable.\n  \n  Example:\n  \n  If  `some_module.erl` has the following attribute:\n  \n  ```erlang\n  -compile([nowarn_missing_spec]).\n  ```\n  \n  and the compiler is invoked like so:\n  \n  ```text\n  % erlc +warn_missing_spec some_module.erl\n  ```\n  \n  no warnings will be issued for functions that do not have any specs.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18968 Aux Id: [GH-6979], [PR-8093]\n\n- Safe destructive update of tuples has been implemented in the compiler and runtime system. This allows the VM to update tuples in-place when it is safe to do so, thus improving performance by doing less copying but also by producing less garbage.\n  \n  Example:\n  \n  ```erlang\n  -record(rec, {a,b,c}).\n  \n  update(#rec{a=needs_update,b=N}=R0) ->\n      R = R0#rec{a=up_to_date},\n      if\n          N < 0 ->\n              R#rec{c=negative};\n          N == 0 ->\n              R#rec{c=zero};\n          N > 0 ->\n              R#rec{c=positive}\n      end.\n  ```\n  \n  The record updates in each of the three clauses of the `if` can safely be done in-place, because variable `R` is not used again.\n\n  Own Id: OTP-18972 Aux Id: [PR-8090]\n\n- Improved the match context reuse optimization slightly, allowing match contexts to be passed as-is to `bit_size/1` and `byte_size/1`.\n\n  Own Id: OTP-18987\n\n- `m:erl_lint` (and by extension the [`compiler`](`m:compile`)) will now warn for code using deprecated callbacks.\n  \n  The only callback currenly deprecated is `format_status/2` in [`gen_server`](`c:gen_server:format_status/2`), [`gen_event`](`c:gen_event:format_status/2`) and [`gen_statem`](`c:gen_server:format_status/2`).\n  \n  You can use `nowarn_deprecated_callback` to silence the warning.\n\n  Own Id: OTP-19010 Aux Id: [PR-8205]\n\n[PR-7383]: https://github.com/erlang/otp/pull/7383\n[PR-7474]: https://github.com/erlang/otp/pull/7474\n[PR-7491]: https://github.com/erlang/otp/pull/7491\n[PR-8086]: https://github.com/erlang/otp/pull/8086\n[PR-7528]: https://github.com/erlang/otp/pull/7528\n[GH-7432]: https://github.com/erlang/otp/issues/7432\n[PR-7739]: https://github.com/erlang/otp/pull/7739\n[PR-7856]: https://github.com/erlang/otp/pull/7856\n[PR-7936]: https://github.com/erlang/otp/pull/7936\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[GH-6979]: https://github.com/erlang/otp/issues/6979\n[PR-8093]: https://github.com/erlang/otp/pull/8093\n[PR-8090]: https://github.com/erlang/otp/pull/8090\n[PR-8205]: https://github.com/erlang/otp/pull/8205","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Compiler 8.4.3.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-4-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"* Fix a bug where unloaded nifs can crash the compiler.\n\n  Own Id: OTP-19600 Aux Id: PR-9737, GH-9715","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Compiler 8.4.3.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-4-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"* Fixed a bug where bogus code was generated for consecutive calls to erlang:setelement/2, potentially crashing the emulator.\n\n  Own Id: OTP-19270 Aux Id: GH-8783 PR-8898","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Compiler 8.4.3.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-4-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"* Fixed a crash in an optimization pass relating to appending binaries.\n\n  Own Id: OTP-19168 Aux Id: GH-8630\n* Fixed a bug in the compiler's alias analysis pass that could make it emit unsafe code.\n\n  Own Id: OTP-19178 Aux Id: PR-8686","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Compiler 8.4.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"* In rare circumstances, the compiler code generate unsafe code for a bit syntax match.\n\n  Own Id: OTP-19019\n* In rare circumstances, binary matches that were supposed to succeed failed.\n\n  Own Id: OTP-19035 Aux Id: GH-8280, PR-8284\n* Fixed a bug where a fun's environment could be overridden by an argument if all of the following conditions were met:\n\n  * The fun was declared in the module that called it.\n  * The fun's target was statically known.\n  * The fun was called with a number of extra arguments equal to the number of environment variables.\n\n  Own Id: OTP-19045 Aux Id: GH-8316","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Compiler 8.4.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"* In rare circumstances, an unsafe optimization could cause the compiler to generate incorrect code for list matching.\n\n  Own Id: OTP-19003 Aux Id: GH-8187, PR-8189","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"* Fix the compilation server to restart if the applications in its lib dir changes inbetween `erlc` invokations.\n\n  Own Id: OTP-18936","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Compiler 8.4.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler could become extremely slow for modules containing huge\n  functions.\n\n  Own Id: OTP-18770 Aux Id: GH-7667, PR-7672","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Compiler 8.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler could run forever when compiling a call to\n  [`is_record/3`](`is_record/3`) with a huge positive tuple size. The call\n  [`is_record(A, a, 0)`](`is_record/3`) would crash the compiler when used in a\n  function body. When used in a guard the compiler would emit incorrect code\n  that would accept `{a>` as a record.\n\n  Own Id: OTP-18605 Aux Id: GH-7298, GH-7317\n\n- Fixed a bug that caused dialyzer to crash when analyzing bogus code that\n  contained the literal atom `undefined` in segment sizes.\n\n  Own Id: OTP-18629 Aux Id: GH-7325\n\n- The compiler would crash when compiling some modules that contained a call to\n  `erlang:load_nif/2`.\n\n  Own Id: OTP-18662 Aux Id: GH-7409, PR-7416\n\n- Fixed a bug that caused the compiler to crash on legal code.\n\n  Own Id: OTP-18678 Aux Id: GH-7488\n\n- The compiler could crash when attempting to compile a call to\n  [`is_list/1`](`is_list/1`) in a complex expression.\n\n  Own Id: OTP-18689 Aux Id: GH-7504, PR-7518\n\n- A complex guard expression using the `or` operator could succeed when it was\n  supposed to fail.\n\n  Own Id: OTP-18692 Aux Id: GH-7517, PR-7519\n\n- Compiling nested `try`/`catch` and `catch` expression could result in an\n  internal compiler error.\n\n  Own Id: OTP-18701 Aux Id: GH-7477, PR-7532\n\n- Using the `bnot` operator in a complex expression could cause the compiler to\n  terminate with an internal consistency failure diagnostic.\n\n  Own Id: OTP-18719 Aux Id: GH-7468, PR-7562\n\n- Fixed a bug that caused the compiler to crash in a binary optimization pass.\n\n  Own Id: OTP-18721 Aux Id: PR-7527\n\n- The compiler could terminate with an internal error when attempting to compile\n  a binary pattern that could not possibly match.\n\n  Own Id: OTP-18725 Aux Id: GH-7467","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Fixed various performance issues related to the alias optimization pass.\n\n  Own Id: OTP-18691 Aux Id: PR-7448","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Compiler 8.3.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a type handling bug that would cause an internal consistence failure for\n  correct code.\n\n  Own Id: OTP-18625 Aux Id: GH-7354\n\n- Fixed a bug that could cause the stack trace of `throw` exceptions to be\n  erroneously optimized out.\n\n  Own Id: OTP-18626 Aux Id: GH-7356\n\n- Complex guard expression using '`or`' were not always fully evaluated, making\n  guards that were supposed to fail succeed.\n\n  Own Id: OTP-18634 Aux Id: GH-7370","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Compiler 8.3.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug where a failing `bsl` expression in a guard threw an exception\n  instead of causing the guard to fail.\n\n  Own Id: OTP-18576\n\n- Fixed a bug that would case the validator to reject legal code.\n\n  Own Id: OTP-18581 Aux Id: GH-7251\n\n- The compiler could re-order clauses matching binaries so that the incorrect\n  clause would match. That could only happen for code that used the option\n  `{error_location,line}` or for code without line or column number information\n  (e.g. generated by a parse transform).\n\n  Own Id: OTP-18583 Aux Id: GH-7259\n\n- Complex guard expression using the `or` operator and guard BIFs that can fail\n  could sometimes be miscompiled so that the guard would succeed even if a call\n  to a guard BIF failed.\n\n  Own Id: OTP-18593 Aux Id: GH-7252\n\n- With optimizations disabled, a `try`/`catch` construct could return an\n  incorrect value.\n\n  Own Id: OTP-18600 Aux Id: GH-7248\n\n- In rare circumstance, a combination of binary construction and\n  [`binary_part/3`](`binary_part/3`) would cause the compiler to generate unsafe\n  code that would crash the runtime system.\n\n  Own Id: OTP-18601\n\n- The compiler could be very slow when compiling guards with multiple guard\n  tests separated with '`or`' or '`;`'.\n\n  Own Id: OTP-18617 Aux Id: GH-7338\n\n- Complex guard expressions using '`or`' and map updates could succeed even if\n  the map update failed.\n\n  Own Id: OTP-18619 Aux Id: GH-7339","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Compiler 8.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler would silently accept singleton (unbound) type variables in a\n  union type. Starting from Erlang/OTP 26, the compiler will generate a warning\n  for this example. The warning can be disabled using the\n  `nowarn_singleton_typevar` option. In Erlang/OTP 27, the warning will become\n  an error.\n\n  Own Id: OTP-18389 Aux Id: GH-6508, PR-6864, GH-7116","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Optimized record updates.\n\n  Own Id: OTP-18126 Aux Id: PR-6033\n\n- There are several new optimization for binary syntax in the JIT:\n\n  - Creation and matching of binaries with segments of fixed sizes have been\n    optimized.\n  - Creation and matching of UTF-8 segments have been optimized.\n  - Appending to binaries has been optimized.\n\n  Own Id: OTP-18137 Aux Id: PR-6259, PR-6404, PR-6576, PR-6804\n\n- The compiler and JIT now generate better code for creation of small maps where\n  all keys are literals known at compile time.\n\n  Own Id: OTP-18185 Aux Id: GH-6139\n\n- A limitation in the binary syntax has been removed. It is now possible to\n  match binary patterns in parallel. Example: `< > = < > = Bin`\n\n  Own Id: OTP-18297 Aux Id: GH-6348\n\n- It is documented that `$\\^X` is the ASCII code for Control X, where X is an\n  uppercase or lowercase letter. However, this notation would work for any\n  character X, even then it didn't make sense.\n\n  In Erlang/OTP 26, it is now documented that the following characters are also\n  allowed to follow the `\\^` characters: `@`, `[`, `\\`, `]`, `^`, `_`, and `?`.\n  Attempt to use other characters will be rejected with a compiler error.\n\n  The value for `$\\^?` is now 127 (instead of 31 as in earlier releases).\n\n  Own Id: OTP-18337 Aux Id: GH-6477, PR-6503\n\n- The BIFs [`min/2`](`min/2`) and [`max/2`](`max/2`) are now allowed to be used\n  in guards and match specs.\n\n  Own Id: OTP-18367 Aux Id: GH-6544\n\n- Map comprehensions as suggested in EEP 58 has now been implemented.\n\n  Own Id: OTP-18413 Aux Id: EEP-58, PR-6727\n\n- Improved the selective receive optimization, which can now be enabled for\n  references returned from other functions.\n\n  This greatly improves the performance of `gen_server:send_request/3`,\n  `gen_server:wait_response/2`, and similar functions.\n\n  Own Id: OTP-18431 Aux Id: PR-6739\n\n- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903\n\n- The compiler will now inline calls to `maps:get/3`.\n\n  Own Id: OTP-18502\n\n- In Erlang/OTP 27, `0.0` will no longer be considered to be exactly equal to\n  `-0.0`. See\n  [Upcoming Potential Incompatibilities](`e:general_info:upcoming_incompatibilities.md#float_matching`).\n\n  Own Id: OTP-18574","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Compiler 8.2.6.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"* In rare circumstances, an unsafe optimization could cause the compiler to generate incorrect code for list matching.\n\n  Own Id: OTP-19003 Aux Id: GH-8187, PR-8189\n* In rare circumstances, the compiler code generate unsafe code for a bit syntax match.\n\n  Own Id: OTP-19019","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Compiler 8.2.6.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that could cause the stack trace of `throw` exceptions to be\n  erroneously optimized out.\n\n  Own Id: OTP-18626 Aux Id: GH-7356","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Compiler 8.2.6.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler could be very slow when compiling guards with multiple guard\n  tests separated with '`or`' or '`;`'.\n\n  Own Id: OTP-18617 Aux Id: GH-7338","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Compiler 8.2.6.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug where a failing `bsl` expression in a guard threw an exception\n  instead of causing the guard to fail.\n\n  Own Id: OTP-18576\n\n- Complex guard expression using the `or` operator and guard BIFs that can fail\n  could sometimes be miscompiled so that the guard would succeed even if a call\n  to a guard BIF failed.\n\n  Own Id: OTP-18593 Aux Id: GH-7252","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Compiler 8.2.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed type handling bugs that could cause an internal error in the compiler\n  for correct code.\n\n  Own Id: OTP-18565 Aux Id: GH-7147","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"Compiler 8.2.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- When a map update such as `#{}#{key:=value}` that should fail with an\n  exception was unused, the exception would be lost.\n\n  Own Id: OTP-18497 Aux Id: GH-6960, PR-6965\n\n- Fixed bug in the validator that made it reject valid code.\n\n  Own Id: OTP-18516 Aux Id: GH-6969","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Compiler 8.2.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that would cause the compiler to hang.\n\n  Own Id: OTP-18378 Aux Id: GH-6604\n\n- Fixed a crash when compiling code that contained `maybe` expressions.\n\n  Own Id: OTP-18381 Aux Id: GH-6601\n\n- Constructing a binary with an explicit size of `all` for a binary segment\n  would crash the compiler.\n\n  Own Id: OTP-18407 Aux Id: GH-6707\n\n- The compiler would generate incorrect code for the following type of\n  expression:\n\n  `Pattern = BoundVar1 = . . . = BoundVarN = Expression`\n\n  An exception should be raised if any of the bound variables have different\n  values than `Expression`. The compiler would generate code that would cause\n  the bound variables to be bound to the value of `Expression`whether the value\n  matched or not.\n\n  Own Id: OTP-18470 Aux Id: GH-6873, PR-6877","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Compiler 8.2.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that could cause legal code to fail validation.\n\n  Own Id: OTP-18365\n\n- Eliminated a rare crash in the `beam_types` module.\n\n  Own Id: OTP-18368","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"Compiler 8.2.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Line number in compiler messages would be truncated to 4 digits for line\n  numbers greater than 9999.\n\n  Own Id: OTP-18268 Aux Id: GH-6332\n\n- In rare circumstance, matching a binary as part of a `receive` clause could\n  cause the compiler to terminate because of an internal consistency check\n  failure.\n\n  Own Id: OTP-18273 Aux Id: GH-6341\n\n- Compiling a function with complex bit syntax matching such as\n  `f(< >, < >) -> ok.` could crash the compiler.\n\n  Own Id: OTP-18308 Aux Id: GH-6426\n\n- It is not allowed to call functions from guards. The compiler failed to reject\n  a call in a guard when done by constructing a record with a default\n  initialization expression that called a function.\n\n  Own Id: OTP-18325 Aux Id: GH-6465, GH-6466\n\n- The compiler could crash when using a record with complex field initialization\n  expression as a filter in a list comprehension.\n\n  Own Id: OTP-18336 Aux Id: GH-6501, PR-6502","ref":"notes.html#fixed-bugs-and-malfunctions-30"},{"type":"extras","title":"Compiler 8.2.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler will now forbid using the empty atom `''` as module name. Also\n  forbidden are modules names containing control characters, and module names\n  containing only spaces and soft hyphens.\n\n  Own Id: OTP-18125 Aux Id: GH-6026\n\n- The `bin_opt_info` and `recv_opt_info` options would cause the compiler to\n  crash when attempting to compile generated code without location information.\n\n  Own Id: OTP-18162 Aux Id: PR-6102\n\n- In rare circumstances involving floating point operations, the compiler could\n  terminate with an internal consistency check failure.\n\n  Own Id: OTP-18182 Aux Id: GH-6163\n\n- In rare circumstances when doing arithmetic instructions on non-numbers, the\n  compiler could crash.\n\n  Own Id: OTP-18183 Aux Id: GH-6169\n\n- In rare circumstances, complex boolean expressions in nested cases could cause\n  the compiler to crash.\n\n  Own Id: OTP-18184 Aux Id: GH-6164\n\n- Expression similar to `#{assoc:=V} = #key=>self()}, V` would return the empty\n  map instead of raising an exception.\n\n  Own Id: OTP-18186\n\n- Eliminated a crash in the `beam_ssa_bool` pass of the compiler when compiling\n  a complex guard expression.\n\n  Own Id: OTP-18187 Aux Id: GH-6184\n\n- In rare circumstances, the compiler could crash with an internal consistency\n  check failure.\n\n  Own Id: OTP-18202 Aux Id: GH-6222\n\n- When compiling with the option `inline_list_funcs`, the compiler could produce\n  a nonsensical warning.\n\n  Own Id: OTP-18214 Aux Id: GH-6158\n\n- When given the `no_ssa_opt` option, the compiler could terminate with an\n  internal consistency failure diagnostic when compiling map matching.\n\n  Own Id: OTP-18234 Aux Id: GH-6277","ref":"notes.html#fixed-bugs-and-malfunctions-31"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Made warnings for existing atoms being keywords in experimental features more\n  precise, by not warning about quoted atoms.\n\n  Own Id: OTP-18050\n\n- There is a new configure option, `--enable-deterministic-build`, which will\n  apply the `deterministic` compiler option when building Erlang/OTP. The\n  `deterministic` option has been improved to eliminate more sources of\n  non-determinism in several applications.\n\n  Own Id: OTP-18165 Aux Id: PR-5965","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Compiler 8.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A subtle bug regarding variable scoping has been corrected. Consider this\n  example:\n\n  `(A=1) + fun() -> A = 2() end`\n\n  In the shell, the expression correctly evaluates to `3`. In compiled code, it\n  raised a `{badmatch, 2}` exception.\n\n  Own Id: OTP-17810 Aux Id: GH-5379\n\n- Fixed a rare bug that would crash the compiler during type optimization.\n\n  Own Id: OTP-17820\n\n- Starting in OTP 24, when a fun was created and immediately used, it would be\n  inlined. An unintended consequence of the inlining was that what would be a\n  `function_clause` exception without the inlining would now be a rather\n  confusing `case_clause` exception. This has been corrected, so that\n  `function_clause` exceptions remain `function_clause` exceptions in inlined\n  code.\n\n  Own Id: OTP-17860 Aux Id: GH-5513, OTP-17226\n\n- If a default record field initialization (`_ = Expr`) was used even though all\n  records fields were explicitly initialized, `Expr` would not be evaluated.\n  That would not be a problem, except when `Expr` would bind a variable\n  subsequently used, in which case the compiler would crash.\n\n  As an example, if record `#r{}` is defined to have only one field `a`, the\n  following code would crash the compiler:\n\n  `#r{a=[],_=V=42}, V`\n\n  To fix that problem, the compiler will make sure that `Expr` is always\n  evaluated at least once. The compiler will now rewrite the example to\n  essentially:\n\n  `V=42, #r{a=[]}, V`\n\n  Own Id: OTP-18083","ref":"notes.html#fixed-bugs-and-malfunctions-32"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- To enable more optimizations, BEAM files compiled with OTP 21 and earlier\n  cannot be loaded in OTP 25.\n\n  Own Id: OTP-16702\n\n- Added support for the compile attribute `-nifs()` to empower compiler and\n  loader with information about which functions may be overridden as NIFs by\n  `erlang:load_nif/2`. It is recommended to use this attribute in all modules\n  that load NIF libraries.\n\n  Own Id: OTP-17151 Aux Id: ERIERL-590, PR-5479\n\n- When binary construction using the binary syntax fails, the error message\n  printed in the shell and by `erl_error:format_exception/3,4` will contain more\n  detailed information about what went wrong.\n\n  Own Id: OTP-17504 Aux Id: GH-4971, PR-5281, PR-5752\n\n- The Erlang compiler now includes type information in BEAM files, and the JIT\n  can now use that type information to do optimizations such as eliminating or\n  simplifying type tests.\n\n  Own Id: OTP-17684 Aux Id: PR-5316, PR-5664\n\n- Improved the JIT's support for external tools like `perf` and `gdb`, allowing\n  them to show line numbers and even the original Erlang source code when that\n  can be found.\n\n  To aid them in finding the source code, the `absolute_path` compiler option\n  has been added to embed the absolute file path of a module.\n\n  Own Id: OTP-17685\n\n- The `maybe` ... `end` construction proposed in EEP-49 has been implemented. It\n  can simplify complex code where otherwise deeply nested cases would have to be\n  used.\n\n  To enable `maybe`, give the option `-enable-feature maybe_expr` to `erlc` or\n  add `-feature(maybe_expr, enable).` inside the module.\n\n  Own Id: OTP-17705 Aux Id: PR-5411\n\n- When a record matching or record update fails, a\n  `{badrecord,ExpectedRecordTag}` exception used to be raised. In this release,\n  the exception has been changed to `{badrecord,ActualValue}`, where\n  `ActualValue` is the actual that was found instead of the expected record.\n\n  Own Id: OTP-17841 Aux Id: PR-5694\n\n- Improved optimization of try/catch expressions.\n\n  Own Id: OTP-17842\n\n- The `beam_trim` pass of the compiler could be extremely slow for huge\n  straight-line functions. It will now compile such functions much faster (down\n  to seconds from minutes for some huge functions).\n\n  Own Id: OTP-17885 Aux Id: GH-5140\n\n- Added support for configurable features as described in EEP-60. Features can\n  be enabled/disabled during compilation with options\n  (`-enable-feature Feature`, `-disable-feature Feature` and\n  `+{feature, Feature, enable|disable}`) to `erlc` as well as with directives\n  (`-feature(Feature, enable|disable).`) in the file. Similar options can be\n  used to `erl` for enabling/disabling features allowed at runtime. The new\n  `maybe` expression (EEP-49) is fully supported as the feature `maybe_expr`.\n  The features support is documented in the reference manual.\n\n  Own Id: OTP-17988","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Compiler 8.1.1.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"* In rare circumstances, an unsafe optimization could cause the compiler to generate incorrect code for list matching.\n\n  Own Id: OTP-19003 Aux Id: GH-8187, PR-8189\n* In rare circumstances, the compiler code generate unsafe code for a bit syntax match.\n\n  Own Id: OTP-19019","ref":"notes.html#fixed-bugs-and-malfunctions-33"},{"type":"extras","title":"Compiler 8.1.1.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler could be very slow when compiling guards with multiple guard\n  tests separated with '`or`' or '`;`'.\n\n  Own Id: OTP-18617 Aux Id: GH-7338","ref":"notes.html#fixed-bugs-and-malfunctions-34"},{"type":"extras","title":"Compiler 8.1.1.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Complex guard expression using the `or` operator and guard BIFs that can fail\n  could sometimes be miscompiled so that the guard would succeed even if a call\n  to a guard BIF failed.\n\n  Own Id: OTP-18593 Aux Id: GH-7252","ref":"notes.html#fixed-bugs-and-malfunctions-35"},{"type":"extras","title":"Compiler 8.1.1.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler would generate incorrect code for the following type of\n  expression:\n\n  `Pattern = BoundVar1 = . . . = BoundVarN = Expression`\n\n  An exception should be raised if any of the bound variables have different\n  values than `Expression`. The compiler would generate code that would cause\n  the bound variables to be bound to the value of `Expression`whether the value\n  matched or not.\n\n  Own Id: OTP-18470 Aux Id: GH-6873, PR-6877","ref":"notes.html#fixed-bugs-and-malfunctions-36"},{"type":"extras","title":"Compiler 8.1.1.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- It is not allowed to call functions from guards. The compiler failed to reject\n  a call in a guard when done by constructing a record with a default\n  initialization expression that called a function.\n\n  Own Id: OTP-18325 Aux Id: GH-6465, GH-6466\n\n- Fixed a bug that could cause legal code to fail validation.\n\n  Own Id: OTP-18365","ref":"notes.html#fixed-bugs-and-malfunctions-37"},{"type":"extras","title":"Compiler 8.1.1.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The `bin_opt_info` and `recv_opt_info` options would cause the compiler to\n  crash when attempting to compile generated code without location information.\n\n  Own Id: OTP-18162 Aux Id: PR-6102\n\n- In rare circumstances involving floating point operations, the compiler could\n  terminate with an internal consistency check failure.\n\n  Own Id: OTP-18182 Aux Id: GH-6163","ref":"notes.html#fixed-bugs-and-malfunctions-38"},{"type":"extras","title":"Compiler 8.1.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a performance bug in the validator that made certain files take a very\n  long time to compile.\n\n  Own Id: OTP-18066 Aux Id: GH-5915\n\n- In rare circumstances, the compiler would mistakenly assume that a call to\n  [`setelement/3`](`setelement/3`) would always fail and remove all code\n  following the call.\n\n  Own Id: OTP-18082","ref":"notes.html#fixed-bugs-and-malfunctions-39"},{"type":"extras","title":"Compiler 8.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The expression `<<0/native-float>>=Bin` would always fail to match, while\n  `<<0/float-native>>=Bin` would match (provided that `Bin` contained the binary\n  representation of `0.0`)\n\n  Own Id: OTP-17895","ref":"notes.html#fixed-bugs-and-malfunctions-40"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler will now compile huge functions with straight-line code faster.\n\n  Own Id: OTP-17886 Aux Id: GH-5140, GH-5686","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Compiler 8.0.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- When the compiler is invoked by Dialyzer, it will no longer apply an\n  optimization of binary patterns that would turn the pattern `<<\"bar\">>` into\n  `<<6447474:24>>`, which would be very confusing when printed out by Dialyzer.\n\n  Own Id: OTP-17768 Aux Id: GH-5429\n\n- The compiler would replace known failing calls (such as\n  [`atom_to_list(42)`](`atom_to_list/1`)) with a call to\n  [`error(badarg)`](`error/1`). With the extended error information introduced\n  in OTP 24 (EEP 54), those \"optimized\" calls would not have extended error\n  information. To ensure that as much extended error information as possible is\n  available, the compiler now keeps the original call even when it is known to\n  fail.\n\n  Own Id: OTP-17786 Aux Id: GH-5440","ref":"notes.html#fixed-bugs-and-malfunctions-41"},{"type":"extras","title":"Compiler 8.0.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- If a parse transform raised an exception using [`throw/1`](`throw/1`) or\n  [`exit/1`](`exit/1`), the compiler would report that as an internal compiler\n  error, which would be confusing. Amended to report that the parse transform\n  failed.\n\n  Own Id: OTP-17421\n\n- The failing call `io:format(\"~p\\n\")` would result in a warning for line number\n  0 instead of the correct line and column numbers. This has been corrected, and\n  all warnings for failing calls to [`io:format()`](`t:io:format/0`) has been\n  rephrased to make it clearer exactly what the problem is.\n\n  Own Id: OTP-17430\n\n- When the options `warn_missing_spec` and `export_all` were given, there would\n  only be warnings for missing specs for functions that had been explicitly\n  exported using an `-export` attribute.\n\n  Own Id: OTP-17434 Aux Id: GH-4772\n\n- In rare circumstances, the compiler could emit an incorrect warning for a term\n  that was constructed but never used.\n\n  Own Id: OTP-17446 Aux Id: PR-4899\n\n- Corrected bugs where builds were not reducible even when the `deterministic`\n  option was given. In particular, modules with map literals with more than 32\n  elements could cause this problem.\n\n  As part of this fix, the `term_to_binary` BIF now accepts the option\n  `deterministic`.\n\n  Own Id: OTP-17495 Aux Id: PR-5153\n\n- The `MODULE` and `MODULE_STRING` macros would always appear to be defined\n  (when tested by `-ifdef`), even though no `-module()` declaration had been\n  seen yet. Changed so that `-ifdef ?MODULE.` will not consider ?MODULE defined\n  if `-module()` has not been previously seen.\n\n  Own Id: OTP-17505 Aux Id: GH-4995\n\n- In a guard, `not (X =:= true)` would incorrectly evaluate to `false` for\n  non-boolean values of `X`.\n\n  Own Id: OTP-17510 Aux Id: GH-5007\n\n- When the `deterministic` option was given to the compiler, the `?FILE` macro\n  would be expanded to full path of the source file before the first `include`\n  directive and to base part of the filename after `include` directive.\n\n  Own Id: OTP-17581 Aux Id: PR-5141","ref":"notes.html#fixed-bugs-and-malfunctions-42"},{"type":"extras","title":"Compiler 8.0.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A compiler optimization pass could crash when given odd but legal code using\n  [`throw/1`](`throw/1`).\n\n  Own Id: OTP-17489 Aux Id: GH-4953","ref":"notes.html#fixed-bugs-and-malfunctions-43"},{"type":"extras","title":"Compiler 8.0.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that could cause `after` blocks to be ignored when\n  `erlang:raise/3` was used in a catch block.\n\n  Own Id: OTP-17428 Aux Id: GH-4859\n\n- Fixed a bug in the validation pass that could cause it to reject valid code.\n\n  Own Id: OTP-17437 Aux Id: OTP-17357, GH-4774","ref":"notes.html#fixed-bugs-and-malfunctions-44"},{"type":"extras","title":"Compiler 8.0 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-8-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A floating point zero (0.0) can be both positive (+0.0) and negative (-0.0).\n  Multiple bugs in the compiler, runtime system, and STDLIB have been fixed to\n  ensure that the minus sign on 0.0 is not lost.\n\n  Own Id: OTP-17077 Aux Id: ERL-1431, PR-2903, PR-2905, PR-2906\n\n- A repeated stack trace variable in a try/catch was not rejected. The following\n  example will now cause a compilation error:\n\n  ```text\n  try E catch _:A:A -> A\n  \t    end.\n  ```\n\n  Own Id: OTP-17104 Aux Id: ERL-1380\n\n- Eliminated a Dialyzer crashed when the `-MMD` option is used to generate a\n  dependency file and a BEAM file a the same time.\n\n  Own Id: OTP-17118 Aux Id: PR-2825\n\n- When the `makedep` option was given, the compiler would crash if the\n  dependency output contained non-latin1 characters. The compiler will now\n  output the dependency information encoded in UTF-8 to avoid crashing.\n\n  Own Id: OTP-17206","ref":"notes.html#fixed-bugs-and-malfunctions-45"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Selective receive optimization will now be applied much more often.\n\n  The new [`recv_opt_info`](`e:system:eff_guide_processes.md#recv_opt_info`)\n  compile flag can be used to print diagnostics relating to this optimization.\n\n  You can read more about the\n  [selective receive optimization](`e:system:eff_guide_processes.md#receiving-messages`)\n  in the Efficiency Guide.\n\n  Own Id: OTP-10391 Aux Id: OTP-16226\n\n- `erlang:throw/1` will no longer build stack traces when we can prove that they\n  will never be inspected.\n\n  Own Id: OTP-16334\n\n- Variables bound between the keywords 'try' and 'of' can now be used in the\n  clauses following the 'of' keyword (that is, in the success case when no\n  exception was raised).\n\n  Own Id: OTP-16706 Aux Id: ERL-1281\n\n- Compiler warnings and errors now include column numbers in addition to line\n  numbers.\n\n  When a compiler message is emitted, the source line is printed along with a\n  marker (a `^` character) that indicates the column position of the issue. The\n  option '`brief`' removes the printout of the source line.\n\n  The compiler option `{error_location, line | column}` has been added. The\n  default value is `column`. Besides adding column numbers to compilation\n  warnings and errors, the option also determines whether column numbers are\n  included in abstract code. If tools stop working, setting the environment\n  variable `ERL_COMPILER_OPTIONS` can help (include `{error_location, line}`).\n\n  The compiler will now call the function `PT`:`parse_transform_info/0` in parse\n  transforms (if it exists). It can be used by parse transforms to signal that\n  they can only handle line numbers in abstract code.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16824 Aux Id: PR-2664, PR-3006\n\n- Fixed a performance bug that made functions with lots of `try/after` blocks\n  slow to compile.\n\n  Own Id: OTP-16867 Aux Id: ERL-1354\n\n- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963\n\n- Generators in list and binary comprehensions will now raise a\n  `{bad_generator,Generator}` exception if the generator has an incorrect type\n  (instead of raising an ad-hoc `badarg` or `badarih` exception). Similarly,\n  when a filter does not evaluate to a boolean, a `{bad_filter,Filter}`\n  exception will be raised. Some minor bugs in the compilation of binary\n  comprehensions have also been fixed.\n\n  Own Id: OTP-16964\n\n- Some compiler warnings, such as the warning for an expression whose result is\n  ignored, could not be suppressed by assigning to a variable beginning with\n  '`_`', but only by assigning to the anonymous variable ('`_`'). This has now\n  been changed so that any warning that can be suppressed by assigning to the\n  anonymous variable can also be suppressed by assigning to a variable beginning\n  with '`_`'.\n\n  Own Id: OTP-16981 Aux Id: ERL-1113\n\n- The previously undocumented compiler options `warn_missing_spec` and\n  `warn_missing_spec_all` are now documented.\n\n  Own Id: OTP-17078 Aux Id: ERL-1430, PR-2918\n\n- The compiler will now emit warnings when (previously bound)\n  underscore-prefixed variables are matched.\n\n  Own Id: OTP-17123\n\n- Erlang source files not encoded in utf-8 will no longer be accepted by the\n  compiler unless it contains a \"coding: latin-1\" comment.\n\n  Own Id: OTP-17168\n\n- New compiler options `from_abstr` and `no_lint` have been added. They are\n  useful when implementing other languages running on the BEAM.\n\n  Own Id: OTP-17172\n\n- The bit matching and construction syntax now supports 16-bit floats (IEEE\n  754-2008).\n\n  Own Id: OTP-17207\n\n- The compiler will now inline funs that are used only once immediately after\n  their definition.\n\n  Own Id: OTP-17226 Aux Id: GH-4019, PR-4545\n\n- It is now possible to disable warnings emitted from the compiler's\n  optimization passes with the new options `nowarn_opportunistic`,\n  `nowarn_nomatch`, `nowarn_ignored`, and `nowarn_failed`.\n\n  Own Id: OTP-17260\n\n- Introduce new types `t:nonempty_binary/0` and `t:nonempty_bitstring/0`.\n\n  Own Id: OTP-17301 Aux Id: GH-4636\n\n- Add compiler option `{nowarn_unused_record, RecordNames}`. Document compiler\n  option `nowarn_unused_type`.\n\n  Own Id: OTP-17330","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Compiler 7.6.9.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-9-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- It is not allowed to call functions from guards. The compiler failed to reject\n  a call in a guard when done by constructing a record with a default\n  initialization expression that called a function.\n\n  Own Id: OTP-18325 Aux Id: GH-6465, GH-6466\n\n- Fixed a bug that could cause legal code to fail validation.\n\n  Own Id: OTP-18365\n\n- The compiler would generate incorrect code for the following type of\n  expression:\n\n  `Pattern = BoundVar1 = . . . = BoundVarN = Expression`\n\n  An exception should be raised if any of the bound variables have different\n  values than `Expression`. The compiler would generate code that would cause\n  the bound variables to be bound to the value of `Expression`whether the value\n  matched or not.\n\n  Own Id: OTP-18470 Aux Id: GH-6873, PR-6877","ref":"notes.html#fixed-bugs-and-malfunctions-46"},{"type":"extras","title":"Compiler 7.6.9.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstances, the compiler would mistakenly assume that a call to\n  [`setelement/3`](`setelement/3`) would always fail and remove all code\n  following the call.\n\n  Own Id: OTP-18082","ref":"notes.html#fixed-bugs-and-malfunctions-47"},{"type":"extras","title":"Compiler 7.6.9.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the validation pass that could cause it to reject valid code.\n\n  Own Id: OTP-17437 Aux Id: OTP-17357, GH-4774","ref":"notes.html#fixed-bugs-and-malfunctions-48"},{"type":"extras","title":"Compiler 7.6.9 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Reverted the fix for `OTP-17357` as it turned out to be incomplete and made\n  the validator reject much more legal code than before.\n\n  It will be fixed more thoroughly in a later patch.\n\n  Own Id: OTP-17386 Aux Id: ERIERL-650, OTP-17357","ref":"notes.html#fixed-bugs-and-malfunctions-49"},{"type":"extras","title":"Compiler 7.6.8 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the validator that could cause it to reject valid code.\n\n  Own Id: OTP-17357 Aux Id: GH-4774","ref":"notes.html#fixed-bugs-and-malfunctions-50"},{"type":"extras","title":"Compiler 7.6.7 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the type optimization pass that could yield incorrect values or\n  cause the wrong clauses to be executed.\n\n  Own Id: OTP-17073\n\n- Fixed a bug in the validator that could cause it to reject valid code.\n\n  Own Id: OTP-17126 Aux Id: ERL-1471","ref":"notes.html#fixed-bugs-and-malfunctions-51"},{"type":"extras","title":"Compiler 7.6.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Several minor compiler bugs have been fixed:\n\n  Constructing a binary with a list as a size of a binary segment could generate\n  a BEAM file that could not be loaded.\n\n  When matching a binary segment of type `float` and ignoring the matched out\n  value, the match would always succeed, even if the size was invalid or the\n  value of the float was NaN or some other non-numeric float value.\n\n  Attempting to construct an invalid external fun (e.g. `fun m:f:bad`) is\n  supposed to raise a '`badarg`' exception, but if the value was never used, no\n  exception would be raised.\n\n  Own Id: OTP-16932\n\n- Fixed multiple bugs in the validator that could cause it to reject valid code.\n\n  Own Id: OTP-17039 Aux Id: ERL-1426\n\n- The compiler could crash when a binary comprehension had a generator that\n  depended on another generator.\n\n  Own Id: OTP-17045 Aux Id: ERL-1427\n\n- Fixed a bug in the type optimization pass that could yield incorrect values or\n  cause the wrong clauses to be executed.\n\n  Own Id: OTP-17072 Aux Id: ERL-1440","ref":"notes.html#fixed-bugs-and-malfunctions-52"},{"type":"extras","title":"Compiler 7.6.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the boolean optimization pass that caused the compiler to\n  confuse different clauses.\n\n  Own Id: OTP-16951 Aux Id: ERL-1384","ref":"notes.html#fixed-bugs-and-malfunctions-53"},{"type":"extras","title":"Compiler 7.6.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a performance bug that could be triggered by tuple matching in very\n  large functions.\n\n  Own Id: OTP-16895 Aux Id: ERL-1359","ref":"notes.html#fixed-bugs-and-malfunctions-54"},{"type":"extras","title":"Compiler 7.6.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- If the update of a map with the '`Map#{Key := Value}`' syntax failed, the line\n  number in the stack backtrace could be incorrect.\n\n  Own Id: OTP-16701 Aux Id: ERL-1271\n\n- Fixed a performance bug that slowed down compilation of modules with deeply\n  nested terms.\n\n  Own Id: OTP-16755 Aux Id: ERL-1297\n\n- The compiler could in rare circumstances do an an unsafe optimization that\n  would result in a matching of a nested map pattern would fail to match.\n\n  Own Id: OTP-16820\n\n- Fixed a bug in the validator that caused it to reject valid code.\n\n  Own Id: OTP-16838 Aux Id: ERL-1340","ref":"notes.html#fixed-bugs-and-malfunctions-55"},{"type":"extras","title":"Compiler 7.6.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- When calls to `is_map_key` were repeated, the compiler could terminate with an\n  internal consistency failure.\n\n  Own Id: OTP-16708 Aux Id: ERL-1276\n\n- Fixed a bug in the type inference pass that could cause the compiler to hang.\n\n  Own Id: OTP-16745 Aux Id: ERL-1289","ref":"notes.html#fixed-bugs-and-malfunctions-56"},{"type":"extras","title":"Compiler 7.6.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstances, a guard using 'not' could evaluate to the wrong boolean\n  value.\n\n  Own Id: OTP-16652 Aux Id: ERL-1246\n\n- A guard expression that referenced a variable bound to a boolean expression\n  could evaluate to the wrong value.\n\n  Own Id: OTP-16657 Aux Id: ERL-1253","ref":"notes.html#fixed-bugs-and-malfunctions-57"},{"type":"extras","title":"Compiler 7.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- `erlang:fun_info(fun foo/1, name/1)` used to return a function name based on\n  the name of the function that `fun foo/1` was used in. The name returned is\n  now `-fun.foo/1-`.\n\n  Own Id: OTP-15837\n\n- Initialization of record fields using `_` is no longer allowed if the number\n  of affected fields is zero.\n\n  Own Id: OTP-16516","ref":"notes.html#fixed-bugs-and-malfunctions-58"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- EEP-52 has been implemented.\n\n  In binary matching, the size of the segment to be matched is now allowed to be\n  a guard expression, and similarly in map matching the keys can now be guard\n  expressions. See the Erlang Reference Manual and Programming Examples for more\n  details.\n\n  Language compilers or code generators that generate Core Erlang code may need\n  to be updated to be compatible with the compiler in OTP 23. For more details,\n  see the section Backwards Compatibility in\n  [EEP 52](http://erlang.org/eeps/eep-0052.html).\n\n  Own Id: OTP-14708\n\n- Allow underscores in numeric literals to improve readability. Examples:\n  `123_456_789`, `16#1234_ABCD`.\n\n  Own Id: OTP-16007 Aux Id: PR-2324\n\n- Improved the type optimization pass' inference of types that depend on\n  themselves, giving us more accurate types and letting us track the content\n  types of lists.\n\n  Own Id: OTP-16214 Aux Id: PR-2460\n\n- Support message queue optimization also for references returned from the new\n  [`spawn_request()`](`erlang:spawn_request/5`) BIFs.\n\n  Own Id: OTP-16367 Aux Id: OTP-15251\n\n- The compiler will now raise a warning when inlining is used in modules that\n  load NIFs.\n\n  Own Id: OTP-16429 Aux Id: ERL-303\n\n- Refactored the internal handling of deprecated and removed functions.\n\n  Own Id: OTP-16469\n\n- Line information was sometimes incorrect for floating-point math exceptions.\n\n  Own Id: OTP-16505 Aux Id: ERL-1178\n\n- The `debug_info` option can now be specified in `-compile()` attributes.\n\n  Own Id: OTP-16523 Aux Id: ERL-1058\n\n- Reduced the resource usage of `erlc` in parallel builds (e.g. `make -j128`).\n\n  Own Id: OTP-16543 Aux Id: ERL-1186","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Compiler 7.5.4.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5-4-3"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Fixed a bug in the type optimization pass that could yield incorrect values or\n  cause the wrong clauses to be executed.\n\n  Own Id: OTP-17073","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Compiler 7.5.4.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the validator that could cause it to reject valid code\n\n  Own Id: OTP-17039 Aux Id: ERL-1426","ref":"notes.html#fixed-bugs-and-malfunctions-59"},{"type":"extras","title":"Compiler 7.5.4.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that could cause the compiler to crash on code that constructed\n  binaries.\n\n  Own Id: OTP-16747 Aux Id: ERL-1290","ref":"notes.html#fixed-bugs-and-malfunctions-60"},{"type":"extras","title":"Compiler 7.5.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the validator that could cause it to reject valid code.\n\n  Own Id: OTP-16580 Aux Id: ERL-1212","ref":"notes.html#fixed-bugs-and-malfunctions-61"},{"type":"extras","title":"Compiler 7.5.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A '`receive`' with an '`after 0`' clause would prevent the optimization that\n  can avoid scanning the entire receive queue when matching on a newly created\n  reference.\n\n  Own Id: OTP-16350\n\n- HiPE can again handle modules with `catch` and `try` constructs.\n\n  Own Id: OTP-16418\n\n- Fixed a bug in bit-syntax optimization that could crash the compiler.\n\n  Own Id: OTP-16515","ref":"notes.html#fixed-bugs-and-malfunctions-62"},{"type":"extras","title":"Compiler 7.5.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that could cause the compiler to reject valid code that used the\n  [`is_map_key/2`](`is_map_key/2`) BIF.\n\n  Own Id: OTP-16452 Aux Id: ERL-1161\n\n- Fixed a bug that could cause the compiler to reject valid code that matched\n  the same map key several times.\n\n  Own Id: OTP-16456 Aux Id: ERL-1163\n\n- The compiler could crash when compiling a convoluted `receive` statement.\n\n  Own Id: OTP-16466 Aux Id: ERL-1170\n\n- The compiler could crash when a fun was created but never used.\n\n  The compiler could crash when compiling the expression `true = 0 / X`.\n\n  Own Id: OTP-16467 Aux Id: ERL-1166, ERL-1167","ref":"notes.html#fixed-bugs-and-malfunctions-63"},{"type":"extras","title":"Compiler 7.5.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the compiler that could cause it to reject valid code.\n\n  Own Id: OTP-16385 Aux Id: ERL-1128","ref":"notes.html#fixed-bugs-and-malfunctions-64"},{"type":"extras","title":"Compiler 7.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the linter where list and binary comprehensions could suppress\n  unsafe variable errors.\n\n  Own Id: OTP-16053 Aux Id: ERL-1039\n\n- When a compilation starts from Core Erlang code, the `core_lint` pass will\n  always be run and the compilation will be aborted if any errors are found.\n\n  Own Id: OTP-16181 Aux Id: ERL-1065","ref":"notes.html#fixed-bugs-and-malfunctions-65"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The warning message that appears when the compiler detects a non-utf-8 encoded\n  source file without an encoding string in the beginning of the file has been\n  changed to contain information about that support for latin1 encoded source\n  files without an encoding string will be removed in Erlang/OTP 24.\n\n  Own Id: OTP-16054 Aux Id: OTP-11791","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Compiler 7.4.9 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a performance bug that caused repeated matches of large records to take\n  a very long time to compile.\n\n  Own Id: OTP-16259 Aux Id: ERIERL-436","ref":"notes.html#fixed-bugs-and-malfunctions-66"},{"type":"extras","title":"Compiler 7.4.8 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler could do an unsafe optimization of receives, which would cause a\n  receive to only scan part of the message queue.\n\n  This bug fix in the compiler fixes a bug in the socket module.\n\n  Own Id: OTP-16219 Aux Id: ERL-1076","ref":"notes.html#fixed-bugs-and-malfunctions-67"},{"type":"extras","title":"Compiler 7.4.7 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug where the compiler could generate incorrect code for a '`receive`'\n  statement inside a '`try`'.\n\n  Own Id: OTP-16199","ref":"notes.html#fixed-bugs-and-malfunctions-68"},{"type":"extras","title":"Compiler 7.4.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the bit-syntax optimization pass that could crash the compiler.\n\n  Own Id: OTP-16103 Aux Id: ERL-1050","ref":"notes.html#fixed-bugs-and-malfunctions-69"},{"type":"extras","title":"Compiler 7.4.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Code such as the following would crash the compiler in OTP 22:\n  `[some_atom = fun some_function/1]`\n\n  Own Id: OTP-15833\n\n- Compilation could get really slow (in the order of minutes instead of seconds)\n  when compiling huge functions. (Thanks to Kostis Sagonas for reporting this\n  bug.)\n\n  Own Id: OTP-15923\n\n- Fixed a bug in the validator that could reject valid code.\n\n  Own Id: OTP-15954 Aux Id: ERL-995\n\n- In rare circumstances, when two clauses had identical bodies and guard tests\n  that tested a single boolean variable, the guard test for the second clause\n  could be discarded, executing the second clause unconditionally if the first\n  clause was not executed.\n\n  Own Id: OTP-15963\n\n- Fixed extremely slow compilation for huge functions doing predominantly\n  pattern matching.\n\n  Own Id: OTP-15966 Aux Id: ERL-1014\n\n- The compiler could generate unsafe code (that would crash the runtime system)\n  for map pattern matching. The code could be unsafe if the matched key was not\n  present in the map at runtime.\n\n  Own Id: OTP-15968 Aux Id: ERL-1017\n\n- Correct code using try/after could fail to compile when using the option\n  '`no_type_opt`'.\n\n  Own Id: OTP-15969 Aux Id: ERL-997\n\n- The compiler could crash when compiling code that called\n  '[`length/1`](`length/1`)' on a binary extracted using the binary syntax.\n\n  Own Id: OTP-15970 Aux Id: ERL-1013\n\n- Fixed a bug where the compiler could fail with an internal consistency failure\n  error when compiling receive statements.\n\n  Own Id: OTP-15982 Aux Id: ERL-1022\n\n- Fixed a problem where the compiler would crash when compiling binary matching\n  in a function head.\n\n  Own Id: OTP-15985 Aux Id: ERL-1026","ref":"notes.html#fixed-bugs-and-malfunctions-70"},{"type":"extras","title":"Compiler 7.4.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a compiler crash introduced in `22.0.6` (OTP-15952).\n\n  Own Id: OTP-15953 Aux Id: ERL-999","ref":"notes.html#fixed-bugs-and-malfunctions-71"},{"type":"extras","title":"Compiler 7.4.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed an unsafe optimization when matching [`tuple_size/1`](`tuple_size/1`)\n  outside of guards, which could crash the emulator if the argument was not a\n  tuple.\n\n  Own Id: OTP-15945\n\n- Fixed a rare bug that could cause the wrong kind of exception to be thrown\n  when a BIF failed in a function that matched bitstrings.\n\n  Own Id: OTP-15946\n\n- Fixed a bug where receive statements inside try/catch blocks could return\n  incorrect results.\n\n  Own Id: OTP-15952","ref":"notes.html#fixed-bugs-and-malfunctions-72"},{"type":"extras","title":"Compiler 7.4.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed an incorrect type determination for constructed binaries, which could\n  cause `is_binary` checks to succeed when they shouldn't have.\n\n  Own Id: OTP-15872","ref":"notes.html#fixed-bugs-and-malfunctions-73"},{"type":"extras","title":"Compiler 7.4.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The type optimization pass of the compiler could hang or loop for a long time\n  when analyzing a [`setelement/3`](`setelement/3`) call with a variable\n  position.\n\n  Own Id: OTP-15828 Aux Id: ERL-948\n\n- Certain complex receive statements would result in an internal compiler\n  failure.\n\n  Own Id: OTP-15832 Aux Id: ERL-950\n\n- Fixed an unsafe type optimization.\n\n  Own Id: OTP-15838\n\n- Fixed a crash when optimizing compiler-generated exceptions (like badmatch)\n  whose offending term was a constructed binary.\n\n  Own Id: OTP-15839 Aux Id: ERL-954\n\n- Fixed a bad optimization related to the `++/2` operator, where the compiler\n  assumed that it always produced a list (`[] ++ RHS` returns `RHS` verbatim,\n  even if it's not a list).\n\n  Own Id: OTP-15841\n\n- An [`is_binary/1`](`is_binary/1`) test followed by\n  [`is_bitstring/1`](`is_bitstring/1`) (or vice versa) could fail because of an\n  usafe optimization.\n\n  Own Id: OTP-15845\n\n- A Core Erlang module where the last clause in a `case` matched a map would\n  fail to load.\n\n  Own Id: OTP-15846 Aux Id: ERL-955\n\n- Fixed a bug that could cause the compiler to crash when compiling complex\n  nested case expressions.\n\n  Own Id: OTP-15848 Aux Id: ERL-956","ref":"notes.html#fixed-bugs-and-malfunctions-74"},{"type":"extras","title":"Compiler 7.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- `record_info/2` is a pseudo-function that requires literal arguments known at\n  compile time. Therefore, the following usage is illegal: `fun record/info/2`.\n  The compiler would crash when during compilation of that kind of code.\n  Corrected to issue a compilation error.\n\n  Own Id: OTP-15760 Aux Id: ERL-907","ref":"notes.html#fixed-bugs-and-malfunctions-75"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler has been rewritten to internally use an intermediate\n  representation based on Static Single Assignment (SSA). The new intermediate\n  representation makes more optimizations possible.\n\n  Most noticeable is that the binary matching optimizations are now applicable\n  in many more circumstances than before.\n\n  Another noticeable change is that type optimizations are now applied across\n  local function calls, and will remove a lot more redundant type tests than\n  before.\n\n  Own Id: OTP-14894 Aux Id: ERL-714\n\n- Funs are no longer created when they are only used locally, greatly improving\n  the performance of named funs and \"fun-wrapped\" macros.\n\n  Own Id: OTP-15273 Aux Id: ERL-639\n\n- All compiler options that can be given in the source file can now also be\n  given in the option list or from the command line for `erlc`.\n\n  Specifically, the option `{nowarn_deprecated_function,MFAs}` was only\n  recognized when given in the file with the attribute `-compile()`. The option\n  `{nowarn_unused_function,FAs}` was incorrectly documented to only work in a\n  file, but it also worked when given in the option list.\n\n  Own Id: OTP-15456\n\n- Do not allow function specifications for functions residing in other modules.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15563 Aux Id: ERL-845, OTP-15562\n\n- Internal documentation has now been added to the _Erts_ and _Compiler_\n  applications.\n\n  The internal documents for _Erts_ describe miscellaneous interesting\n  implementation details. Those details can change at any time.\n\n  The internal documentation for _Compiler_ documents the API for the Core\n  Erlang modules. While we will not change those APIs without good reason, we\n  don't give the same guarantees about backward compatibility as for the rest of\n  the APIs in OTP.\n\n  Own Id: OTP-15715\n\n- There are new compiler options `nowarn_removed` and `{nowarn_removed,Items}`\n  to suppress warnings for functions and modules that have been removed from\n  OTP.\n\n  Own Id: OTP-15749 Aux Id: ERL-904","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Compiler 7.3.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- An expression such as `(A / B) band 16#ff` would crash the compiler.\n\n  Own Id: OTP-15518 Aux Id: ERL-829\n\n- There could be an incorrect warning when the `tuple_calls` option was given.\n  The generated code would be correct. Here is an example of code that would\n  trigger the warning:\n\n  `(list_to_atom(\"prefix_\" ++ atom_to_list(suffix))):doit(X)`.\n\n  Own Id: OTP-15552 Aux Id: ERL-838\n\n- Optimize (again) Dialyzer's handling of left-associative use of `andalso` and\n  `orelse` in guards.\n\n  Own Id: OTP-15577 Aux Id: ERL-851, PR-2141, PR-1944","ref":"notes.html#fixed-bugs-and-malfunctions-76"},{"type":"extras","title":"Compiler 7.3.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- An optimization that avoided allocation of a stack frame for some `case`\n  expressions was introduced in OTP 21. (ERL-504/OTP-14808) It turns out that in\n  rare circumstances, this optimization is not safe. Therefore, this\n  optimization has been disabled.\n\n  A similar optimization will be included in OTP 22 in a safe way.\n\n  Own Id: OTP-15501 Aux Id: ERL-807, ERL-514, OTP-14808","ref":"notes.html#fixed-bugs-and-malfunctions-77"},{"type":"extras","title":"Compiler 7.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a rare internal consistency failure caused by a bug in the `beam_jump`\n  pass. (Thanks to Simon Cornish for reporting this bug.)\n\n  Own Id: OTP-15400 Aux Id: ERL-759\n\n- The compiler could fail with an internal consistency check failure when\n  compiling code that used the [`is_function/2`](`is_function/2`) BIF.\n\n  Own Id: OTP-15435 Aux Id: ERL-778\n\n- When an external fun was used, warnings for unused variables could be\n  suppressed.\n\n  Own Id: OTP-15437 Aux Id: ERL-762\n\n- The compiler would crash when compiling an `after` block that called\n  `erlang:raise/3` like this: `erlang:raise(Class, Stacktrace, Stacktrace)`\n\n  Own Id: OTP-15481","ref":"notes.html#fixed-bugs-and-malfunctions-78"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- When specified, the `+{source,Name}` option will now override the actual file\n  name in stack traces, instead of only affecting the return value of\n  `Mod:module_info()`.\n\n  The `+deterministic` flag will also affect stack traces now, omitting all path\n  information except the file name, fixing a long-standing issue where\n  deterministic builds required deterministic paths.\n\n  Own Id: OTP-15245 Aux Id: ERL-706","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Compiler 7.2.7 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug where incorrect code was generated following a binary match guard.\n\n  Own Id: OTP-15353 Aux Id: ERL-753","ref":"notes.html#fixed-bugs-and-malfunctions-79"},{"type":"extras","title":"Compiler 7.2.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstances, the matched out tail of a binary could be the entire\n  original binary. (There was partial correction to this problem in version\n  7.2.5 of the compiler application.)\n\n  Own Id: OTP-15335 Aux Id: ERL-689, OTP-15219","ref":"notes.html#fixed-bugs-and-malfunctions-80"},{"type":"extras","title":"Compiler 7.2.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug that prevented certain variable-sized binary comprehensions from\n  compiling.\n\n  Own Id: OTP-15186 Aux Id: ERL-665\n\n- When compiling from Core Erlang, funs created in certain expressions that were\n  only used for their side-effects were subtly broken.\n\n  Own Id: OTP-15188 Aux Id: ERL-658\n\n- There could be an internal consistency failure when a `receive` was nested in\n  a `try`/`catch`.\n\n  Own Id: OTP-15218 Aux Id: ERL-684\n\n- In rare circumstances, the matched out tail of a binary could be the entire\n  original binary.\n\n  Own Id: OTP-15219 Aux Id: ERL-689\n\n- When [`is_map_key/2`](`is_map_key/2`) was used in a guard together with the\n  `not/1` or `or/2` operators, the error behavior could be wrong when\n  [`is_map_key/2`](`is_map_key/2`) was passed a non-map as the second argument.\n\n  In rare circumstances, compiling code that uses\n  [`is_map_key/2`](`is_map_key/2`) could cause an internal consistency check\n  failure.\n\n  Own Id: OTP-15227 Aux Id: ERL-699\n\n- The compiler could crash when compiling a function with multiple receives in\n  multiple clauses.\n\n  Own Id: OTP-15235 Aux Id: ERL-703","ref":"notes.html#fixed-bugs-and-malfunctions-81"},{"type":"extras","title":"Compiler 7.2.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fix a regression in OTP-15204 that removed `.beam` file metadata that some\n  external build tools relied on.\n\n  Own Id: OTP-15292","ref":"notes.html#fixed-bugs-and-malfunctions-82"},{"type":"extras","title":"Compiler 7.2.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed an issue where files compiled with the `+deterministic` option differed\n  if they were compiled in a different directory but were otherwise identical.\n\n  Own Id: OTP-15204 Aux Id: ERL-679","ref":"notes.html#fixed-bugs-and-malfunctions-83"},{"type":"extras","title":"Compiler 7.2.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare cases involving matching of binary literal strings, the compiler could\n  optimize away code that should be executed.\n\n  Own Id: OTP-15156 Aux Id: ERL-655\n\n- There could be an internal consistency check failure when compiling code that\n  called [`map_get(Key, Map)`](`map_get/2`) and then updated the same map.\n\n  Own Id: OTP-15157\n\n- In rare circumstances, the compiler could crash in `beam_jump` when compiling\n  a floating point operation.\n\n  Own Id: OTP-15166 Aux Id: ERL-660","ref":"notes.html#fixed-bugs-and-malfunctions-84"},{"type":"extras","title":"Compiler 7.2.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The could could crash when compiling a complicated function that used the\n  binary syntax.\n\n  Own Id: OTP-15150 Aux Id: ERL-650","ref":"notes.html#fixed-bugs-and-malfunctions-85"},{"type":"extras","title":"Compiler 7.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed an error in an optimization pass that caused impossible tuple matching.\n\n  Own Id: OTP-14855 Aux Id: ERL-549\n\n- The exception thrown when a list comprehension was given a non-list term was\n  not always correct.\n\n  Own Id: OTP-14992 Aux Id: ERL-572\n\n- The compiler could produce incorrect code in rare circumstances when the\n  `[{inline,F/A}]` option was used.\n\n  Own Id: OTP-15115 Aux Id: PR-1831","ref":"notes.html#fixed-bugs-and-malfunctions-86"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Changed the default behaviour of `.erlang` loading: `.erlang` is no longer\n  loaded from the current directory. `c:erlangrc(PathList)` can be used to\n  search and load an `.erlang` file from user specified directories.\n\n  `escript`, `erlc`, `dialyzer` and `typer` no longer load an `.erlang` at all.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14439\n\n- Support for \"tuple calls\" have been removed from the run-time system. Tuple\n  calls was an undocumented and unsupported feature which allowed the module\n  argument for an apply operation to be a tuple: `Var = dict:new(), Var:size()`.\n  This \"feature\" frequently caused confusion, especially when such call failed.\n  The stacktrace would point out functions that don't exist in the source code.\n\n  For legacy code that need to use parameterized modules or tuple calls for some\n  other reason, there is a new compiler option called `tuple_calls`. When this\n  option is given, the compiler will generate extra code that emulates the old\n  behavior for calls where the module is a variable.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14497\n\n- In code such as `example({ok, Val}) -> {ok, Val}.` a tuple would be built. The\n  compiler will now automatically rewrite the code to\n  `example({ok,Val}=Tuple) -> Tuple.` which will reduce code size, execution\n  time, and remove GC pressure.\n\n  Own Id: OTP-14505\n\n- The optimization of `case` expression where only one of the case arms can\n  execute successfully has been improved.\n\n  Own Id: OTP-14525\n\n- Some uses of binary matching has been slightly improved, eliminating\n  unnecessary register shuffling.\n\n  Own Id: OTP-14594 Aux Id: ERL-444\n\n- There is a new `{compile_info,Info}` option for the compiler that allows\n  BEAM-based languages such as Elixir and LFE to add their own compiler\n  versions.\n\n  Own Id: OTP-14615 Aux Id: PR-1558\n\n- Loaded BEAM code in a 64-bit system requires less memory because of better\n  packing of operands for instructions.\n\n  These memory savings were achieved by major improvements to the `beam_makeops`\n  scripts used when building the run time system and BEAM compiler. There is\n  also new for documentation for `beam_makeops` that describes how new BEAM\n  instructions and loader transformations can be implemented. The documentation\n  is found in here in a source directory or git repository:\n  erts/emulator/internal_doc/beam_makeops.md. An online version can be found\n  here:\n  https://github.com/erlang/otp/blob/master/erts/emulator/internal_doc/beam_makeops.md\n\n  Own Id: OTP-14626\n\n- Size calculations for binary constructions has been somewhat optimized,\n  producing smaller code.\n\n  Own Id: OTP-14654\n\n- When the value returned from a '`catch`' expression is ignored, no stacktrace\n  will be built if an exception is caught. That will save time and produce less\n  garbage. There are also some minor optimizations of '`try`/`catch`' both in\n  the compiler and run-time system.\n\n  Own Id: OTP-14683\n\n- There is a new syntax in '`try/catch`' for retrieving the stacktrace without\n  calling '`erlang:get_stacktrace/0`'. See the reference manual for a\n  description of the new syntax. The '`erlang:get_stacktrace/0`' BIF is now\n  deprecated.\n\n  Own Id: OTP-14692\n\n- The following is an internal change in the compiler, that is not noticeable\n  for normal use of the compiler: The module `v3_life` has been removed. Its\n  functionality has been simplified and integrated into `v3_codegen`.\n\n  Own Id: OTP-14712\n\n- The optimization of binary matching that delays creation of sub binaries (see\n  the Efficiency Guide) could be thwarted by the argument order and could be\n  necessary to change the argument order. The compiler has now become smarter\n  and can handle any argument order.\n\n  Own Id: OTP-14774\n\n- When the compiler was faced with complex case expressions it would\n  unnecessarily allocate stack elements and shuffle data between x and y\n  registers. Improved code generation to only allocate a stack frame when\n  strictly necessary.\n\n  Own Id: OTP-14808 Aux Id: ERL-514\n\n- There is a new option '`makedep_side_effect`' for the compiler and `-MMD` for\n  '`erlc`' that generates dependencies and continues to compile as normal.\n\n  Own Id: OTP-14830\n\n- When compiling modules with huge functions, the compiler would generate a lot\n  of atoms for its internal, sometimes so many that the atom table would\n  overflow. The compiler has been rewritten to generate far less internal atoms\n  to avoid filling the atom table.\n\n  Own Id: OTP-14968 Aux Id: ERL-563\n\n- External funs with literal values for module, name, and arity (e.g.\n  `erlang:abs/1`) are now treated as literals. That means more efficient code\n  that produces less garbage on the heap.\n\n  Own Id: OTP-15003\n\n- Two new guards BIFs operating on maps have been added:\n  [`map_get/2`](`map_get/2`) and [`is_map_key/2`](`is_map_key/2`). They do the\n  same as `maps:get/2` and `maps:is_key/2`, respectively, except that they are\n  allowed to be used in guards.\n\n  Own Id: OTP-15037 Aux Id: PR-1784, PR-1802\n\n- A call or apply of a literal external fun will be replaced with a direct call.\n\n  Own Id: OTP-15044 Aux Id: ERL-614\n\n- Part of EEP-44 has been implemented.\n\n  There is a new predefined macro called `OTP_RELEASE` which is an integer\n  indicating the OTP release number (its value is `21` in this release).\n\n  There are new preprocessor directives `-if(Condition).` and\n  `-elif(Condition).`. The `if/elif` supports the builtin function\n  `defined(Symbol)`.\n\n  Own Id: OTP-15087 Aux Id: PR-1810","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Compiler 7.1.5.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fix a regression in OTP-15204 that removed `.beam` file metadata that some\n  external build tools relied on.\n\n  Own Id: OTP-15292","ref":"notes.html#fixed-bugs-and-malfunctions-87"},{"type":"extras","title":"Compiler 7.1.5.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed an issue where files compiled with the `+deterministic` option differed\n  if they were compiled in a different directory but were otherwise identical.\n\n  Own Id: OTP-15204 Aux Id: ERL-679","ref":"notes.html#fixed-bugs-and-malfunctions-88"},{"type":"extras","title":"Compiler 7.1.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The internal compiler pass (`beam_validator`) that validates the generated\n  code has been strengthened.\n\n  When compiling from BEAM assembly code, the `beam_type` optimizer pass could\n  make the code unsafe. Corrected.\n\n  Own Id: OTP-14863\n\n- Corrected optimizations of integers matched out from binaries and used in bit\n  operations.\n\n  Own Id: OTP-14898","ref":"notes.html#fixed-bugs-and-malfunctions-89"},{"type":"extras","title":"Compiler 7.1.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The '`deterministic`' option was not recognized when given in a `-compile()`\n  attribute in the source code.\n\n  Own Id: OTP-14773 Aux Id: ERL-498","ref":"notes.html#fixed-bugs-and-malfunctions-90"},{"type":"extras","title":"Compiler 7.1.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler could issue an incorrect internal consistency failure diagnostic\n  for some complicated bit syntax matches.\n\n  Own Id: OTP-14640 Aux Id: ERL-490","ref":"notes.html#fixed-bugs-and-malfunctions-91"},{"type":"extras","title":"Compiler 7.1.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fail labels on guard BIFs weren't taken into account during an optimization\n  pass, and a bug in the validation pass sometimes prevented this from being\n  noticed when a fault occurred.\n\n  Own Id: OTP-14522 Aux Id: ERIERL-48\n\n- When compiling from Core Erlang, an 'apply' with a nested apply in the\n  function position would be treated as an invalid call. Corrected. (Thanks to\n  Mikael Pettersson for reporting this bug.)\n\n  Own Id: OTP-14526\n\n- Fixed checking of binary matching in the `beam_validator` module to ensure\n  that potential compiler bugs are found at compile-time instead as emulator\n  crash at run-time.\n\n  Own Id: OTP-14591\n\n- There could be false warnings for `erlang:get_stacktrace/0` being used outside\n  of a `try` block when using multiple `catch` clauses.\n\n  Own Id: OTP-14600 Aux Id: ERL-478","ref":"notes.html#fixed-bugs-and-malfunctions-92"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The Erlang code linter no longer checks that the functions mentioned in\n  `nowarn_deprecated_function` options are declared in the module.\n\n  Own Id: OTP-14378","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Compiler 7.1.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fail labels on guard BIFs weren't taken into account during an optimization\n  pass, and a bug in the validation pass sometimes prevented this from being\n  noticed when a fault occurred.\n\n  Own Id: OTP-14522 Aux Id: ERIERL-48","ref":"notes.html#fixed-bugs-and-malfunctions-93"},{"type":"extras","title":"Compiler 7.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- For many releases, it has been legal to override a BIF with a local function\n  having the same name. However, calling a local function with the same name as\n  guard BIF as filter in a list comprehension was not allowed.\n\n  Own Id: OTP-13690\n\n- compile:forms/2 would not return the module name as documented when one of the\n  options '`from_core`', '`from_asm`', or '`from_beam`' was given. Also, the\n  compiler would crash if one of those options was combined with '`native`'.\n\n  Own Id: OTP-14408 Aux Id: ERL-417","ref":"notes.html#fixed-bugs-and-malfunctions-94"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Optimized test for tuples with an atom as first element.\n\n  Own Id: OTP-12148\n\n- Compilation of modules with huge literal binary strings is now much faster.\n\n  Own Id: OTP-13794\n\n- Replaced usage of deprecated symbolic [`time unit`](`t:erlang:time_unit/0`)\n  representations.\n\n  Own Id: OTP-13831 Aux Id: OTP-13735\n\n- The undocumented and unsupported module `sys_pre_expand` has been removed. As\n  a partial replacement for the functionality, there is a new function\n  `erl_internal:add_predefined_functions/1` and `erl_expand_records` will now\n  add a module prefix to calls to BIFs and imported functions.\n\n  Own Id: OTP-13856\n\n- The internal compiler passes now start all generated variables with \"@\" to\n  avoid any conflicts with variables in languages such as Elixir or LFE.\n\n  Own Id: OTP-13924\n\n- The function `fmod/2` has been added to the `math` module.\n\n  Own Id: OTP-14000\n\n- Code generation for complicated guards have been improved.\n\n  Own Id: OTP-14042\n\n- The compiler has new warnings for repeated identical map keys.\n\n  A map expression such as,\n\n  `#{'a' => 1, 'b' => 2, 'a' => 3}.`\n\n  will produce a warning for the repeated key 'a'.\n\n  Own Id: OTP-14058\n\n- By default, there will now be a warning when `export_all` is used. The warning\n  can be disabled using `nowarn_export_all`.\n\n  Own Id: OTP-14071\n\n- Optimize maps pattern matching by only examining the common keys in each\n  clause first instead of all keys. This will reduce the number of lookups of\n  each key in maps pattern matching.\n\n  Own Id: OTP-14072\n\n- There is a new '`deterministic`' option to omit '`source`' and '`options`'\n  tuples in the BEAM file.\n\n  Own Id: OTP-14087\n\n- Analyzing modules with binary construction with huge strings is now much\n  faster. The compiler also compiles such modules slightly faster.\n\n  Own Id: OTP-14125 Aux Id: ERL-308\n\n- Atoms may now contain arbitrary Unicode characters.\n\n  Own Id: OTP-14178\n\n- `compile:file/2` now accepts the option `extra_chunks` to include extra chunks\n  in the BEAM file.\n\n  Own Id: OTP-14221\n\n- The format of debug information that is stored in BEAM files (when\n  `debug_info` is used) has been changed. The purpose of the change is to better\n  support other BEAM-based languages such as Elixir or LFE.\n\n  All tools included in OTP (dialyzer, debugger, cover, and so on) will handle\n  both the new format and the previous format. Tools that retrieve the debug\n  information using `beam_lib:chunk(Beam, [abstract_code])` will continue to\n  work with both the new and old format. Tools that call\n  `beam_lib:chunk(Beam, [\"Abst\"])` will not work with the new format.\n\n  For more information, see the description of `debug_info` in the documentation\n  for `beam_lib` and the description of the `{debug_info,{Backend,Data}}` option\n  in the documentation for `compile`.\n\n  Own Id: OTP-14369 Aux Id: PR-1367\n\n- In a future release, `erlang:get_stacktrace/0` will probably only work when\n  called from within a '`try`' expression (otherwise it will return `[]`.\n\n  To help prepare for that change, the compiler will now by default warn if\n  '`get_stacktrace/0`' is used in a way that will not work in the future. Note\n  that the warning will not be issued if '`get_stacktrace/0`' is used in a\n  function that uses neither '`catch`' nor '`try`' (because that could be a\n  legal use if the function is called from within a '`try`'.\n\n  Own Id: OTP-14401","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Compiler 7.0.4.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-0-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fail labels on guard BIFs weren't taken into account during an optimization\n  pass, and a bug in the validation pass sometimes prevented this from being\n  noticed when a fault occurred.\n\n  Own Id: OTP-14522 Aux Id: ERIERL-48","ref":"notes.html#fixed-bugs-and-malfunctions-95"},{"type":"extras","title":"Compiler 7.0.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Minor internal changes. A typo in the documentation was also fixed.\n\n  Own Id: OTP-14240","ref":"notes.html#fixed-bugs-and-malfunctions-96"},{"type":"extras","title":"Compiler 7.0.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a compiler crash when maps were matched.\n\n  Own Id: OTP-13931 Aux Id: ERL-266\n\n- Fixed a compiler crash having to with the delayed sub-creation optimization.\n  (Thanks to Jose Valim for reporting this bug.)\n\n  Own Id: OTP-13947 Aux Id: ERL-268\n\n- The compiler option `inline_list_funcs` accidentally turned off some other\n  optimizations.\n\n  Own Id: OTP-13985\n\n- The compiler could sometimes generate spurious warnings when inlining was\n  enabled.\n\n  Own Id: OTP-14040 Aux Id: ERL-301","ref":"notes.html#fixed-bugs-and-malfunctions-97"},{"type":"extras","title":"Compiler 7.0.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- If the compiler fails to write the BEAM file, it will now report the reason of\n  the error for the write operation.\n\n  Own Id: OTP-13701\n\n- Fixed an internal compiler error. (Thanks to Svilen Ivanov for reporting this\n  bug.)\n\n  Own Id: OTP-13780 Aux Id: ERL-202\n\n- The compiler could crash when trying to compile a complicated expression with\n  multiple catches all on one line . (Thanks to Thomas Arts for reporting this\n  bug.)\n\n  Own Id: OTP-13804 Aux Id: ERL-209\n\n- Eliminated a few internal compiler failures.\n\n  Own Id: OTP-13863","ref":"notes.html#fixed-bugs-and-malfunctions-98"},{"type":"extras","title":"Compiler 7.0.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A literal binary matching regression was introduced in 19.0 where a match\n  could fail to resolve to the right clause. This has now been fixed.\n\n  Own Id: OTP-13738","ref":"notes.html#fixed-bugs-and-malfunctions-99"},{"type":"extras","title":"Compiler 7.0 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-7-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- `compile:forms/1,2` would crash when used in a working directory that had been\n  deleted by another process.\n\n  Own Id: OTP-13430 Aux Id: ERL-113\n\n- Dialyzer no longer crashes when there is an invalid function call such as\n  `42(7)` in a module being analyzed. The compiler will now warn for invalid\n  function calls such as `X = 42, x(7)`.\n\n  Own Id: OTP-13552 Aux Id: ERL-138","ref":"notes.html#fixed-bugs-and-malfunctions-100"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Optimization of tuple matching has been slightly improved.\n\n  Own Id: OTP-12951\n\n- Five deprecated and undocumented functions in the module `core_lib` have been\n  removed. The functions are: `get_anno/{1,2}`, `is_literal/1`,\n  `is_literal_list/1`, and `literal_value`. Use the appropriate functions in the\n  `cerl` module instead.\n\n  Own Id: OTP-12979\n\n- The pre-processor can now expand the ?FUNCTION_NAME and ?FUNCTION_ARITY\n  macros.\n\n  Own Id: OTP-13059\n\n- The function mapfold/4 has been added to the `cerl_trees` module.\n\n  Own Id: OTP-13280\n\n- Bitstring comprehensions have been generalized to allow arbitrary expressions\n  in the construction part.\n\n  Own Id: OTP-13289\n\n- The compiler will now produce warnings for binary patterns that will never\n  match (example: `<<-1/unsigned>> = Bin`).\n\n  Own Id: OTP-13374 Aux Id: ERL-44\n\n- The compiler will no longer put the compilation date and time into BEAM files.\n  That means that two BEAM files compiled on the same computer from the same\n  source code and compilation options will be identical.\n\n  Note: If you want to find out whether a BEAM file on disk is different from\n  the loaded code, compared the MD5 value obtained from `Mod:module_info(md5)`\n  with the MD5 value obtained from `beam_lib:md5(BeamFileForMod)`\n\n  .\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-13504\n\n- The function `compile:env_compiler_options/0` has been added to allow tools to\n  pick up the same default compiler options as the compiler itself.\n\n  Own Id: OTP-13654","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Compiler 6.0.3.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-6-0-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fail labels on guard BIFs weren't taken into account during an optimization\n  pass, and a bug in the validation pass sometimes prevented this from being\n  noticed when a fault occurred.\n\n  Own Id: OTP-14522 Aux Id: ERIERL-48","ref":"notes.html#fixed-bugs-and-malfunctions-101"},{"type":"extras","title":"Compiler 6.0.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-6-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- An complicated guard expression in a function call could crash the compiler.\n  (Thanks to Thomas Arts for reporting this bug.)\n\n  Own Id: OTP-13208\n\n- Constructing a map in a guard in a catch could crash the compiler. (Thanks to\n  Thomas Arts for reporting this bug.)\n\n  Own Id: OTP-13223\n\n- Updating a fun as if it were a map would cause the compiler to crash. (Thanks\n  to Thomas Arts for reporting this bug.)\n\n  Own Id: OTP-13231\n\n- Fix pretty printing of Core Maps\n\n  Literal maps could cause Dialyzer to crash when pretty printing the results.\n\n  Own Id: OTP-13238\n\n- A complex combination of bit syntax matching operations would cause an\n  internal consistency check failure during compilation. (Thanks to Jose Valim\n  for reporting this bug.)\n\n  Own Id: OTP-13309","ref":"notes.html#fixed-bugs-and-malfunctions-102"},{"type":"extras","title":"Compiler 6.0.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-6-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fix cerl_trees:label/2 bug with map K/V swap\n\n  Own Id: OTP-13091\n\n- Warnings produced when the '`bin_opt_info`' option was given could sometimes\n  lack filenames and line numbers. (Thanks to José Valim for reporting this\n  bug.)\n\n  Own Id: OTP-13113","ref":"notes.html#fixed-bugs-and-malfunctions-103"},{"type":"extras","title":"Compiler 6.0.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-6-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fix `get_map_elements` register corruption\n\n  Instruction `get_map_elements` might destroy target registers when the\n  fail-label is taken. Only seen for patterns with two, and only two, target\n  registers. Specifically if we copy one register and then jump.\n\n  Own Id: OTP-12967","ref":"notes.html#fixed-bugs-and-malfunctions-104"},{"type":"extras","title":"Compiler 6.0 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-6-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler optimizes away building of terms that are never actually used. As\n  a result, the compiler in OTP 18 may produce more warnings for terms that are\n  built but not used than the compiler in OTP 17.\n\n  Own Id: OTP-12453\n\n- Using a map could incorrectly suppress warnings for unused variables.\n\n  Own Id: OTP-12515\n\n- The compiler now properly reports unknown parse transforms. That is, `undef`\n  exceptions coming from the parse transform itself is reported differently from\n  the absence of the parse transform.\n\n  Own Id: OTP-12723\n\n- Allow for 'creation of sub binary delayed' optimization if maps instructions\n  are in a clause.\n\n  Own Id: OTP-12758","ref":"notes.html#fixed-bugs-and-malfunctions-105"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The `cerl` and `cerl_trees` modules in the Compiler application are now\n  documented.\n\n  Own Id: OTP-11978\n\n- The deprecated '`asm`' option has been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12100\n\n- Support variables as Map keys in expressions and patterns\n\n  Erlang will accept any expression as keys in Map expressions and it will\n  accept literals or bound variables as keys in Map patterns.\n\n  Own Id: OTP-12218\n\n- Infer Map type information in beam_type compiler optimization pass.\n\n  Own Id: OTP-12253\n\n- Compiler optimizations have been improved.\n\n  Own Id: OTP-12393\n\n- Five undocumented functions in the module `core_lib` have been deprecated and\n  will be removed in the next major release. The functions are:\n  `get_anno/{1,2}`, `is_literal/1`, `is_literal_list/1`, and `literal_value`.\n  Use the appropriate functions in the `cerl` module instead.\n\n  Own Id: OTP-12497\n\n- Change some internal data structures to Maps in order to speed up compilation\n  time. Measured speed up is around 10%-15%.\n\n  Own Id: OTP-12774\n\n- Fix beam_bool pass for Maps instruction get_map_elements\n\n  Before beam_split the get_map_elements instruction is still in blocks and the\n  helper function in beam_jump did not reflect this.\n\n  Own Id: OTP-12844 Aux Id: 17","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Compiler 5.0.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-5-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Matching out a map from a record and then updating the record could cause a\n  'badarg' exception at run-time. (Thanks to Dmitry Aleksandrov for reporting\n  this bug.)\n\n  Own Id: OTP-12402\n\n- The compiler would crash when compiling some complex, nonsensical guards such\n  as:\n\n  ... `when {{X}}, -X`...\n\n  Own Id: OTP-12410\n\n- In rare circumstances, using binary pattern in the value part of a map pattern\n  would cause the compiler to crash.\n\n  Own Id: OTP-12414\n\n- Case expressions where a map was wrapped in a tuple or list such as:\n\n  `case {a,Map} of`  \n  `{a,#{k:=_}}=Tuple -> Tuple`  \n  `end.`\n\n  would be unsafely \"optimized\" to either cause an exception at run-time or\n  would return an empty map.\n\n  Own Id: OTP-12451\n\n- When a variable was compared to a literal map using the '`==`' operator, the\n  compiler would change the operator to '`=:=`' since it is more efficient.\n  However, this optimization is not safe if the map literal has numeric keys or\n  values. The compiler will now only do the optimization if all keys and values\n  are non-numeric.\n\n  Own Id: OTP-12456","ref":"notes.html#fixed-bugs-and-malfunctions-106"},{"type":"extras","title":"Compiler 5.0.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-5-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Named funs with the same name and arity could get mixed up with each other.\n\n  Own Id: OTP-12262\n\n- Coalesce map keys in dialyzer mode\n\n  This fixes a regression introduced in commit\n  805f9c89fc01220bc1bb0f27e1b68fd4eca688ba The problem occurred with compounded\n  map keys compiled with dialyzer option turned on, '+dialyzer'.\n\n  Reported by: Ivan Uemlianin\n\n  Own Id: OTP-12347","ref":"notes.html#fixed-bugs-and-malfunctions-107"},{"type":"extras","title":"Compiler 5.0.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-5-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Corrected a bug with incorrect code generation when inlining was turned on.\n\n  Own Id: OTP-12132","ref":"notes.html#fixed-bugs-and-malfunctions-108"},{"type":"extras","title":"Compiler 5.0.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-5-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A Dialyzer crash involving analysis of Map types has now been fixed.\n\n  Own Id: OTP-11947\n\n- The compiler would fail to compile a file with a latin-1 character in the\n  false branch of an `-ifdef` or `-indef`.\n\n  Own Id: OTP-11987","ref":"notes.html#fixed-bugs-and-malfunctions-109"},{"type":"extras","title":"Compiler 5.0 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-5-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Line numbers would not be correct when a binary construction such as\n  '`< >`' fails. (Thanks to Stanislav Seletskiy for reporting\n  this bug.)\n\n  Own Id: OTP-11572\n\n- The compiler now properly annotates the code in value in the '`after`' clause\n  for a '`try`' so that Dialyzer no longer generates a false warning for an\n  unmatched return.\n\n  Own Id: OTP-11580\n\n- Some case statements where no clause would match could cause an internal error\n  in the compiler. (Thanks to Erik Soe Sorensen for reporting this bug.)\n\n  Own Id: OTP-11610\n\n- With `--Wunmatched_returns`, dialyzer will no longer warn when the value of a\n  list comprehension is ignored, provided that the each value in the list would\n  be an atomic value (such as integer or atoms, as opposed to tuples and lists).\n  Example: ignoring '`[io:format(...) || ...]`' will not cause a warning, while\n  ignoring '`[file:close(Fd) || ...]`' will.\n\n  Own Id: OTP-11626\n\n- Matching out a binary and applying the binary as if it were a fun would crash\n  the run-time system. (Thanks to Loïc Hoguin.)\n\n  Own Id: OTP-11672\n\n- Some local implementations of removing the last element from a list are\n  replaced by `lists:droplast/1`. Note that this requires at least `stdlib-2.0`,\n  which is the stdlib version delivered in OTP 17.0. (Thanks to Hans Svensson)\n\n  Own Id: OTP-11678\n\n- Allow all auto imports to be suppressed at once. Introducing the\n  no_auto_import attribute: -compile(no_auto_import). Useful for code generation\n  tools that always use the qualified function names and want to avoid the auto\n  imported functions clashing with local ones. (Thanks to José Valim.)\n\n  Own Id: OTP-11682\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- Adapt 'asm' deprecation message to new version scheme. (Thanks to Tuncer Ayaz)\n\n  Own Id: OTP-11751\n\n- A number of compiler errors where unusual or nonsensical code would crash the\n  compiler have been reported by Ulf Norell and corrected by Anthony Ramine.\n\n  Own Id: OTP-11770","ref":"notes.html#fixed-bugs-and-malfunctions-110"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Compilation times for modules with a huge number for record accesses using the\n  dot operator has been improved.\n\n  Own Id: OTP-10652\n\n- The compiler can generate somewhat better code by moving let expressions into\n  sequences. (Thanks to Anthony Ramine.)\n\n  Own Id: OTP-11056\n\n- Forbid unsized fields in patterns of binary generators and simplified\n  v3_core's translation of bit string generators. (Thanks to Anthony Ramine.)\n\n  Own Id: OTP-11186\n\n- Funs can now be a given a name. Thanks to to Richard O'Keefe for the idea\n  (EEP37) and to Anthony Ramine for the implementation.\n\n  Own Id: OTP-11537\n\n- Using the `from_asm` option to produce a BEAM file starting from BEAM assembly\n  code would often fail because early optimization passes would not understand\n  instructions that later optimization passes would introduce. (Thanks to\n  Anthony Ramine.)\n\n  Own Id: OTP-11544\n\n- The `.core` and `.S` extensions are now documented in the `erlc`\n  documentation, and the '`from_core`' and '`from_asm`' options are now\n  documented in the compiler documentation. (Thanks to Tuncer Ayaz.)\n\n  Own Id: OTP-11547\n\n- Optimization of case expressions that build tuples or lists have been\n  improved.\n\n  Own Id: OTP-11584\n\n- EEP43: New data type - Maps\n\n  With Maps you may for instance:\n\n  - \\_\\_\\_\\_ - `M0 = #{ a => 1, b => 2}, % create associations`\n\n  - \\_\\_\\_\\_ - `M1 = M0#{ a := 10 }, % update values`\n\n  - \\_\\_\\_\\_ - `M2 = M1#{ \"hi\" => \"hello\"}, % add new associations`\n\n  - \\_\\_\\_\\_ - `#{ \"hi\" := V1, a := V2, b := V3} = M2. % match keys with values`\n\n  For information on how to use Maps please see Map Expressions in the\n  [Reference Manual](`e:system:expressions.md#map-expressions`).\n\n  The current implementation is without the following features:\n\n  - \\_\\_\\_\\_ - No variable keys\n\n  - \\_\\_\\_\\_ - No single value access\n\n  - \\_\\_\\_\\_ - No map comprehensions\n\n  Note that Maps is _experimental_ during OTP 17.0.\n\n  Own Id: OTP-11616\n\n- Some function specs are corrected or moved and some edoc comments are\n  corrected in order to allow use of edoc. (Thanks to Pierre Fenoll)\n\n  Own Id: OTP-11702\n\n- Thanks to Anthony Ramine for several improvements to the optimizations in the\n  BEAM compiler and for cleaning up the code the code that transforms list and\n  binary comprehensions to Core Erlang.\n\n  Own Id: OTP-11720\n\n- The default encoding for Erlang source files is now UTF-8. As a temporary\n  measure to ease the transition from the old default of latin-1, if the\n  compiler encounters byte sequences that are not valid UTF-8 sequences, the\n  compiler will re-try the compilation in latin-1 mode. This workaround will be\n  removed in a future release.\n\n  Own Id: OTP-11791","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Compiler 4.9.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-9-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Typo fix ambigous -> ambiguous. Thanks to Leo Correa.\n\n  Own Id: OTP-11455","ref":"notes.html#fixed-bugs-and-malfunctions-111"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Lift 'after' blocks to zeroary functions. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11267","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Compiler 4.9.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-9-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Expressions such as `'B = is_integer(V), if B and B -> ok end'` would crash\n  the compiler.\n\n  Own Id: OTP-11240\n\n- `compile:file2/2` with the option `report_errors` could return ErrorInfo\n  tuples with only two elements, while the documentation says that the ErrorInfo\n  tuple always has three elements. Also updated the documentation to add that\n  the first element may be '`none`' if no line number is applicable.\n\n  Own Id: OTP-11304 Aux Id: seq12412","ref":"notes.html#fixed-bugs-and-malfunctions-112"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Fix matching of floating point middle-endian machines. Thanks to Johannes\n  Weissl.\n\n  Own Id: OTP-11201\n\n- Restrict inlining of local fun references. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11211\n\n- Silence a misleading warning with some comprehensions. Thanks to Anthony\n  Ramine.\n\n  Own Id: OTP-11212\n\n- Forbid returning a match context in beam_validator. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11247","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Compiler 4.9.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Compiling functions with complex boolean operations in guards could be very\n  slow. (Thanks to Magnus Muller for reporting this issue.)\n\n  Own Id: OTP-10939\n\n- Certain guard expressions used in a receive statement could cause the compiler\n  to crash.\n\n  Own Id: OTP-11119 Aux Id: seq12342","ref":"notes.html#fixed-bugs-and-malfunctions-113"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Fix optimization of some binary comprehensions. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11005\n\n- Use a set to store ref registers in beam_receive. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11069\n\n- Fix renaming of bs_put_string instructions. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11129","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Compiler 4.9.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler would crash attempting to compile expressions such as \"element(2,\n  not_tuple)\".\n\n  Own Id: OTP-10794\n\n- Forbid multiple values in Core Erlang sequence arguments. Thanks to José Valim\n  and Anthony Ramine.\n\n  Own Id: OTP-10818\n\n- An unsafe optimization would cause the compiler to crash with an internal\n  error for certain complex code sequences.\n\n  Own Id: OTP-10825 Aux Id: seq12247","ref":"notes.html#fixed-bugs-and-malfunctions-114"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Integers in expression that will give a floating point result (such as\n  \"`X / 2`\" will now be converted to floating point at compile-time. (Suggested\n  by Richard O'Keefe.)\n\n  Identical floating points constans in a module will now be coalesced to one\n  entry in the constant pool.\n\n  Own Id: OTP-10788","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Compiler 4.9 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-9"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler optimizations have been polished, so that the code quality will\n  be slightly better in some cases.\n\n  Own Id: OTP-10193\n\n- Support for Unicode has been implemented.\n\n  Own Id: OTP-10302\n\n- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Fix some wrong warnings triggered by the option inline_list_funcs. Thanks to\n  Anthony Ramine.\n\n  Own Id: OTP-10690\n\n- Forbid local fun variables in Core Erlang guards. Thanks to Anthony Ramine.\n\n  Own Id: OTP-10706\n\n- Binary syntax matches could cause an internal consistency error in in the\n  compiler. (Thanks to Viktor Sovietov for reporting this bug.)\n\n  Own Id: OTP-10724","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Compiler 4.8.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Modules with very many functions would compile very slowly.\n\n  Own Id: OTP-10123\n\n- `compile:forms/2` will now use a \\{source,SourceFilePath\\} to set the source\n  returned by `module_info(compile)` (Thanks to José Valim)\n\n  Own Id: OTP-10150\n\n- A process which had enabled trap_exit would receive EXIT messages after\n  calling the compiler. (Thanks to Jeremy Heater.)\n\n  Own Id: OTP-10171\n\n- Fix messages ordering with column numbers\n\n  Own Id: OTP-10183\n\n- sys_pre_expand: Fix BASE never being set\n\n  Commit a612e99fb5aaa934fe5a8591db0f083d7fa0b20a turned module attributes from\n  2-tuples to 3-tuples but forgot to update get_base/1, breaking BASE for\n  parametric modules.\n\n  Own Id: OTP-10184\n\n- The compiler will now issue a warning if literal tuple funs are used. For\n  example, \\{erlang,is_tuple\\}(X) will now generate a warning.\n\n  Own Id: OTP-10185\n\n- The compiler will now warn for illegal sizes for segments in binary\n  construction. For example, < > will now cause the compiler to issue a\n  warning.\n\n  Own Id: OTP-10197\n\n- Fix the erlc -MP flag\n\n  Because of a copy-and-paste error in erlc.c, the -MP flag had the same effect\n  as -MG. As a workaround, you had to pass +makedep_phony to enable the MP\n  option. This patch makes -MP work as intended.\n\n  Own Id: OTP-10211","ref":"notes.html#fixed-bugs-and-malfunctions-115"},{"type":"extras","title":"Compiler 4.8.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstance, the compiler could crash when compiling a case\n  statement. (Thanks to Hakan Mattsson.)\n\n  Own Id: OTP-9842\n\n- Calling a guard test (such as is_list/1) from the top-level in a guard, would\n  cause a compiler crash if there was a local definition with the same name.\n  Corrected to reject the program with an error message.\n\n  Own Id: OTP-9866\n\n- Using [`get/1`](`get/1`) in a `try` block could in some cases cause an\n  internal compiler error. (Thanks to Eric Merritt.)\n\n  Own Id: OTP-9867\n\n- An unexported on_load function would not get run if the module was compiled\n  with the `inline` option. (Thanks to Yiannis Tsiouris.)\n\n  Own Id: OTP-9910\n\n- Fixed a discrepancy in compile_info\n\n  The BEAM disassembler used the atom 'none' to signify the absence of a\n  compile_info chunk in a .beam file. This clashed with the type declaration of\n  the compile_info field of a #beam_file\\{\\} record as containing a list. Now []\n  signifies the absence of this chunk. This simplifies the code and avoids a\n  dialyzer warning.\n\n  Own Id: OTP-9917\n\n- Fix typo in \\`compile' doc: unmatched parenthesis (Thanks to Ricardo Catalinas\n  Jiménez)\n\n  Own Id: OTP-9919\n\n- In a `try`...`catch` statement that always returned `false`, the compiler\n  would remove calls to BIFs that could not cause an exception (such as\n  [`put/2`](`put/2`)). Example of such code:\n  `try put(K, V), false catch _:_ -> false end.`\n\n  Own Id: OTP-9982","ref":"notes.html#fixed-bugs-and-malfunctions-116"},{"type":"extras","title":"Compiler 4.8 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Add '-callback' attributes in stdlib's behaviours\n\n  Replace the behaviour_info(callbacks) export in stdlib's behaviours with\n  -callback' attributes for all the callbacks. Update the documentation with\n  information on the callback attribute Automatically generate 'behaviour_info'\n  function from '-callback' attributes\n\n  'behaviour_info(callbacks)' is a special function that is defined in a module\n  which describes a behaviour and returns a list of its callbacks.\n\n  This function is now automatically generated using the '-callback' specs. An\n  error is returned by lint if user defines both '-callback' attributes and the\n  behaviour_info/1 function. If no type info is needed for a callback use a\n  generic spec for it. Add '-callback' attribute to language syntax\n\n  Behaviours may define specs for their callbacks using the familiar spec\n  syntax, replacing the '-spec' keyword with '-callback'. Simple lint checks are\n  performed to ensure that no callbacks are defined twice and all types referred\n  are declared.\n\n  These attributes can be then used by tools to provide documentation to the\n  behaviour or find discrepancies in the callback definitions in the callback\n  module.\n\n  Add callback specs into 'application' module in kernel Add callback specs to\n  tftp module following internet documentation Add callback specs to\n  inets_service module following possibly deprecated comments\n\n  Own Id: OTP-9621\n\n- The calculation of the 'uniq' value for a fun (see `erlang:fun_info/1`) was\n  too weak and has been strengthened. It used to be based on the only the code\n  for the fun body, but it is now based on the MD5 of the BEAM code for the\n  module.\n\n  Own Id: OTP-9667","ref":"notes.html#fixed-bugs-and-malfunctions-117"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Variables are now now allowed in '`fun M:F/A`' as suggested by Richard O'Keefe\n  in EEP-23.\n\n  The representation of '`fun M:F/A`' in the abstract format has been changed in\n  an incompatible way. Tools that directly read or manipulate the abstract\n  format (such as parse transforms) may need to be updated. The compiler can\n  handle both the new and the old format (i.e. extracting the abstract format\n  from a pre-R15 BEAM file and compiling it using compile:forms/1,2 will work).\n  The `syntax_tools` application can also handle both formats.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9643\n\n- `filename:find_src/1,2` will now work on stripped BEAM files (reported by Per\n  Hedeland). The HiPE compiler will also work on stripped BEAM files. The BEAM\n  compiler will no longer include compilation options given in the source code\n  itself in `M:module_info(compile)` (because those options will be applied\n  anyway if the module is re-compiled).\n\n  Own Id: OTP-9752\n\n- Inlining binary matching could cause an internal compiler error. (Thanks to\n  Rene Kijewski for reporting this bug.)\n\n  Own Id: OTP-9770","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Compiler 4.7.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-7-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Compiler options given in the source code using a `-compile()` attribute used\n  to be included twice in `Mod:module_info(compile)`. They are now only included\n  once at the beginning of the list of options.\n\n  Own Id: OTP-9534\n\n- beam_disasm: Handle stripped BEAM files\n\n  beam_disasm:file/1 would crash if asked to disassemble a stripped BEAM file\n  without an \"Attr\" chunk. (Thanks to Haitao Li)\n\n  Own Id: OTP-9571","ref":"notes.html#fixed-bugs-and-malfunctions-118"},{"type":"extras","title":"Compiler 4.7.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-7-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- If a variable is matched out in binary matching and used as the size for a\n  binary element, it would seem to be unbound if used in a subsequent match\n  operation. (Thanks to Bernard Duggan.)\n\n  Own Id: OTP-9134\n\n- Eliminate incorrect warning in `sys_core_fold`\n\n  Own Id: OTP-9152","ref":"notes.html#fixed-bugs-and-malfunctions-119"},{"type":"extras","title":"Compiler 4.7.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The `-export_type()` directive is no longer included among the attributes.\n\n  Own Id: OTP-8998","ref":"notes.html#fixed-bugs-and-malfunctions-120"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The maximum number of allowed arguments for an Erlang function has been\n  lowered from 256 to 255, so that the number of arguments can now fit in a\n  byte.\n\n  Own Id: OTP-9049\n\n- Dependency generation for Makefiles has been added to the compiler and erlc.\n  See the manual pages for `compile` and `erlc`. (Thanks to Jean-Sebastien\n  Pedron.)\n\n  Own Id: OTP-9065","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Compiler 4.7.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Two compiler bugs (that would cause the compiler to terminate) reported by\n  Christopher Williams have been fixed.\n\n  Own Id: OTP-8949","ref":"notes.html#fixed-bugs-and-malfunctions-121"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler would translate binary comprehensions containing tail segments in\n  a way that would would confuse Dialyzer. For instance:\n\n  `[42 || <<_:8/integer, _/bits>> <= Bits]`\n\n  would produce a Dialyzer warning.\n\n  Own Id: OTP-8864\n\n- Code such as `foo(A) -> < >` would crash the compiler.\n\n  Own Id: OTP-8865\n\n- The compiler could fail with an internal error when variables were exported\n  from a receive block but the return value of the receive block were not used.\n  (Thanks to Jim Engquist for reporting this error.)\n\n  Own Id: OTP-8888","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Compiler 4.7.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-7-1"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Eliminated warnings for auto-imported BIF clashes.\n\n  Own Id: OTP-8840","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"Compiler 4.7 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Several problems in the inliner have been fixed.\n\n  Own Id: OTP-8552","ref":"notes.html#fixed-bugs-and-malfunctions-122"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The module binary from EEP31 (and EEP9) is implemented.\n\n  Own Id: OTP-8217\n\n- Local and imported functions now override the auto-imported BIFs when the\n  names clash. The pre R14 behaviour was that auto-imported BIFs would override\n  local functions. To avoid that old programs change behaviour, the following\n  will generate an error:\n\n  - Doing a call without explicit module name to a local function having a name\n    clashing with the name of an auto-imported BIF that was present (and\n    auto-imported) before OTP R14A\n  - Explicitly importing a function having a name clashing with the name of an\n    autoimported BIF that was present (and autoimported) before OTP R14A\n  - Using any form of the old compiler directive `nowarn_bif_clash`\n\n  If the BIF was added or auto-imported in OTP R14A or later, overriding it with\n  an import or a local function will only result in a warning,\n\n  To resolve clashes, you can either use the explicit module name `erlang` to\n  call the BIF, or you can remove the auto-import of that specific BIF by using\n  the new compiler directive `-compile({no_auto_import,[F/A]}).`, which makes\n  all calls to the local or imported function without explicit module name pass\n  without warnings or errors.\n\n  The change makes it possible to add auto-imported BIFs without breaking or\n  silently changing old code in the future. However some current code\n  ingeniously utilizing the old behaviour or the `nowarn_bif_clash` compiler\n  directive, might need changing to be accepted by the compiler.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8579\n\n- The undocumented, unsupported, and deprecated function `lists:flat_length/1`\n  has been removed.\n\n  Own Id: OTP-8584\n\n- Nested records can now be accessed without parenthesis. See the Reference\n  Manual for examples. (Thanks to YAMASHINA Hio and Tuncer Ayaz.)\n\n  Own Id: OTP-8597\n\n- It is now possible to suppress the warning in code such as\n  \"`list_to_integer(S), ok`\" by assigning the ignored value \"_\" like this: \"`_ =\n  list_to_integer(S), ok`\".\n\n  Own Id: OTP-8602\n\n- `receive` statements that can only read out a newly created reference are now\n  specially optimized so that it will execute in constant time regardless of the\n  number of messages in the receive queue for the process. That optimization\n  will benefit calls to `gen_server:call()`. (See `gen:do_call/4` for an example\n  of a receive statement that will be optimized.)\n\n  Own Id: OTP-8623\n\n- The compiler optimizes record operations better.\n\n  Own Id: OTP-8668","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"Compiler 4.6.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Using complex boolean expressions in ifs could cause the compiler to either\n  crash or terminate with an internal error. (Thanks to Simon Cornish.)\n\n  Own Id: OTP-8338\n\n- Bit string comprehensions can now be used in parameterized modules. (Thanks to\n  Jebu Ittiachen.)\n\n  Own Id: OTP-8447","ref":"notes.html#fixed-bugs-and-malfunctions-123"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The expected return value for an on_load function has been changed. (See the\n  section about code loading in the Reference manual.)\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8339\n\n- In rare circumstances when using garbaging collecting guard BIFs, the\n  validation pass (beam_validator) would signal that the code was unsafe, when\n  it in fact was correct. (Thanks to Kiran Khaladkar.)\n\n  Own Id: OTP-8378\n\n- The `-Werror` option for `erlc` and the compiler option `warnings_as_errors`\n  will cause warnings to be treated as errors. (Thanks to Christopher Faulet.)\n\n  Own Id: OTP-8382\n\n- Macros overloading has been implemented. (Thanks to Christopher Faulet.)\n\n  Own Id: OTP-8388","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"Compiler 4.6.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler's 'E' option now works with modules with types and\n  specifications.\n\n  Own Id: OTP-8238 Aux Id: OTP-8150\n\n- Certain uses of binary matching in a `begin`-`end` in a list comprehension\n  could cause the compiler to crash or generate incorrect code.\n\n  Own Id: OTP-8271","ref":"notes.html#fixed-bugs-and-malfunctions-124"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201\n\n- The compiler could crash if invalid calls to is_record/2 was used in (for\n  example) a list comprehension. (Thanks to Tobias Lindahl.)\n\n  Own Id: OTP-8269\n\n- The -on_load() directive can be used to run a function when a module is\n  loaded. It is documented in the section about code loading in the Reference\n  Manual.\n\n  Own Id: OTP-8295","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"Compiler 4.6.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-6-3"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Corrected liveness optimization to eliminate a compiler crash that could occur\n  when compiling bit syntax construction code. (Thanks to Mikage Sawatari.)\n\n  Calling BIFs such as [`length/1`](`length/1`) in guard context in a try/catch\n  block could cause a compiler crash. (Thanks to Paul Fisher.)\n\n  Using filter expressions containing `andalso` or `orelse` in a list\n  comprehension could cause a compiler crash. (Thanks to Martin Engström.)\n\n  Own Id: OTP-8054\n\n- A guard with nested 'not' operators could cause the compiler to crash. (Thanks\n  to Tuncer Ayaz.)\n\n  Own Id: OTP-8131","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"Compiler 4.6.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler would crash while compiling certain complex function bodies\n  containing `receive after` due to a bug in the jump optimizer (a label that\n  had only had backward references could still be removed). (Thanks to Vincent\n  de Phily.)\n\n  Own Id: OTP-7980","ref":"notes.html#fixed-bugs-and-malfunctions-125"},{"type":"extras","title":"Compiler 4.6.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Miscellaneous minor bugs fixed.\n\n  Own Id: OTP-7937","ref":"notes.html#fixed-bugs-and-malfunctions-126"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- There will be more efficient code if there is a clause that matches the empty\n  binary and no other clauses that matches non-empty binaries.\n\n  Own Id: OTP-7924\n\n- There is new option to allow a module to have a module name other than the\n  filename. Do not use it unless you know what you are doing.\n\n  Own Id: OTP-7927","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"Compiler 4.6.0.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-6-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Using `andalso`/`orelse` or record access in a `try`...`catch` could cause a\n  compiler crash.\n\n  Some large and complex functions could require extremely long compilation\n  times (hours or days).\n\n  Own Id: OTP-7905","ref":"notes.html#fixed-bugs-and-malfunctions-127"},{"type":"extras","title":"Compiler 4.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- For some complex guards which used `andalso`/`orelse`, the compiler would\n  crash. (Thanks to Hunter Morris.)\n\n  Own Id: OTP-7679\n\n- Code that (incorrectly) used the the value of nested applications of\n  [`setelement/3`](`setelement/3`) in bit syntax construction could crash the\n  compiler.\n\n  Own Id: OTP-7690\n\n- Modules containing huge integers (consisting of several hundreds of thousands\n  of digits or more) could be slow to compile. This problem has been corrected.\n\n  Own Id: OTP-7707 Aux Id: seq11129\n\n- If the generator in a list comprehension is given a non-list term, there will\n  now be `function_clause` exception instead of a `case_clause` exception (as it\n  was in all releases before R12B).\n\n  Own Id: OTP-7844","ref":"notes.html#fixed-bugs-and-malfunctions-128"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler could crash if the size for a binary segment in matching was a\n  complex literal such as binary or tuple.\n\n  Own Id: OTP-7650\n\n- The compiler generates more compact and faster code for matching of complex\n  constants (such as constant lists and tuples).\n\n  Own Id: OTP-7655\n\n- The undocumented, unsupported, and deprecated guard BIF `is_constant/1` has\n  been removed.\n\n  \\*** INCOMPATIBILITY with R12B \\***\n\n  Own Id: OTP-7673\n\n- The compiler generates better code for many guard expressions, and especially\n  for guards that use `andalso`/`orelse` or record fields.\n\n  (In technical terms, `andalso`/`orelse` in a guard would case the creation of\n  a stack frame and saving of all x registers that could potentially be alive\n  after the guard and restoring all x registers before leaving the guard. For\n  certain guards, far too many x registers were saved and subsequently restored.\n  In this version of the compiler, no stack frame is created and no x registers\n  are saved and restored.)\n\n  Own Id: OTP-7718\n\n- The default size for the resulting binary created by a binary comprehension\n  was 64Kb in R12B (it would grow if needed). This was often far too much. In\n  this release, the default is changed to 256 bytes. Furthermore, for most\n  binary comprehensions without filters, the exact size of the resulting binary\n  can be calculated beforehand and the compiler now generates code that does\n  that calculation.\n\n  Own Id: OTP-7737\n\n- The short-circuit operators `andalso` and `orelse` no longer guarantees that\n  their second argument is either `true` or `false`. As a consequence,\n  `andalso`/`orelse` are now tail-recursive.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7748\n\n- The compiler will refuse to a compile file where the module name in the file\n  differs from the output file name.\n\n  When compiling using `erlc`, the current working directory will no be included\n  in the code path (unless explicitly added using \"-pa .\").\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7793\n\n- There will no longer be any warnings for list comprehensions without\n  generators, as such list comprehension have turned out to be useful.\n\n  Own Id: OTP-7846\n\n- Warnings for obsolete guard tests are now turned on. (That is, writing\n  [`list(L)`](`t:list/1`) in a guard instead of [`is_list(L)`](`is_list/1`) will\n  generate a warning.)\n\n  The warnings can be turned off using the `nowarn_obsolete_guard` option.\n\n  Own Id: OTP-7850\n\n- The copyright notices have been updated.\n\n  Own Id: OTP-7851\n\n- If a module contains an exported function with the same name as an\n  auto-imported BIF (such as [`length/1`](`length/1`)), any calls to the BIF\n  must have an explicit `erlang:` prefix, or there will be a compilation error\n  (such calls would only generate a warning in previous releases).\n\n  (The reason for the change is to avoid breaking code in a future major\n  release, R14 or R15, in which we plan to make calls without a module prefix\n  always call the local function in the same module even if there is an\n  auto-imported BIF with the same name.)\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7873","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"Compiler 4.5.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Matching on a zero-width segment in the bit syntax would crash the compiler.\n  (Thanks to Will.)\n\n  Own Id: OTP-7591","ref":"notes.html#fixed-bugs-and-malfunctions-129"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- In bit syntax expressions which started with a binary segment, and was\n  followed by at least two segments of variable size, too little space could be\n  allocated for the binary, leading to memory corruption.\n\n  Own Id: OTP-7556\n\n- In user-defined attributes, `Name/Arity` is now allowed and will be translated\n  to `{Name,Arity}`. (An implementation of EEP-24 by Richard O'Keefe.)\n\n  The `module_info/{0,1}` functions automatically inserted into each compiled\n  modules are now documented in the Modules section in the Reference Manual.\n\n  Own Id: OTP-7586","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"Compiler 4.5.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5-4"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Certain complex bit syntax matching operations matching out binaries and\n  having several clauses could give incorrect results (the matched out binaries\n  were too short). (Thanks to Christian von Roques for bug report and\n  correction.)\n\n  Own Id: OTP-7498","ref":"notes.html#improvements-and-new-features-37"},{"type":"extras","title":"Compiler 4.5.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5-3"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- New option `warn_export_all` to warn for a module using `export_all`. (Thanks\n  to Richard Carlsson.)\n\n  Own Id: OTP-7392","ref":"notes.html#improvements-and-new-features-38"},{"type":"extras","title":"Compiler 4.5.2.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstances, the length/1 BIF (and a few other guard BIFs) would\n  seem to return an incorrect value (of any type).\n\n  Own Id: OTP-7345 Aux Id: seq10962","ref":"notes.html#fixed-bugs-and-malfunctions-130"},{"type":"extras","title":"Compiler 4.5.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A bug in the old inliner has been fixed. Some undocumented functionality has\n  been removed.\n\n  Own Id: OTP-7223\n\n- Matching several binary patterns in parallel using the '=' operator is not\n  allowed (an implementation limitation), but the compiler did not reject all\n  such attempts (depending on the patterns, the generated code might or might\n  not work correctly). Now the compiler rejects all binary patterns joined by\n  '='.\n\n  Own Id: OTP-7227\n\n- Complex combinations of record operations and binary matching could cause the\n  compiler to crash. (Thanks to Vladimir Klebansky.)\n\n  Own Id: OTP-7233\n\n- In rare circumstances, mixing binary matching clauses with clauses matching\n  other data types, the compiler could crash.\n\n  Own Id: OTP-7240 Aux Id: seq10916","ref":"notes.html#fixed-bugs-and-malfunctions-131"},{"type":"extras","title":"Compiler 4.5.1.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Corrected a compiler bug that could cause a complex binary matching operation\n  to fail when it shouldn't. (Thanks to Tomas Stejskal.)\n\n  Own Id: OTP-7188\n\n- In unusual circumstances, the environment for a fun could bind wrong values.\n\n  Own Id: OTP-7202 Aux Id: seq10887\n\n- Long sequences of list comprehensions without generators joined by the '++'\n  operator would cause a code expansion explosion, which could cause the\n  compiler to run out of memory. To resolve this problem, in\n  '`[...||...]++Expr`', `Expr` is now evaluated before the list comprehension.\n  This change _is_ backwards compatible (see the following note about evaluation\n  order if you have doubts).\n\n  Note about evaluation order: The Reference manual says that subexpressions are\n  evaluated _in any order_ before the expression itself. Therefore, in an\n  expression such as '`LeftExpr++RightExpr`', you should not depend on\n  `LeftExpr` being evaluated before `RightExpr` or vice versa. The evaluation\n  order is only important if the expressions contains and/or depends on\n  operations with side-effects, such as message passing or ETS operations.\n\n  Own Id: OTP-7206","ref":"notes.html#fixed-bugs-and-malfunctions-132"},{"type":"extras","title":"Compiler 4.5.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- A match expression inside a function call could cause a false \"a term is\n  constructed but never used\" warning.\n\n  Own Id: OTP-7018 Aux Id: seq10824\n\n- The compiler could crash if a binary tail was matched out, and then used in a\n  binary append operation. (Thanks to Oleg Avdeev.)\n\n  Similarly, the compiler could crash if a binary tail was matched out, and then\n  used (incorrectly) in binary construction in an integer field. (Thanks to\n  Fredrik Svahn.) Or was incorrectly used in a float field. Or was used in a\n  binary field with a given length. (Thanks to Chih - Wei Yu.)\n\n  Own Id: OTP-7022\n\n- Matching an empty binary in a record and then using the same record again\n  could cause a compiler crash. (Thanks to Fredrik Thulin.)\n\n  Own Id: OTP-7029\n\n- In rare circumstances, constants containing floating points and integers could\n  be confused. Example:\n\n  `f(a) -> [1]; f(b) -> [1.0].`\n\n  Both `f(a)` and `f(b)` would return `[1]`.\n\n  Own Id: OTP-7073\n\n- Some bit syntax code such as\n\n  `matching d(_,<$lt;$gt;$gt;) -> one; d(0,<$lt;D$gt;$gt;) ->two.`\n\n  could crash the compiler. (Thanks to Simon Cornish.)\n\n  Own Id: OTP-7094\n\n- In unusual circumstances, a call to a fun could fail due to an unsafe\n  optimization. (Thanks to Simon Cornish.)\n\n  Own Id: OTP-7102\n\n- Bit syntax matching with a guard containing two or more uses of andalso/orelse\n  could cause the compiler to crash. (Thanks to Mateusz Berezecki.)\n\n  Own Id: OTP-7113\n\n- This was only a problem if you generated or wrote your own Core Erlang code:\n  The Core Erlang optimizer code could move nested calls such as\n  `erlang:'$lt;'(erlang:length(L), 2)` as case expression into a guard, which\n  would change the semantics. (Thanks to Robert Virding.)\n\n  Own Id: OTP-7117","ref":"notes.html#fixed-bugs-and-malfunctions-133"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler could generate suboptimal code for record updates if the record\n  update code consisted of multiple source code lines.\n\n  Own Id: OTP-7101","ref":"notes.html#improvements-and-new-features-39"},{"type":"extras","title":"Compiler 4.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler used to allow that a binary field without size could be used in\n  other positions than at the end in bit syntax pattern. For instance,\n  `< > = Bin` used to compile, but now the\n  compilation will fail with an an error message.\n\n  Also, it is now longer permitted to give a literal string in a binary pattern\n  a type or a size; for instance, `<<\"abc\"/binary>> = Bin` will no longer\n  compile. (In previous releases, there would always be a `badmatch` exception\n  at run-time.)\n\n  Own Id: OTP-6885","ref":"notes.html#fixed-bugs-and-malfunctions-134"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Bitstrings (bit-level) binaries and binary comprehensions are now part of the\n  language. See the Reference Manual.\n\n  Own Id: OTP-6558\n\n- The '`compressed`' option for the compiler has been documented.\n\n  Own Id: OTP-6801\n\n- If the value of a list comprehension is not used, such as in\n  '`[do_something(X) || X <- List], ok`', a result list will no longer be built.\n  For more details, see the Efficiency Guide.\n\n  If the value of an expression is not used, and the expression has no side\n  effects except for possibly throwing an exception, a warning will be\n  generated. Examples: '`self(),ok`' and '`{error,Reason},ok`'.\n\n  Own Id: OTP-6824\n\n- Three new functions have been added to the `compile` module: `noenv_file/2`,\n  `noenv_forms/2`, and `noenv_output_generated/1`.\n\n  Own Id: OTP-6829\n\n- Many bit syntax operations, both construction and matching, are faster. For\n  further information, see the Efficiency Guide.\n\n  Own Id: OTP-6838\n\n- Literal lists, tuples, and binaries are no longer constructed at run-time as\n  they used to be, but are stored in a per-module constant pool. Literals that\n  are used more than once are stored only once.\n\n  This is not a change to the language, only in the details of its\n  implementation. Therefore, the implications of this change is described in the\n  Efficiency Guide.\n\n  Example 1: In the expression\n  [`element(BitNum-1, {1,2,4,8,16,32,64,128})`](`element/2`), the tuple used to\n  be constructed every time the expression was executed, which could be\n  detrimental to performance in two ways if the expression was executed in a\n  loop: the time to build the tuple itself and the time spent in garbage\n  collections because the heap filled up with garbage faster.\n\n  Example 2: Literal strings, such as `\"abc\"`, used to be stored in the compiled\n  code compactly as a byte string and expanded to a list at run-time. Now all\n  strings will be stored expanded to lists (such as `[$a,$b,$c]`) in the\n  constant pool. That means that the string will be faster to use at run-time,\n  but that it will require more space even when not used. If space is an issue,\n  you might want to use binary literals (that is, `<<\"abc\"<<`) instead of string\n  literals for infrequently used long strings (such as error messages).\n\n  Own Id: OTP-6850\n\n- Recursive calls now usually consume less stack than in R11B. See the\n  Efficiency Guide.\n\n  Own Id: OTP-6862 Aux Id: seq10746\n\n- Two new guard BIFs have been introduced as a recommended replacement for\n  [`size/1`](`size/1`). (The [`size/1`](`size/1`) BIF will be removed no earlier\n  than in R14B.) The BIFs are [`tuple_size/1`](`tuple_size/1`) to calculate the\n  size of a tuple and [`byte_size/1`](`byte_size/1`) to calculate the number of\n  bytes needed for the contents of the binary or bitstring (rounded up to the\n  nearest number of bytes if necessary).\n\n  There is also a new [`bit_size/1`](`bit_size/1`) BIF that returns the exact\n  number of bits that a binary or bitstring contains.\n\n  Own Id: OTP-6902\n\n- The two internal functions `erl_bifs:is_bif/3` and `erl_bifs:is_guard/3` have\n  been removed. They were unsupported, undocumented, and unmaintained.\n\n  Own Id: OTP-6966","ref":"notes.html#improvements-and-new-features-40"},{"type":"extras","title":"Compiler 4.4.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler would crash if you tried to combine to non-list literals with\n  '`++`' (for instance, `an_atom++\"string\"`).\n\n  Own Id: OTP-6630 Aux Id: seq10635","ref":"notes.html#fixed-bugs-and-malfunctions-135"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689","ref":"notes.html#improvements-and-new-features-41"},{"type":"extras","title":"Compiler 4.4.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Incorrect code could be generated for bit syntax matching if the old inliner\n  was used with aggressive settings.\n\n  Own Id: OTP-6461","ref":"notes.html#fixed-bugs-and-malfunctions-136"},{"type":"extras","title":"Compiler 4.4.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The R10B compiler could generate unsafe `bs_save/bs_restore` instructions that\n  could cause memory corruption. (The R11B compiler does not have that problem.)\n  The erlang emulator will now refuse to load R10B-compiled modules that contain\n  such unsafe `bs_save/bs_restore` instructions. In addition, the beam_validator\n  module in the compiler will also reject such instructions (in case it is used\n  to validate R10B code). (Thanks to Matthew Reilly.)\n\n  Own Id: OTP-6386","ref":"notes.html#fixed-bugs-and-malfunctions-137"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Directives for parse transforms that have been run are now removed from the\n  abstract code stored when the debug_info option is given, to prevent the parse\n  transforms to be run again.\n\n  Own Id: OTP-5344\n\n- Minor improvements in code generation for some guards expression involving\n  boolean expressions.\n\n  Own Id: OTP-6347","ref":"notes.html#improvements-and-new-features-42"},{"type":"extras","title":"Compiler 4.4.2.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-4-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler could generate incorrect code for bit syntax matching consisting\n  of several clauses.\n\n  Own Id: OTP-6392 Aux Id: seq10539","ref":"notes.html#fixed-bugs-and-malfunctions-138"},{"type":"extras","title":"Compiler 4.4.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Defining a fun itself containing a fun in an `after` block of a `try` would\n  cause the compiler to crash or generate incorrect code. (Thanks to Tim Rath.)\n\n  Shorter compilation times for modules containing with an extreme number of\n  functions (10000 functions or more).\n\n  (The compiled could generate deprecated instructions for certain bit syntax\n  matching operations.)\n\n  Own Id: OTP-6212 Aux Id: seq10446\n\n- Fixed several bugs that would cause warnings to be shown without file name and\n  line number.\n\n  Own Id: OTP-6260 Aux Id: seq10461","ref":"notes.html#fixed-bugs-and-malfunctions-139"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The `strict_record_tests` option is now default; that is, reading a field from\n  a record using the `Record#record_tag.field` syntax will fail if `Record` is\n  not a record of the correct type.\n\n  If necessary, the record tests can be turned off by giving the\n  `no_strict_record_tests` option. To avoid editing Makefiles, the environment\n  variable `ERL_COMPILER_OPTIONS` can be set to \"`no_strict_record_tests`\".\n\n  The `no_strict_record_tests` option will probably be removed in the R12B\n  release.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-6294","ref":"notes.html#improvements-and-new-features-43"},{"type":"extras","title":"Compiler 4.4.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- The compiler used to crash if a module contained code similar to\n  '`fun(1=0) -> ok end`'. (Thanks to Richard Carlsson.)\n\n  The compiler would spend really long time compiling bit syntax expressions\n  such as '`<<1:(50*1024*1024)>>`' and produce a huge .beam file. Corrected.\n\n  The compiler would compile list comprehensions with many generators really,\n  really slow. (Thanks to Thomas Raes.)\n\n  Module attributes would be stored in reverse order compared to the order in\n  the source code. (Thus, `M:module_info(attributes)` would also return the\n  attributes in reversed order.)\n\n  Defining a fun in an `after` block of a `try` would cause the compiler to\n  crash or generate incorrect code. (Thanks to Martin Bjorklund.)\n\n  The combination of binary pattern and a guard with andalso/orelse could cause\n  the compiler to crash.\n\n  Own Id: OTP-6121 Aux Id: seq10400","ref":"notes.html#fixed-bugs-and-malfunctions-140"},{"type":"extras","title":"Compiler 4.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- When a `.hrl` file is included using `-include_lib`, the include path is\n  temporarily updated to include the directory the `.hrl` file was found in,\n  which will allow that `.hrl` file to itself include files from the same\n  directory using `-include`. (Thanks to Richard Carlsson.)\n\n  Own Id: OTP-5944","ref":"notes.html#fixed-bugs-and-malfunctions-141"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The `andalso` and `orelse` operators are now allowed to be used in guards.\n  That also applies to match specifications.\n\n  Own Id: OTP-5894 Aux Id: OTP-5149\n\n- When given the new option `strict_record_tests`, the compiler will generate\n  code that verifies the record type for `R#record.field` operations in guards.\n  Code that verifies record types in bodies has already been generated since\n  R10B, but in this release there will be a `{badrecord,RecordTag}` instead of a\n  `badmatch` if the record verification test fails. See `m:compile` for more\n  information.\n\n  The Erlang shell always applies strict record tests.\n\n  Own Id: OTP-5915 Aux Id: OTP-5714\n\n- The BIF [`is_record/3`](`is_record/3`) can now be used in guards. Also,\n  [`is_record/3`](`is_record/3`) can now be called without an `erlang:` module\n  prefix for consistency with the other `is_*` functions.\n\n  Own Id: OTP-5916\n\n- The compiler options `ignore_try` and `ignore_cond`, which allowed code that\n  used unquoted `try` or `cond` as atoms or record tags, has been removed. Old\n  code that depended on the options need to be revised to have occurrences of\n  `try` or `cond` as atom or record tags single-quoted. (Note: Although `cond`\n  is a reserved keyword, there is no `cond` statement. It might be introduced in\n  a future release.)\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-6058","ref":"notes.html#improvements-and-new-features-44"},{"type":"extras","title":"Compiler 4.3.12 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-12"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The following code would crash the compiler:\n  `case T of #r{s = \"\"} -> T #r{s = \"x\"} end`. (Thanks to Richard Carlsson.)\n\n  The compiler could crash if binaries were constructed in certain guards\n  involving boolean operators (including semicolon). (Thanks to Torbjorn\n  Tornkvist.)\n\n  Own Id: OTP-5872\n\n- The compiler will now warn that the `megaco:format_versions/1` function is\n  deprecated.\n\n  Own Id: OTP-5976","ref":"notes.html#improvements-and-new-features-45"},{"type":"extras","title":"Compiler 4.3.11 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-11"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The compiler would assume that some patterns with aliases ('=') would not\n  match if they were split into several lines. (Thanks to Peter Nagy/Mats\n  Cronqvist.)\n\n  Minor cleanups to eliminate Dialyzer warnings.\n\n  Own Id: OTP-5791 Aux Id: seq10141","ref":"notes.html#improvements-and-new-features-46"},{"type":"extras","title":"Compiler 4.3.10 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- When given the new option `strict_record_tests`, the compiler will generate\n  code that verifies the record type for `R#record.field` operations (in body\n  context only, not in guards). See the documentation for the `compile` module\n  for more information.\n\n  The beam validator pass of the compiler could crash given in rare\n  circumstances when given certain combinations of catches and record\n  operations. (Thanks to Mats Cronqvist.)\n\n  Attributes containing binaries (such as -a(<<1,2,3>>)) would crash the\n  compiler. (Thanks to Roger Price.)\n\n  Multiple behaviours in the same module will no longer generate a warning,\n  unless one or more callbacks for the behaviours overlap. For instance, using\n  both the `application` and `supervisor` behaviours in the same module will NOT\n  generate any warning, but using `gen_server` and `gen_fsm` will.\n\n  Own Id: OTP-5714 Aux Id: seq10073\n\n- The pre-processor used to complain that the macro definition\n  `-define(S(S), ??S).` was circular, which it isn't. (Thanks to Richard\n  Carlsson.)\n\n  Own Id: OTP-5777","ref":"notes.html#fixed-bugs-and-malfunctions-142"},{"type":"extras","title":"Compiler 4.3.9 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Updating at least two fields of a record with a literal string could cause the\n  compiler to generate dangerous code that could cause a crash at run-time (e.g.\n  `R#r{a=\"abc\",b=1}`). (Thanks to Mikael Karlsson.)\n\n  Unnecessary tests (such as a 'case' with two case branches that were\n  identical) could cause the compiler to crash. (Thanks to Fredrik Thulin.)\n\n  The validation pass of the compiler could generate an error for correct code\n  when floating point operations were used in try/catch statements.\n\n  In bit syntax construction, any field following a binary field would always be\n  marked as \"aligned\" (which may or may not be correct). That would cause the\n  hipe native compiler to generate incorrect code if the field was in fact\n  unaligned. (Thanks to Per Gustafsson.)\n\n  Some complex guard expressions (such as `A#a.b==\"\"; A#a.b==undefined`) would\n  crash the compiler. (Thanks to Sean Hinde.)\n\n  Compilation speed has been increased for modules with many functions and/or\n  atoms (such as modules generated by the Asn1 application or other code\n  generators).\n\n  Own Id: OTP-5632 Aux Id: seq10057","ref":"notes.html#fixed-bugs-and-malfunctions-143"},{"type":"extras","title":"Compiler 4.3.8 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In some circumstances, having two try/catch constructs following each in a\n  function body, would cause an internal error to be generated (when in fact the\n  generated code was correct). (Thanks to Fredrik Thulin.)\n\n  Incorrect calls such as `M:42()` would crash the compiler. The compiler now\n  generates a warning. (Thanks to Ulf Wiger.)\n\n  Own Id: OTP-5553","ref":"notes.html#fixed-bugs-and-malfunctions-144"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- The new `fun M:F/A` construct creates a fun that refers to the latest version\n  of `M:F/A`. This syntax is meant to replace tuple funs `{M,F}` which have many\n  problems.\n\n  The new type test [`is_function(Fun, A)`](`is_function/2`) (which may be used\n  in guards) test whether `Fun` is a fun that can be applied with `A` arguments.\n  (Currently, `Fun` can also be a tuple fun.)\n\n  Own Id: OTP-5584","ref":"notes.html#improvements-and-new-features-47"},{"type":"extras","title":"Compiler 4.3.7 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-7"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Further improvements of encrypted debug info: New option `encrypt_debug_info`\n  for compiler.\n\n  Own Id: OTP-5541 Aux Id: seq9837","ref":"notes.html#improvements-and-new-features-48"},{"type":"extras","title":"Compiler 4.3.6 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Fixed a bug in the validator of the generated code (beam_validator) which\n  caused an internal compiler error even though the generated code was indeed\n  correct.\n\n  Own Id: OTP-5481 Aux Id: seq9798","ref":"notes.html#fixed-bugs-and-malfunctions-145"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- It is now possible to encrypt the debug information in Beam files, to help\n  keep the source code secret. See the documentation for `compile` on how to\n  provide the key for encrypting, and the documentation for `beam_lib` on how to\n  provide the key for decryption so that tools such as the Debugger, Xref, or\n  Cover can be used.\n\n  The `beam_lib:chunks/2` functions now accepts an additional chunk type\n  `compile_info` to retrieve the compilation information directly as a term.\n  (Thanks to Tobias Lindahl.)\n\n  Own Id: OTP-5460 Aux Id: seq9787","ref":"notes.html#improvements-and-new-features-49"},{"type":"extras","title":"Compiler 4.3.5 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Complex functions could cause the internal validator in the compiler to\n  generate an internal error even though the generated code was correct.\n\n  Own Id: OTP-5436 Aux Id: seq9781","ref":"notes.html#fixed-bugs-and-malfunctions-146"},{"type":"extras","title":"Compiler 4.3.4 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare circumstances, incorrect code for record or tuple access could be\n  generated. The incorrect code would either trigger an internal error in the\n  compiler or cause an exception at run time. (Thanks to Martin Bjorklund.)\n\n  Corrected a bug in in bit syntax matching where clauses could match in the\n  wrong order. (Thanks to Ulf Wiger.)\n\n  Own Id: OTP-5404 Aux Id: seq9767","ref":"notes.html#fixed-bugs-and-malfunctions-147"},{"type":"extras","title":"Compiler 4.3.3 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-3"},{"type":"extras","title":"Improvements and New Features - Compiler Release Notes","doc":"- Given bit syntax construction in certain complex contexts involving a catch,\n  the compiler would either crash or terminate due to failure in an internal\n  consistency check. (Thanks to Fredrik Thulin.)\n\n  Matches such as `<<103133:64/float>> = <<103133:64/float>>` used to fail. Now\n  they succeed.\n\n  Shadowing of variables in bit syntax matches in fun heads such as in\n  `L = 8, F = fun(< >) -> B end` was handled incorrectly by the\n  compiler. The fun used to be compiled as if it was written\n  '`>fun(<<8:8,B:8>>)`, while it should be compiled in the same way as\n  `fun(< >)`.\n\n  A bug in the validation pass has been corrected. It sometimes occurred when\n  the compiler optimized by reusing code for causing an exception when the\n  reused code was called from within catch or try-catch statements. Then the\n  validator refused to approve the code and complained about\n  `fun(< >) -> B end` was handled incorrectly by the in the same way as\n  `fun(< >)`.\n\n  A bug in the unknown_catch_try_state.\n\n  Corrected a bug in the optimizer that would cause the compiler to crash.\n  (Thanks to Peter-Henry Mander.)\n\n  There are now warnings generated if a bit syntax construction will fail at\n  run-time because of a type mismatch (e.g. `< >`).\n\n  Own Id: OTP-5342 Aux Id: OTP-5118, OTP-5270, OTP-5323\n\n- Binary pattern matching such as `t(< > = < )` used to silently fail at\n  runtime (i.e. never match). The compiler now generates an error for any such\n  patterns.\n\n  Own Id: OTP-5371","ref":"notes.html#improvements-and-new-features-50"},{"type":"extras","title":"Compiler 4.3.2 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- In rare cases, the code compiler code generate code for a tuple match that\n  could crash the emulator if passed a term that was not a tuple.\n\n  If a bit syntax construction failed within a catch, previously assigned\n  variables could get the wrong value.\n\n  The compiler now runs a validation pass on the generated code and aborts\n  before writing a Beam file if any suspect code is found. In particular, the\n  validation pass checks for incorrect code that may cause emulator crashes or\n  other strange symptoms in the emulator.\n\n  Some corrections to the unsupported feature parameterized modules by Richard\n  Carlsson (HiPE).\n\n  Own Id: OTP-5247 Aux Id: OTP-5235","ref":"notes.html#fixed-bugs-and-malfunctions-148"},{"type":"extras","title":"Compiler 4.3.1 - Compiler Release Notes","doc":"","ref":"notes.html#compiler-4-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Compiler Release Notes","doc":"- Corrected the release note regarding `try/catch` below. `try/catch` DOES work\n  in the initial R10B release.\n\n  A few minor issues code generation issues were corrected. Although the\n  generated code was correct, it was slightly slower and larger than it needed\n  to be.\n\n  A debug printout (that could be seen in rare circumstances) has been removed.\n\n  `not record_test(not_a_tuple, RecordTag)` and similar expressions in a guard\n  would fail.\n\n  New options `basic_validation` and `strong_validation` to do a quick check of\n  the code of a module.\n\n  The `inline` option was not recognized if it appeared in a `-compile()`\n  directive inside the module.\n\n  Corrected some bugs in the undocumented feature \"parameterized modules\".\n\n  Own Id: OTP-5198\n\n- When the undocumented feature \"parameterized modules\" was used, the `?MODULE`\n  macro did not work correctly.\n\n  Own Id: OTP-5224","ref":"notes.html#fixed-bugs-and-malfunctions-149"},{"type":"extras","title":"Invariants on the Structure and Format of BEAM SSA","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n\nInvariants on the Structure and Format of BEAM SSA\n==================================================\n\nException Handling\n------------------\n\nThe translation of a `try`-`catch` expression into BEAM SSA has the\nfollowing structure:\n\n    @tag = new_try_tag `try`\n\tbr @tag, ^protected_block0, ^landing_pad_block\n\n\tprotected_block0:\n\t  @success0 = ... % Something that could raise an exception\n\t  br @success0, ^protected_block1, ^landing_pad_block\n\n\t...\n\n\tprotected_blockN:\n\t  % The end of the protected code\n\t  @ignored0 = kill_try_tag @tag\n      br ^after_try_catch\n\n\tlanding_pad_block:\n\t  @aggregate = landingpad try, @tag\n\t  @class  = extract @aggregate, `0` % The error class\n\t  @reason = extract @aggregate, `1` % The reason\n\t  @stk    = extract @aggregate, `2` % The stack trace\n\t  @ignored1 = kill_try_tag @tag\n\t  %% Pattern matching on @class, @reason, and @stk is done here\n\t  %% to send control to the appropriate catch clause\n      br ^after_try_catch\n\n    after_try_catch:\n      % Normal execution continues\n\nThe following invariants must hold for the SSA:\n\n * All code that can cause an exception in one of the protected blocks\n   must have explicit control flow edges to the landing pad block. If\n   there are no edges to the landing pad block except from the block\n   containing the `new_try_tag`, the compiler will remove the\n   redundant exception handler.\n * The extraction of the class, reason and stack trace from the result\n   of the `landingpad` instruction must be done in that\n   order. Omitting the extraction of elements which are unused is\n   allowed.\n * Both the landing pad block and the final protected block must end\n   with a `kill_try_tag` instruction. Trying to share the\n   `kill_try_tag` epilogue between the last protected block and the\n   landing pad is unlikely to work.\n\nThe translation of an old-style `catch` expression into BEAM SSA has\nthe following structure:\n\n    @tag = new_try_tag `try`\n\tbr @tag, ^protected_block0, ^landing_pad_block\n\n\tprotected_block0:\n\t  @success0 = ... % Something that could raise an exception\n\t  br @success0, ^protected_block1, ^landing_pad_block\n\n\t...\n\n\tprotected_blockN:\n\t  % The end of the protected code\n\t  @successful_result = .... % The result of a successful computation\n\t  br ^common_end_of_catch\n\n\tlanding_pad_block:\n\t   @aggregate = landingpad catch, @tag\n\t   @catched_val = extract @ssa_agg, `0`\n\t   br ^common_end_of_catch\n\n\tcommon_end_of_catch:\n\t  @tmp = phi { @catched_val, ^landing_pad_block },\n\t             { @successful_result, ^protected_blockN }\n\t  @result_of_catch_expr = catch_end @tag, @tmp\n\nJust as for a `try`-`catch` expression all code that can cause an\nexception in one of the protected blocks must have explicit control\nflow edges to the landing pad block.\n\nException Re-issuing\n--------------------\n\nA typical user-written `try`-`catch` expression will catch a subset of\nall possible exception classes and reasons and leave unhandled\nexceptions to a handler further up the call stack. Re-issuing an\nexception is done with the `resume` instruction. The `resume` must\ncome after the `kill_try_tag` instruction in the program flow. For\nexample, if the [example in the Exception Handling Section](#exception-handling)\nwas to only handle user `throws`, the relevant blocks would look like this:\n\n\tlanding_pad_block:\n\t  @aggregate = landingpad `try`, @tag\n\t  @class  = extract @aggregate, `0` % The error class\n\t  @reason = extract @aggregate, `1` % The reason\n\t  @stk    = extract @aggregate, `2` % The stack trace\n\t  @ignored1 = kill_try_tag @tag\n\t  @is_throw = bif:'=:=' @class, `throw`\n      br @is_throw ^first_block_of_throw_handler, ^reissue\n\n\tfirst_block_of_throw_handler:\n\t  %% Handle the user-defined throw\n\n\treissue:\n\t  @tmp = resume @stk, @reason\n\t  ret @tmp\n\nFunction Calls\n--------------\n\nAll function calls not in a tail call position must be followed by a\nsucceeded:body-instruction unless one of the following exceptions\napply:\n\n* The function call can statically be proven to always fail.\n\n* The function call is to the `erlang`-module and can statically be\n  proven to always succeed or fail.\n\nVariable Naming\n---------------\n\nA variable name in BEAM SSA is either an atom or a non-negative\ninteger:\n\n    atom() | non_neg_integer()\n\nIn order to generate fresh unused variable names, all compiler\ntransforms maintain a counter, the `cnt`-field in the `b_function` and\n`opt_st` records, which is incremented each time a new variable or\nlabel is created. In the following description the value of the\n`cnt`-field is called `Cnt`. The `Cnt` value is guaranteed to never\nclash with a previously defined variable name. Therefore, value of\n`Cnt` can directly be used as a variable name in the SSA passes.\n\nNote that the rules were more complicated before Erlang/OTP 27, because\nthe `Cnt` value could clash with other variables.","ref":"beam_ssa.html"},{"type":"extras","title":"BEAM SSA Checks","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n\nBEAM SSA Checks\n===============\n\nWhile developing optimizations operating on the BEAM SSA it is often\nhard to check that various transforms have the intended effect. For\nexample, unless a transform produces crashing code, it is hard to\ndetect that the transform is broken. Likewise missing an optimization\nopportunity is also hard to detect.\n\nTo simplify the creation of tests on BEAM SSA the compiler has an\ninternal mode in which it parses and checks assertions on the\nstructure and content of the produced BEAM SSA code. This is a short\nintroduction to the syntax and semantics of the SSA checker\nfunctionality.\n\nSyntax\n------\n\nSSA checks are embedded in the source code as comments starting with\nwith one of `%ssa%`, `%%ssa%` or `%%%ssa%`. This is a short\nintroduction the syntax, for the full syntax please refer to the\n`ssa_check_when_clause` production in `erl_parse.yrl`.\n\nSSA checks can be placed inside any Erlang function, for example:\n\n    t0() ->\n    %ssa% () when post_ssa_opt ->\n    %ssa%   ret(#{}).\n      #{}.\n\nwill check that `t0/0` returns the literal `#{}`. If we want to check\nthat a function returns its first formal parameter, we can write:\n\n    t1(A, _B) ->\n    %ssa% (X, _) when post_ssa_opt ->\n    %ssa%   ret(X).\n      A.\n\nNote how we match the first formal parameter using `X`. The reason for\nhaving our own formal parameters for the SSA check, is that we don't\nwant to introduce new identifiers at the Erlang level to support\nSSA-level checks. Consider if `t1/2` had been defined as `t1([A|As],\nB)` we would have had to introduce a new identifier for the aggregate\nvalue `[A|As]`.\n\nThe full syntax for a SSA check clause is:\n\n     ? ( ) when   ->   '.'\n\nwhere ` ` can be one of `pass` (the check must\nsucceed), `fail` and `xfail` (the check must fail). Omitting\n` ` is parsed as an implicit `pass`.\n\n` ` is a comma-separated list of variables.\n\n` ` specifies when in the compiler pipeline to run\nthe checks. For now the only supported value for ` `\nis `post_ssa_opt` which runs the checks after the `ssa_opt` pass.\n\n` ` is a comma-separated list of matches against the BEAM SSA\ncode. For non-flow-control operations the syntax is:\n\n      =   (   )  ?\n\nwhere ` ` is the `#b_set.op` field from the internal SSA\nrepresentation. BIFs are written as `bif: `.\n\n` ` is a comma-separated list of variables or literals.\n\nFor flow control operations and labels, the syntax is as follows:\n\n    br( ,  ,  )\n\n    switch( ,  , [{ , },...])\n\n\tret( )\n\n\tlabel  \n\nwhere ` ` is a literal or a variable.\n\nA check can also include an assertion on operation annotations. The\nassertion is written as a map-like pattern following the argument\nlist, for example:\n\n    t0() ->\n    %ssa% () when post_ssa_opt ->\n    %ssa% _ = call(fun return_int/0) { result_type => {t_integer,{17,17}},\n    %ssa%                              location => {_,32} },\n    %ssa% _ = call(fun return_tuple/0) {\n    %ssa%    result_type => {t_tuple,2,true,#{1 => {t_integer,{1,1}},\n    %ssa%                                     2 => {t_integer,{2,2}}}}\n    %ssa% }.\n        X = return_int(),\n        Y = return_tuple(),\n        {X, Y}.\n\nSemantics\n---------\n\nWhen an SSA assertion is matched against the BEAM SSA for a function,\npatterns are applied sequentially. If the current pattern doesn't\nmatch, the checker tries with the next instruction. If the checker\nreaches the end of the SSA representation without having matched all\npatterns, the check is considered failed otherwise the assertion is\nconsidered successful. When a pattern is matched against an SSA\noperation, the values of variables already bound are considered and if\nthe patterns matches, free variables introduced in the successfully\nmatched pattern are bound to the values they have in the matched\noperation.\n\nCompiler integration\n--------------------\n\nThe BEAM SSA checker is enabled by the compiler option\n`{check_ssa,post_ssa_opt}`. When enabled, a failed SSA assertion will\nbe reported using the same mechanisms as an ordinary compilation\nerror.\n\nLimitations\n-----------\n\n* Unbound variables are not allowed in the key-part of map literals nor\nin annotation assertions.","ref":"ssa_checks.html"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}