/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.Connection;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.StatisticsManager;

public class FBStatisticsManager
extends FBServiceManager
implements StatisticsManager {
    private static final int possibleStatistics = 57;
    private static final int DB_TRANSACTION_INFO_BUFFER_LENGTH = 100;

    public FBStatisticsManager() {
    }

    public FBStatisticsManager(String gdsType) {
        super(gdsType);
    }

    public FBStatisticsManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void getHeaderPage() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createStatsSRB(service, 4);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void getDatabaseStatistics() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createDefaultStatsSRB(service);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void getDatabaseStatistics(int options) throws SQLException {
        if (options != 0 && (options | 0x39) != 57) {
            throw new IllegalArgumentException("options must be 0 or a combination of DATA_TABLE_STATISTICS, SYSTEM_TABLE_STATISTICS, INDEX_STATISTICS, or 0");
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createStatsSRB(service, options);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void getTableStatistics(String[] tableNames) throws SQLException {
        StringBuilder commandLine = new StringBuilder();
        for (int i = 0; i < tableNames.length; ++i) {
            commandLine.append(tableNames[i]);
            if (i >= tableNames.length - 1) continue;
            commandLine.append(' ');
        }
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.createStatsSRB(service, 64);
            srb.addArgument(105, commandLine.toString());
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public StatisticsManager.DatabaseTransactionInfo getDatabaseTransactionInfo() throws SQLException {
        try (FbDatabase database = this.attachDatabase();){
            StatisticsManager.DatabaseTransactionInfo databaseTransactionInfo = FBStatisticsManager.getDatabaseTransactionInfo(database);
            return databaseTransactionInfo;
        }
    }

    public static StatisticsManager.DatabaseTransactionInfo getDatabaseTransactionInfo(Connection connection) throws SQLException {
        FirebirdConnection firebirdConnection = connection.unwrap(FirebirdConnection.class);
        return FBStatisticsManager.getDatabaseTransactionInfo(firebirdConnection.getFbDatabase());
    }

    private static StatisticsManager.DatabaseTransactionInfo getDatabaseTransactionInfo(FbDatabase database) throws SQLException {
        byte[] infoItems = DatabaseTransactionInfoProcessor.getInfoItems(database.getServerVersion());
        return database.getDatabaseInfo(infoItems, 100, new DatabaseTransactionInfoProcessor());
    }

    private ServiceRequestBuffer createDefaultStatsSRB(FbService service) {
        return this.createStatsSRB(service, 0);
    }

    private ServiceRequestBuffer createStatsSRB(FbService service, int options) {
        return this.createRequestBuffer(service, 11, options);
    }

    private static final class DatabaseTransactionInfoProcessor
    implements InfoProcessor<StatisticsManager.DatabaseTransactionInfo> {
        private static final Logger log = LoggerFactory.getLogger(DatabaseTransactionInfoProcessor.class);

        private DatabaseTransactionInfoProcessor() {
        }

        @Override
        public StatisticsManager.DatabaseTransactionInfo process(byte[] info) throws SQLException {
            if (info.length == 0) {
                throw new SQLException("Response buffer for service information request is empty");
            }
            StatisticsManager.DatabaseTransactionInfo databaseTransactionInfo = new StatisticsManager.DatabaseTransactionInfo();
            int idx = 0;
            block7: while (info[idx] != 1) {
                byte infoItem = info[idx];
                ++idx;
                if (infoItem == 2) {
                    log.warn("Transaction information response was truncated at index " + idx + ". Info block size: " + info.length + ". This could indicate a bug in the implementation.");
                    break;
                }
                int valueLength = VaxEncoding.iscVaxInteger2(info, idx);
                long dataItem = VaxEncoding.iscVaxLong(info, idx += 2, valueLength);
                idx += valueLength;
                switch (infoItem) {
                    case 104: {
                        databaseTransactionInfo.setOldestTransaction(dataItem);
                        continue block7;
                    }
                    case 105: {
                        databaseTransactionInfo.setOldestActiveTransaction(dataItem);
                        continue block7;
                    }
                    case 106: {
                        databaseTransactionInfo.setOldestSnapshotTransaction(dataItem);
                        continue block7;
                    }
                    case 107: {
                        databaseTransactionInfo.setNextTransaction(dataItem);
                        continue block7;
                    }
                    case 110: {
                        databaseTransactionInfo.setActiveTransactionCount(dataItem);
                        continue block7;
                    }
                }
                log.warn("Unknown or unexpected info item: " + infoItem);
            }
            return databaseTransactionInfo;
        }

        public static byte[] getInfoItems(GDSServerVersion serverVersion) {
            if (serverVersion.isEqualOrAbove(2, 0)) {
                return new byte[]{104, 105, 106, 107, 110};
            }
            return new byte[]{104, 105, 106, 107};
        }
    }
}

