/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.clickhouse;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import org.flywaydb.community.database.clickhouse.ClickHouseDatabase;
import org.flywaydb.community.database.clickhouse.ClickHouseSchema;
import org.flywaydb.core.internal.database.base.Database;

public class ClickHouseConnection
extends org.flywaydb.core.internal.database.base.Connection<ClickHouseDatabase> {
    private static final String DEFAULT_CATALOG_TERM = "database";

    ClickHouseConnection(ClickHouseDatabase database, Connection connection) {
        super((Database)database, connection);
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        Connection jdbcConnection = this.getJdbcTemplate().getConnection();
        String currentSchema = this.useCatalog(jdbcConnection) ? jdbcConnection.getCatalog() : jdbcConnection.getSchema();
        return Optional.ofNullable(currentSchema).map(arg_0 -> ((ClickHouseDatabase)((ClickHouseDatabase)this.database)).unQuote(arg_0)).orElse(null);
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        Connection jdbcConnection = this.getJdbcTemplate().getConnection();
        if (this.useCatalog(jdbcConnection)) {
            jdbcConnection.setCatalog(schema);
        } else {
            jdbcConnection.setSchema(schema);
        }
    }

    protected boolean useCatalog(Connection jdbcConnection) throws SQLException {
        return DEFAULT_CATALOG_TERM.equals(jdbcConnection.getMetaData().getCatalogTerm());
    }

    public ClickHouseSchema getSchema(String name) {
        return new ClickHouseSchema(this.jdbcTemplate, (ClickHouseDatabase)this.database, name);
    }
}

