/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.postgresql.yugabytedb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.community.database.postgresql.yugabytedb.YugabyteDBConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.postgresql.PostgreSQLDatabase;

public class YugabyteDBDatabase
extends PostgreSQLDatabase {
    private static final Log LOG = LogFactory.getLog(YugabyteDBDatabase.class);
    public static final String LOCK_TABLE_NAME = "YB_FLYWAY_LOCK_TABLE";
    private static final String LOCK_TABLE_SCHEMA_SQL = "SELECT table_name, column_name FROM information_schema.columns WHERE table_name = 'YB_FLYWAY_LOCK_TABLE'";
    private static final String DROP_LOCK_TABLE_IF_EXISTS_DDL = "DROP TABLE IF EXISTS YB_FLYWAY_LOCK_TABLE";
    private static final String CREATE_LOCK_TABLE_DDL = "CREATE TABLE IF NOT EXISTS YB_FLYWAY_LOCK_TABLE (table_name varchar PRIMARY KEY, lock_id bigint, ts timestamp)";

    public YugabyteDBDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
        this.createLockTable();
    }

    protected YugabyteDBConnection doGetConnection(Connection connection) {
        return new YugabyteDBConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("11.2");
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE IF NOT EXISTS " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INTEGER,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT now(),\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX IF NOT EXISTS \"" + table.getName() + "_s_idx\" ON " + String.valueOf(table) + " (\"success\");";
    }

    public boolean useSingleConnection() {
        return true;
    }

    private void createLockTable() {
        try {
            List columns = this.jdbcTemplate.query(LOCK_TABLE_SCHEMA_SQL, rs -> rs.getString("column_name"), new Object[0]);
            if (columns.isEmpty()) {
                LOG.debug("Lock table not found, creating it...");
                this.jdbcTemplate.execute(CREATE_LOCK_TABLE_DDL, new Object[0]);
            } else {
                for (String column : columns) {
                    if (!"lock_id".equals(column)) continue;
                    LOG.debug("Lock table with expected schema already exists");
                    return;
                }
                LOG.info("Lock table exists but has old schema. Dropping and recreating it with new schema...");
                this.jdbcTemplate.execute(DROP_LOCK_TABLE_IF_EXISTS_DDL, new Object[0]);
                this.jdbcTemplate.execute(CREATE_LOCK_TABLE_DDL, new Object[0]);
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to initialize the lock table", e);
        }
    }
}

