/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl;

import com.databricks.client.jdbc42.internal.nimbusjose.Header;
import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWEHeader;
import java.util.Collections;
import java.util.Set;

public class CriticalHeaderParamsDeferral {
    private Set<String> deferredParams = Collections.emptySet();

    public Set<String> getProcessedCriticalHeaderParams() {
        return Collections.singleton("b64");
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return Collections.unmodifiableSet(this.deferredParams);
    }

    public void setDeferredCriticalHeaderParams(Set<String> defCritHeaders) {
        this.deferredParams = defCritHeaders == null ? Collections.emptySet() : defCritHeaders;
    }

    public boolean headerPasses(Header header) {
        if (header.getCriticalParams() == null) {
            return true;
        }
        for (String critParam : header.getCriticalParams()) {
            if (this.getProcessedCriticalHeaderParams().contains(critParam) || this.getDeferredCriticalHeaderParams().contains(critParam)) continue;
            return false;
        }
        return true;
    }

    public void ensureHeaderPasses(JWEHeader header) throws JOSEException {
        if (!this.headerPasses(header)) {
            throw new JOSEException("Unsupported critical header parameter(s)");
        }
    }
}

