/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.metadatautil;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.Nullable;
import com.databricks.client.dsi.dataengine.utilities.Searchable;
import com.databricks.client.dsi.dataengine.utilities.TypeUtilities;
import com.databricks.client.dsi.dataengine.utilities.Updatable;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.databricks.client.sqlengine.dsiext.dataengine.IColumnInfo;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.exceptions.ErrorException;

class AEMetadataCoercer {
    private AECoercionProperties m_properties;

    public AEMetadataCoercer(AECoercionProperties aECoercionProperties) {
        this.m_properties = aECoercionProperties;
    }

    public long calcColumnLength(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        if (sqlTypes.isBinary()) {
            SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo.getType());
            SqlTypes sqlTypes3 = SqlTypes.getValueOf(iColumnInfo2.getType());
            if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.SET_OPERATION && sqlTypes2.isBinary() && sqlTypes3.isBinary()) {
                return Math.max(iColumnInfo.getColumnLength(), iColumnInfo2.getColumnLength());
            }
            if ((coercionOperation == AEMetadataCoercionHandler.CoercionOperation.COMPARISON || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.IN) && (sqlTypes2.isBinary() || sqlTypes3.isBinary())) {
                if (sqlTypes2.isBinary() && sqlTypes3.isBinary()) {
                    return Math.max(iColumnInfo.getColumnLength(), iColumnInfo2.getColumnLength());
                }
                if (sqlTypes2.isChar()) {
                    return Math.max(iColumnInfo.getColumnLength() / 2L, iColumnInfo2.getColumnLength());
                }
                if (sqlTypes3.isChar()) {
                    return Math.max(iColumnInfo.getColumnLength(), iColumnInfo2.getColumnLength() / 2L);
                }
                throw SQLEngineExceptionFactory.invalidOperationException("Invalid coercion between: type1: " + sqlTypes2.name() + ", type2: " + sqlTypes3.name());
            }
            throw SQLEngineExceptionFactory.invalidCoercionException(coercionOperation.name(), TypeUtilities.sqlTypeToString(iColumnInfo.getType()), TypeUtilities.sqlTypeToString(iColumnInfo2.getType()));
        }
        if (sqlTypes.isChar() || sqlTypes.isWChar()) {
            if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.COMPARISON || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.LIKE || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.SET_OPERATION || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.IN) {
                return Math.max(iColumnInfo.getDisplaySize(), iColumnInfo2.getDisplaySize());
            }
            if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.PLUS || coercionOperation == AEMetadataCoercionHandler.CoercionOperation.CONCAT) {
                long l = iColumnInfo.getDisplaySize() + iColumnInfo2.getDisplaySize();
                return l > 0xFFFFFFFFL ? 0xFFFFFFFFL : l;
            }
            throw SQLEngineExceptionFactory.invalidCoercionException(coercionOperation.name(), TypeUtilities.sqlTypeToString(iColumnInfo.getType()), TypeUtilities.sqlTypeToString(iColumnInfo2.getType()));
        }
        return iColumn.getColumnLength();
    }

    public AEMetadataCoercionHandler.PrecisionScale calcPrecisionScale(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        if (this.isTimeOrTimestamp(sqlTypes)) {
            return this.coerceDatetimePrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
        }
        if (sqlTypes.isExactNum()) {
            return this.coerceExactNumPrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
        }
        return new AEMetadataCoercionHandler.PrecisionScale(iColumn.getTypeMetadata().getPrecision(), iColumn.getTypeMetadata().getScale());
    }

    public boolean coerceIsCurrency(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return !(!iColumnInfo.isCurrency() && !iColumnInfo2.isCurrency() || coercionOperation != AEMetadataCoercionHandler.CoercionOperation.DIVISION && coercionOperation != AEMetadataCoercionHandler.CoercionOperation.PLUS && coercionOperation != AEMetadataCoercionHandler.CoercionOperation.MINUS && coercionOperation != AEMetadataCoercionHandler.CoercionOperation.MULTIPLICATION);
    }

    public boolean coerceIsSigned(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo.getType());
        SqlTypes sqlTypes3 = SqlTypes.getValueOf(iColumnInfo2.getType());
        if (!sqlTypes.isNumber() || sqlTypes == SqlTypes.SQL_BIT) {
            return false;
        }
        if (coercionOperation == AEMetadataCoercionHandler.CoercionOperation.MINUS) {
            return true;
        }
        if (!sqlTypes2.isNumber() || !sqlTypes3.isNumber()) {
            return true;
        }
        return iColumnInfo.isSigned() || iColumnInfo2.isSigned();
    }

    public Nullable coerceNullable(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        Nullable nullable = iColumnInfo.getNullable();
        Nullable nullable2 = iColumnInfo2.getNullable();
        if (nullable == Nullable.NULLABLE || nullable2 == Nullable.NULLABLE) {
            return Nullable.NULLABLE;
        }
        if (nullable == Nullable.UNKNOWN || nullable2 == Nullable.UNKNOWN) {
            return Nullable.UNKNOWN;
        }
        return Nullable.NO_NULLS;
    }

    public boolean coerceIsCaseSensitive(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return iColumnInfo.isCaseSensitive() || iColumnInfo2.isCaseSensitive();
    }

    public Searchable coerceSearchability(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        Searchable searchable = iColumnInfo.getSearchable();
        Searchable searchable2 = iColumnInfo2.getSearchable();
        if (searchable == Searchable.PREDICATE_NONE || searchable2 == Searchable.PREDICATE_NONE) {
            return Searchable.PREDICATE_NONE;
        }
        if (searchable == Searchable.PREDICATE_CHAR | searchable2 == Searchable.PREDICATE_CHAR) {
            return Searchable.PREDICATE_CHAR;
        }
        if (searchable == Searchable.PREDICATE_BASIC || searchable2 == Searchable.PREDICATE_BASIC) {
            return Searchable.PREDICATE_BASIC;
        }
        return Searchable.SEARCHABLE;
    }

    public Updatable coerceUpdatability(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return Updatable.READ_ONLY;
    }

    public boolean coerceIsAutoUnique(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) {
        return false;
    }

    private AEMetadataCoercionHandler.PrecisionScale coerceExactNumPrecisionScale(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        int n;
        int n2;
        short s;
        short s2;
        short s3;
        short s4;
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumnInfo.getType());
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo2.getType());
        if (sqlTypes.isNumber()) {
            s4 = iColumnInfo.getScale();
            s3 = iColumnInfo.getPrecision();
        } else {
            s4 = this.m_properties.getDefaultExactNumScale();
            s3 = this.m_properties.getMaxExactNumPrecision();
        }
        if (sqlTypes2.isNumber()) {
            s2 = iColumnInfo2.getScale();
            s = iColumnInfo2.getPrecision();
        } else {
            s2 = this.m_properties.getDefaultExactNumScale();
            s = this.m_properties.getMaxExactNumPrecision();
        }
        boolean bl = false;
        int n3 = Math.max(s4, s2);
        int n4 = Math.max(s3 - s4, s - s2);
        switch (coercionOperation) {
            case COMPARISON: 
            case IN: {
                bl = true;
            }
            case SET_OPERATION: {
                n2 = n4 + n3;
                n = n3;
                break;
            }
            case DIVISION: {
                n2 = s3 - s4 + s2 + Math.max(6, s4 + s + 1);
                n = Math.max(6, s4 + s + 1);
                break;
            }
            case MULTIPLICATION: {
                n2 = s3 + s + 1;
                n = s4 + s2;
                break;
            }
            case PLUS: 
            case MINUS: {
                n2 = n3 + n4 + 1;
                n = n3;
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.invalidOperationException("Coercion result does not match coercion operation: Operator: " + coercionOperation.name() + " , type1: " + sqlTypes.name() + ", type2: " + sqlTypes2.name());
            }
        }
        if (n2 > this.m_properties.getMaxExactNumPrecision()) {
            n = Math.max(Math.min(s2, s4), n - (n2 - this.m_properties.getMaxExactNumPrecision()));
            if (!bl) {
                n2 = this.m_properties.getMaxExactNumPrecision();
            }
        }
        assert (n <= Short.MAX_VALUE && n2 <= Short.MAX_VALUE);
        return new AEMetadataCoercionHandler.PrecisionScale((short)n2, (short)n);
    }

    private AEMetadataCoercionHandler.PrecisionScale coerceDatetimePrecisionScale(AEMetadataCoercionHandler.CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumnInfo.getType());
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(iColumnInfo2.getType());
        SqlTypes sqlTypes3 = SqlTypes.getValueOf(iColumn.getTypeMetadata().getType());
        assert (sqlTypes3 == SqlTypes.SQL_TIME || sqlTypes3 == SqlTypes.SQL_TIMESTAMP);
        short s = -1;
        s = this.isTimeOrTimestamp(sqlTypes) && this.isTimeOrTimestamp(sqlTypes2) ? (short)((short)Math.max(iColumnInfo.getPrecision(), iColumnInfo2.getPrecision())) : (this.isTimeOrTimestamp(sqlTypes) ? (short)iColumnInfo.getPrecision() : (this.isTimeOrTimestamp(sqlTypes2) ? (short)iColumnInfo2.getPrecision() : (sqlTypes3 == SqlTypes.SQL_TIME ? this.m_properties.getMaxTimePrecision() : this.m_properties.getMaxTimestampPrecision())));
        return new AEMetadataCoercionHandler.PrecisionScale(s, s);
    }

    private boolean isTimeOrTimestamp(SqlTypes sqlTypes) {
        return sqlTypes == SqlTypes.SQL_TIME || sqlTypes == SqlTypes.SQL_TIMESTAMP;
    }
}

