/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.aggregatefn;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.AESortSpec;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.temptable.IRowView;
import com.databricks.client.sqlengine.executor.etree.temptable.InMemTable;
import com.databricks.client.sqlengine.executor.etree.temptable.IndexRowView;
import com.databricks.client.sqlengine.executor.etree.temptable.RowBlock;
import com.databricks.client.sqlengine.executor.etree.temptable.RowComparator;
import com.databricks.client.sqlengine.executor.etree.temptable.TemporaryFile;
import com.databricks.client.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.AbstractAggregator;
import com.databricks.client.sqlengine.executor.etree.value.aggregatefn.AbstractAggregatorFactory;
import com.databricks.client.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class MinMaxAggregatorFactory
extends AbstractAggregatorFactory {
    private RowComparator m_rowCmp = null;
    private final boolean m_isMax;
    private final int m_maxColSize;

    public MinMaxAggregatorFactory(IColumn[] iColumnArray, IColumn iColumn, boolean bl, int n) {
        super(iColumnArray, iColumn);
        this.m_isMax = bl;
        this.m_maxColSize = n;
    }

    public boolean requiresDistinct() {
        return false;
    }

    @Override
    public AbstractAggregator createAggregator() throws ErrorException {
        IColumn[] iColumnArray = new IColumn[]{this.getInputMetadata(0)};
        boolean[] blArray = new boolean[]{true};
        if (null == this.m_rowCmp) {
            this.m_rowCmp = RowComparator.createComparator(iColumnArray, Arrays.asList(new AESortSpec(0, this.m_isMax)), RowComparator.getDefaultNullCollation());
        }
        InMemTable inMemTable = new InMemTable(iColumnArray, this.m_maxColSize, 2, blArray, null);
        inMemTable.setMemLimit(Long.MAX_VALUE);
        return new MinMaxAggregator(this, inMemTable, inMemTable.appendRow(), inMemTable.appendRow());
    }

    protected final RowComparator getComparator() {
        return this.m_rowCmp;
    }

    private static class MinMaxAggregator
    extends AbstractAggregator {
        private final InMemTable m_inMemTable;
        private int m_currRow;
        private int m_nextRow;

        public MinMaxAggregator(MinMaxAggregatorFactory minMaxAggregatorFactory, InMemTable inMemTable, int n, int n2) {
            super(minMaxAggregatorFactory);
            this.m_currRow = n;
            this.m_nextRow = n2;
            this.m_inMemTable = inMemTable;
        }

        @Override
        public void close() {
            this.m_inMemTable.clear();
        }

        @Override
        public void load(byte[] byArray) throws ErrorException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byte[] byArray2 = new byte[byArray.length];
            byteBuffer.get(byArray2);
            RowBlock rowBlock = RowBlock.loadData(byArray2, null, new IColumn[]{this.getInputMetadata(0)});
            rowBlock.moveToNextRow();
            InMemTable.setColumn(this.m_inMemTable, rowBlock, 0, this.m_currRow, Integer.MAX_VALUE);
            rowBlock.moveToNextRow();
            InMemTable.setColumn(this.m_inMemTable, rowBlock, 0, this.m_nextRow, Integer.MAX_VALUE);
            assert (!rowBlock.moveToNextRow());
            if (this.m_inMemTable.isNull(this.m_currRow, 0) && !this.m_inMemTable.isNull(this.m_nextRow, 0)) {
                int n = this.m_currRow;
                this.m_currRow = this.m_nextRow;
                this.m_nextRow = n;
            } else if (!this.m_inMemTable.isNull(this.m_nextRow, 0) && 0 > this.doCompare()) {
                int n = this.m_currRow;
                this.m_currRow = this.m_nextRow;
                this.m_nextRow = n;
            }
            this.m_inMemTable.setNull(this.m_nextRow, 0);
        }

        @Override
        public byte[] serialize() throws ErrorException {
            byte[] byArray = this.m_inMemTable.toRowBlock().serialize();
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            byteBuffer.put(byArray);
            return byteBuffer.array();
        }

        @Override
        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            IndexRowView indexRowView = new IndexRowView(this.m_inMemTable);
            indexRowView.setRowNum(this.m_currRow);
            return DataRetrievalUtil.retrieveFromRowView(0, false, eTDataRequest, (IRowView)indexRowView, (TemporaryFile)null);
        }

        @Override
        public void reset() {
            this.m_inMemTable.setNull(this.m_currRow, 0);
            this.m_inMemTable.setNull(this.m_nextRow, 0);
        }

        @Override
        protected long getMemoryUsage() {
            if (null != this.m_inMemTable) {
                return this.m_inMemTable.getMemUsage() + 4;
            }
            return 4L;
        }

        @Override
        protected void update() throws ErrorException {
            if (this.m_inMemTable.isNull(this.m_currRow, 0)) {
                InMemTable.setColumn(this.m_inMemTable, this.getArgumentData(0), this.getInputMetadata(0), 0, this.m_currRow);
            } else {
                InMemTable.setColumn(this.m_inMemTable, this.getArgumentData(0), this.getInputMetadata(0), 0, this.m_nextRow);
                if (!this.m_inMemTable.isNull(this.m_nextRow, 0)) {
                    if (this.doCompare() < 0) {
                        int n = this.m_currRow;
                        this.m_currRow = this.m_nextRow;
                        this.m_nextRow = n;
                    }
                    this.m_inMemTable.setNull(this.m_nextRow, 0);
                }
            }
        }

        private int doCompare() {
            IndexRowView indexRowView = new IndexRowView(this.m_inMemTable);
            indexRowView.setRowNum(this.m_currRow);
            IndexRowView indexRowView2 = new IndexRowView(this.m_inMemTable);
            indexRowView2.setRowNum(this.m_nextRow);
            return ((MinMaxAggregatorFactory)this.getFactory()).getComparator().compare(indexRowView, indexRowView2);
        }
    }
}

