#if !defined  HAVE_REALLOC_H__
#define       HAVE_REALLOC_H__
// This file is part of the FXT library.
// Copyright (C) 2010, 2017, 2018, 2023 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "fxttypes.h"

#include <cstdlib>  // realloc()

template <typename Type>
inline Type * ReAlloc(Type *p, ulong n, ulong /*nold*/)
// p must be form std::malloc
{
    return (Type *)std::realloc((void *)p, n*sizeof(Type));
}
// -------------------------


#endif  // !defined HAVE_REALLOC_H__
