/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { Message, Task, Part } from '@a2a-js/sdk';
/**
 * Extracts a human-readable text representation from a Message object.
 * Handles Text, Data (JSON), and File parts.
 */
export declare function extractMessageText(message: Message | undefined): string;
/**
 * Extracts text from a single Part.
 */
export declare function extractPartText(part: Part): string;
/**
 * Extracts a human-readable text summary from a Task object.
 * Includes status, ID, and any artifact content.
 */
export declare function extractTaskText(task: Task): string;
/**
 * Extracts contextId and taskId from a Message or Task response.
 * Follows the pattern from the A2A CLI sample to maintain conversational continuity.
 */
export declare function extractIdsFromResponse(result: Message | Task): {
    contextId?: string;
    taskId?: string;
};
