var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AGENT_CARD_PATH: () => AGENT_CARD_PATH,
  Extensions: () => Extensions,
  HTTP_EXTENSION_HEADER: () => HTTP_EXTENSION_HEADER
});
module.exports = __toCommonJS(index_exports);

// src/constants.ts
var AGENT_CARD_PATH = ".well-known/agent-card.json";
var HTTP_EXTENSION_HEADER = "X-A2A-Extensions";

// src/extensions.ts
var Extensions = {
  /**
   * Creates new {@link Extensions} from `current` and `additional`.
   * If `current` already contains `additional` it is returned unmodified.
   */
  createFrom: (current, additional) => {
    if (current?.includes(additional)) {
      return current;
    }
    return [...current ?? [], additional];
  },
  /**
   * Creates {@link Extensions} from comma separated extensions identifiers as per
   * https://a2a-protocol.org/latest/specification/#326-service-parameters.
   * Parses the output of `toServiceParameter`.
   */
  parseServiceParameter: (value) => {
    if (!value) {
      return [];
    }
    const unique = new Set(
      value.split(",").map((ext) => ext.trim()).filter((ext) => ext.length > 0)
    );
    return Array.from(unique);
  },
  /**
   * Converts {@link Extensions} to comma separated extensions identifiers as per
   * https://a2a-protocol.org/latest/specification/#326-service-parameters.
   */
  toServiceParameter: (value) => {
    return value.join(",");
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AGENT_CARD_PATH,
  Extensions,
  HTTP_EXTENSION_HEADER
});
