var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/server/grpc/index.ts
var grpc_exports = {};
__export(grpc_exports, {
  A2AService: () => A2AServiceService,
  UserBuilder: () => UserBuilder,
  grpcService: () => grpcService
});
module.exports = __toCommonJS(grpc_exports);

// src/server/grpc/grpc_service.ts
var grpc = __toESM(require("@grpc/grpc-js"), 1);

// src/server/error.ts
var A2AError = class _A2AError extends Error {
  code;
  data;
  taskId;
  // Optional task ID context
  constructor(code, message, data, taskId) {
    super(message);
    this.name = "A2AError";
    this.code = code;
    this.data = data;
    this.taskId = taskId;
  }
  /**
   * Formats the error into a standard JSON-RPC error object structure.
   */
  toJSONRPCError() {
    const errorObject = {
      code: this.code,
      message: this.message
    };
    if (this.data !== void 0) {
      errorObject.data = this.data;
    }
    return errorObject;
  }
  // Static factory methods for common errors
  static parseError(message, data) {
    return new _A2AError(-32700, message, data);
  }
  static invalidRequest(message, data) {
    return new _A2AError(-32600, message, data);
  }
  static methodNotFound(method) {
    return new _A2AError(-32601, `Method not found: ${method}`);
  }
  static invalidParams(message, data) {
    return new _A2AError(-32602, message, data);
  }
  static internalError(message, data) {
    return new _A2AError(-32603, message, data);
  }
  static taskNotFound(taskId) {
    return new _A2AError(-32001, `Task not found: ${taskId}`, void 0, taskId);
  }
  static taskNotCancelable(taskId) {
    return new _A2AError(-32002, `Task not cancelable: ${taskId}`, void 0, taskId);
  }
  static pushNotificationNotSupported() {
    return new _A2AError(-32003, "Push Notification is not supported");
  }
  static unsupportedOperation(operation) {
    return new _A2AError(-32004, `Unsupported operation: ${operation}`);
  }
  static authenticatedExtendedCardNotConfigured() {
    return new _A2AError(-32007, `Extended card not configured.`);
  }
};

// src/types/converters/id_decoding.ts
var CONFIG_REGEX = /^tasks\/([^/]+)\/pushNotificationConfigs\/([^/]+)$/;
var TASK_ONLY_REGEX = /^tasks\/([^/]+)(?:\/|$)/;
var extractTaskId = (name) => {
  const match = name.match(TASK_ONLY_REGEX);
  if (!match) {
    throw A2AError.invalidParams(`Invalid or missing task ID in: "${name}"`);
  }
  return match[1];
};
var generateTaskName = (taskId) => {
  return `tasks/${taskId}`;
};
var extractTaskAndPushNotificationConfigId = (name) => {
  const match = name.match(CONFIG_REGEX);
  if (!match) {
    throw A2AError.invalidParams(`Invalid or missing config ID in: "${name}"`);
  }
  return { taskId: match[1], configId: match[2] };
};
var generatePushNotificationConfigName = (taskId, configId) => {
  return `tasks/${taskId}/pushNotificationConfigs/${configId}`;
};

// src/types/converters/from_proto.ts
var FromProto = class _FromProto {
  static taskQueryParams(request) {
    return {
      id: extractTaskId(request.name),
      historyLength: request.historyLength
    };
  }
  static taskIdParams(request) {
    return {
      id: extractTaskId(request.name)
    };
  }
  static getTaskPushNotificationConfigParams(request) {
    const { taskId, configId } = extractTaskAndPushNotificationConfigId(request.name);
    return {
      id: taskId,
      pushNotificationConfigId: configId
    };
  }
  static listTaskPushNotificationConfigParams(request) {
    return {
      id: extractTaskId(request.parent)
    };
  }
  static createTaskPushNotificationConfig(request) {
    if (!request.config?.pushNotificationConfig) {
      throw A2AError.invalidParams(
        "Request must include a `config` object with a `pushNotificationConfig`"
      );
    }
    return {
      taskId: extractTaskId(request.parent),
      pushNotificationConfig: _FromProto.pushNotificationConfig(
        request.config.pushNotificationConfig
      )
    };
  }
  static deleteTaskPushNotificationConfigParams(request) {
    const { taskId, configId } = extractTaskAndPushNotificationConfigId(request.name);
    return {
      id: taskId,
      pushNotificationConfigId: configId
    };
  }
  static message(message) {
    if (!message) {
      return void 0;
    }
    return {
      kind: "message",
      messageId: message.messageId,
      parts: message.content.map((p) => _FromProto.part(p)),
      contextId: message.contextId || void 0,
      taskId: message.taskId || void 0,
      role: _FromProto.role(message.role),
      metadata: message.metadata,
      extensions: message.extensions
    };
  }
  static role(role) {
    switch (role) {
      case 2 /* ROLE_AGENT */:
        return "agent";
      case 1 /* ROLE_USER */:
        return "user";
      default:
        throw A2AError.invalidParams(`Invalid role: ${role}`);
    }
  }
  static messageSendConfiguration(configuration) {
    if (!configuration) {
      return void 0;
    }
    return {
      blocking: configuration.blocking,
      acceptedOutputModes: configuration.acceptedOutputModes,
      pushNotificationConfig: _FromProto.pushNotificationConfig(configuration.pushNotification)
    };
  }
  static pushNotificationConfig(config) {
    if (!config) {
      return void 0;
    }
    return {
      id: config.id,
      url: config.url,
      token: config.token || void 0,
      authentication: _FromProto.pushNotificationAuthenticationInfo(config.authentication)
    };
  }
  static pushNotificationAuthenticationInfo(authInfo) {
    if (!authInfo) {
      return void 0;
    }
    return {
      schemes: authInfo.schemes,
      credentials: authInfo.credentials
    };
  }
  static part(part) {
    if (part.part?.$case === "text") {
      return {
        kind: "text",
        text: part.part.value
      };
    }
    if (part.part?.$case === "file") {
      const filePart = part.part.value;
      if (filePart.file?.$case === "fileWithUri") {
        return {
          kind: "file",
          file: {
            uri: filePart.file.value,
            mimeType: filePart.mimeType
          }
        };
      } else if (filePart.file?.$case === "fileWithBytes") {
        return {
          kind: "file",
          file: {
            bytes: filePart.file.value.toString("base64"),
            mimeType: filePart.mimeType
          }
        };
      }
      throw A2AError.invalidParams("Invalid file part type");
    }
    if (part.part?.$case === "data") {
      return {
        kind: "data",
        data: part.part.value.data
      };
    }
    throw A2AError.invalidParams("Invalid part type");
  }
  static messageSendParams(request) {
    return {
      message: _FromProto.message(request.request),
      configuration: _FromProto.messageSendConfiguration(request.configuration),
      metadata: request.metadata
    };
  }
  static sendMessageResult(response) {
    if (response.payload?.$case === "task") {
      return _FromProto.task(response.payload.value);
    } else if (response.payload?.$case === "msg") {
      return _FromProto.message(response.payload.value);
    }
    throw A2AError.invalidParams("Invalid SendMessageResponse: missing result");
  }
  static task(task) {
    return {
      kind: "task",
      id: task.id,
      status: _FromProto.taskStatus(task.status),
      contextId: task.contextId,
      artifacts: task.artifacts?.map((a) => _FromProto.artifact(a)),
      history: task.history?.map((h) => _FromProto.message(h)),
      metadata: task.metadata
    };
  }
  static taskStatus(status2) {
    return {
      message: _FromProto.message(status2.update),
      state: _FromProto.taskState(status2.state),
      timestamp: status2.timestamp
    };
  }
  static taskState(state) {
    switch (state) {
      case 1 /* TASK_STATE_SUBMITTED */:
        return "submitted";
      case 2 /* TASK_STATE_WORKING */:
        return "working";
      case 6 /* TASK_STATE_INPUT_REQUIRED */:
        return "input-required";
      case 3 /* TASK_STATE_COMPLETED */:
        return "completed";
      case 5 /* TASK_STATE_CANCELLED */:
        return "canceled";
      case 4 /* TASK_STATE_FAILED */:
        return "failed";
      case 7 /* TASK_STATE_REJECTED */:
        return "rejected";
      case 8 /* TASK_STATE_AUTH_REQUIRED */:
        return "auth-required";
      case 0 /* TASK_STATE_UNSPECIFIED */:
        return "unknown";
      default:
        throw A2AError.invalidParams(`Invalid task state: ${state}`);
    }
  }
  static artifact(artifact) {
    return {
      artifactId: artifact.artifactId,
      name: artifact.name || void 0,
      description: artifact.description || void 0,
      parts: artifact.parts.map((p) => _FromProto.part(p)),
      metadata: artifact.metadata
    };
  }
  static taskPushNotificationConfig(request) {
    return {
      taskId: extractTaskId(request.name),
      pushNotificationConfig: _FromProto.pushNotificationConfig(request.pushNotificationConfig)
    };
  }
  static listTaskPushNotificationConfig(request) {
    return request.configs.map((c) => _FromProto.taskPushNotificationConfig(c));
  }
  static agentCard(agentCard) {
    return {
      additionalInterfaces: agentCard.additionalInterfaces?.map((i) => _FromProto.agentInterface(i)),
      capabilities: agentCard.capabilities ? _FromProto.agentCapabilities(agentCard.capabilities) : {},
      defaultInputModes: agentCard.defaultInputModes,
      defaultOutputModes: agentCard.defaultOutputModes,
      description: agentCard.description,
      documentationUrl: agentCard.documentationUrl || void 0,
      name: agentCard.name,
      preferredTransport: agentCard.preferredTransport,
      provider: agentCard.provider ? _FromProto.agentProvider(agentCard.provider) : void 0,
      protocolVersion: agentCard.protocolVersion,
      security: agentCard.security?.map((s) => _FromProto.security(s)),
      securitySchemes: agentCard.securitySchemes ? Object.fromEntries(
        Object.entries(agentCard.securitySchemes).map(([key, value]) => [
          key,
          _FromProto.securityScheme(value)
        ])
      ) : {},
      skills: agentCard.skills.map((s) => _FromProto.skills(s)),
      signatures: agentCard.signatures?.map((s) => _FromProto.agentCardSignature(s)),
      supportsAuthenticatedExtendedCard: agentCard.supportsAuthenticatedExtendedCard,
      url: agentCard.url,
      version: agentCard.version
    };
  }
  static agentCapabilities(capabilities) {
    return {
      extensions: capabilities.extensions?.map((e) => _FromProto.agentExtension(e)),
      pushNotifications: capabilities.pushNotifications,
      streaming: capabilities.streaming
    };
  }
  static agentExtension(extension) {
    return {
      uri: extension.uri,
      description: extension.description || void 0,
      required: extension.required,
      params: extension.params
    };
  }
  static agentInterface(intf) {
    return {
      transport: intf.transport,
      url: intf.url
    };
  }
  static agentProvider(provider) {
    return {
      organization: provider.organization,
      url: provider.url
    };
  }
  static security(security) {
    return Object.fromEntries(
      Object.entries(security.schemes)?.map(([key, value]) => [key, value.list])
    );
  }
  static securityScheme(securitySchemes) {
    switch (securitySchemes.scheme?.$case) {
      case "apiKeySecurityScheme":
        return {
          type: "apiKey",
          name: securitySchemes.scheme.value.name,
          in: securitySchemes.scheme.value.location,
          description: securitySchemes.scheme.value.description || void 0
        };
      case "httpAuthSecurityScheme":
        return {
          type: "http",
          scheme: securitySchemes.scheme.value.scheme,
          bearerFormat: securitySchemes.scheme.value.bearerFormat || void 0,
          description: securitySchemes.scheme.value.description || void 0
        };
      case "mtlsSecurityScheme":
        return {
          type: "mutualTLS",
          description: securitySchemes.scheme.value.description || void 0
        };
      case "oauth2SecurityScheme":
        return {
          type: "oauth2",
          description: securitySchemes.scheme.value.description || void 0,
          flows: _FromProto.oauthFlows(securitySchemes.scheme.value.flows),
          oauth2MetadataUrl: securitySchemes.scheme.value.oauth2MetadataUrl || void 0
        };
      case "openIdConnectSecurityScheme":
        return {
          type: "openIdConnect",
          description: securitySchemes.scheme.value.description || void 0,
          openIdConnectUrl: securitySchemes.scheme.value.openIdConnectUrl
        };
      default:
        throw A2AError.internalError(`Unsupported security scheme type`);
    }
  }
  static oauthFlows(flows) {
    switch (flows.flow?.$case) {
      case "implicit":
        return {
          implicit: {
            authorizationUrl: flows.flow.value.authorizationUrl,
            scopes: flows.flow.value.scopes,
            refreshUrl: flows.flow.value.refreshUrl || void 0
          }
        };
      case "password":
        return {
          password: {
            refreshUrl: flows.flow.value.refreshUrl || void 0,
            scopes: flows.flow.value.scopes,
            tokenUrl: flows.flow.value.tokenUrl
          }
        };
      case "authorizationCode":
        return {
          authorizationCode: {
            refreshUrl: flows.flow.value.refreshUrl || void 0,
            authorizationUrl: flows.flow.value.authorizationUrl,
            scopes: flows.flow.value.scopes,
            tokenUrl: flows.flow.value.tokenUrl
          }
        };
      case "clientCredentials":
        return {
          clientCredentials: {
            refreshUrl: flows.flow.value.refreshUrl || void 0,
            scopes: flows.flow.value.scopes,
            tokenUrl: flows.flow.value.tokenUrl
          }
        };
      default:
        throw A2AError.internalError(`Unsupported OAuth flows`);
    }
  }
  static skills(skill) {
    return {
      id: skill.id,
      name: skill.name,
      description: skill.description,
      tags: skill.tags,
      examples: skill.examples,
      inputModes: skill.inputModes,
      outputModes: skill.outputModes,
      security: skill.security?.map((s) => _FromProto.security(s))
    };
  }
  static agentCardSignature(signatures) {
    return {
      protected: signatures.protected,
      signature: signatures.signature,
      header: signatures.header
    };
  }
  static taskStatusUpdateEvent(event) {
    return {
      kind: "status-update",
      taskId: event.taskId,
      status: _FromProto.taskStatus(event.status),
      contextId: event.contextId,
      metadata: event.metadata,
      final: event.final
    };
  }
  static taskArtifactUpdateEvent(event) {
    return {
      kind: "artifact-update",
      taskId: event.taskId,
      artifact: _FromProto.artifact(event.artifact),
      contextId: event.contextId,
      metadata: event.metadata,
      lastChunk: event.lastChunk
    };
  }
  static messageStreamResult(event) {
    switch (event.payload?.$case) {
      case "msg":
        return _FromProto.message(event.payload.value);
      case "task":
        return _FromProto.task(event.payload.value);
      case "statusUpdate":
        return _FromProto.taskStatusUpdateEvent(event.payload.value);
      case "artifactUpdate":
        return _FromProto.taskArtifactUpdateEvent(event.payload.value);
      default:
        throw A2AError.internalError("Invalid event type in StreamResponse");
    }
  }
};

// src/types/converters/to_proto.ts
var ToProto = class _ToProto {
  static agentCard(agentCard) {
    return {
      protocolVersion: agentCard.protocolVersion,
      name: agentCard.name,
      description: agentCard.description,
      url: agentCard.url,
      preferredTransport: agentCard.preferredTransport ?? "",
      additionalInterfaces: agentCard.additionalInterfaces?.map((i) => _ToProto.agentInterface(i)) ?? [],
      provider: _ToProto.agentProvider(agentCard.provider),
      version: agentCard.version,
      documentationUrl: agentCard.documentationUrl ?? "",
      capabilities: _ToProto.agentCapabilities(agentCard.capabilities),
      securitySchemes: agentCard.securitySchemes ? Object.fromEntries(
        Object.entries(agentCard.securitySchemes).map(([key, value]) => [
          key,
          _ToProto.securityScheme(value)
        ])
      ) : {},
      security: agentCard.security?.map((s) => _ToProto.security(s)) ?? [],
      defaultInputModes: agentCard.defaultInputModes,
      defaultOutputModes: agentCard.defaultOutputModes,
      skills: agentCard.skills.map((s) => _ToProto.agentSkill(s)),
      supportsAuthenticatedExtendedCard: agentCard.supportsAuthenticatedExtendedCard,
      signatures: agentCard.signatures?.map((s) => _ToProto.agentCardSignature(s)) ?? []
    };
  }
  static agentCardSignature(signatures) {
    return {
      protected: signatures.protected,
      signature: signatures.signature,
      header: signatures.header
    };
  }
  static agentSkill(skill) {
    return {
      id: skill.id,
      name: skill.name,
      description: skill.description,
      tags: skill.tags ?? [],
      examples: skill.examples ?? [],
      inputModes: skill.inputModes ?? [],
      outputModes: skill.outputModes ?? [],
      security: skill.security ? skill.security.map((s) => _ToProto.security(s)) : []
    };
  }
  static security(security) {
    return {
      schemes: Object.fromEntries(
        Object.entries(security).map(([key, value]) => {
          return [key, { list: value }];
        })
      )
    };
  }
  static securityScheme(scheme) {
    switch (scheme.type) {
      case "apiKey":
        return {
          scheme: {
            $case: "apiKeySecurityScheme",
            value: {
              name: scheme.name,
              location: scheme.in,
              description: scheme.description ?? ""
            }
          }
        };
      case "http":
        return {
          scheme: {
            $case: "httpAuthSecurityScheme",
            value: {
              description: scheme.description ?? "",
              scheme: scheme.scheme,
              bearerFormat: scheme.bearerFormat ?? ""
            }
          }
        };
      case "mutualTLS":
        return {
          scheme: {
            $case: "mtlsSecurityScheme",
            value: {
              description: scheme.description ?? ""
            }
          }
        };
      case "oauth2":
        return {
          scheme: {
            $case: "oauth2SecurityScheme",
            value: {
              description: scheme.description ?? "",
              flows: _ToProto.oauthFlows(scheme.flows),
              oauth2MetadataUrl: scheme.oauth2MetadataUrl ?? ""
            }
          }
        };
      case "openIdConnect":
        return {
          scheme: {
            $case: "openIdConnectSecurityScheme",
            value: {
              description: scheme.description ?? "",
              openIdConnectUrl: scheme.openIdConnectUrl
            }
          }
        };
      default:
        throw A2AError.internalError(`Unsupported security scheme type`);
    }
  }
  static oauthFlows(flows) {
    if (flows.implicit) {
      return {
        flow: {
          $case: "implicit",
          value: {
            authorizationUrl: flows.implicit.authorizationUrl,
            scopes: flows.implicit.scopes,
            refreshUrl: flows.implicit.refreshUrl ?? ""
          }
        }
      };
    } else if (flows.password) {
      return {
        flow: {
          $case: "password",
          value: {
            tokenUrl: flows.password.tokenUrl,
            scopes: flows.password.scopes,
            refreshUrl: flows.password.refreshUrl ?? ""
          }
        }
      };
    } else if (flows.clientCredentials) {
      return {
        flow: {
          $case: "clientCredentials",
          value: {
            tokenUrl: flows.clientCredentials.tokenUrl,
            scopes: flows.clientCredentials.scopes,
            refreshUrl: flows.clientCredentials.refreshUrl ?? ""
          }
        }
      };
    } else if (flows.authorizationCode) {
      return {
        flow: {
          $case: "authorizationCode",
          value: {
            authorizationUrl: flows.authorizationCode.authorizationUrl,
            tokenUrl: flows.authorizationCode.tokenUrl,
            scopes: flows.authorizationCode.scopes,
            refreshUrl: flows.authorizationCode.refreshUrl ?? ""
          }
        }
      };
    } else {
      throw A2AError.internalError(`Unsupported OAuth flows`);
    }
  }
  static agentInterface(agentInterface) {
    return {
      transport: agentInterface.transport,
      url: agentInterface.url
    };
  }
  static agentProvider(agentProvider) {
    if (!agentProvider) {
      return void 0;
    }
    return {
      url: agentProvider.url,
      organization: agentProvider.organization
    };
  }
  static agentCapabilities(capabilities) {
    return {
      streaming: capabilities.streaming,
      pushNotifications: capabilities.pushNotifications,
      extensions: capabilities.extensions ? capabilities.extensions.map((e) => _ToProto.agentExtension(e)) : []
    };
  }
  static agentExtension(extension) {
    return {
      uri: extension.uri,
      description: extension.description ?? "",
      required: extension.required ?? false,
      params: extension.params
    };
  }
  static listTaskPushNotificationConfig(config) {
    return {
      configs: config.map((c) => _ToProto.taskPushNotificationConfig(c)),
      nextPageToken: ""
    };
  }
  static getTaskPushNotificationConfigParams(config) {
    return {
      name: generatePushNotificationConfigName(config.id, config.pushNotificationConfigId)
    };
  }
  static listTaskPushNotificationConfigParams(config) {
    return {
      parent: generateTaskName(config.id),
      pageToken: "",
      pageSize: 0
    };
  }
  static deleteTaskPushNotificationConfigParams(config) {
    return {
      name: generatePushNotificationConfigName(config.id, config.pushNotificationConfigId)
    };
  }
  static taskPushNotificationConfig(config) {
    return {
      name: generatePushNotificationConfigName(
        config.taskId,
        config.pushNotificationConfig.id ?? ""
      ),
      pushNotificationConfig: _ToProto.pushNotificationConfig(config.pushNotificationConfig)
    };
  }
  static taskPushNotificationConfigCreate(config) {
    return {
      parent: generateTaskName(config.taskId),
      config: _ToProto.taskPushNotificationConfig(config),
      configId: config.pushNotificationConfig.id
    };
  }
  static pushNotificationConfig(config) {
    if (!config) {
      return void 0;
    }
    return {
      id: config.id ?? "",
      url: config.url,
      token: config.token ?? "",
      authentication: _ToProto.pushNotificationAuthenticationInfo(config.authentication)
    };
  }
  static pushNotificationAuthenticationInfo(authInfo) {
    if (!authInfo) {
      return void 0;
    }
    return {
      schemes: authInfo.schemes,
      credentials: authInfo.credentials ?? ""
    };
  }
  static messageStreamResult(event) {
    if (event.kind === "message") {
      return {
        payload: {
          $case: "msg",
          value: _ToProto.message(event)
        }
      };
    } else if (event.kind === "task") {
      return {
        payload: {
          $case: "task",
          value: _ToProto.task(event)
        }
      };
    } else if (event.kind === "status-update") {
      return {
        payload: {
          $case: "statusUpdate",
          value: _ToProto.taskStatusUpdateEvent(event)
        }
      };
    } else if (event.kind === "artifact-update") {
      return {
        payload: {
          $case: "artifactUpdate",
          value: _ToProto.taskArtifactUpdateEvent(event)
        }
      };
    } else {
      throw A2AError.internalError("Invalid event type");
    }
  }
  static taskStatusUpdateEvent(event) {
    return {
      taskId: event.taskId,
      status: _ToProto.taskStatus(event.status),
      contextId: event.contextId,
      metadata: event.metadata,
      final: event.final
    };
  }
  static taskArtifactUpdateEvent(event) {
    return {
      taskId: event.taskId,
      artifact: _ToProto.artifact(event.artifact),
      contextId: event.contextId,
      metadata: event.metadata,
      append: event.append,
      lastChunk: event.lastChunk
    };
  }
  static messageSendResult(params) {
    if (params.kind === "message") {
      return {
        payload: {
          $case: "msg",
          value: _ToProto.message(params)
        }
      };
    } else if (params.kind === "task") {
      return {
        payload: {
          $case: "task",
          value: _ToProto.task(params)
        }
      };
    }
  }
  static message(message) {
    if (!message) {
      return void 0;
    }
    return {
      messageId: message.messageId,
      content: message.parts.map((p) => _ToProto.part(p)),
      contextId: message.contextId ?? "",
      taskId: message.taskId ?? "",
      role: _ToProto.role(message.role),
      metadata: message.metadata,
      extensions: message.extensions ?? []
    };
  }
  static role(role) {
    switch (role) {
      case "agent":
        return 2 /* ROLE_AGENT */;
      case "user":
        return 1 /* ROLE_USER */;
      default:
        throw A2AError.internalError(`Invalid role`);
    }
  }
  static task(task) {
    return {
      id: task.id,
      contextId: task.contextId,
      status: _ToProto.taskStatus(task.status),
      artifacts: task.artifacts?.map((a) => _ToProto.artifact(a)) ?? [],
      history: task.history?.map((m) => _ToProto.message(m)) ?? [],
      metadata: task.metadata
    };
  }
  static taskStatus(status2) {
    return {
      state: _ToProto.taskState(status2.state),
      update: _ToProto.message(status2.message),
      timestamp: status2.timestamp
    };
  }
  static artifact(artifact) {
    return {
      artifactId: artifact.artifactId,
      name: artifact.name ?? "",
      description: artifact.description ?? "",
      parts: artifact.parts.map((p) => _ToProto.part(p)),
      metadata: artifact.metadata,
      extensions: artifact.extensions ? artifact.extensions : []
    };
  }
  static taskState(state) {
    switch (state) {
      case "submitted":
        return 1 /* TASK_STATE_SUBMITTED */;
      case "working":
        return 2 /* TASK_STATE_WORKING */;
      case "input-required":
        return 6 /* TASK_STATE_INPUT_REQUIRED */;
      case "rejected":
        return 7 /* TASK_STATE_REJECTED */;
      case "auth-required":
        return 8 /* TASK_STATE_AUTH_REQUIRED */;
      case "completed":
        return 3 /* TASK_STATE_COMPLETED */;
      case "failed":
        return 4 /* TASK_STATE_FAILED */;
      case "canceled":
        return 5 /* TASK_STATE_CANCELLED */;
      case "unknown":
        return 0 /* TASK_STATE_UNSPECIFIED */;
      default:
        return -1 /* UNRECOGNIZED */;
    }
  }
  static part(part) {
    if (part.kind === "text") {
      return {
        part: { $case: "text", value: part.text }
      };
    }
    if (part.kind === "file") {
      let filePart;
      if ("uri" in part.file) {
        filePart = {
          file: { $case: "fileWithUri", value: part.file.uri },
          mimeType: part.file.mimeType
        };
      } else if ("bytes" in part.file) {
        filePart = {
          file: { $case: "fileWithBytes", value: Buffer.from(part.file.bytes, "base64") },
          mimeType: part.file.mimeType
        };
      } else {
        throw A2AError.internalError("Invalid file part");
      }
      return {
        part: { $case: "file", value: filePart }
      };
    }
    if (part.kind === "data") {
      return {
        part: { $case: "data", value: { data: part.data } }
      };
    }
    throw A2AError.internalError("Invalid part type");
  }
  static messageSendParams(params) {
    return {
      request: _ToProto.message(params.message),
      configuration: _ToProto.configuration(params.configuration),
      metadata: params.metadata
    };
  }
  static configuration(configuration) {
    if (!configuration) {
      return void 0;
    }
    return {
      blocking: configuration.blocking,
      acceptedOutputModes: configuration.acceptedOutputModes ?? [],
      pushNotification: _ToProto.pushNotificationConfig(configuration.pushNotificationConfig),
      historyLength: configuration.historyLength ?? 0
    };
  }
  static taskQueryParams(params) {
    return {
      name: generateTaskName(params.id),
      historyLength: params.historyLength ?? 0
    };
  }
  static cancelTaskRequest(params) {
    return {
      name: generateTaskName(params.id)
    };
  }
  static taskIdParams(params) {
    return {
      name: generateTaskName(params.id)
    };
  }
  static getAgentCardRequest() {
    return {};
  }
};

// src/extensions.ts
var Extensions = {
  /**
   * Creates new {@link Extensions} from `current` and `additional`.
   * If `current` already contains `additional` it is returned unmodified.
   */
  createFrom: (current, additional) => {
    if (current?.includes(additional)) {
      return current;
    }
    return [...current ?? [], additional];
  },
  /**
   * Creates {@link Extensions} from comma separated extensions identifiers as per
   * https://a2a-protocol.org/latest/specification/#326-service-parameters.
   * Parses the output of `toServiceParameter`.
   */
  parseServiceParameter: (value) => {
    if (!value) {
      return [];
    }
    const unique = new Set(
      value.split(",").map((ext) => ext.trim()).filter((ext) => ext.length > 0)
    );
    return Array.from(unique);
  },
  /**
   * Converts {@link Extensions} to comma separated extensions identifiers as per
   * https://a2a-protocol.org/latest/specification/#326-service-parameters.
   */
  toServiceParameter: (value) => {
    return value.join(",");
  }
};

// src/server/context.ts
var ServerCallContext = class {
  _requestedExtensions;
  _user;
  _activatedExtensions;
  constructor(requestedExtensions, user) {
    this._requestedExtensions = requestedExtensions;
    this._user = user;
  }
  get user() {
    return this._user;
  }
  get activatedExtensions() {
    return this._activatedExtensions;
  }
  get requestedExtensions() {
    return this._requestedExtensions;
  }
  addActivatedExtension(uri) {
    this._activatedExtensions = Extensions.createFrom(this._activatedExtensions, uri);
  }
};

// src/constants.ts
var HTTP_EXTENSION_HEADER = "X-A2A-Extensions";

// src/server/grpc/grpc_service.ts
function grpcService(options) {
  const requestHandler = options.requestHandler;
  const wrapUnary = async (call, callback, parser, handler, converter) => {
    try {
      const context = await buildContext(call, options.userBuilder);
      const params = parser(call.request);
      const result = await handler(params, context);
      call.sendMetadata(buildMetadata(context));
      callback(null, converter(result));
    } catch (error) {
      callback(mapToError(error), null);
    }
  };
  const wrapStreaming = async (call, parser, handler, converter) => {
    try {
      const context = await buildContext(call, options.userBuilder);
      const params = parser(call.request);
      const stream = await handler(params, context);
      const metadata = buildMetadata(context);
      call.sendMetadata(metadata);
      for await (const responsePart of stream) {
        const response = converter(responsePart);
        call.write(response);
      }
    } catch (error) {
      call.emit("error", mapToError(error));
    } finally {
      call.end();
    }
  };
  return {
    sendMessage(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.messageSendParams,
        requestHandler.sendMessage.bind(requestHandler),
        ToProto.messageSendResult
      );
    },
    sendStreamingMessage(call) {
      return wrapStreaming(
        call,
        FromProto.messageSendParams,
        requestHandler.sendMessageStream.bind(requestHandler),
        ToProto.messageStreamResult
      );
    },
    taskSubscription(call) {
      return wrapStreaming(
        call,
        FromProto.taskIdParams,
        requestHandler.resubscribe.bind(requestHandler),
        ToProto.messageStreamResult
      );
    },
    deleteTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.deleteTaskPushNotificationConfigParams,
        requestHandler.deleteTaskPushNotificationConfig.bind(requestHandler),
        () => ({})
      );
    },
    listTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.listTaskPushNotificationConfigParams,
        requestHandler.listTaskPushNotificationConfigs.bind(requestHandler),
        ToProto.listTaskPushNotificationConfig
      );
    },
    createTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.createTaskPushNotificationConfig,
        requestHandler.setTaskPushNotificationConfig.bind(requestHandler),
        ToProto.taskPushNotificationConfig
      );
    },
    getTaskPushNotificationConfig(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.getTaskPushNotificationConfigParams,
        requestHandler.getTaskPushNotificationConfig.bind(requestHandler),
        ToProto.taskPushNotificationConfig
      );
    },
    getTask(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.taskQueryParams,
        requestHandler.getTask.bind(requestHandler),
        ToProto.task
      );
    },
    cancelTask(call, callback) {
      return wrapUnary(
        call,
        callback,
        FromProto.taskIdParams,
        requestHandler.cancelTask.bind(requestHandler),
        ToProto.task
      );
    },
    getAgentCard(call, callback) {
      return wrapUnary(
        call,
        callback,
        () => ({}),
        (_params, context) => requestHandler.getAuthenticatedExtendedAgentCard(context),
        ToProto.agentCard
      );
    }
  };
}
var mapping = {
  [-32001]: grpc.status.NOT_FOUND,
  [-32002]: grpc.status.FAILED_PRECONDITION,
  [-32003]: grpc.status.UNIMPLEMENTED,
  [-32004]: grpc.status.UNIMPLEMENTED,
  [-32005]: grpc.status.INVALID_ARGUMENT,
  [-32006]: grpc.status.INTERNAL,
  [-32007]: grpc.status.FAILED_PRECONDITION,
  [-32600]: grpc.status.INVALID_ARGUMENT,
  [-32602]: grpc.status.INVALID_ARGUMENT,
  [-32603]: grpc.status.INTERNAL
};
var mapToError = (error) => {
  const a2aError = error instanceof A2AError ? error : A2AError.internalError(error instanceof Error ? error.message : "Internal server error");
  return {
    code: mapping[a2aError.code] ?? grpc.status.UNKNOWN,
    details: a2aError.message
  };
};
var buildContext = async (call, userBuilder) => {
  const user = await userBuilder(call);
  const extensionHeaders = call.metadata.get(HTTP_EXTENSION_HEADER);
  const extensionString = extensionHeaders.map((v) => v.toString()).join(",");
  return new ServerCallContext(Extensions.parseServiceParameter(extensionString), user);
};
var buildMetadata = (context) => {
  const metadata = new grpc.Metadata();
  if (context.activatedExtensions?.length) {
    metadata.set(HTTP_EXTENSION_HEADER, context.activatedExtensions.join(","));
  }
  return metadata;
};

// src/grpc/pb/a2a_services.ts
var import_wire4 = require("@bufbuild/protobuf/wire");
var import_grpc_js = require("@grpc/grpc-js");

// src/grpc/pb/google/protobuf/empty.ts
var import_wire = require("@bufbuild/protobuf/wire");
function createBaseEmpty() {
  return {};
}
var Empty = {
  encode(_, writer = new import_wire.BinaryWriter()) {
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire.BinaryReader ? input : new import_wire.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseEmpty();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};

// src/grpc/pb/google/protobuf/struct.ts
var import_wire2 = require("@bufbuild/protobuf/wire");
function createBaseStruct() {
  return { fields: {} };
}
var Struct = {
  encode(message, writer = new import_wire2.BinaryWriter()) {
    Object.entries(message.fields).forEach(([key, value]) => {
      if (value !== void 0) {
        Struct_FieldsEntry.encode({ key, value }, writer.uint32(10).fork()).join();
      }
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire2.BinaryReader ? input : new import_wire2.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStruct();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          const entry1 = Struct_FieldsEntry.decode(reader, reader.uint32());
          if (entry1.value !== void 0) {
            message.fields[entry1.key] = entry1.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  },
  wrap(object) {
    const struct = createBaseStruct();
    if (object !== void 0) {
      for (const key of Object.keys(object)) {
        struct.fields[key] = object[key];
      }
    }
    return struct;
  },
  unwrap(message) {
    const object = {};
    if (message.fields) {
      for (const key of Object.keys(message.fields)) {
        object[key] = message.fields[key];
      }
    }
    return object;
  }
};
function createBaseStruct_FieldsEntry() {
  return { key: "", value: void 0 };
}
var Struct_FieldsEntry = {
  encode(message, writer = new import_wire2.BinaryWriter()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== void 0) {
      Value.encode(Value.wrap(message.value), writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire2.BinaryReader ? input : new import_wire2.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStruct_FieldsEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = Value.unwrap(Value.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseValue() {
  return { kind: void 0 };
}
var Value = {
  encode(message, writer = new import_wire2.BinaryWriter()) {
    switch (message.kind?.$case) {
      case "nullValue":
        writer.uint32(8).int32(message.kind.value);
        break;
      case "numberValue":
        writer.uint32(17).double(message.kind.value);
        break;
      case "stringValue":
        writer.uint32(26).string(message.kind.value);
        break;
      case "boolValue":
        writer.uint32(32).bool(message.kind.value);
        break;
      case "structValue":
        Struct.encode(Struct.wrap(message.kind.value), writer.uint32(42).fork()).join();
        break;
      case "listValue":
        ListValue.encode(ListValue.wrap(message.kind.value), writer.uint32(50).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire2.BinaryReader ? input : new import_wire2.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseValue();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.kind = { $case: "nullValue", value: reader.int32() };
          continue;
        }
        case 2: {
          if (tag !== 17) {
            break;
          }
          message.kind = { $case: "numberValue", value: reader.double() };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.kind = { $case: "stringValue", value: reader.string() };
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.kind = { $case: "boolValue", value: reader.bool() };
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.kind = { $case: "structValue", value: Struct.unwrap(Struct.decode(reader, reader.uint32())) };
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.kind = { $case: "listValue", value: ListValue.unwrap(ListValue.decode(reader, reader.uint32())) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  },
  wrap(value) {
    const result = createBaseValue();
    if (value === null) {
      result.kind = { $case: "nullValue", value };
    } else if (typeof value === "boolean") {
      result.kind = { $case: "boolValue", value };
    } else if (typeof value === "number") {
      result.kind = { $case: "numberValue", value };
    } else if (typeof value === "string") {
      result.kind = { $case: "stringValue", value };
    } else if (globalThis.Array.isArray(value)) {
      result.kind = { $case: "listValue", value };
    } else if (typeof value === "object") {
      result.kind = { $case: "structValue", value };
    } else if (typeof value !== "undefined") {
      throw new globalThis.Error("Unsupported any value type: " + typeof value);
    }
    return result;
  },
  unwrap(message) {
    return message.kind?.value;
  }
};
function createBaseListValue() {
  return { values: [] };
}
var ListValue = {
  encode(message, writer = new import_wire2.BinaryWriter()) {
    for (const v of message.values) {
      Value.encode(Value.wrap(v), writer.uint32(10).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire2.BinaryReader ? input : new import_wire2.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseListValue();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.values.push(Value.unwrap(Value.decode(reader, reader.uint32())));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  },
  wrap(array) {
    const result = createBaseListValue();
    result.values = array ?? [];
    return result;
  },
  unwrap(message) {
    if (message?.hasOwnProperty("values") && globalThis.Array.isArray(message.values)) {
      return message.values;
    } else {
      return message;
    }
  }
};

// src/grpc/pb/google/protobuf/timestamp.ts
var import_wire3 = require("@bufbuild/protobuf/wire");
function createBaseTimestamp() {
  return { seconds: 0, nanos: 0 };
}
var Timestamp = {
  encode(message, writer = new import_wire3.BinaryWriter()) {
    if (message.seconds !== 0) {
      writer.uint32(8).int64(message.seconds);
    }
    if (message.nanos !== 0) {
      writer.uint32(16).int32(message.nanos);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire3.BinaryReader ? input : new import_wire3.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTimestamp();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.seconds = longToNumber(reader.int64());
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.nanos = reader.int32();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function longToNumber(int64) {
  const num = globalThis.Number(int64.toString());
  if (num > globalThis.Number.MAX_SAFE_INTEGER) {
    throw new globalThis.Error("Value is larger than Number.MAX_SAFE_INTEGER");
  }
  if (num < globalThis.Number.MIN_SAFE_INTEGER) {
    throw new globalThis.Error("Value is smaller than Number.MIN_SAFE_INTEGER");
  }
  return num;
}

// src/grpc/pb/a2a_services.ts
function createBaseSendMessageConfiguration() {
  return { acceptedOutputModes: [], pushNotification: void 0, historyLength: 0, blocking: false };
}
var SendMessageConfiguration3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    for (const v of message.acceptedOutputModes) {
      writer.uint32(10).string(v);
    }
    if (message.pushNotification !== void 0) {
      PushNotificationConfig3.encode(message.pushNotification, writer.uint32(18).fork()).join();
    }
    if (message.historyLength !== 0) {
      writer.uint32(24).int32(message.historyLength);
    }
    if (message.blocking !== false) {
      writer.uint32(32).bool(message.blocking);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSendMessageConfiguration();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.acceptedOutputModes.push(reader.string());
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.pushNotification = PushNotificationConfig3.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 24) {
            break;
          }
          message.historyLength = reader.int32();
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.blocking = reader.bool();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTask() {
  return { id: "", contextId: "", status: void 0, artifacts: [], history: [], metadata: void 0 };
}
var Task3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.status !== void 0) {
      TaskStatus3.encode(message.status, writer.uint32(26).fork()).join();
    }
    for (const v of message.artifacts) {
      Artifact3.encode(v, writer.uint32(34).fork()).join();
    }
    for (const v of message.history) {
      Message3.encode(v, writer.uint32(42).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTask();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.status = TaskStatus3.decode(reader, reader.uint32());
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.artifacts.push(Artifact3.decode(reader, reader.uint32()));
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.history.push(Message3.decode(reader, reader.uint32()));
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskStatus() {
  return { state: 0, update: void 0, timestamp: void 0 };
}
var TaskStatus3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.state !== 0) {
      writer.uint32(8).int32(message.state);
    }
    if (message.update !== void 0) {
      Message3.encode(message.update, writer.uint32(18).fork()).join();
    }
    if (message.timestamp !== void 0) {
      Timestamp.encode(toTimestamp(message.timestamp), writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskStatus();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.state = reader.int32();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.update = Message3.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.timestamp = fromTimestamp(Timestamp.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePart() {
  return { part: void 0 };
}
var Part3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    switch (message.part?.$case) {
      case "text":
        writer.uint32(10).string(message.part.value);
        break;
      case "file":
        FilePart.encode(message.part.value, writer.uint32(18).fork()).join();
        break;
      case "data":
        DataPart.encode(message.part.value, writer.uint32(26).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePart();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.part = { $case: "text", value: reader.string() };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.part = { $case: "file", value: FilePart.decode(reader, reader.uint32()) };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.part = { $case: "data", value: DataPart.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseFilePart() {
  return { file: void 0, mimeType: "" };
}
var FilePart = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    switch (message.file?.$case) {
      case "fileWithUri":
        writer.uint32(10).string(message.file.value);
        break;
      case "fileWithBytes":
        writer.uint32(18).bytes(message.file.value);
        break;
    }
    if (message.mimeType !== "") {
      writer.uint32(26).string(message.mimeType);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseFilePart();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.file = { $case: "fileWithUri", value: reader.string() };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.file = { $case: "fileWithBytes", value: Buffer.from(reader.bytes()) };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.mimeType = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseDataPart() {
  return { data: void 0 };
}
var DataPart = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.data !== void 0) {
      Struct.encode(Struct.wrap(message.data), writer.uint32(10).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseDataPart();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.data = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseMessage() {
  return { messageId: "", contextId: "", taskId: "", role: 0, content: [], metadata: void 0, extensions: [] };
}
var Message3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.messageId !== "") {
      writer.uint32(10).string(message.messageId);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.taskId !== "") {
      writer.uint32(26).string(message.taskId);
    }
    if (message.role !== 0) {
      writer.uint32(32).int32(message.role);
    }
    for (const v of message.content) {
      Part3.encode(v, writer.uint32(42).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    for (const v of message.extensions) {
      writer.uint32(58).string(v);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseMessage();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.messageId = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.taskId = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.role = reader.int32();
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.content.push(Part3.decode(reader, reader.uint32()));
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.extensions.push(reader.string());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseArtifact() {
  return { artifactId: "", name: "", description: "", parts: [], metadata: void 0, extensions: [] };
}
var Artifact3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.artifactId !== "") {
      writer.uint32(10).string(message.artifactId);
    }
    if (message.name !== "") {
      writer.uint32(26).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(34).string(message.description);
    }
    for (const v of message.parts) {
      Part3.encode(v, writer.uint32(42).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    for (const v of message.extensions) {
      writer.uint32(58).string(v);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseArtifact();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.artifactId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.parts.push(Part3.decode(reader, reader.uint32()));
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.extensions.push(reader.string());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskStatusUpdateEvent() {
  return { taskId: "", contextId: "", status: void 0, final: false, metadata: void 0 };
}
var TaskStatusUpdateEvent3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.taskId !== "") {
      writer.uint32(10).string(message.taskId);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.status !== void 0) {
      TaskStatus3.encode(message.status, writer.uint32(26).fork()).join();
    }
    if (message.final !== false) {
      writer.uint32(32).bool(message.final);
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(42).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskStatusUpdateEvent();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.taskId = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.status = TaskStatus3.decode(reader, reader.uint32());
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.final = reader.bool();
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskArtifactUpdateEvent() {
  return { taskId: "", contextId: "", artifact: void 0, append: false, lastChunk: false, metadata: void 0 };
}
var TaskArtifactUpdateEvent3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.taskId !== "") {
      writer.uint32(10).string(message.taskId);
    }
    if (message.contextId !== "") {
      writer.uint32(18).string(message.contextId);
    }
    if (message.artifact !== void 0) {
      Artifact3.encode(message.artifact, writer.uint32(26).fork()).join();
    }
    if (message.append !== false) {
      writer.uint32(32).bool(message.append);
    }
    if (message.lastChunk !== false) {
      writer.uint32(40).bool(message.lastChunk);
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(50).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskArtifactUpdateEvent();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.taskId = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.contextId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.artifact = Artifact3.decode(reader, reader.uint32());
          continue;
        }
        case 4: {
          if (tag !== 32) {
            break;
          }
          message.append = reader.bool();
          continue;
        }
        case 5: {
          if (tag !== 40) {
            break;
          }
          message.lastChunk = reader.bool();
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePushNotificationConfig() {
  return { id: "", url: "", token: "", authentication: void 0 };
}
var PushNotificationConfig3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.url !== "") {
      writer.uint32(18).string(message.url);
    }
    if (message.token !== "") {
      writer.uint32(26).string(message.token);
    }
    if (message.authentication !== void 0) {
      AuthenticationInfo3.encode(message.authentication, writer.uint32(34).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePushNotificationConfig();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.token = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.authentication = AuthenticationInfo3.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAuthenticationInfo() {
  return { schemes: [], credentials: "" };
}
var AuthenticationInfo3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    for (const v of message.schemes) {
      writer.uint32(10).string(v);
    }
    if (message.credentials !== "") {
      writer.uint32(18).string(message.credentials);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAuthenticationInfo();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.schemes.push(reader.string());
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.credentials = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentInterface() {
  return { url: "", transport: "" };
}
var AgentInterface3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.url !== "") {
      writer.uint32(10).string(message.url);
    }
    if (message.transport !== "") {
      writer.uint32(18).string(message.transport);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentInterface();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.transport = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCard() {
  return {
    protocolVersion: "",
    name: "",
    description: "",
    url: "",
    preferredTransport: "",
    additionalInterfaces: [],
    provider: void 0,
    version: "",
    documentationUrl: "",
    capabilities: void 0,
    securitySchemes: {},
    security: [],
    defaultInputModes: [],
    defaultOutputModes: [],
    skills: [],
    supportsAuthenticatedExtendedCard: false,
    signatures: []
  };
}
var AgentCard3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.protocolVersion !== "") {
      writer.uint32(130).string(message.protocolVersion);
    }
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(18).string(message.description);
    }
    if (message.url !== "") {
      writer.uint32(26).string(message.url);
    }
    if (message.preferredTransport !== "") {
      writer.uint32(114).string(message.preferredTransport);
    }
    for (const v of message.additionalInterfaces) {
      AgentInterface3.encode(v, writer.uint32(122).fork()).join();
    }
    if (message.provider !== void 0) {
      AgentProvider3.encode(message.provider, writer.uint32(34).fork()).join();
    }
    if (message.version !== "") {
      writer.uint32(42).string(message.version);
    }
    if (message.documentationUrl !== "") {
      writer.uint32(50).string(message.documentationUrl);
    }
    if (message.capabilities !== void 0) {
      AgentCapabilities3.encode(message.capabilities, writer.uint32(58).fork()).join();
    }
    Object.entries(message.securitySchemes).forEach(([key, value]) => {
      AgentCard_SecuritySchemesEntry.encode({ key, value }, writer.uint32(66).fork()).join();
    });
    for (const v of message.security) {
      Security3.encode(v, writer.uint32(74).fork()).join();
    }
    for (const v of message.defaultInputModes) {
      writer.uint32(82).string(v);
    }
    for (const v of message.defaultOutputModes) {
      writer.uint32(90).string(v);
    }
    for (const v of message.skills) {
      AgentSkill3.encode(v, writer.uint32(98).fork()).join();
    }
    if (message.supportsAuthenticatedExtendedCard !== false) {
      writer.uint32(104).bool(message.supportsAuthenticatedExtendedCard);
    }
    for (const v of message.signatures) {
      AgentCardSignature3.encode(v, writer.uint32(138).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCard();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 16: {
          if (tag !== 130) {
            break;
          }
          message.protocolVersion = reader.string();
          continue;
        }
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 14: {
          if (tag !== 114) {
            break;
          }
          message.preferredTransport = reader.string();
          continue;
        }
        case 15: {
          if (tag !== 122) {
            break;
          }
          message.additionalInterfaces.push(AgentInterface3.decode(reader, reader.uint32()));
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.provider = AgentProvider3.decode(reader, reader.uint32());
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.version = reader.string();
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.documentationUrl = reader.string();
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.capabilities = AgentCapabilities3.decode(reader, reader.uint32());
          continue;
        }
        case 8: {
          if (tag !== 66) {
            break;
          }
          const entry8 = AgentCard_SecuritySchemesEntry.decode(reader, reader.uint32());
          if (entry8.value !== void 0) {
            message.securitySchemes[entry8.key] = entry8.value;
          }
          continue;
        }
        case 9: {
          if (tag !== 74) {
            break;
          }
          message.security.push(Security3.decode(reader, reader.uint32()));
          continue;
        }
        case 10: {
          if (tag !== 82) {
            break;
          }
          message.defaultInputModes.push(reader.string());
          continue;
        }
        case 11: {
          if (tag !== 90) {
            break;
          }
          message.defaultOutputModes.push(reader.string());
          continue;
        }
        case 12: {
          if (tag !== 98) {
            break;
          }
          message.skills.push(AgentSkill3.decode(reader, reader.uint32()));
          continue;
        }
        case 13: {
          if (tag !== 104) {
            break;
          }
          message.supportsAuthenticatedExtendedCard = reader.bool();
          continue;
        }
        case 17: {
          if (tag !== 138) {
            break;
          }
          message.signatures.push(AgentCardSignature3.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCard_SecuritySchemesEntry() {
  return { key: "", value: void 0 };
}
var AgentCard_SecuritySchemesEntry = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== void 0) {
      SecurityScheme3.encode(message.value, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCard_SecuritySchemesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = SecurityScheme3.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentProvider() {
  return { url: "", organization: "" };
}
var AgentProvider3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.url !== "") {
      writer.uint32(10).string(message.url);
    }
    if (message.organization !== "") {
      writer.uint32(18).string(message.organization);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentProvider();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.url = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.organization = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCapabilities() {
  return { streaming: false, pushNotifications: false, extensions: [] };
}
var AgentCapabilities3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.streaming !== false) {
      writer.uint32(8).bool(message.streaming);
    }
    if (message.pushNotifications !== false) {
      writer.uint32(16).bool(message.pushNotifications);
    }
    for (const v of message.extensions) {
      AgentExtension3.encode(v, writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCapabilities();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 8) {
            break;
          }
          message.streaming = reader.bool();
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.pushNotifications = reader.bool();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.extensions.push(AgentExtension3.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentExtension() {
  return { uri: "", description: "", required: false, params: void 0 };
}
var AgentExtension3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.uri !== "") {
      writer.uint32(10).string(message.uri);
    }
    if (message.description !== "") {
      writer.uint32(18).string(message.description);
    }
    if (message.required !== false) {
      writer.uint32(24).bool(message.required);
    }
    if (message.params !== void 0) {
      Struct.encode(Struct.wrap(message.params), writer.uint32(34).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentExtension();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.uri = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 24) {
            break;
          }
          message.required = reader.bool();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.params = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentSkill() {
  return { id: "", name: "", description: "", tags: [], examples: [], inputModes: [], outputModes: [], security: [] };
}
var AgentSkill3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.name !== "") {
      writer.uint32(18).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(26).string(message.description);
    }
    for (const v of message.tags) {
      writer.uint32(34).string(v);
    }
    for (const v of message.examples) {
      writer.uint32(42).string(v);
    }
    for (const v of message.inputModes) {
      writer.uint32(50).string(v);
    }
    for (const v of message.outputModes) {
      writer.uint32(58).string(v);
    }
    for (const v of message.security) {
      Security3.encode(v, writer.uint32(66).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentSkill();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.tags.push(reader.string());
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.examples.push(reader.string());
          continue;
        }
        case 6: {
          if (tag !== 50) {
            break;
          }
          message.inputModes.push(reader.string());
          continue;
        }
        case 7: {
          if (tag !== 58) {
            break;
          }
          message.outputModes.push(reader.string());
          continue;
        }
        case 8: {
          if (tag !== 66) {
            break;
          }
          message.security.push(Security3.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAgentCardSignature() {
  return { protected: "", signature: "", header: void 0 };
}
var AgentCardSignature3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.protected !== "") {
      writer.uint32(10).string(message.protected);
    }
    if (message.signature !== "") {
      writer.uint32(18).string(message.signature);
    }
    if (message.header !== void 0) {
      Struct.encode(Struct.wrap(message.header), writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAgentCardSignature();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.protected = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.signature = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.header = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskPushNotificationConfig() {
  return { name: "", pushNotificationConfig: void 0 };
}
var TaskPushNotificationConfig3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.pushNotificationConfig !== void 0) {
      PushNotificationConfig3.encode(message.pushNotificationConfig, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskPushNotificationConfig();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.pushNotificationConfig = PushNotificationConfig3.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseStringList() {
  return { list: [] };
}
var StringList = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    for (const v of message.list) {
      writer.uint32(10).string(v);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStringList();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.list.push(reader.string());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSecurity() {
  return { schemes: {} };
}
var Security3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    Object.entries(message.schemes).forEach(([key, value]) => {
      Security_SchemesEntry.encode({ key, value }, writer.uint32(10).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSecurity();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          const entry1 = Security_SchemesEntry.decode(reader, reader.uint32());
          if (entry1.value !== void 0) {
            message.schemes[entry1.key] = entry1.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSecurity_SchemesEntry() {
  return { key: "", value: void 0 };
}
var Security_SchemesEntry = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== void 0) {
      StringList.encode(message.value, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSecurity_SchemesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = StringList.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSecurityScheme() {
  return { scheme: void 0 };
}
var SecurityScheme3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    switch (message.scheme?.$case) {
      case "apiKeySecurityScheme":
        APIKeySecurityScheme.encode(message.scheme.value, writer.uint32(10).fork()).join();
        break;
      case "httpAuthSecurityScheme":
        HTTPAuthSecurityScheme.encode(message.scheme.value, writer.uint32(18).fork()).join();
        break;
      case "oauth2SecurityScheme":
        OAuth2SecurityScheme.encode(message.scheme.value, writer.uint32(26).fork()).join();
        break;
      case "openIdConnectSecurityScheme":
        OpenIdConnectSecurityScheme.encode(message.scheme.value, writer.uint32(34).fork()).join();
        break;
      case "mtlsSecurityScheme":
        MutualTlsSecurityScheme.encode(message.scheme.value, writer.uint32(42).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.scheme = {
            $case: "apiKeySecurityScheme",
            value: APIKeySecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.scheme = {
            $case: "httpAuthSecurityScheme",
            value: HTTPAuthSecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.scheme = {
            $case: "oauth2SecurityScheme",
            value: OAuth2SecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.scheme = {
            $case: "openIdConnectSecurityScheme",
            value: OpenIdConnectSecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
        case 5: {
          if (tag !== 42) {
            break;
          }
          message.scheme = {
            $case: "mtlsSecurityScheme",
            value: MutualTlsSecurityScheme.decode(reader, reader.uint32())
          };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAPIKeySecurityScheme() {
  return { description: "", location: "", name: "" };
}
var APIKeySecurityScheme = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.location !== "") {
      writer.uint32(18).string(message.location);
    }
    if (message.name !== "") {
      writer.uint32(26).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAPIKeySecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.location = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseHTTPAuthSecurityScheme() {
  return { description: "", scheme: "", bearerFormat: "" };
}
var HTTPAuthSecurityScheme = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.scheme !== "") {
      writer.uint32(18).string(message.scheme);
    }
    if (message.bearerFormat !== "") {
      writer.uint32(26).string(message.bearerFormat);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseHTTPAuthSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.scheme = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.bearerFormat = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseOAuth2SecurityScheme() {
  return { description: "", flows: void 0, oauth2MetadataUrl: "" };
}
var OAuth2SecurityScheme = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.flows !== void 0) {
      OAuthFlows3.encode(message.flows, writer.uint32(18).fork()).join();
    }
    if (message.oauth2MetadataUrl !== "") {
      writer.uint32(26).string(message.oauth2MetadataUrl);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseOAuth2SecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.flows = OAuthFlows3.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.oauth2MetadataUrl = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseOpenIdConnectSecurityScheme() {
  return { description: "", openIdConnectUrl: "" };
}
var OpenIdConnectSecurityScheme = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    if (message.openIdConnectUrl !== "") {
      writer.uint32(18).string(message.openIdConnectUrl);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseOpenIdConnectSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.openIdConnectUrl = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseMutualTlsSecurityScheme() {
  return { description: "" };
}
var MutualTlsSecurityScheme = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.description !== "") {
      writer.uint32(10).string(message.description);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseMutualTlsSecurityScheme();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.description = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseOAuthFlows() {
  return { flow: void 0 };
}
var OAuthFlows3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    switch (message.flow?.$case) {
      case "authorizationCode":
        AuthorizationCodeOAuthFlow.encode(message.flow.value, writer.uint32(10).fork()).join();
        break;
      case "clientCredentials":
        ClientCredentialsOAuthFlow.encode(message.flow.value, writer.uint32(18).fork()).join();
        break;
      case "implicit":
        ImplicitOAuthFlow.encode(message.flow.value, writer.uint32(26).fork()).join();
        break;
      case "password":
        PasswordOAuthFlow.encode(message.flow.value, writer.uint32(34).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseOAuthFlows();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.flow = {
            $case: "authorizationCode",
            value: AuthorizationCodeOAuthFlow.decode(reader, reader.uint32())
          };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.flow = {
            $case: "clientCredentials",
            value: ClientCredentialsOAuthFlow.decode(reader, reader.uint32())
          };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.flow = { $case: "implicit", value: ImplicitOAuthFlow.decode(reader, reader.uint32()) };
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.flow = { $case: "password", value: PasswordOAuthFlow.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAuthorizationCodeOAuthFlow() {
  return { authorizationUrl: "", tokenUrl: "", refreshUrl: "", scopes: {} };
}
var AuthorizationCodeOAuthFlow = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.authorizationUrl !== "") {
      writer.uint32(10).string(message.authorizationUrl);
    }
    if (message.tokenUrl !== "") {
      writer.uint32(18).string(message.tokenUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(26).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      AuthorizationCodeOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(34).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAuthorizationCodeOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.authorizationUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.tokenUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          const entry4 = AuthorizationCodeOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry4.value !== void 0) {
            message.scopes[entry4.key] = entry4.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseAuthorizationCodeOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var AuthorizationCodeOAuthFlow_ScopesEntry = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseAuthorizationCodeOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseClientCredentialsOAuthFlow() {
  return { tokenUrl: "", refreshUrl: "", scopes: {} };
}
var ClientCredentialsOAuthFlow = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.tokenUrl !== "") {
      writer.uint32(10).string(message.tokenUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(18).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      ClientCredentialsOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(26).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseClientCredentialsOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.tokenUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          const entry3 = ClientCredentialsOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry3.value !== void 0) {
            message.scopes[entry3.key] = entry3.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseClientCredentialsOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var ClientCredentialsOAuthFlow_ScopesEntry = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseClientCredentialsOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseImplicitOAuthFlow() {
  return { authorizationUrl: "", refreshUrl: "", scopes: {} };
}
var ImplicitOAuthFlow = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.authorizationUrl !== "") {
      writer.uint32(10).string(message.authorizationUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(18).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      ImplicitOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(26).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseImplicitOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.authorizationUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          const entry3 = ImplicitOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry3.value !== void 0) {
            message.scopes[entry3.key] = entry3.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseImplicitOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var ImplicitOAuthFlow_ScopesEntry = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseImplicitOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePasswordOAuthFlow() {
  return { tokenUrl: "", refreshUrl: "", scopes: {} };
}
var PasswordOAuthFlow = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.tokenUrl !== "") {
      writer.uint32(10).string(message.tokenUrl);
    }
    if (message.refreshUrl !== "") {
      writer.uint32(18).string(message.refreshUrl);
    }
    Object.entries(message.scopes).forEach(([key, value]) => {
      PasswordOAuthFlow_ScopesEntry.encode({ key, value }, writer.uint32(26).fork()).join();
    });
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePasswordOAuthFlow();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.tokenUrl = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.refreshUrl = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          const entry3 = PasswordOAuthFlow_ScopesEntry.decode(reader, reader.uint32());
          if (entry3.value !== void 0) {
            message.scopes[entry3.key] = entry3.value;
          }
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePasswordOAuthFlow_ScopesEntry() {
  return { key: "", value: "" };
}
var PasswordOAuthFlow_ScopesEntry = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePasswordOAuthFlow_ScopesEntry();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSendMessageRequest() {
  return { request: void 0, configuration: void 0, metadata: void 0 };
}
var SendMessageRequest3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.request !== void 0) {
      Message3.encode(message.request, writer.uint32(10).fork()).join();
    }
    if (message.configuration !== void 0) {
      SendMessageConfiguration3.encode(message.configuration, writer.uint32(18).fork()).join();
    }
    if (message.metadata !== void 0) {
      Struct.encode(Struct.wrap(message.metadata), writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSendMessageRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.request = Message3.decode(reader, reader.uint32());
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.configuration = SendMessageConfiguration3.decode(reader, reader.uint32());
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.metadata = Struct.unwrap(Struct.decode(reader, reader.uint32()));
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetTaskRequest() {
  return { name: "", historyLength: 0 };
}
var GetTaskRequest3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.historyLength !== 0) {
      writer.uint32(16).int32(message.historyLength);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetTaskRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.historyLength = reader.int32();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCancelTaskRequest() {
  return { name: "" };
}
var CancelTaskRequest3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCancelTaskRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetTaskPushNotificationConfigRequest() {
  return { name: "" };
}
var GetTaskPushNotificationConfigRequest3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseDeleteTaskPushNotificationConfigRequest() {
  return { name: "" };
}
var DeleteTaskPushNotificationConfigRequest3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseDeleteTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCreateTaskPushNotificationConfigRequest() {
  return { parent: "", configId: "", config: void 0 };
}
var CreateTaskPushNotificationConfigRequest3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.parent !== "") {
      writer.uint32(10).string(message.parent);
    }
    if (message.configId !== "") {
      writer.uint32(18).string(message.configId);
    }
    if (message.config !== void 0) {
      TaskPushNotificationConfig3.encode(message.config, writer.uint32(26).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCreateTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.parent = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.configId = reader.string();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.config = TaskPushNotificationConfig3.decode(reader, reader.uint32());
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseTaskSubscriptionRequest() {
  return { name: "" };
}
var TaskSubscriptionRequest2 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseTaskSubscriptionRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.name = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseListTaskPushNotificationConfigRequest() {
  return { parent: "", pageSize: 0, pageToken: "" };
}
var ListTaskPushNotificationConfigRequest3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    if (message.parent !== "") {
      writer.uint32(10).string(message.parent);
    }
    if (message.pageSize !== 0) {
      writer.uint32(16).int32(message.pageSize);
    }
    if (message.pageToken !== "") {
      writer.uint32(26).string(message.pageToken);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseListTaskPushNotificationConfigRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.parent = reader.string();
          continue;
        }
        case 2: {
          if (tag !== 16) {
            break;
          }
          message.pageSize = reader.int32();
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.pageToken = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetAgentCardRequest() {
  return {};
}
var GetAgentCardRequest2 = {
  encode(_, writer = new import_wire4.BinaryWriter()) {
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetAgentCardRequest();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSendMessageResponse() {
  return { payload: void 0 };
}
var SendMessageResponse3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    switch (message.payload?.$case) {
      case "task":
        Task3.encode(message.payload.value, writer.uint32(10).fork()).join();
        break;
      case "msg":
        Message3.encode(message.payload.value, writer.uint32(18).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSendMessageResponse();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.payload = { $case: "task", value: Task3.decode(reader, reader.uint32()) };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.payload = { $case: "msg", value: Message3.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseStreamResponse() {
  return { payload: void 0 };
}
var StreamResponse3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    switch (message.payload?.$case) {
      case "task":
        Task3.encode(message.payload.value, writer.uint32(10).fork()).join();
        break;
      case "msg":
        Message3.encode(message.payload.value, writer.uint32(18).fork()).join();
        break;
      case "statusUpdate":
        TaskStatusUpdateEvent3.encode(message.payload.value, writer.uint32(26).fork()).join();
        break;
      case "artifactUpdate":
        TaskArtifactUpdateEvent3.encode(message.payload.value, writer.uint32(34).fork()).join();
        break;
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseStreamResponse();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.payload = { $case: "task", value: Task3.decode(reader, reader.uint32()) };
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.payload = { $case: "msg", value: Message3.decode(reader, reader.uint32()) };
          continue;
        }
        case 3: {
          if (tag !== 26) {
            break;
          }
          message.payload = { $case: "statusUpdate", value: TaskStatusUpdateEvent3.decode(reader, reader.uint32()) };
          continue;
        }
        case 4: {
          if (tag !== 34) {
            break;
          }
          message.payload = { $case: "artifactUpdate", value: TaskArtifactUpdateEvent3.decode(reader, reader.uint32()) };
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseListTaskPushNotificationConfigResponse() {
  return { configs: [], nextPageToken: "" };
}
var ListTaskPushNotificationConfigResponse3 = {
  encode(message, writer = new import_wire4.BinaryWriter()) {
    for (const v of message.configs) {
      TaskPushNotificationConfig3.encode(v, writer.uint32(10).fork()).join();
    }
    if (message.nextPageToken !== "") {
      writer.uint32(18).string(message.nextPageToken);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof import_wire4.BinaryReader ? input : new import_wire4.BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseListTaskPushNotificationConfigResponse();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1: {
          if (tag !== 10) {
            break;
          }
          message.configs.push(TaskPushNotificationConfig3.decode(reader, reader.uint32()));
          continue;
        }
        case 2: {
          if (tag !== 18) {
            break;
          }
          message.nextPageToken = reader.string();
          continue;
        }
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
var A2AServiceService = {
  /**
   * Send a message to the agent. This is a blocking call that will return the
   * task once it is completed, or a LRO if requested.
   */
  sendMessage: {
    path: "/a2a.v1.A2AService/SendMessage",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(SendMessageRequest3.encode(value).finish()),
    requestDeserialize: (value) => SendMessageRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(SendMessageResponse3.encode(value).finish()),
    responseDeserialize: (value) => SendMessageResponse3.decode(value)
  },
  /**
   * SendStreamingMessage is a streaming call that will return a stream of
   * task update events until the Task is in an interrupted or terminal state.
   */
  sendStreamingMessage: {
    path: "/a2a.v1.A2AService/SendStreamingMessage",
    requestStream: false,
    responseStream: true,
    requestSerialize: (value) => Buffer.from(SendMessageRequest3.encode(value).finish()),
    requestDeserialize: (value) => SendMessageRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(StreamResponse3.encode(value).finish()),
    responseDeserialize: (value) => StreamResponse3.decode(value)
  },
  /** Get the current state of a task from the agent. */
  getTask: {
    path: "/a2a.v1.A2AService/GetTask",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(GetTaskRequest3.encode(value).finish()),
    requestDeserialize: (value) => GetTaskRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(Task3.encode(value).finish()),
    responseDeserialize: (value) => Task3.decode(value)
  },
  /**
   * Cancel a task from the agent. If supported one should expect no
   * more task updates for the task.
   */
  cancelTask: {
    path: "/a2a.v1.A2AService/CancelTask",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(CancelTaskRequest3.encode(value).finish()),
    requestDeserialize: (value) => CancelTaskRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(Task3.encode(value).finish()),
    responseDeserialize: (value) => Task3.decode(value)
  },
  /**
   * TaskSubscription is a streaming call that will return a stream of task
   * update events. This attaches the stream to an existing in process task.
   * If the task is complete the stream will return the completed task (like
   * GetTask) and close the stream.
   */
  taskSubscription: {
    path: "/a2a.v1.A2AService/TaskSubscription",
    requestStream: false,
    responseStream: true,
    requestSerialize: (value) => Buffer.from(TaskSubscriptionRequest2.encode(value).finish()),
    requestDeserialize: (value) => TaskSubscriptionRequest2.decode(value),
    responseSerialize: (value) => Buffer.from(StreamResponse3.encode(value).finish()),
    responseDeserialize: (value) => StreamResponse3.decode(value)
  },
  /** Set a push notification config for a task. */
  createTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/CreateTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(CreateTaskPushNotificationConfigRequest3.encode(value).finish()),
    requestDeserialize: (value) => CreateTaskPushNotificationConfigRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(TaskPushNotificationConfig3.encode(value).finish()),
    responseDeserialize: (value) => TaskPushNotificationConfig3.decode(value)
  },
  /** Get a push notification config for a task. */
  getTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/GetTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(GetTaskPushNotificationConfigRequest3.encode(value).finish()),
    requestDeserialize: (value) => GetTaskPushNotificationConfigRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(TaskPushNotificationConfig3.encode(value).finish()),
    responseDeserialize: (value) => TaskPushNotificationConfig3.decode(value)
  },
  /** Get a list of push notifications configured for a task. */
  listTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/ListTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(ListTaskPushNotificationConfigRequest3.encode(value).finish()),
    requestDeserialize: (value) => ListTaskPushNotificationConfigRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(ListTaskPushNotificationConfigResponse3.encode(value).finish()),
    responseDeserialize: (value) => ListTaskPushNotificationConfigResponse3.decode(value)
  },
  /** GetAgentCard returns the agent card for the agent. */
  getAgentCard: {
    path: "/a2a.v1.A2AService/GetAgentCard",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(GetAgentCardRequest2.encode(value).finish()),
    requestDeserialize: (value) => GetAgentCardRequest2.decode(value),
    responseSerialize: (value) => Buffer.from(AgentCard3.encode(value).finish()),
    responseDeserialize: (value) => AgentCard3.decode(value)
  },
  /** Delete a push notification config for a task. */
  deleteTaskPushNotificationConfig: {
    path: "/a2a.v1.A2AService/DeleteTaskPushNotificationConfig",
    requestStream: false,
    responseStream: false,
    requestSerialize: (value) => Buffer.from(DeleteTaskPushNotificationConfigRequest3.encode(value).finish()),
    requestDeserialize: (value) => DeleteTaskPushNotificationConfigRequest3.decode(value),
    responseSerialize: (value) => Buffer.from(Empty.encode(value).finish()),
    responseDeserialize: (value) => Empty.decode(value)
  }
};
var A2AServiceClient = (0, import_grpc_js.makeGenericClientConstructor)(A2AServiceService, "a2a.v1.A2AService");
function toTimestamp(dateStr) {
  const date = new globalThis.Date(dateStr);
  const seconds = Math.trunc(date.getTime() / 1e3);
  const nanos = date.getTime() % 1e3 * 1e6;
  return { seconds, nanos };
}
function fromTimestamp(t) {
  let millis = (t.seconds || 0) * 1e3;
  millis += (t.nanos || 0) / 1e6;
  return new globalThis.Date(millis).toISOString();
}

// src/server/authentication/user.ts
var UnauthenticatedUser = class {
  get isAuthenticated() {
    return false;
  }
  get userName() {
    return "";
  }
};

// src/server/grpc/common.ts
var UserBuilder = {
  noAuthentication: () => Promise.resolve(new UnauthenticatedUser())
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  A2AService,
  UserBuilder,
  grpcService
});
