/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import * as path from 'node:path';
import { homedir } from '@google/gemini-cli-core';
export function resolvePath(p) {
    if (!p) {
        return '';
    }
    let expandedPath = p;
    if (p.toLowerCase().startsWith('%userprofile%')) {
        expandedPath = homedir() + p.substring('%userprofile%'.length);
    }
    else if (p === '~' || p.startsWith('~/')) {
        expandedPath = homedir() + p.substring(1);
    }
    return path.normalize(expandedPath);
}
//# sourceMappingURL=resolvePath.js.map