import { z } from "zod/v4";
/**
 * Describes an available authentication method.
 */
export declare const zAuthMethod: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
/**
 * Request parameters for the authenticate method.
 *
 * Specifies which authentication method to use.
 */
export declare const zAuthenticateRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    methodId: z.ZodString;
}, z.core.$strip>;
/**
 * Response to the `authenticate` method.
 */
export declare const zAuthenticateResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Binary resource contents.
 */
export declare const zBlobResourceContents: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    blob: z.ZodString;
    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    uri: z.ZodString;
}, z.core.$strip>;
/**
 * Response containing the ID of the created terminal.
 */
export declare const zCreateTerminalResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    terminalId: z.ZodString;
}, z.core.$strip>;
/**
 * A diff representing file modifications.
 *
 * Shows changes to files in a format suitable for display in the client UI.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/tool-calls#content)
 */
export declare const zDiff: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    newText: z.ZodString;
    oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    path: z.ZodString;
}, z.core.$strip>;
/**
 * An environment variable to set when launching an MCP server.
 */
export declare const zEnvVariable: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    name: z.ZodString;
    value: z.ZodString;
}, z.core.$strip>;
/**
 * Predefined error codes for common JSON-RPC and ACP-specific errors.
 *
 * These codes follow the JSON-RPC 2.0 specification for standard errors
 * and use the reserved range (-32000 to -32099) for protocol-specific errors.
 */
export declare const zErrorCode: z.ZodUnion<readonly [z.ZodLiteral<-32700>, z.ZodLiteral<-32600>, z.ZodLiteral<-32601>, z.ZodLiteral<-32602>, z.ZodLiteral<-32603>, z.ZodLiteral<-32800>, z.ZodLiteral<-32000>, z.ZodLiteral<-32002>, z.ZodNumber]>;
/**
 * JSON-RPC error object.
 *
 * Represents an error that occurred during method execution, following the
 * JSON-RPC 2.0 error object specification with optional additional data.
 *
 * See protocol docs: [JSON-RPC Error Object](https://www.jsonrpc.org/specification#error_object)
 */
export declare const zError: z.ZodObject<{
    code: z.ZodUnion<readonly [z.ZodLiteral<-32700>, z.ZodLiteral<-32600>, z.ZodLiteral<-32601>, z.ZodLiteral<-32602>, z.ZodLiteral<-32603>, z.ZodLiteral<-32800>, z.ZodLiteral<-32000>, z.ZodLiteral<-32002>, z.ZodNumber]>;
    data: z.ZodOptional<z.ZodUnknown>;
    message: z.ZodString;
}, z.core.$strip>;
/**
 * Allows the Agent to send an arbitrary notification that is not part of the ACP spec.
 * Extension notifications provide a way to send one-way messages for custom functionality
 * while maintaining protocol compatibility.
 *
 * See protocol docs: [Extensibility](https://agentclientprotocol.com/protocol/extensibility)
 */
export declare const zExtNotification: z.ZodUnknown;
/**
 * Allows for sending an arbitrary request that is not part of the ACP spec.
 * Extension methods provide a way to add custom functionality while maintaining
 * protocol compatibility.
 *
 * See protocol docs: [Extensibility](https://agentclientprotocol.com/protocol/extensibility)
 */
export declare const zExtRequest: z.ZodUnknown;
/**
 * Allows for sending an arbitrary response to an [`ExtRequest`] that is not part of the ACP spec.
 * Extension methods provide a way to add custom functionality while maintaining
 * protocol compatibility.
 *
 * See protocol docs: [Extensibility](https://agentclientprotocol.com/protocol/extensibility)
 */
export declare const zExtResponse: z.ZodUnknown;
/**
 * Filesystem capabilities supported by the client.
 * File system capabilities that a client may support.
 *
 * See protocol docs: [FileSystem](https://agentclientprotocol.com/protocol/initialization#filesystem)
 */
export declare const zFileSystemCapability: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    readTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    writeTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
}, z.core.$strip>;
/**
 * Capabilities supported by the client.
 *
 * Advertised during initialization to inform the agent about
 * available features and methods.
 *
 * See protocol docs: [Client Capabilities](https://agentclientprotocol.com/protocol/initialization#client-capabilities)
 */
export declare const zClientCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    fs: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        readTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        writeTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    }, z.core.$strip>>>;
    terminal: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
}, z.core.$strip>;
/**
 * An HTTP header to set when making requests to the MCP server.
 */
export declare const zHttpHeader: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    name: z.ZodString;
    value: z.ZodString;
}, z.core.$strip>;
/**
 * Metadata about the implementation of the client or agent.
 * Describes the name and version of an MCP implementation, with an optional
 * title for UI representation.
 */
export declare const zImplementation: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    name: z.ZodString;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    version: z.ZodString;
}, z.core.$strip>;
/**
 * Response to terminal/kill command method
 */
export declare const zKillTerminalCommandResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for listing existing sessions.
 *
 * Only available if the Agent supports the `listSessions` capability.
 *
 * @experimental
 */
export declare const zListSessionsRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    cursor: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    cwd: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * MCP capabilities supported by the agent
 */
export declare const zMcpCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    http: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    sse: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
}, z.core.$strip>;
/**
 * HTTP transport configuration for MCP.
 */
export declare const zMcpServerHttp: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    headers: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
    name: z.ZodString;
    url: z.ZodString;
}, z.core.$strip>;
/**
 * SSE transport configuration for MCP.
 */
export declare const zMcpServerSse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    headers: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
    name: z.ZodString;
    url: z.ZodString;
}, z.core.$strip>;
/**
 * Stdio transport configuration for MCP.
 */
export declare const zMcpServerStdio: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    args: z.ZodArray<z.ZodString>;
    command: z.ZodString;
    env: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
    name: z.ZodString;
}, z.core.$strip>;
/**
 * Configuration for connecting to an MCP (Model Context Protocol) server.
 *
 * MCP servers provide tools and context that the agent can use when
 * processing prompts.
 *
 * See protocol docs: [MCP Servers](https://agentclientprotocol.com/protocol/session-setup#mcp-servers)
 */
export declare const zMcpServer: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    headers: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
    name: z.ZodString;
    url: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"http">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    headers: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
    name: z.ZodString;
    url: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"sse">;
}, z.core.$strip>>, z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    args: z.ZodArray<z.ZodString>;
    command: z.ZodString;
    env: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
    name: z.ZodString;
}, z.core.$strip>]>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A unique identifier for a model.
 *
 * @experimental
 */
export declare const zModelId: z.ZodString;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Information about a selectable model.
 *
 * @experimental
 */
export declare const zModelInfo: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    modelId: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
/**
 * Request parameters for creating a new session.
 *
 * See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
 */
export declare const zNewSessionRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    cwd: z.ZodString;
    mcpServers: z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"http">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"sse">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        args: z.ZodArray<z.ZodString>;
        command: z.ZodString;
        env: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
    }, z.core.$strip>]>>;
}, z.core.$strip>;
/**
 * Unique identifier for a permission option.
 */
export declare const zPermissionOptionId: z.ZodString;
/**
 * The type of permission option being presented to the user.
 *
 * Helps clients choose appropriate icons and UI treatment.
 */
export declare const zPermissionOptionKind: z.ZodUnion<readonly [z.ZodLiteral<"allow_once">, z.ZodLiteral<"allow_always">, z.ZodLiteral<"reject_once">, z.ZodLiteral<"reject_always">]>;
/**
 * An option presented to the user when requesting permission.
 */
export declare const zPermissionOption: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    kind: z.ZodUnion<readonly [z.ZodLiteral<"allow_once">, z.ZodLiteral<"allow_always">, z.ZodLiteral<"reject_once">, z.ZodLiteral<"reject_always">]>;
    name: z.ZodString;
    optionId: z.ZodString;
}, z.core.$strip>;
/**
 * Priority levels for plan entries.
 *
 * Used to indicate the relative importance or urgency of different
 * tasks in the execution plan.
 * See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
 */
export declare const zPlanEntryPriority: z.ZodUnion<readonly [z.ZodLiteral<"high">, z.ZodLiteral<"medium">, z.ZodLiteral<"low">]>;
/**
 * Status of a plan entry in the execution flow.
 *
 * Tracks the lifecycle of each task from planning through completion.
 * See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
 */
export declare const zPlanEntryStatus: z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">]>;
/**
 * A single entry in the execution plan.
 *
 * Represents a task or goal that the assistant intends to accomplish
 * as part of fulfilling the user's request.
 * See protocol docs: [Plan Entries](https://agentclientprotocol.com/protocol/agent-plan#plan-entries)
 */
export declare const zPlanEntry: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodString;
    priority: z.ZodUnion<readonly [z.ZodLiteral<"high">, z.ZodLiteral<"medium">, z.ZodLiteral<"low">]>;
    status: z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">]>;
}, z.core.$strip>;
/**
 * An execution plan for accomplishing complex tasks.
 *
 * Plans consist of multiple entries representing individual tasks or goals.
 * Agents report plans to clients to provide visibility into their execution strategy.
 * Plans can evolve during execution as the agent discovers new requirements or completes tasks.
 *
 * See protocol docs: [Agent Plan](https://agentclientprotocol.com/protocol/agent-plan)
 */
export declare const zPlan: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    entries: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodString;
        priority: z.ZodUnion<readonly [z.ZodLiteral<"high">, z.ZodLiteral<"medium">, z.ZodLiteral<"low">]>;
        status: z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">]>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * Prompt capabilities supported by the agent in `session/prompt` requests.
 *
 * Baseline agent functionality requires support for [`ContentBlock::Text`]
 * and [`ContentBlock::ResourceLink`] in prompt requests.
 *
 * Other variants must be explicitly opted in to.
 * Capabilities for different types of content in prompt requests.
 *
 * Indicates which content types beyond the baseline (text and resource links)
 * the agent can process.
 *
 * See protocol docs: [Prompt Capabilities](https://agentclientprotocol.com/protocol/initialization#prompt-capabilities)
 */
export declare const zPromptCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    audio: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    embeddedContext: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    image: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
}, z.core.$strip>;
/**
 * Protocol version identifier.
 *
 * This version is only bumped for breaking changes.
 * Non-breaking changes should be introduced via capabilities.
 */
export declare const zProtocolVersion: z.ZodNumber;
/**
 * Request parameters for the initialize method.
 *
 * Sent by the client to establish connection and negotiate capabilities.
 *
 * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
 */
export declare const zInitializeRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    clientCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        fs: z.ZodDefault<z.ZodOptional<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            readTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            writeTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        }, z.core.$strip>>>;
        terminal: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    }, z.core.$strip>>>;
    clientInfo: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        version: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    protocolVersion: z.ZodNumber;
}, z.core.$strip>;
/**
 * Response containing the contents of a text file.
 */
export declare const zReadTextFileResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodString;
}, z.core.$strip>;
/**
 * Response to terminal/release method
 */
export declare const zReleaseTerminalResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * JSON RPC Request Id
 *
 * An identifier established by the Client that MUST contain a String, Number, or NULL value if included. If it is not included it is assumed to be a notification. The value SHOULD normally not be Null [1] and Numbers SHOULD NOT contain fractional parts [2]
 *
 * The Server MUST reply with the same value in the Response object if included. This member is used to correlate the context between the two objects.
 *
 * [1] The use of Null as a value for the id member in a Request object is discouraged, because this specification uses a value of Null for Responses with an unknown id. Also, because JSON-RPC 1.0 uses an id value of Null for Notifications this could cause confusion in handling.
 *
 * [2] Fractional parts may be problematic, since many decimal fractions cannot be represented exactly as binary fractions.
 */
export declare const zRequestId: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Notification to cancel an ongoing request.
 *
 * See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/cancellation)
 *
 * @experimental
 */
export declare const zCancelRequestNotification: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    requestId: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
}, z.core.$strip>;
/**
 * The sender or recipient of messages and data in a conversation.
 */
export declare const zRole: z.ZodEnum<{
    assistant: "assistant";
    user: "user";
}>;
/**
 * Optional annotations for the client. The client can use annotations to inform how objects are used or displayed
 */
export declare const zAnnotations: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
        assistant: "assistant";
        user: "user";
    }>>, z.ZodNull]>>;
    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Audio provided to or from an LLM.
 */
export declare const zAudioContent: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    data: z.ZodString;
    mimeType: z.ZodString;
}, z.core.$strip>;
/**
 * An image provided to or from an LLM.
 */
export declare const zImageContent: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    data: z.ZodString;
    mimeType: z.ZodString;
    uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * A resource that the server is capable of reading, included in a prompt or tool call result.
 */
export declare const zResourceLink: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    name: z.ZodString;
    size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    uri: z.ZodString;
}, z.core.$strip>;
/**
 * The user selected one of the provided options.
 */
export declare const zSelectedPermissionOutcome: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    optionId: z.ZodString;
}, z.core.$strip>;
/**
 * The outcome of a permission request.
 */
export declare const zRequestPermissionOutcome: z.ZodUnion<readonly [z.ZodObject<{
    outcome: z.ZodLiteral<"cancelled">;
}, z.core.$strip>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    optionId: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    outcome: z.ZodLiteral<"selected">;
}, z.core.$strip>>]>;
/**
 * Response to a permission request.
 */
export declare const zRequestPermissionResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    outcome: z.ZodUnion<readonly [z.ZodObject<{
        outcome: z.ZodLiteral<"cancelled">;
    }, z.core.$strip>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        optionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        outcome: z.ZodLiteral<"selected">;
    }, z.core.$strip>>]>;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Unique identifier for a session configuration option value group.
 *
 * @experimental
 */
export declare const zSessionConfigGroupId: z.ZodString;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Unique identifier for a session configuration option.
 *
 * @experimental
 */
export declare const zSessionConfigId: z.ZodString;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Unique identifier for a session configuration option value.
 *
 * @experimental
 */
export declare const zSessionConfigValueId: z.ZodString;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A possible value for a session configuration option.
 *
 * @experimental
 */
export declare const zSessionConfigSelectOption: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    name: z.ZodString;
    value: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A group of possible values for a session configuration option.
 *
 * @experimental
 */
export declare const zSessionConfigSelectGroup: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    group: z.ZodString;
    name: z.ZodString;
    options: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Possible values for a session configuration option.
 *
 * @experimental
 */
export declare const zSessionConfigSelectOptions: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    name: z.ZodString;
    value: z.ZodString;
}, z.core.$strip>>, z.ZodArray<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    group: z.ZodString;
    name: z.ZodString;
    options: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>>]>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * A single-value selector (dropdown) session configuration option payload.
 *
 * @experimental
 */
export declare const zSessionConfigSelect: z.ZodObject<{
    currentValue: z.ZodString;
    options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        group: z.ZodString;
        name: z.ZodString;
        options: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>>]>;
}, z.core.$strip>;
export declare const zSessionConfigOption: z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
    currentValue: z.ZodString;
    options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        group: z.ZodString;
        name: z.ZodString;
        options: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>>]>;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"select">;
}, z.core.$strip>>, z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Session configuration options have been updated.
 *
 * @experimental
 */
export declare const zConfigOptionUpdate: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configOptions: z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        currentValue: z.ZodString;
        options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            group: z.ZodString;
            name: z.ZodString;
            options: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"select">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Capabilities for the `session/fork` method.
 *
 * By supplying `{}` it means that the agent supports forking of sessions.
 *
 * @experimental
 */
export declare const zSessionForkCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * A unique identifier for a conversation session between a client and agent.
 *
 * Sessions maintain their own context, conversation history, and state,
 * allowing multiple independent interactions with the same agent.
 *
 * See protocol docs: [Session ID](https://agentclientprotocol.com/protocol/session-setup#session-id)
 */
export declare const zSessionId: z.ZodString;
/**
 * Notification to cancel ongoing operations for a session.
 *
 * See protocol docs: [Cancellation](https://agentclientprotocol.com/protocol/prompt-turn#cancellation)
 */
export declare const zCancelNotification: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
export declare const zClientNotification: z.ZodObject<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodUnknown]>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Request to create a new terminal and execute a command.
 */
export declare const zCreateTerminalRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    args: z.ZodOptional<z.ZodArray<z.ZodString>>;
    command: z.ZodString;
    cwd: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    env: z.ZodOptional<z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>>>;
    outputByteLimit: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for forking an existing session.
 *
 * Creates a new session based on the context of an existing one, allowing
 * operations like generating summaries without affecting the original session's history.
 *
 * Only available if the Agent supports the `session.fork` capability.
 *
 * @experimental
 */
export declare const zForkSessionRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    cwd: z.ZodString;
    mcpServers: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"http">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"sse">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        args: z.ZodArray<z.ZodString>;
        command: z.ZodString;
        env: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
    }, z.core.$strip>]>>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * Request to kill a terminal command without releasing the terminal.
 */
export declare const zKillTerminalCommandRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    sessionId: z.ZodString;
    terminalId: z.ZodString;
}, z.core.$strip>;
/**
 * Request parameters for loading an existing session.
 *
 * Only available if the Agent supports the `loadSession` capability.
 *
 * See protocol docs: [Loading Sessions](https://agentclientprotocol.com/protocol/session-setup#loading-sessions)
 */
export declare const zLoadSessionRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    cwd: z.ZodString;
    mcpServers: z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"http">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"sse">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        args: z.ZodArray<z.ZodString>;
        command: z.ZodString;
        env: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
    }, z.core.$strip>]>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * Request to read content from a text file.
 *
 * Only available if the client supports the `fs.readTextFile` capability.
 */
export declare const zReadTextFileRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    limit: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    path: z.ZodString;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * Request to release a terminal and free its resources.
 */
export declare const zReleaseTerminalRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    sessionId: z.ZodString;
    terminalId: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for resuming an existing session.
 *
 * Resumes an existing session without returning previous messages (unlike `session/load`).
 * This is useful for agents that can resume sessions but don't implement full session loading.
 *
 * Only available if the Agent supports the `session.resume` capability.
 *
 * @experimental
 */
export declare const zResumeSessionRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    cwd: z.ZodString;
    mcpServers: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"http">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        headers: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
        url: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"sse">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        args: z.ZodArray<z.ZodString>;
        command: z.ZodString;
        env: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>;
        name: z.ZodString;
    }, z.core.$strip>]>>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Information about a session returned by session/list
 *
 * @experimental
 */
export declare const zSessionInfo: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    cwd: z.ZodString;
    sessionId: z.ZodString;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    updatedAt: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response from listing sessions.
 *
 * @experimental
 */
export declare const zListSessionsResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    nextCursor: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    sessions: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        cwd: z.ZodString;
        sessionId: z.ZodString;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        updatedAt: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * Update to session metadata. All fields are optional to support partial updates.
 *
 * Agents send this notification to update session information like title or custom metadata.
 * This allows clients to display dynamic session names and track session state changes.
 */
export declare const zSessionInfoUpdate: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    updatedAt: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Capabilities for the `session/list` method.
 *
 * By supplying `{}` it means that the agent supports listing of sessions.
 *
 * Further capabilities can be added in the future for other means of filtering or searching the list.
 */
export declare const zSessionListCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Unique identifier for a Session Mode.
 */
export declare const zSessionModeId: z.ZodString;
/**
 * The current mode of the session has changed
 *
 * See protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)
 */
export declare const zCurrentModeUpdate: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    currentModeId: z.ZodString;
}, z.core.$strip>;
/**
 * A mode the agent can operate in.
 *
 * See protocol docs: [Session Modes](https://agentclientprotocol.com/protocol/session-modes)
 */
export declare const zSessionMode: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
/**
 * The set of modes and the one currently active.
 */
export declare const zSessionModeState: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    availableModes: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>;
    currentModeId: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * The set of models and the one currently active.
 *
 * @experimental
 */
export declare const zSessionModelState: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    availableModels: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        modelId: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>;
    currentModelId: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response from forking an existing session.
 *
 * @experimental
 */
export declare const zForkSessionResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        currentValue: z.ZodString;
        options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            group: z.ZodString;
            name: z.ZodString;
            options: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"select">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>, z.ZodNull]>>;
    models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModels: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            modelId: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModelId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModes: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModeId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * Response from loading an existing session.
 */
export declare const zLoadSessionResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        currentValue: z.ZodString;
        options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            group: z.ZodString;
            name: z.ZodString;
            options: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"select">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>, z.ZodNull]>>;
    models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModels: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            modelId: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModelId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModes: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModeId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Response from creating a new session.
 *
 * See protocol docs: [Creating a Session](https://agentclientprotocol.com/protocol/session-setup#creating-a-session)
 */
export declare const zNewSessionResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        currentValue: z.ZodString;
        options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            group: z.ZodString;
            name: z.ZodString;
            options: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"select">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>, z.ZodNull]>>;
    models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModels: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            modelId: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModelId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModes: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModeId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response from resuming an existing session.
 *
 * @experimental
 */
export declare const zResumeSessionResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        currentValue: z.ZodString;
        options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            group: z.ZodString;
            name: z.ZodString;
            options: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"select">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>, z.ZodNull]>>;
    models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModels: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            modelId: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModelId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableModes: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
        currentModeId: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Capabilities for the `session/resume` method.
 *
 * By supplying `{}` it means that the agent supports resuming of sessions.
 *
 * @experimental
 */
export declare const zSessionResumeCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Session capabilities supported by the agent.
 *
 * As a baseline, all Agents **MUST** support `session/new`, `session/prompt`, `session/cancel`, and `session/update`.
 *
 * Optionally, they **MAY** support other session methods and notifications by specifying additional capabilities.
 *
 * Note: `session/load` is still handled by the top-level `load_session` capability. This will be unified in future versions of the protocol.
 *
 * See protocol docs: [Session Capabilities](https://agentclientprotocol.com/protocol/initialization#session-capabilities)
 */
export declare const zSessionCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    fork: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    list: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    resume: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Capabilities supported by the agent.
 *
 * Advertised during initialization to inform the client about
 * available features and content types.
 *
 * See protocol docs: [Agent Capabilities](https://agentclientprotocol.com/protocol/initialization#agent-capabilities)
 */
export declare const zAgentCapabilities: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    loadSession: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    mcpCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        http: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        sse: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    }, z.core.$strip>>>;
    promptCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audio: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        embeddedContext: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        image: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    }, z.core.$strip>>>;
    sessionCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        fork: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        list: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resume: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
    }, z.core.$strip>>>;
}, z.core.$strip>;
/**
 * Response to the `initialize` method.
 *
 * Contains the negotiated protocol version and agent capabilities.
 *
 * See protocol docs: [Initialization](https://agentclientprotocol.com/protocol/initialization)
 */
export declare const zInitializeResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    agentCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        loadSession: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        mcpCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            http: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            sse: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        }, z.core.$strip>>>;
        promptCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audio: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            embeddedContext: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            image: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        }, z.core.$strip>>>;
        sessionCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            fork: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            list: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resume: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
        }, z.core.$strip>>>;
    }, z.core.$strip>>>;
    agentInfo: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        name: z.ZodString;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        version: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    authMethods: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>>;
    protocolVersion: z.ZodNumber;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for setting a session configuration option.
 *
 * @experimental
 */
export declare const zSetSessionConfigOptionRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configId: z.ZodString;
    sessionId: z.ZodString;
    value: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response to `session/set_config_option` method.
 *
 * @experimental
 */
export declare const zSetSessionConfigOptionResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configOptions: z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        currentValue: z.ZodString;
        options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            group: z.ZodString;
            name: z.ZodString;
            options: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"select">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
/**
 * Request parameters for setting a session mode.
 */
export declare const zSetSessionModeRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    modeId: z.ZodString;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * Response to `session/set_mode` method.
 */
export declare const zSetSessionModeResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Request parameters for setting a session model.
 *
 * @experimental
 */
export declare const zSetSessionModelRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    modelId: z.ZodString;
    sessionId: z.ZodString;
}, z.core.$strip>;
/**
 * **UNSTABLE**
 *
 * This capability is not part of the spec yet, and may be removed or changed at any point.
 *
 * Response to `session/set_model` method.
 *
 * @experimental
 */
export declare const zSetSessionModelResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Reasons why an agent stops processing a prompt turn.
 *
 * See protocol docs: [Stop Reasons](https://agentclientprotocol.com/protocol/prompt-turn#stop-reasons)
 */
export declare const zStopReason: z.ZodUnion<readonly [z.ZodLiteral<"end_turn">, z.ZodLiteral<"max_tokens">, z.ZodLiteral<"max_turn_requests">, z.ZodLiteral<"refusal">, z.ZodLiteral<"cancelled">]>;
/**
 * Response from processing a user prompt.
 *
 * See protocol docs: [Check for Completion](https://agentclientprotocol.com/protocol/prompt-turn#4-check-for-completion)
 */
export declare const zPromptResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    stopReason: z.ZodUnion<readonly [z.ZodLiteral<"end_turn">, z.ZodLiteral<"max_tokens">, z.ZodLiteral<"max_turn_requests">, z.ZodLiteral<"refusal">, z.ZodLiteral<"cancelled">]>;
}, z.core.$strip>;
export declare const zAgentResponse: z.ZodUnion<readonly [z.ZodObject<{
    id: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
    result: z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        agentCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            loadSession: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            mcpCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                http: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
                sse: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            }, z.core.$strip>>>;
            promptCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audio: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
                embeddedContext: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
                image: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            }, z.core.$strip>>>;
            sessionCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                fork: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                list: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                resume: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
            }, z.core.$strip>>>;
        }, z.core.$strip>>>;
        agentInfo: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            version: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        authMethods: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>>;
        protocolVersion: z.ZodNumber;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            currentValue: z.ZodString;
            options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                group: z.ZodString;
                name: z.ZodString;
                options: z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    value: z.ZodString;
                }, z.core.$strip>>;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"select">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>, z.ZodNull]>>;
        models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModels: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                modelId: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModelId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModes: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                id: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModeId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            currentValue: z.ZodString;
            options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                group: z.ZodString;
                name: z.ZodString;
                options: z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    value: z.ZodString;
                }, z.core.$strip>>;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"select">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>, z.ZodNull]>>;
        models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModels: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                modelId: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModelId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModes: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                id: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModeId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        nextCursor: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        sessions: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            cwd: z.ZodString;
            sessionId: z.ZodString;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            updatedAt: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            currentValue: z.ZodString;
            options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                group: z.ZodString;
                name: z.ZodString;
                options: z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    value: z.ZodString;
                }, z.core.$strip>>;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"select">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>, z.ZodNull]>>;
        models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModels: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                modelId: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModelId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModes: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                id: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModeId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        configOptions: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            currentValue: z.ZodString;
            options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                group: z.ZodString;
                name: z.ZodString;
                options: z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    value: z.ZodString;
                }, z.core.$strip>>;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"select">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>, z.ZodNull]>>;
        models: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModels: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                modelId: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModelId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        modes: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableModes: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                id: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>;
            currentModeId: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        configOptions: z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            currentValue: z.ZodString;
            options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                group: z.ZodString;
                name: z.ZodString;
                options: z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    value: z.ZodString;
                }, z.core.$strip>>;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"select">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        stopReason: z.ZodUnion<readonly [z.ZodLiteral<"end_turn">, z.ZodLiteral<"max_tokens">, z.ZodLiteral<"max_turn_requests">, z.ZodLiteral<"refusal">, z.ZodLiteral<"cancelled">]>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodUnknown]>;
}, z.core.$strip>, z.ZodObject<{
    error: z.ZodObject<{
        code: z.ZodUnion<readonly [z.ZodLiteral<-32700>, z.ZodLiteral<-32600>, z.ZodLiteral<-32601>, z.ZodLiteral<-32602>, z.ZodLiteral<-32603>, z.ZodLiteral<-32800>, z.ZodLiteral<-32000>, z.ZodLiteral<-32002>, z.ZodNumber]>;
        data: z.ZodOptional<z.ZodUnknown>;
        message: z.ZodString;
    }, z.core.$strip>;
    id: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
}, z.core.$strip>]>;
/**
 * Embed a terminal created with `terminal/create` by its id.
 *
 * The terminal must be added before calling `terminal/release`.
 *
 * See protocol docs: [Terminal](https://agentclientprotocol.com/protocol/terminals)
 */
export declare const zTerminal: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    terminalId: z.ZodString;
}, z.core.$strip>;
/**
 * Exit status of a terminal command.
 */
export declare const zTerminalExitStatus: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    exitCode: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    signal: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Request to get the current output and status of a terminal.
 */
export declare const zTerminalOutputRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    sessionId: z.ZodString;
    terminalId: z.ZodString;
}, z.core.$strip>;
/**
 * Response containing the terminal output and exit status.
 */
export declare const zTerminalOutputResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    exitStatus: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        exitCode: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        signal: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    output: z.ZodString;
    truncated: z.ZodBoolean;
}, z.core.$strip>;
/**
 * Text provided to or from an LLM.
 */
export declare const zTextContent: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    text: z.ZodString;
}, z.core.$strip>;
/**
 * Text-based resource contents.
 */
export declare const zTextResourceContents: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    text: z.ZodString;
    uri: z.ZodString;
}, z.core.$strip>;
/**
 * Resource content that can be embedded in a message.
 */
export declare const zEmbeddedResourceResource: z.ZodUnion<readonly [z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    text: z.ZodString;
    uri: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    blob: z.ZodString;
    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    uri: z.ZodString;
}, z.core.$strip>]>;
/**
 * The contents of a resource, embedded into a prompt or tool call result.
 */
export declare const zEmbeddedResource: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    resource: z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        text: z.ZodString;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        blob: z.ZodString;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>]>;
}, z.core.$strip>;
/**
 * Content blocks represent displayable information in the Agent Client Protocol.
 *
 * They provide a structured way to handle various types of user-facing content—whether
 * it's text from language models, images for analysis, or embedded resources for context.
 *
 * Content blocks appear in:
 * - User prompts sent via `session/prompt`
 * - Language model output streamed through `session/update` notifications
 * - Progress updates and results from tool calls
 *
 * This structure is compatible with the Model Context Protocol (MCP), enabling
 * agents to seamlessly forward content from MCP tool outputs without transformation.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/content)
 */
export declare const zContentBlock: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    text: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"text">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    data: z.ZodString;
    mimeType: z.ZodString;
    uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"image">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    data: z.ZodString;
    mimeType: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"audio">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    name: z.ZodString;
    size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    uri: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"resource_link">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
            assistant: "assistant";
            user: "user";
        }>>, z.ZodNull]>>;
        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodNull]>>;
    resource: z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        text: z.ZodString;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        blob: z.ZodString;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>]>;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"resource">;
}, z.core.$strip>>]>;
/**
 * Standard content block (text, images, resources).
 */
export declare const zContent: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        text: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"text">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
        uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource_link">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resource: z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            text: z.ZodString;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            blob: z.ZodString;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
    }, z.core.$strip>>]>;
}, z.core.$strip>;
/**
 * A streamed item of content
 */
export declare const zContentChunk: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        text: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"text">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
        uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource_link">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resource: z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            text: z.ZodString;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            blob: z.ZodString;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
    }, z.core.$strip>>]>;
}, z.core.$strip>;
/**
 * Request parameters for sending a user prompt to the agent.
 *
 * Contains the user's message and any additional context.
 *
 * See protocol docs: [User Message](https://agentclientprotocol.com/protocol/prompt-turn#1-user-message)
 */
export declare const zPromptRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    prompt: z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        text: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"text">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
        uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource_link">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resource: z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            text: z.ZodString;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            blob: z.ZodString;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
    }, z.core.$strip>>]>>;
    sessionId: z.ZodString;
}, z.core.$strip>;
export declare const zClientRequest: z.ZodObject<{
    id: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
    method: z.ZodString;
    params: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        clientCapabilities: z.ZodDefault<z.ZodOptional<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            fs: z.ZodDefault<z.ZodOptional<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                readTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
                writeTextFile: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
            }, z.core.$strip>>>;
            terminal: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        }, z.core.$strip>>>;
        clientInfo: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            version: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        protocolVersion: z.ZodNumber;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        methodId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        cwd: z.ZodString;
        mcpServers: z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"http">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"sse">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            args: z.ZodArray<z.ZodString>;
            command: z.ZodString;
            env: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
        }, z.core.$strip>]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        cwd: z.ZodString;
        mcpServers: z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"http">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"sse">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            args: z.ZodArray<z.ZodString>;
            command: z.ZodString;
            env: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
        }, z.core.$strip>]>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        cursor: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        cwd: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        cwd: z.ZodString;
        mcpServers: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"http">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"sse">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            args: z.ZodArray<z.ZodString>;
            command: z.ZodString;
            env: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
        }, z.core.$strip>]>>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        cwd: z.ZodString;
        mcpServers: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"http">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            headers: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
            url: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"sse">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            args: z.ZodArray<z.ZodString>;
            command: z.ZodString;
            env: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
            name: z.ZodString;
        }, z.core.$strip>]>>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        modeId: z.ZodString;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        configId: z.ZodString;
        sessionId: z.ZodString;
        value: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        prompt: z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        modelId: z.ZodString;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodUnknown]>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Content produced by a tool call.
 *
 * Tool calls can produce different types of content including
 * standard content blocks (text, images) or file diffs.
 *
 * See protocol docs: [Content](https://agentclientprotocol.com/protocol/tool-calls#content)
 */
export declare const zToolCallContent: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        text: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"text">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
        uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource_link">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resource: z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            text: z.ZodString;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            blob: z.ZodString;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
    }, z.core.$strip>>]>;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"content">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    newText: z.ZodString;
    oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    path: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"diff">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    terminalId: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    type: z.ZodLiteral<"terminal">;
}, z.core.$strip>>]>;
/**
 * Unique identifier for a tool call within a session.
 */
export declare const zToolCallId: z.ZodString;
/**
 * A file location being accessed or modified by a tool.
 *
 * Enables clients to implement "follow-along" features that track
 * which files the agent is working with in real-time.
 *
 * See protocol docs: [Following the Agent](https://agentclientprotocol.com/protocol/tool-calls#following-the-agent)
 */
export declare const zToolCallLocation: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    path: z.ZodString;
}, z.core.$strip>;
/**
 * Execution status of a tool call.
 *
 * Tool calls progress through different statuses during their lifecycle.
 *
 * See protocol docs: [Status](https://agentclientprotocol.com/protocol/tool-calls#status)
 */
export declare const zToolCallStatus: z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>;
/**
 * Categories of tools that can be invoked.
 *
 * Tool kinds help clients choose appropriate icons and optimize how they
 * display tool execution progress.
 *
 * See protocol docs: [Creating](https://agentclientprotocol.com/protocol/tool-calls#creating)
 */
export declare const zToolKind: z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>;
/**
 * Represents a tool call that the language model has requested.
 *
 * Tool calls are actions that the agent executes on behalf of the language model,
 * such as reading files, executing code, or fetching data from external sources.
 *
 * See protocol docs: [Tool Calls](https://agentclientprotocol.com/protocol/tool-calls)
 */
export declare const zToolCall: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"content">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        newText: z.ZodString;
        oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"diff">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"terminal">;
    }, z.core.$strip>>]>>>;
    kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>>;
    locations: z.ZodOptional<z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>>>;
    rawInput: z.ZodOptional<z.ZodUnknown>;
    rawOutput: z.ZodOptional<z.ZodUnknown>;
    status: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>>;
    title: z.ZodString;
    toolCallId: z.ZodString;
}, z.core.$strip>;
/**
 * An update to an existing tool call.
 *
 * Used to report progress and results as tools execute. All fields except
 * the tool call ID are optional - only changed fields need to be included.
 *
 * See protocol docs: [Updating](https://agentclientprotocol.com/protocol/tool-calls#updating)
 */
export declare const zToolCallUpdate: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"content">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        newText: z.ZodString;
        oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"diff">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"terminal">;
    }, z.core.$strip>>]>>, z.ZodNull]>>;
    kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>, z.ZodNull]>>;
    locations: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>>, z.ZodNull]>>;
    rawInput: z.ZodOptional<z.ZodUnknown>;
    rawOutput: z.ZodOptional<z.ZodUnknown>;
    status: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>, z.ZodNull]>>;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    toolCallId: z.ZodString;
}, z.core.$strip>;
/**
 * Request for user permission to execute a tool call.
 *
 * Sent when the agent needs authorization before performing a sensitive operation.
 *
 * See protocol docs: [Requesting Permission](https://agentclientprotocol.com/protocol/tool-calls#requesting-permission)
 */
export declare const zRequestPermissionRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    options: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        kind: z.ZodUnion<readonly [z.ZodLiteral<"allow_once">, z.ZodLiteral<"allow_always">, z.ZodLiteral<"reject_once">, z.ZodLiteral<"reject_always">]>;
        name: z.ZodString;
        optionId: z.ZodString;
    }, z.core.$strip>>;
    sessionId: z.ZodString;
    toolCall: z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                text: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"text">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
                uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource_link">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                resource: z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    text: z.ZodString;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    blob: z.ZodString;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource">;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"content">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            newText: z.ZodString;
            oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            path: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"diff">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            terminalId: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"terminal">;
        }, z.core.$strip>>]>>, z.ZodNull]>>;
        kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>, z.ZodNull]>>;
        locations: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            path: z.ZodString;
        }, z.core.$strip>>, z.ZodNull]>>;
        rawInput: z.ZodOptional<z.ZodUnknown>;
        rawOutput: z.ZodOptional<z.ZodUnknown>;
        status: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        toolCallId: z.ZodString;
    }, z.core.$strip>;
}, z.core.$strip>;
/**
 * All text that was typed after the command name is provided as input.
 */
export declare const zUnstructuredCommandInput: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    hint: z.ZodString;
}, z.core.$strip>;
/**
 * All text that was typed after the command name is provided as input.
 */
export declare const zAvailableCommandInput: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    hint: z.ZodString;
}, z.core.$strip>;
/**
 * Information about a command.
 */
export declare const zAvailableCommand: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    description: z.ZodString;
    input: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        hint: z.ZodString;
    }, z.core.$strip>, z.ZodNull]>>;
    name: z.ZodString;
}, z.core.$strip>;
/**
 * Available commands are ready or have changed
 */
export declare const zAvailableCommandsUpdate: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    availableCommands: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodString;
        input: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            hint: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        name: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
/**
 * Different types of updates that can be sent during session processing.
 *
 * These updates provide real-time feedback about the agent's progress.
 *
 * See protocol docs: [Agent Reports Output](https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output)
 */
export declare const zSessionUpdate: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        text: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"text">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
        uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource_link">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resource: z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            text: z.ZodString;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            blob: z.ZodString;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
    }, z.core.$strip>>]>;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"user_message_chunk">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        text: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"text">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
        uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource_link">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resource: z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            text: z.ZodString;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            blob: z.ZodString;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
    }, z.core.$strip>>]>;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"agent_message_chunk">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        text: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"text">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
        uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        data: z.ZodString;
        mimeType: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        name: z.ZodString;
        size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        uri: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource_link">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                assistant: "assistant";
                user: "user";
            }>>, z.ZodNull]>>;
            lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        resource: z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            text: z.ZodString;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            blob: z.ZodString;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
    }, z.core.$strip>>]>;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"agent_thought_chunk">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"content">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        newText: z.ZodString;
        oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"diff">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"terminal">;
    }, z.core.$strip>>]>>>;
    kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>>;
    locations: z.ZodOptional<z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>>>;
    rawInput: z.ZodOptional<z.ZodUnknown>;
    rawOutput: z.ZodOptional<z.ZodUnknown>;
    status: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>>;
    title: z.ZodString;
    toolCallId: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"tool_call">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"content">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        newText: z.ZodString;
        oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"diff">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"terminal">;
    }, z.core.$strip>>]>>, z.ZodNull]>>;
    kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>, z.ZodNull]>>;
    locations: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        path: z.ZodString;
    }, z.core.$strip>>, z.ZodNull]>>;
    rawInput: z.ZodOptional<z.ZodUnknown>;
    rawOutput: z.ZodOptional<z.ZodUnknown>;
    status: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>, z.ZodNull]>>;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    toolCallId: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"tool_call_update">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    entries: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodString;
        priority: z.ZodUnion<readonly [z.ZodLiteral<"high">, z.ZodLiteral<"medium">, z.ZodLiteral<"low">]>;
        status: z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">]>;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"plan">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    availableCommands: z.ZodArray<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodString;
        input: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            hint: z.ZodString;
        }, z.core.$strip>, z.ZodNull]>>;
        name: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"available_commands_update">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    currentModeId: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"current_mode_update">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    configOptions: z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
        currentValue: z.ZodString;
        options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            group: z.ZodString;
            name: z.ZodString;
            options: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        type: z.ZodLiteral<"select">;
    }, z.core.$strip>>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"config_option_update">;
}, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    updatedAt: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>, z.ZodObject<{
    sessionUpdate: z.ZodLiteral<"session_info_update">;
}, z.core.$strip>>]>;
/**
 * Notification containing a session update from the agent.
 *
 * Used to stream real-time progress and results during prompt processing.
 *
 * See protocol docs: [Agent Reports Output](https://agentclientprotocol.com/protocol/prompt-turn#3-agent-reports-output)
 */
export declare const zSessionNotification: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    sessionId: z.ZodString;
    update: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"user_message_chunk">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"agent_message_chunk">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            text: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"text">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
            uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            data: z.ZodString;
            mimeType: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            name: z.ZodString;
            size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            uri: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource_link">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                    assistant: "assistant";
                    user: "user";
                }>>, z.ZodNull]>>;
                lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodNull]>>;
            resource: z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                text: z.ZodString;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                blob: z.ZodString;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"agent_thought_chunk">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                text: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"text">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
                uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource_link">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                resource: z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    text: z.ZodString;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    blob: z.ZodString;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource">;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"content">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            newText: z.ZodString;
            oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            path: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"diff">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            terminalId: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"terminal">;
        }, z.core.$strip>>]>>>;
        kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>>;
        locations: z.ZodOptional<z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            path: z.ZodString;
        }, z.core.$strip>>>;
        rawInput: z.ZodOptional<z.ZodUnknown>;
        rawOutput: z.ZodOptional<z.ZodUnknown>;
        status: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>>;
        title: z.ZodString;
        toolCallId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"tool_call">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                text: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"text">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
                uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource_link">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                resource: z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    text: z.ZodString;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    blob: z.ZodString;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource">;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"content">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            newText: z.ZodString;
            oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            path: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"diff">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            terminalId: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"terminal">;
        }, z.core.$strip>>]>>, z.ZodNull]>>;
        kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>, z.ZodNull]>>;
        locations: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            path: z.ZodString;
        }, z.core.$strip>>, z.ZodNull]>>;
        rawInput: z.ZodOptional<z.ZodUnknown>;
        rawOutput: z.ZodOptional<z.ZodUnknown>;
        status: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        toolCallId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"tool_call_update">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        entries: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodString;
            priority: z.ZodUnion<readonly [z.ZodLiteral<"high">, z.ZodLiteral<"medium">, z.ZodLiteral<"low">]>;
            status: z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">]>;
        }, z.core.$strip>>;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"plan">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        availableCommands: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodString;
            input: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                hint: z.ZodString;
            }, z.core.$strip>, z.ZodNull]>>;
            name: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"available_commands_update">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        currentModeId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"current_mode_update">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        configOptions: z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
            currentValue: z.ZodString;
            options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                value: z.ZodString;
            }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                group: z.ZodString;
                name: z.ZodString;
                options: z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    value: z.ZodString;
                }, z.core.$strip>>;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            type: z.ZodLiteral<"select">;
        }, z.core.$strip>>, z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"config_option_update">;
    }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        updatedAt: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        sessionUpdate: z.ZodLiteral<"session_info_update">;
    }, z.core.$strip>>]>;
}, z.core.$strip>;
export declare const zAgentNotification: z.ZodObject<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        sessionId: z.ZodString;
        update: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                text: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"text">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
                uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource_link">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                resource: z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    text: z.ZodString;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    blob: z.ZodString;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource">;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"user_message_chunk">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                text: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"text">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
                uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource_link">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                resource: z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    text: z.ZodString;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    blob: z.ZodString;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource">;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"agent_message_chunk">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                text: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"text">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
                uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                data: z.ZodString;
                mimeType: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                name: z.ZodString;
                size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                uri: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource_link">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                        assistant: "assistant";
                        user: "user";
                    }>>, z.ZodNull]>>;
                    lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodNull]>>;
                resource: z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    text: z.ZodString;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    blob: z.ZodString;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"resource">;
            }, z.core.$strip>>]>;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"agent_thought_chunk">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodOptional<z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    text: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"text">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    data: z.ZodString;
                    mimeType: z.ZodString;
                    uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"image">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    data: z.ZodString;
                    mimeType: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"audio">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"resource_link">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    resource: z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        text: z.ZodString;
                        uri: z.ZodString;
                    }, z.core.$strip>, z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        blob: z.ZodString;
                        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        uri: z.ZodString;
                    }, z.core.$strip>]>;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"resource">;
                }, z.core.$strip>>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"content">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                newText: z.ZodString;
                oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                path: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"diff">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                terminalId: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"terminal">;
            }, z.core.$strip>>]>>>;
            kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>>;
            locations: z.ZodOptional<z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                path: z.ZodString;
            }, z.core.$strip>>>;
            rawInput: z.ZodOptional<z.ZodUnknown>;
            rawOutput: z.ZodOptional<z.ZodUnknown>;
            status: z.ZodOptional<z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>>;
            title: z.ZodString;
            toolCallId: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"tool_call">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    text: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"text">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    data: z.ZodString;
                    mimeType: z.ZodString;
                    uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"image">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    data: z.ZodString;
                    mimeType: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"audio">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"resource_link">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    resource: z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        text: z.ZodString;
                        uri: z.ZodString;
                    }, z.core.$strip>, z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        blob: z.ZodString;
                        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        uri: z.ZodString;
                    }, z.core.$strip>]>;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"resource">;
                }, z.core.$strip>>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"content">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                newText: z.ZodString;
                oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                path: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"diff">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                terminalId: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"terminal">;
            }, z.core.$strip>>]>>, z.ZodNull]>>;
            kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>, z.ZodNull]>>;
            locations: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                path: z.ZodString;
            }, z.core.$strip>>, z.ZodNull]>>;
            rawInput: z.ZodOptional<z.ZodUnknown>;
            rawOutput: z.ZodOptional<z.ZodUnknown>;
            status: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            toolCallId: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"tool_call_update">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            entries: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                content: z.ZodString;
                priority: z.ZodUnion<readonly [z.ZodLiteral<"high">, z.ZodLiteral<"medium">, z.ZodLiteral<"low">]>;
                status: z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">]>;
            }, z.core.$strip>>;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"plan">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            availableCommands: z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodString;
                input: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    hint: z.ZodString;
                }, z.core.$strip>, z.ZodNull]>>;
                name: z.ZodString;
            }, z.core.$strip>>;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"available_commands_update">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            currentModeId: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"current_mode_update">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            configOptions: z.ZodArray<z.ZodIntersection<z.ZodIntersection<z.ZodObject<{
                currentValue: z.ZodString;
                options: z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    value: z.ZodString;
                }, z.core.$strip>>, z.ZodArray<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    group: z.ZodString;
                    name: z.ZodString;
                    options: z.ZodArray<z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        name: z.ZodString;
                        value: z.ZodString;
                    }, z.core.$strip>>;
                }, z.core.$strip>>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"select">;
            }, z.core.$strip>>, z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                id: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>>>;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"config_option_update">;
        }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            updatedAt: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodObject<{
            sessionUpdate: z.ZodLiteral<"session_info_update">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodUnknown]>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Request to wait for a terminal command to exit.
 */
export declare const zWaitForTerminalExitRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    sessionId: z.ZodString;
    terminalId: z.ZodString;
}, z.core.$strip>;
/**
 * Response containing the exit status of a terminal command.
 */
export declare const zWaitForTerminalExitResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    exitCode: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
    signal: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Request to write content to a text file.
 *
 * Only available if the client supports the `fs.writeTextFile` capability.
 */
export declare const zWriteTextFileRequest: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    content: z.ZodString;
    path: z.ZodString;
    sessionId: z.ZodString;
}, z.core.$strip>;
export declare const zAgentRequest: z.ZodObject<{
    id: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
    method: z.ZodString;
    params: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodString;
        path: z.ZodString;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        limit: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        path: z.ZodString;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        options: z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            kind: z.ZodUnion<readonly [z.ZodLiteral<"allow_once">, z.ZodLiteral<"allow_always">, z.ZodLiteral<"reject_once">, z.ZodLiteral<"reject_always">]>;
            name: z.ZodString;
            optionId: z.ZodString;
        }, z.core.$strip>>;
        sessionId: z.ZodString;
        toolCall: z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            content: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                content: z.ZodUnion<readonly [z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    text: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"text">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    data: z.ZodString;
                    mimeType: z.ZodString;
                    uri: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"image">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    data: z.ZodString;
                    mimeType: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"audio">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    description: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    name: z.ZodString;
                    size: z.ZodOptional<z.ZodUnion<readonly [z.ZodCoercedBigInt<unknown>, z.ZodNull]>>;
                    title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                    uri: z.ZodString;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"resource_link">;
                }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                    annotations: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        audience: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodEnum<{
                            assistant: "assistant";
                            user: "user";
                        }>>, z.ZodNull]>>;
                        lastModified: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        priority: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                    }, z.core.$strip>, z.ZodNull]>>;
                    resource: z.ZodUnion<readonly [z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        text: z.ZodString;
                        uri: z.ZodString;
                    }, z.core.$strip>, z.ZodObject<{
                        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                        blob: z.ZodString;
                        mimeType: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                        uri: z.ZodString;
                    }, z.core.$strip>]>;
                }, z.core.$strip>, z.ZodObject<{
                    type: z.ZodLiteral<"resource">;
                }, z.core.$strip>>]>;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"content">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                newText: z.ZodString;
                oldText: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
                path: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"diff">;
            }, z.core.$strip>>, z.ZodIntersection<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                terminalId: z.ZodString;
            }, z.core.$strip>, z.ZodObject<{
                type: z.ZodLiteral<"terminal">;
            }, z.core.$strip>>]>>, z.ZodNull]>>;
            kind: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"read">, z.ZodLiteral<"edit">, z.ZodLiteral<"delete">, z.ZodLiteral<"move">, z.ZodLiteral<"search">, z.ZodLiteral<"execute">, z.ZodLiteral<"think">, z.ZodLiteral<"fetch">, z.ZodLiteral<"switch_mode">, z.ZodLiteral<"other">]>, z.ZodNull]>>;
            locations: z.ZodOptional<z.ZodUnion<readonly [z.ZodArray<z.ZodObject<{
                _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
                line: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
                path: z.ZodString;
            }, z.core.$strip>>, z.ZodNull]>>;
            rawInput: z.ZodOptional<z.ZodUnknown>;
            rawOutput: z.ZodOptional<z.ZodUnknown>;
            status: z.ZodOptional<z.ZodUnion<readonly [z.ZodUnion<readonly [z.ZodLiteral<"pending">, z.ZodLiteral<"in_progress">, z.ZodLiteral<"completed">, z.ZodLiteral<"failed">]>, z.ZodNull]>>;
            title: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
            toolCallId: z.ZodString;
        }, z.core.$strip>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        args: z.ZodOptional<z.ZodArray<z.ZodString>>;
        command: z.ZodString;
        cwd: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        env: z.ZodOptional<z.ZodArray<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            name: z.ZodString;
            value: z.ZodString;
        }, z.core.$strip>>>;
        outputByteLimit: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        sessionId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        sessionId: z.ZodString;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        sessionId: z.ZodString;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        sessionId: z.ZodString;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        sessionId: z.ZodString;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodUnknown]>, z.ZodNull]>>;
}, z.core.$strip>;
/**
 * Response to `fs/write_text_file`
 */
export declare const zWriteTextFileResponse: z.ZodObject<{
    _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
}, z.core.$strip>;
export declare const zClientResponse: z.ZodUnion<readonly [z.ZodObject<{
    id: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
    result: z.ZodUnion<readonly [z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        content: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        outcome: z.ZodUnion<readonly [z.ZodObject<{
            outcome: z.ZodLiteral<"cancelled">;
        }, z.core.$strip>, z.ZodIntersection<z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            optionId: z.ZodString;
        }, z.core.$strip>, z.ZodObject<{
            outcome: z.ZodLiteral<"selected">;
        }, z.core.$strip>>]>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        terminalId: z.ZodString;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        exitStatus: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
            exitCode: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
            signal: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
        }, z.core.$strip>, z.ZodNull]>>;
        output: z.ZodString;
        truncated: z.ZodBoolean;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
        exitCode: z.ZodOptional<z.ZodUnion<readonly [z.ZodNumber, z.ZodNull]>>;
        signal: z.ZodOptional<z.ZodUnion<readonly [z.ZodString, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodObject<{
        _meta: z.ZodOptional<z.ZodUnion<readonly [z.ZodRecord<z.ZodString, z.ZodUnknown>, z.ZodNull]>>;
    }, z.core.$strip>, z.ZodUnknown]>;
}, z.core.$strip>, z.ZodObject<{
    error: z.ZodObject<{
        code: z.ZodUnion<readonly [z.ZodLiteral<-32700>, z.ZodLiteral<-32600>, z.ZodLiteral<-32601>, z.ZodLiteral<-32602>, z.ZodLiteral<-32603>, z.ZodLiteral<-32800>, z.ZodLiteral<-32000>, z.ZodLiteral<-32002>, z.ZodNumber]>;
        data: z.ZodOptional<z.ZodUnknown>;
        message: z.ZodString;
    }, z.core.$strip>;
    id: z.ZodUnion<readonly [z.ZodNull, z.ZodCoercedBigInt<unknown>, z.ZodString]>;
}, z.core.$strip>]>;
