import { jsx as _jsx } from "react/jsx-runtime";
import { Text } from 'ink';
import { getStatusColor, QUOTA_THRESHOLD_HIGH, QUOTA_THRESHOLD_MEDIUM, } from '../utils/displayUtils.js';
import { formatResetTime } from '../utils/formatters.js';
export const QuotaDisplay = ({ remaining, limit, resetTime, terse = false, }) => {
    if (remaining === undefined || limit === undefined || limit === 0) {
        return null;
    }
    const percentage = (remaining / limit) * 100;
    if (percentage > QUOTA_THRESHOLD_HIGH) {
        return null;
    }
    const color = getStatusColor(percentage, {
        green: QUOTA_THRESHOLD_HIGH,
        yellow: QUOTA_THRESHOLD_MEDIUM,
    });
    const resetInfo = !terse && resetTime ? `, ${formatResetTime(resetTime)}` : '';
    if (remaining === 0) {
        return (_jsx(Text, { color: color, children: terse
                ? 'Limit reached'
                : `/stats Limit reached${resetInfo}${!terse && '. /auth to continue.'}` }));
    }
    return (_jsx(Text, { color: color, children: terse
            ? `${percentage.toFixed(0)}%`
            : `/stats ${percentage.toFixed(0)}% usage remaining${resetInfo}` }));
};
//# sourceMappingURL=QuotaDisplay.js.map