/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.feature.vt.api.db.VTAddressCorrelatorAdapter;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VTAddressCorrelationAdapterV0
extends VTAddressCorrelatorAdapter {
    private Table table;

    public VTAddressCorrelationAdapterV0(DBHandle dbHandle) throws IOException {
        super(dbHandle);
        this.table = dbHandle.createTable(TABLE_NAME, TABLE_SCHEMA);
    }

    public VTAddressCorrelationAdapterV0(DBHandle dbHandle, TaskMonitor monitor) throws VersionException {
        super(dbHandle);
        this.table = dbHandle.getTable(TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: " + TABLE_NAME);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    void createAddressRecord(long sourceEntryLong, long sourceLong, long destinationLong) throws IOException {
        DBRecord record = TABLE_SCHEMA.createRecord(this.table.getKey());
        record.setLongValue(VTAddressCorrelatorAdapter.AddressCorrelationTableDescriptor.SOURCE_ENTRY_COL.column(), sourceLong);
        record.setLongValue(VTAddressCorrelatorAdapter.AddressCorrelationTableDescriptor.SOURCE_ADDRESS_COL.column(), sourceLong);
        record.setLongValue(VTAddressCorrelatorAdapter.AddressCorrelationTableDescriptor.DESTINATION_ADDRESS_COL.column(), destinationLong);
        this.table.putRecord(record);
    }

    @Override
    List<DBRecord> getAddressRecords(long sourceEntryLong) throws IOException {
        LongField value = new LongField(sourceEntryLong);
        RecordIterator indexIterator = this.table.indexIterator(0, (Field)value, (Field)value, true);
        ArrayList<DBRecord> records = new ArrayList<DBRecord>();
        while (indexIterator.hasNext()) {
            records.add(indexIterator.next());
        }
        return records;
    }
}

