/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import generic.jar.ResourceFile;
import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.WeightedLSHCosineVectorFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.Configuration;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.PasswordChange;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.ResponsePassword;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public interface FunctionDatabase
extends AutoCloseable {
    default public boolean isPasswordChangeAllowed() {
        return this.getStatus() == Status.Ready && this.getConnectionType() == ConnectionType.SSL_Password_Authentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String changePassword(char[] newPassword) {
        if (this.getStatus() != Status.Ready) {
            return "Connection not established";
        }
        if (!this.isPasswordChangeAllowed()) {
            return "Password change not supported";
        }
        PasswordChange passwordChange = new PasswordChange();
        try {
            passwordChange.username = this.getUserName();
            passwordChange.newPassword = newPassword;
            ResponsePassword response = (ResponsePassword)passwordChange.execute(this);
            if (!response.changeSuccessful) {
                String string = response.errorMessage;
                return string;
            }
        }
        finally {
            passwordChange.clearPassword();
        }
        return null;
    }

    public Status getStatus();

    public ConnectionType getConnectionType();

    public String getUserName();

    public LSHVectorFactory getLSHVectorFactory();

    public DatabaseInformation getInfo();

    public int compareLayout();

    public BSimServerInfo getServerInfo();

    @Deprecated
    public String getURLString();

    public boolean initialize();

    @Override
    public void close();

    public BSimError getLastError();

    public QueryResponseRecord query(BSimQuery<?> var1);

    public static void checkSettingsForQuery(DescriptionManager manage, DatabaseInformation info) throws LSHException {
        int res = info.checkSignatureSettings(manage.getMajorVersion(), manage.getMinorVersion(), manage.getSettings());
        if (res <= 1) {
            return;
        }
        if (res == 4) {
            return;
        }
        if (res == 3) {
            throw new LSHException("Query signature data has no setting information");
        }
        throw new LSHException("Query signature data " + FunctionDatabase.getFormattedVersion(manage.getMajorVersion(), manage.getMinorVersion(), manage.getSettings()) + " does not match database " + FunctionDatabase.getFormattedVersion(info.major, info.minor, info.settings));
    }

    private static String getFormattedVersion(int maj, int min, int settings) {
        return String.format("%d.%d:0x%02x", maj, min, settings);
    }

    public static boolean checkSettingsForInsert(DescriptionManager manage, DatabaseInformation info) throws LSHException, DatabaseNonFatalException {
        if (manage.numFunctions() == 0) {
            throw new DatabaseNonFatalException("Empty signature file");
        }
        int res = info.checkSignatureSettings(manage.getMajorVersion(), manage.getMinorVersion(), manage.getSettings());
        if (res == 0) {
            return false;
        }
        if (res == 1) {
            throw new LSHException("Trying to insert signature data with slight differences in settings");
        }
        if (res == 4) {
            return true;
        }
        if (res == 3) {
            throw new LSHException("Trying to insert signature data with no setting information");
        }
        throw new LSHException("Trying to insert signature data " + FunctionDatabase.getFormattedVersion(manage.getMajorVersion(), manage.getMinorVersion(), manage.getSettings()) + " with settings that don't match database " + FunctionDatabase.getFormattedVersion(info.major, info.minor, info.settings));
    }

    public static String constructFatalError(int flags, ExecutableRecord newrec, ExecutableRecord orig) {
        String res = null;
        if ((flags & 2) != 0) {
            res = newrec.getNameExec() + " already ingested with different architecture field: " + orig.getArchitecture();
        } else if ((flags & 4) != 0) {
            res = newrec.getNameExec() + " already ingested with different compiler field: " + orig.getNameCompiler();
        } else if ((flags & 0x40) != 0) {
            res = newrec.getNameExec() + " already ingested -- library field differs!!";
        } else if ((flags & 0x10) != 0) {
            res = newrec.getNameExec() + " already ingested from a different repository: " + orig.getRepository();
        }
        return res;
    }

    public static String constructNonfatalError(int flags, ExecutableRecord newrec, ExecutableRecord orig) {
        String res = (flags & 1) != 0 ? newrec.getNameExec() + " already ingested with a different name: " + orig.getNameExec() : ((flags & 0x20) != 0 ? newrec.getNameExec() + " already ingested under a different path: " + orig.getPath() : ((flags & 8) != 0 ? newrec.getNameExec() + " already ingested with a different date: " + orig.getDate().toString() : newrec.getNameExec() + " already ingested with UNKNOWN difference in metadata"));
        return res;
    }

    public static Configuration loadConfigurationTemplate(String configname) throws LSHException {
        Configuration config = new Configuration();
        try {
            ResourceFile moduleDataSubDirectory = Application.getModuleDataSubDirectory((String)"");
            config.loadTemplate(moduleDataSubDirectory, configname);
        }
        catch (FileNotFoundException e) {
            throw new LSHException("Missing configuration data: " + e.getMessage());
        }
        catch (IOException e) {
            throw new LSHException("Could open module data directory");
        }
        catch (SAXException e) {
            throw new LSHException("Unable to parse configuration template");
        }
        return config;
    }

    public static WeightedLSHCosineVectorFactory generateLSHVectorFactory() {
        return new WeightedLSHCosineVectorFactory();
    }

    public static List<File> getConfigurationTemplates() {
        ArrayList<File> templateFiles = new ArrayList<File>();
        try {
            ResourceFile moduleDataSubDirectory = Application.getModuleDataSubDirectory((String)"");
            File templateDir = new File(moduleDataSubDirectory.getAbsolutePath());
            if (!templateDir.exists()) {
                return Collections.emptyList();
            }
            FilenameFilter nameFilter = (dir, name) -> name.endsWith(".xml");
            File[] files = templateDir.listFiles(nameFilter);
            if (files != null) {
                for (File file : files) {
                    if (!FunctionDatabase.isConfigTemplate(file)) continue;
                    templateFiles.add(file);
                }
            }
        }
        catch (IOException e) {
            Msg.error(null, (Object)"Error retrieving configuration templates", (Throwable)e);
        }
        return templateFiles;
    }

    public static boolean isConfigTemplate(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            Element rootElem = doc.getDocumentElement();
            if (rootElem.getTagName().equals("dbconfig")) {
                return true;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Msg.error(null, (Object)"Error inspecting xml file", (Throwable)e);
        }
        return false;
    }

    default public int getQueriedFunctionsPerStage() {
        return 0;
    }

    default public int getOverviewFunctionsPerStage() {
        return 0;
    }

    public static enum Status {
        Unconnected("Unconnected"),
        Busy("Busy"),
        Error("Error"),
        Ready("Ready");

        private final String label;

        private Status(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum ConnectionType {
        SSL_No_Authentication(0),
        SSL_Password_Authentication(1),
        Unencrypted_No_Authentication(2);


        private ConnectionType(int label) {
        }
    }

    public static class DatabaseNonFatalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DatabaseNonFatalException(String message) {
            super(message);
        }
    }

    public static class BSimError {
        public ErrorCategory category;
        public String message;

        public BSimError(ErrorCategory cat, String msg) {
            this.category = cat;
            this.message = msg;
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum ErrorCategory {
        Unused(0),
        Nonfatal(1),
        Fatal(2),
        Initialization(3),
        Format(4),
        Nodatabase(5),
        Connection(6),
        Authentication(7),
        AuthenticationCancelled(8);

        private final int label;

        private ErrorCategory(int label) {
            this.label = label;
        }

        public int getInteger() {
            return this.label;
        }
    }
}

