/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import ghidra.app.util.bin.format.macho.Section;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class SectionAttributes {
    public static final int SECTION_ATTRIBUTES_MASK = -256;
    public static final int SECTION_ATTRIBUTES_USR = -16777216;
    public static final int SECTION_ATTRIBUTES_SYS = 0xFFFF00;
    public static final int S_ATTR_PURE_INSTRUCTIONS = Integer.MIN_VALUE;
    public static final int S_ATTR_NO_TOC = 0x40000000;
    public static final int S_ATTR_STRIP_STATIC_SYMS = 0x20000000;
    public static final int S_ATTR_NO_DEAD_STRIP = 0x10000000;
    public static final int S_ATTR_LIVE_SUPPORT = 0x8000000;
    public static final int S_ATTR_SELF_MODIFYING_CODE = 0x4000000;
    public static final int S_ATTR_SOME_INSTRUCTIONS = 1024;
    public static final int S_ATTR_EXT_RELOC = 512;
    public static final int S_ATTR_LOC_RELOC = 256;

    public static final List<String> getAttributeNames(int attributes) {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : fields = Section.class.getDeclaredFields()) {
            if (!field.getName().startsWith("S_ATTR_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if ((attributes & value) == 0) continue;
                list.add(field.getName().substring("S_ATTR_".length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }
}

