/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.formats.gfilesystem.crypto.CachedPasswordProvider;
import ghidra.formats.gfilesystem.crypto.CryptoProviders;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.util.Msg;
import java.util.List;

public class ClearCachedPwdFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Clear Cached Passwords", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(FSBActionContext::notBusy).popupMenuPath(new String[]{"Clear Cached Passwords"}).popupMenuGroup("Z", "B").description("Clear cached container file passwords").onAction(ac -> {
            CachedPasswordProvider ccp = CryptoProviders.getInstance().getCachedCryptoProvider();
            int preCount = ccp.getCount();
            ccp.clearCache();
            String msg = "Cleared %d cached passwords.".formatted(preCount - ccp.getCount());
            Msg.info((Object)this, (Object)msg);
            this.context.fsbComponent().getPlugin().getTool().setStatusInfo(msg);
        }).build());
    }
}

