/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphToTreeAlgorithm;
import ghidra.graph.algo.ChkDominanceAlgorithm;
import ghidra.graph.algo.ChkPostDominanceAlgorithm;
import ghidra.graph.algo.DepthFirstSorter;
import ghidra.graph.algo.GraphNavigator;
import ghidra.graph.algo.IterativeFindPathsAlgorithm;
import ghidra.graph.algo.JohnsonCircuitsAlgorithm;
import ghidra.graph.algo.TarjanStronglyConnectedAlgorthm;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.TimeoutException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TimeoutTaskMonitor;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import util.CollectionUtils;

public class GraphAlgorithms {
    private GraphAlgorithms() {
    }

    public static <V, E extends GEdge<V>> Set<V> getSources(GDirectedGraph<V, E> g) {
        HashSet<V> sources = new HashSet<V>();
        Collection<V> vertices = g.getVertices();
        for (V v : vertices) {
            Collection<E> inEdges = g.getInEdges(v);
            if (!inEdges.isEmpty()) continue;
            sources.add(v);
        }
        return sources;
    }

    public static <V, E extends GEdge<V>> Set<V> getSinks(GDirectedGraph<V, E> g) {
        HashSet<V> sinks = new HashSet<V>();
        Collection<V> vertices = g.getVertices();
        for (V v : vertices) {
            Collection<E> outEdges = g.getOutEdges(v);
            if (!outEdges.isEmpty()) continue;
            sinks.add(v);
        }
        return sinks;
    }

    public static <V, E extends GEdge<V>> Set<V> getDescendants(GDirectedGraph<V, E> g, Collection<V> vertices) {
        Set<E> edges = GraphAlgorithms.getEdgesFrom(g, vertices, true);
        Set<V> descendants = GraphAlgorithms.toVertices(edges);
        return descendants;
    }

    public static <V, E extends GEdge<V>> Set<V> getAncestors(GDirectedGraph<V, E> g, Collection<V> vertices) {
        Set<E> edges = GraphAlgorithms.getEdgesFrom(g, vertices, false);
        Set<V> ancestors = GraphAlgorithms.toVertices(edges);
        return ancestors;
    }

    public static <V, E extends GEdge<V>> Set<E> getEdgesFrom(GDirectedGraph<V, E> g, V v, boolean topDown) {
        List<Object> list = Arrays.asList(v);
        Set<E> edges = GraphAlgorithms.getEdgesFrom(g, list, topDown);
        return edges;
    }

    public static <V, E extends GEdge<V>> Set<E> getEdgesFrom(GDirectedGraph<V, E> g, Collection<V> vertices, boolean topDown) {
        GraphNavigator<V, E> navigator = null;
        navigator = topDown ? GraphNavigator.topDownNavigator() : GraphNavigator.bottomUpNavigator();
        HashSet<GEdge> edges = new HashSet<GEdge>();
        HashSet newlyPending = new HashSet();
        HashSet<V> pending = new HashSet<V>(vertices);
        while (!pending.isEmpty()) {
            for (Object parent : pending) {
                Collection outEdges = navigator.getEdges(g, parent);
                for (GEdge e : outEdges) {
                    Object destination = navigator.getEnd(e);
                    if (!edges.add(e)) continue;
                    newlyPending.add(destination);
                }
            }
            pending = newlyPending;
            newlyPending = new HashSet();
        }
        return edges;
    }

    public static <V, E extends GEdge<V>> GDirectedGraph<V, E> createSubGraph(GDirectedGraph<V, E> g, Collection<V> vertices) {
        vertices = CollectionUtils.asSet(vertices);
        GDirectedGraph<V, GEdge> subGraph = g.emptyCopy();
        for (GEdge e : g.getEdges()) {
            Object start = e.getStart();
            Object end = e.getEnd();
            if (!vertices.contains(start) || !vertices.contains(end)) continue;
            subGraph.addEdge(e);
        }
        return subGraph;
    }

    public static <V, E extends GEdge<V>> Set<Set<V>> getStronglyConnectedComponents(GDirectedGraph<V, E> g) {
        TarjanStronglyConnectedAlgorthm<V, E> algorithm = new TarjanStronglyConnectedAlgorthm<V, E>(g);
        return algorithm.getConnectedComponents();
    }

    public static <V, E extends GEdge<V>> Set<V> getEntryPoints(GDirectedGraph<V, E> g) {
        Set<V> sources = GraphAlgorithms.getSources(g);
        Set<V> descendants = GraphAlgorithms.getDescendants(g, sources);
        HashSet<V> isolatedVertices = new HashSet<V>(g.getVertices());
        isolatedVertices.removeAll(sources);
        isolatedVertices.removeAll(descendants);
        HashSet<V> entryPoints = new HashSet<V>(sources);
        if (isolatedVertices.isEmpty()) {
            return entryPoints;
        }
        GDirectedGraph<V, E> isolatedGraph = GraphAlgorithms.createSubGraph(g, isolatedVertices);
        Set<Set<V>> strongs = GraphAlgorithms.getStronglyConnectedComponents(isolatedGraph);
        for (Set<V> set : strongs) {
            if (!GraphAlgorithms.isSelfContainedStrongComponent(g, set)) continue;
            entryPoints.add(set.iterator().next());
        }
        return entryPoints;
    }

    public static <V, E extends GEdge<V>> GDirectedGraph<V, GEdge<V>> findDominanceTree(GDirectedGraph<V, E> g, TaskMonitor monitor) throws CancelledException {
        ChkDominanceAlgorithm<V, E> algorithm = new ChkDominanceAlgorithm<V, E>(g, monitor);
        return algorithm.getDominanceTree();
    }

    public static <V, E extends GEdge<V>> Set<V> findDominance(GDirectedGraph<V, E> g, V from, TaskMonitor monitor) throws CancelledException {
        ChkDominanceAlgorithm<V, E> algo = new ChkDominanceAlgorithm<V, E>(g, monitor);
        Set<V> dominated = algo.getDominated(from);
        return dominated;
    }

    public static <V, E extends GEdge<V>> Set<V> findPostDominance(GDirectedGraph<V, E> g, V from, TaskMonitor monitor) throws CancelledException {
        ChkPostDominanceAlgorithm<V, E> algo = new ChkPostDominanceAlgorithm<V, E>(g, monitor);
        Set<V> postDominated = algo.getDominated(from);
        return postDominated;
    }

    public static <V, E extends GEdge<V>> List<List<V>> findCircuits(GDirectedGraph<V, E> g, TaskMonitor monitor) throws CancelledException {
        return GraphAlgorithms.findCircuits(g, true, monitor);
    }

    public static <V, E extends GEdge<V>> List<List<V>> findCircuits(GDirectedGraph<V, E> g, boolean uniqueCircuits, TaskMonitor monitor) throws CancelledException {
        ListAccumulator accumulator = new ListAccumulator();
        JohnsonCircuitsAlgorithm<V, E> algorithm = new JohnsonCircuitsAlgorithm<V, E>(g, accumulator);
        algorithm.compute(uniqueCircuits, monitor);
        return accumulator.asList();
    }

    public static <V, E extends GEdge<V>> List<List<V>> findCircuits(GDirectedGraph<V, E> g, boolean uniqueCircuits, TimeoutTaskMonitor monitor) throws CancelledException, TimeoutException {
        ListAccumulator accumulator = new ListAccumulator();
        JohnsonCircuitsAlgorithm<V, E> algorithm = new JohnsonCircuitsAlgorithm<V, E>(g, accumulator);
        algorithm.compute(uniqueCircuits, (TaskMonitor)monitor);
        return accumulator.asList();
    }

    public static <V, E extends GEdge<V>> void findPaths(GDirectedGraph<V, E> g, V start, V end, Accumulator<List<V>> accumulator, TaskMonitor monitor) throws CancelledException {
        IterativeFindPathsAlgorithm<V, E> algo = new IterativeFindPathsAlgorithm<V, E>();
        algo.findPaths(g, start, end, accumulator, monitor);
    }

    public static <V, E extends GEdge<V>> void findPaths(GDirectedGraph<V, E> g, V start, V end, Accumulator<List<V>> accumulator, TimeoutTaskMonitor monitor) throws CancelledException, TimeoutException {
        IterativeFindPathsAlgorithm<V, E> algo = new IterativeFindPathsAlgorithm<V, E>();
        algo.findPaths(g, start, end, accumulator, (TaskMonitor)monitor);
    }

    public static <V, E extends GEdge<V>> List<V> getVerticesInPostOrder(GDirectedGraph<V, E> g, GraphNavigator<V, E> navigator) {
        List<V> postOrder = DepthFirstSorter.postOrder(g, navigator);
        return postOrder;
    }

    public static <V, E extends GEdge<V>> List<V> getVerticesInPreOrder(GDirectedGraph<V, E> g, GraphNavigator<V, E> navigator) {
        List<V> preOrder = DepthFirstSorter.preOrder(g, navigator);
        return preOrder;
    }

    public static <V, E extends GEdge<V>> Map<V, Integer> getComplexityDepth(GDirectedGraph<V, E> g) {
        HashMap<V, Integer> map = new HashMap<V, Integer>();
        List<V> verticesInPostOrder = GraphAlgorithms.getVerticesInPostOrder(g, GraphNavigator.topDownNavigator());
        for (V v : verticesInPostOrder) {
            int maxChildLevel = GraphAlgorithms.getMaxChildLevel(g, map, v);
            map.put(v, maxChildLevel + 1);
        }
        return map;
    }

    public static <V, E extends GEdge<V>> Set<E> retainEdges(GDirectedGraph<V, E> graph, Set<V> vertices) {
        Collection<E> edges = graph.getEdges();
        Set results = edges.stream().filter(e -> vertices.contains(e.getStart())).filter(e -> vertices.contains(e.getEnd())).collect(Collectors.toSet());
        return results;
    }

    public static <V, E extends GEdge<V>> Set<V> toVertices(Collection<E> edges) {
        HashSet result = new HashSet();
        for (GEdge e : edges) {
            result.add(e.getStart());
            result.add(e.getEnd());
        }
        return result;
    }

    public static <V, E extends GEdge<V>> void printGraph(GDirectedGraph<V, E> g, PrintStream ps) {
        Set<V> sources = GraphAlgorithms.getSources(g);
        HashSet printedSet = new HashSet();
        ps.println("=================================");
        for (V v : sources) {
            GraphAlgorithms.recursivePrint(g, v, printedSet, 0, ps);
            ps.println("---------------------------------");
        }
        ps.println("=================================");
    }

    private static <V, E extends GEdge<V>> boolean isSelfContainedStrongComponent(GDirectedGraph<V, E> g, Set<V> strongComponent) {
        HashSet<V> parents = new HashSet<V>();
        for (V v : strongComponent) {
            parents.addAll(g.getPredecessors(v));
        }
        return strongComponent.containsAll(parents);
    }

    private static <V, E extends GEdge<V>> int getMaxChildLevel(GDirectedGraph<V, E> g, Map<V, Integer> levelMap, V v) {
        int maxLevel = -1;
        Collection<V> successors = g.getSuccessors(v);
        for (V child : successors) {
            Integer level = levelMap.get(child);
            if (level == null || level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }

    private static <V, E extends GEdge<V>> void recursivePrint(GDirectedGraph<V, E> g, V v, Set<V> set, int depth, PrintStream ps) {
        for (int i = 1; i <= depth; ++i) {
            ps.print(".");
        }
        if (set.contains(v)) {
            ps.println(String.valueOf(v) + "^ (" + depth + ")");
            return;
        }
        ps.print(v);
        if (depth > 0) {
            ps.print(" (" + depth + ")");
        }
        ps.print('\n');
        set.add(v);
        Collection<V> successors = g.getSuccessors(v);
        for (V v2 : successors) {
            GraphAlgorithms.recursivePrint(g, v2, set, depth + 1, ps);
        }
    }

    public static <V, E extends GEdge<V>> List<V> topologicalSort(GDirectedGraph<V, E> g, V root, Comparator<E> edgeComparator) {
        GraphToTreeAlgorithm<V, E> algorithm = new GraphToTreeAlgorithm<V, E>(g, edgeComparator);
        return algorithm.topolocigalSort(root);
    }

    public static <V, E extends GEdge<V>> GDirectedGraph<V, E> toTree(GDirectedGraph<V, E> g, V root, Comparator<E> edgeComparator) {
        GraphToTreeAlgorithm<V, E> algorithm = new GraphToTreeAlgorithm<V, E>(g, edgeComparator);
        return algorithm.toTree(root);
    }
}

