/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ARM_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ARM_ElfRelocationType;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import java.util.Map;

public class ARM_ElfRelocationHandler
extends AbstractElfRelocationHandler<ARM_ElfRelocationType, ARM_ElfRelocationContext> {
    public ARM_ElfRelocationHandler() {
        super(ARM_ElfRelocationType.class);
    }

    public ARM_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new ARM_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 40;
    }

    public int getRelrRelocationType() {
        return ARM_ElfRelocationType.R_ARM_RELATIVE.typeId;
    }

    protected RelocationResult relocate(ARM_ElfRelocationContext elfRelocationContext, ElfRelocation relocation, ARM_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        boolean instructionBigEndian = program.getLanguage().getLanguageDescription().getInstructionEndian().isBigEndian();
        long addend = relocation.getAddend();
        long offset = Integer.toUnsignedLong((int)relocationAddress.getOffset());
        int symbolIndex = relocation.getSymbolIndex();
        int newValue = 0;
        int byteLength = 4;
        switch (type) {
            case R_ARM_RELATIVE: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() + (int)addend;
                memory.setInt(relocationAddress, newValue);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_ARM_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        boolean isThumb = this.isThumb(sym);
        switch (type) {
            case R_ARM_PC24: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 8 >> 6;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(false)));
                newValue = (oldValue & 0xF0000000) == -268435456 ? oldValue & 0xFE000000 | (newValue >> 1 & 1) << 24 | newValue >> 2 & 0xFFFFFF : oldValue & 0xFF000000 | newValue >> 2 & 0xFFFFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case R_ARM_ABS32: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)(symbolValue + addend);
                if (isThumb) {
                    newValue |= 1;
                }
                memory.setInt(relocationAddress, newValue);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                ARM_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                ARM_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_ARM_REL32: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - offset);
                if (isThumb) {
                    newValue |= 1;
                }
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_ARM_PREL31: {
                int oldValue = memory.getInt(relocationAddress);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 1 >> 1;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - offset);
                if (isThumb) {
                    newValue |= 1;
                }
                newValue = (newValue & Integer.MAX_VALUE) + (oldValue & Integer.MIN_VALUE);
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_ARM_LDR_PC_G0: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(false)));
                newValue = oldValue & 0xFF7FF000 | (~(newValue >> 31) & 1) << 23 | newValue >> 2 & 0xFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case R_ARM_ABS16: {
                short sValue = (short)(symbolValue + addend);
                memory.setShort(relocationAddress, sValue);
                byteLength = 2;
                break;
            }
            case R_ARM_ABS12: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                newValue = (int)(symbolValue + addend);
                newValue = oldValue & 0xFFFFF000 | newValue & 0xFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case R_ARM_ABS_8: {
                byte bValue = (byte)(symbolValue + addend);
                memory.setByte(relocationAddress, bValue);
                byteLength = 1;
                break;
            }
            case R_ARM_THM_JUMP24: 
            case R_ARM_THM_CALL: {
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - offset);
                short oldValueH = memory.getShort(relocationAddress, instructionBigEndian);
                short oldValueL = memory.getShort(relocationAddress.add(2L), instructionBigEndian);
                boolean isBLX = (oldValueL & 0x1000) == 0;
                int s = (oldValueH & 0x400) >> 10;
                int upper = oldValueH & 0x3FF;
                int lower = oldValueL & 0x7FF;
                int j1 = (oldValueL & 0x2000) >> 13;
                int j2 = (oldValueL & 0x800) >> 11;
                int i1 = j1 != s ? 0 : 1;
                int i2 = j2 != s ? 0 : 1;
                int origaddend = i1 << 23 | i2 << 22 | upper << 12 | lower << 1;
                origaddend = (origaddend | (s ^ 1) << 24) - 0x1000000;
                newValue += origaddend;
                short newValueH = (short)(oldValueH & 0xF800 | (newValue >>= 1) >> 11 & 0x7FF);
                short newValueL = (short)(oldValueL & 0xF800 | newValue & 0x7FF);
                if (isBLX) {
                    newValueL = (short)(newValueL & 0xFFFE);
                }
                memory.setShort(relocationAddress, newValueH, instructionBigEndian);
                memory.setShort(relocationAddress.add(2L), newValueL, instructionBigEndian);
                break;
            }
            case R_ARM_THM_PC8: {
                short oldValue = memory.getShort(relocationAddress, instructionBigEndian);
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(true)));
                short sValue = (short)(oldValue & 0xFF00 | (newValue >>= 1) & 0xFF);
                memory.setShort(relocationAddress, sValue, instructionBigEndian);
                byteLength = 2;
                break;
            }
            case R_ARM_GLOB_DAT: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)(symbolValue + addend);
                if (isThumb) {
                    newValue |= 1;
                }
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_ARM_JUMP_SLOT: {
                Function extFunction;
                boolean isExternalSym;
                MemoryBlock block = memory.getBlock(symbolAddr);
                boolean isPltSym = block != null && block.getName().startsWith(".plt");
                boolean bl = isExternalSym = block != null && "EXTERNAL".equals(block.getName());
                if (!isPltSym) {
                    memory.setInt(relocationAddress, (int)symbolValue);
                }
                if (!isPltSym && !isExternalSym || (extFunction = elfRelocationContext.getLoadHelper().createExternalFunctionLinkage(symbolName, symbolAddr, null)) != null) break;
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to create external function", elfRelocationContext.getLog());
                break;
            }
            case R_ARM_JUMP24: 
            case R_ARM_CALL: 
            case R_ARM_PLT32: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 8 >> 6;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(false)));
                newValue = (oldValue & 0xFF000000) == -83886080 ? oldValue & 0xFE000000 | (newValue >> 1 & 1) << 24 | newValue >> 2 & 0xFFFFFF : oldValue & 0xFF000000 | newValue >> 2 & 0xFFFFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case R_ARM_MOVW_ABS_NC: 
            case R_ARM_MOVT_ABS: {
                int oldValue;
                newValue = oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                oldValue = (oldValue & 0xF0000) >> 4 | oldValue & 0xFFF;
                oldValue = (oldValue ^ 0x8000) - 32768;
                oldValue = (int)((long)oldValue + symbolValue);
                if (type == ARM_ElfRelocationType.R_ARM_MOVT_ABS) {
                    oldValue >>= 16;
                }
                newValue &= 0xFFF0F000;
                memory.setInt(relocationAddress, newValue |= (oldValue & 0xF000) << 4 | oldValue & 0xFFF, instructionBigEndian);
                break;
            }
            case R_ARM_THM_MOVW_ABS_NC: 
            case R_ARM_THM_MOVT_ABS: 
            case R_ARM_THM_MOVW_PREL_NC: 
            case R_ARM_THM_MOVT_PREL: 
            case R_ARM_THM_MOVW_BREL_NC: 
            case R_ARM_THM_MOVW_BREL: 
            case R_ARM_THM_MOVT_BREL: {
                int oldValue = memory.getShort(relocationAddress, instructionBigEndian) << 16;
                oldValue |= memory.getShort(relocationAddress.add(2L), instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue >> 4 & 0xF000;
                    addend |= (long)(oldValue >> 15 & 0x800);
                    addend |= (long)(oldValue >> 4 & 0x700);
                    addend |= (long)(oldValue & 0xFF);
                    addend = (addend ^ 0x8000L) - 32768L;
                }
                int value = (int)(symbolValue + addend);
                if (type == ARM_ElfRelocationType.R_ARM_THM_MOVW_PREL_NC || type == ARM_ElfRelocationType.R_ARM_THM_MOVT_PREL) {
                    value = (int)((long)value - (offset + (long)elfRelocationContext.getPcBias(true)));
                }
                if (type == ARM_ElfRelocationType.R_ARM_THM_MOVT_ABS || type == ARM_ElfRelocationType.R_ARM_THM_MOVT_PREL || type == ARM_ElfRelocationType.R_ARM_THM_MOVT_BREL) {
                    value >>= 16;
                }
                newValue = oldValue & 0xFBF08F00;
                newValue |= (value & 0xF000) << 4;
                newValue |= (value & 0x800) << 15;
                newValue |= (value & 0x700) << 4;
                memory.setShort(relocationAddress, (short)((newValue |= value & 0xFF) >> 16), instructionBigEndian);
                memory.setShort(relocationAddress.add(2L), (short)newValue, instructionBigEndian);
                break;
            }
            case R_ARM_THM_JUMP11: {
                short oldValue = memory.getShort(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 21 >> 20;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(true)));
                newValue = oldValue & 0xF800 | newValue >> 1 & 0x7FF;
                memory.setShort(relocationAddress, (short)newValue, instructionBigEndian);
                byteLength = 2;
                break;
            }
            case R_ARM_THM_JUMP8: {
                short oldValue = memory.getShort(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 24 >> 23;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(true)));
                newValue = oldValue & 0xFF00 | newValue >> 1 & 0xFF;
                memory.setShort(relocationAddress, (short)newValue, instructionBigEndian);
                byteLength = 2;
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private boolean isThumb(ElfSymbol symbol) {
        return symbol != null && symbol.isFunction() && symbol.getValue() % 1L == 1L;
    }
}

