/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.ParsingIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.util.NoSuchElementException;

class GlobalReferenceOffsetIterator
implements ParsingIterator<Long> {
    private PdbByteReader reader;
    private Long currentGlobalReferenceOffset = null;

    public GlobalReferenceOffsetIterator(PdbByteReader reader) throws CancelledException, PdbException {
        this.reader = reader;
        this.processHeader();
    }

    @Override
    public boolean hasNext() {
        if (this.currentGlobalReferenceOffset == null) {
            this.find();
        }
        return this.currentGlobalReferenceOffset != null;
    }

    @Override
    public Long next() throws NoSuchElementException {
        if (this.hasNext()) {
            Long returnGlobalReferenceOffset = this.currentGlobalReferenceOffset;
            this.currentGlobalReferenceOffset = null;
            return returnGlobalReferenceOffset;
        }
        throw new NoSuchElementException("next() called with no more elements");
    }

    @Override
    public Long peek() throws NoSuchElementException {
        if (this.hasNext()) {
            return this.currentGlobalReferenceOffset;
        }
        throw new NoSuchElementException("peek() called with no more elements");
    }

    private void find() {
        try {
            this.currentGlobalReferenceOffset = this.reader.parseUnsignedIntVal();
        }
        catch (PdbException e) {
            Msg.error((Object)this, (Object)"Problem seen in find()", (Throwable)e);
            this.currentGlobalReferenceOffset = null;
        }
    }

    private void processHeader() throws PdbException {
        int sizeField = this.reader.parseInt();
        if (sizeField + 4 != this.reader.getLimit()) {
            throw new PdbException(String.format("Error in module global refs size field: %d != %d", sizeField, this.reader.getLimit()));
        }
    }
}

