/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class AssemblyNumericSymbols {
    public static final AssemblyNumericSymbols EMPTY = new AssemblyNumericSymbols();
    public final NavigableMap<String, Set<Long>> programEquates;
    public final NavigableMap<String, Set<Address>> languageLabels;
    private final Program program;

    private static NavigableMap<String, Set<Address>> collectLanguageLabels(Language language) {
        TreeMap<String, Set<Address>> labels = new TreeMap<String, Set<Address>>();
        for (Register reg : language.getRegisters()) {
            if (reg.getAddressSpace().isRegisterSpace()) continue;
            labels.computeIfAbsent(reg.getName(), n -> new HashSet()).add(reg.getAddress());
        }
        return labels;
    }

    private static Stream<Address> streamAddresses(Symbol sym) {
        SymbolType symbolType = sym.getSymbolType();
        if (symbolType == SymbolType.LABEL) {
            return Stream.of(sym.getAddress());
        }
        if (symbolType == SymbolType.FUNCTION) {
            Function function = (Function)sym.getObject();
            Address[] thunks = function.getFunctionThunkAddresses(true);
            return thunks == null ? Stream.of(sym.getAddress()) : Stream.concat(Stream.of(sym.getAddress()), Stream.of(thunks));
        }
        return Stream.of(new Address[0]);
    }

    private static Stream<Address> streamNonExternalAddresses(Symbol sym) {
        return AssemblyNumericSymbols.streamAddresses(sym).filter(a -> !a.isExternalAddress());
    }

    private static NavigableMap<String, Set<Long>> collectProgramEquates(Program program) {
        TreeMap<String, Set<Long>> equates = new TreeMap<String, Set<Long>>();
        Iterator<Equate> it = program.getEquateTable().getEquates();
        while (it.hasNext()) {
            Equate eq = it.next();
            equates.computeIfAbsent(eq.getDisplayName(), n -> new HashSet()).add(eq.getValue());
        }
        return equates;
    }

    public static AssemblyNumericSymbols fromLanguage(Language language) {
        return new AssemblyNumericSymbols(language);
    }

    public static AssemblyNumericSymbols fromProgram(Program program) {
        return new AssemblyNumericSymbols(program);
    }

    private AssemblyNumericSymbols() {
        this.program = null;
        this.programEquates = new TreeMap<String, Set<Long>>();
        this.languageLabels = new TreeMap<String, Set<Address>>();
    }

    private AssemblyNumericSymbols(Language language) {
        this.program = null;
        this.programEquates = new TreeMap<String, Set<Long>>();
        this.languageLabels = AssemblyNumericSymbols.collectLanguageLabels(language);
    }

    private AssemblyNumericSymbols(Program program) {
        this.program = program;
        this.programEquates = AssemblyNumericSymbols.collectProgramEquates(program);
        this.languageLabels = AssemblyNumericSymbols.collectLanguageLabels(program.getLanguage());
    }

    public Set<Long> chooseAll(String name) {
        TreeSet<Long> result = new TreeSet<Long>();
        result.addAll(this.programEquates.getOrDefault(name, Set.of()));
        if (this.program != null) {
            StreamSupport.stream(this.program.getSymbolTable().getSymbols(name).spliterator(), false).flatMap(sym -> AssemblyNumericSymbols.streamNonExternalAddresses(sym)).forEach(a -> result.add(a.getAddressableWordOffset()));
        }
        for (Address address : this.languageLabels.getOrDefault(name, Set.of())) {
            result.add(address.getAddressableWordOffset());
        }
        return result;
    }

    public Set<Long> chooseBySpace(String name, AddressSpace space) {
        TreeSet<Long> result = new TreeSet<Long>();
        if (this.program != null) {
            StreamSupport.stream(this.program.getSymbolTable().getSymbols(name).spliterator(), false).flatMap(sym -> AssemblyNumericSymbols.streamAddresses(sym)).filter(a -> a.getAddressSpace() == space).forEach(a -> result.add(a.getAddressableWordOffset()));
        }
        for (Address address : this.languageLabels.getOrDefault(name, Set.of())) {
            if (address.getAddressSpace() != space) continue;
            result.add(address.getAddressableWordOffset());
        }
        return result;
    }

    public Set<Long> choose(String name, AddressSpace space) {
        if (space == null || space.isConstantSpace()) {
            return this.chooseAll(name);
        }
        return this.chooseBySpace(name, space);
    }

    private void suggestFrom(List<String> result, String got, NavigableSet<String> keys, int max) {
        int count = 0;
        for (String k : keys.tailSet(got)) {
            if (count >= max || !k.startsWith(got)) {
                return;
            }
            result.add(k);
            ++count;
        }
    }

    private void suggestFromBySpace(List<String> result, String got, NavigableMap<String, Set<Address>> labels, int max, AddressSpace space) {
        int count = 0;
        for (Map.Entry ent : labels.entrySet()) {
            if (count >= max || !((String)ent.getKey()).startsWith(got)) {
                return;
            }
            if (!((Set)ent.getValue()).stream().anyMatch(a -> a.getAddressSpace() == space)) continue;
            result.add((String)ent.getKey());
            ++count;
        }
    }

    private void suggestFromProgramAny(List<String> result, String got, int max) {
        int count = 0;
        for (Symbol s : this.program.getSymbolTable().scanSymbolsByName(got)) {
            if (count >= max || !s.getName().startsWith(got)) {
                return;
            }
            if (AssemblyNumericSymbols.streamNonExternalAddresses(s).findAny().isEmpty()) continue;
            result.add(s.getName());
            ++count;
        }
    }

    private void suggestFromProgramBySpace(List<String> result, String got, int max, AddressSpace space) {
        int count = 0;
        for (Symbol s : this.program.getSymbolTable().scanSymbolsByName(got)) {
            if (count >= max || !s.getName().startsWith(got)) {
                return;
            }
            if (!AssemblyNumericSymbols.streamAddresses(s).anyMatch(a -> a.getAddressSpace() == space)) continue;
            result.add(s.getName());
            ++count;
        }
    }

    public Collection<String> suggestAny(String got, int max) {
        ArrayList<String> result = new ArrayList<String>();
        this.suggestFrom(result, got, this.languageLabels.navigableKeySet(), max);
        if (this.program == null) {
            return result;
        }
        this.suggestFrom(result, got, this.programEquates.navigableKeySet(), max);
        this.suggestFromProgramAny(result, got, max);
        Collections.sort(result);
        if (result.size() > max) {
            return result.subList(0, max);
        }
        return result;
    }

    public Collection<String> suggestBySpace(String got, AddressSpace space, int max) {
        ArrayList<String> result = new ArrayList<String>();
        this.suggestFromBySpace(result, got, this.languageLabels, max, space);
        if (this.program == null) {
            return result;
        }
        this.suggestFromProgramBySpace(result, got, max, space);
        Collections.sort(result);
        if (result.size() > max) {
            return result.subList(0, max);
        }
        return result;
    }

    public Collection<String> getSuggestions(String got, AddressSpace space, int max) {
        if (space == null || space.isConstantSpace()) {
            return this.suggestAny(got, max);
        }
        return this.suggestBySpace(got, space, max);
    }
}

