/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;

public class TypedefDataType
extends GenericDataType
implements TypeDef {
    private DataType dataType;
    private SettingsDefinition[] settingsDef;
    private boolean isAutoNamed = false;
    private boolean deleted = false;

    public TypedefDataType(String name, DataType dt) {
        this(CategoryPath.ROOT, name, dt, dt.getDataTypeManager());
    }

    public TypedefDataType(CategoryPath path, String name, DataType dt) {
        this(path, name, dt, dt.getDataTypeManager());
    }

    public TypedefDataType(CategoryPath path, String name, DataType dt, DataTypeManager dtm) {
        super(path, name, dtm);
        this.validate(dt);
        this.dataType = dt.clone(dtm);
        dt.addParent(this);
        this.defaultSettings = null;
    }

    public TypedefDataType(CategoryPath path, String name, DataType dt, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        this.validate(dt);
        this.dataType = dt.clone(dtm);
        dt.addParent(this);
        this.defaultSettings = null;
    }

    private void validate(DataType dt) {
        if (dt instanceof BitFieldDataType) {
            throw new IllegalArgumentException("TypeDef data-type may not be a bitfield: " + dt.getName());
        }
        if (dt instanceof FactoryDataType) {
            throw new IllegalArgumentException("TypeDef data-type may not be a Factory data-type: " + dt.getName());
        }
        if (dt instanceof Dynamic) {
            throw new IllegalArgumentException("TypeDef data-type may not be a Dynamic data-type: " + dt.getName());
        }
    }

    @Override
    public void enableAutoNaming() {
        if (this.isAutoNamed) {
            return;
        }
        this.isAutoNamed = true;
        this.notifyNameChanged(this.name);
    }

    @Override
    public boolean isAutoNamed() {
        return this.isAutoNamed;
    }

    @Override
    public String getDefaultLabelPrefix() {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultLabelPrefix();
        }
        return this.getName();
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultLabelPrefix(buf, settings, len, options);
        }
        return super.getDefaultLabelPrefix(buf, settings, len, options);
    }

    @Override
    public String getDefaultAbbreviatedLabelPrefix() {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultAbbreviatedLabelPrefix();
        }
        return super.getDefaultAbbreviatedLabelPrefix();
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        if (this.isAutoNamed()) {
            return this.getDataType().getDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength);
        }
        return super.getDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength);
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.dataType.hasLanguageDependantLength();
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeDef)) {
            return false;
        }
        TypeDef td = (TypeDef)obj;
        if (this.isAutoNamed != td.isAutoNamed()) {
            return false;
        }
        if (!this.isAutoNamed && !DataTypeUtilities.equalsIgnoreConflict(this.getName(), td.getName())) {
            return false;
        }
        if (!this.hasSameTypeDefSettings(td)) {
            return false;
        }
        DataType otherDataType = td.getDataType();
        if (DataTypeUtilities.isSameDataType(this.dataType, otherDataType)) {
            return true;
        }
        return this.dataType.isEquivalent(otherDataType);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getDescription() {
        return this.dataType.getDescription();
    }

    @Override
    public boolean isZeroLength() {
        return this.dataType.isZeroLength();
    }

    @Override
    public int getLength() {
        return this.dataType.getLength();
    }

    @Override
    public int getAlignedLength() {
        return this.dataType.getAlignedLength();
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.dataType.getRepresentation(buf, settings, length);
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.dataType.getValue(buf, settings, length);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.dataType.getValueClass(settings);
    }

    public static TypeDef clone(TypeDef typedef, DataTypeManager dtm) {
        if (typedef.getDataTypeManager() == dtm) {
            return typedef;
        }
        TypedefDataType newTypedef = new TypedefDataType(typedef.getCategoryPath(), typedef.getName(), typedef.getDataType(), typedef.getUniversalID(), typedef.getSourceArchive(), typedef.getLastChangeTime(), typedef.getLastChangeTimeInSourceArchive(), dtm);
        TypedefDataType.copyTypeDefSettings(typedef, newTypedef, false);
        newTypedef.isAutoNamed = typedef.isAutoNamed();
        return newTypedef;
    }

    public static TypedefDataType copy(TypeDef typedef, DataTypeManager dtm) {
        TypedefDataType newTypedef = new TypedefDataType(typedef.getCategoryPath(), typedef.getName(), typedef.getDataType(), dtm);
        TypedefDataType.copyTypeDefSettings(typedef, newTypedef, false);
        newTypedef.isAutoNamed = typedef.isAutoNamed();
        return newTypedef;
    }

    @Override
    public TypedefDataType clone(DataTypeManager dtm) {
        return (TypedefDataType)TypedefDataType.clone(this, dtm);
    }

    @Override
    public TypedefDataType copy(DataTypeManager dtm) {
        return TypedefDataType.copy(this, dtm);
    }

    @Override
    public String getName() {
        if (this.isAutoNamed()) {
            return TypedefDataType.generateTypedefName(this);
        }
        return super.getName();
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        super.setName(name);
        this.isAutoNamed = false;
    }

    @Override
    public void setCategoryPath(CategoryPath path) {
        if (this.isAutoNamed()) {
            return;
        }
        super.setCategoryPath(path);
    }

    @Override
    public CategoryPath getCategoryPath() {
        if (this.isAutoNamed()) {
            return this.getDataType().getCategoryPath();
        }
        return super.getCategoryPath();
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt == this.dataType) {
            this.notifySizeChanged();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        if (dt == this.dataType) {
            this.notifyAlignmentChanged();
        }
    }

    @Override
    public DataType getBaseDataType() {
        if (this.dataType instanceof TypeDef) {
            return ((TypeDef)this.dataType).getBaseDataType();
        }
        return this.dataType;
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.dataType == dt) {
            this.notifyDeleted();
            this.deleted = true;
        }
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        if (this.settingsDef == null) {
            DataType dt = this.getDataType();
            SettingsDefinition[] settingsDefinitions = dt.getSettingsDefinitions();
            TypeDefSettingsDefinition[] typeDefSettingsDefinitions = dt.getTypeDefSettingsDefinitions();
            this.settingsDef = new SettingsDefinition[settingsDefinitions.length + typeDefSettingsDefinitions.length];
            System.arraycopy(settingsDefinitions, 0, this.settingsDef, 0, settingsDefinitions.length);
            System.arraycopy(typeDefSettingsDefinitions, 0, this.settingsDef, settingsDefinitions.length, typeDefSettingsDefinitions.length);
        }
        return this.settingsDef;
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return this.getDataType().getTypeDefSettingsDefinitions();
    }

    @Override
    public Settings getDefaultSettings() {
        if (this.defaultSettings == null) {
            DataType dt = this.getDataType();
            SettingsImpl settings = dt.getTypeDefSettingsDefinitions().length == 0 ? new SettingsImpl(true) : new SettingsImpl(n -> this.isAllowedSetting((String)n));
            settings.setDefaultSettings(this.getDataType().getDefaultSettings());
            this.defaultSettings = settings;
        }
        return this.defaultSettings;
    }

    private boolean isAllowedSetting(String settingName) {
        for (TypeDefSettingsDefinition def : this.getTypeDefSettingsDefinitions()) {
            if (!def.getStorageKey().equals(settingName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        this.validate(newDt);
        if (oldDt == this.dataType) {
            this.settingsDef = null;
            if (this.dataMgr != null) {
                this.defaultSettings = null;
            }
            this.dataType = newDt;
            oldDt.removeParent(this);
            newDt.addParent(this);
            if (oldDt.getLength() != newDt.getLength()) {
                this.notifySizeChanged();
            } else if (oldDt.getAlignment() != newDt.getAlignment()) {
                this.notifyAlignmentChanged();
            }
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    public String toString() {
        if (this.isAutoNamed()) {
            return this.getName();
        }
        return "typedef " + this.getName() + " " + this.dataType.getName();
    }

    public static void copyTypeDefSettings(TypeDef src, TypeDef dest, boolean clearBeforeCopy) {
        Settings otherSettings;
        if (clearBeforeCopy) {
            Settings settings = dest.getDefaultSettings();
            settings.clearAllSettings();
        }
        if ((otherSettings = src.getDefaultSettings()).isEmpty()) {
            return;
        }
        Settings settings = dest.getDefaultSettings();
        for (TypeDefSettingsDefinition def : dest.getTypeDefSettingsDefinitions()) {
            def.copySetting(otherSettings, settings);
        }
    }

    public static String generateTypedefName(TypeDef modelType) {
        Settings settings = modelType.getDefaultSettings();
        StringBuilder attributesBuf = new StringBuilder();
        for (TypeDefSettingsDefinition def : modelType.getTypeDefSettingsDefinitions()) {
            String attribute = def.getAttributeSpecification(settings);
            if (attribute == null) continue;
            if (attributesBuf.length() != 0) {
                attributesBuf.append(',');
            }
            attributesBuf.append(attribute);
        }
        StringBuilder buf = new StringBuilder(modelType.getDataType().getName());
        buf.append(' ');
        buf.append("__((");
        buf.append((CharSequence)attributesBuf);
        buf.append("))");
        return buf.toString();
    }
}

