/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control.modal;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jungrapht.visualization.control.modal.Modal;

public class ModeControl
implements Modal {
    protected Modal.Mode mode;
    protected Set<Modal> modals;

    public static Builder builder() {
        return new Builder();
    }

    ModeControl(Builder builder) {
        this.mode = builder.mode;
        this.modals = builder.modals;
    }

    public boolean addModal(Modal modal) {
        return this.modals.add(modal);
    }

    public boolean removeModal(Modal modal) {
        return this.modals.remove(modal);
    }

    @Override
    public void setMode(Modal.Mode mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.modals.forEach(modal -> modal.setMode(mode));
        }
    }

    @Override
    public Modal.Mode getMode() {
        return this.mode;
    }

    public static class Builder {
        protected Modal.Mode mode;
        protected Set<Modal> modals = new LinkedHashSet<Modal>();

        public Builder mode(Modal.Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder modals(Modal ... modals) {
            this.modals = Stream.of(modals).collect(Collectors.toCollection(LinkedHashSet::new));
            return this;
        }

        public ModeControl build() {
            return new ModeControl(this);
        }
    }
}

