########################################################################
# This template script is sourced by /bin/sh when invoking the SYSTEM
# command (through the SIC logical GAG_PROCESS) at any GILDAS prompt.
# Because it is sourced, it must be POSIX-sh compliant for maximum
# portability.
#
# You could also choose to write it as a bash script (with specific bash
# syntax), insert the proper shebang on top (#!/bin/bash), make it
# executable, and execute it instead of sourcing it.
########################################################################

# Two goals must be achieved:
# 1/ open an interactive bash session
# 2/ customize the prompt (as SIC# or other)

# Naive version:
#   export PS1="SIC# "
#   bash  # Sub-shell should inherit PS1 exported in the current shell
# However this does not work if the user customizes its prompt in its
# init files (like .bashrc) but also on some OS (e.g. Debian 12) which
# overwrite inherited PS1 early at shell startup.

# Advanced version:
# This is not so obvious as bash can execute a script, it can open an
# interactive session, but it can not do both in a single call (!). The
# poor man solution is to open an interactive session with a custom init
# file (ensuring this custom init file does the usual init plus the
# custom commands like redefining PS1).

cat <<EOF 1>$GAG_GAG/tmp/gag-process.sh
  # Usual initializations
  if [ -e "$HOME/.bashrc" ]; then
    . $HOME/.bashrc
  fi
  # Custom PS1 prompt
  if [ -n "$GAG_PROGRAM" ]; then
    PS1="$GAG_PROGRAM# "
  else
    PS1="SIC# "
  fi
EOF

bash --init-file $GAG_GAG/tmp/gag-process.sh
rm $GAG_GAG/tmp/gag-process.sh
