// Code generated by 'tmplgen'; DO NOT EDIT.

//go:build goexperiment.simd && amd64

// This file contains functions testing binary simd methods.
// Each function in this file is specialized for a
// particular simd type <BaseType><Width>x<Count>.

package simd_test

import (
	"simd/archsimd"
	"testing"
)

// testInt8x16Binary tests the simd binary method f against the expected behavior generated by want
func testInt8x16Binary(t *testing.T, f func(_, _ archsimd.Int8x16) archsimd.Int8x16, want func(_, _ []int8) []int8) {
	n := 16
	t.Helper()
	forSlicePair(t, int8s, n, func(x, y []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		b := archsimd.LoadInt8x16Slice(y)
		g := make([]int8, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt16x8Binary tests the simd binary method f against the expected behavior generated by want
func testInt16x8Binary(t *testing.T, f func(_, _ archsimd.Int16x8) archsimd.Int16x8, want func(_, _ []int16) []int16) {
	n := 8
	t.Helper()
	forSlicePair(t, int16s, n, func(x, y []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		b := archsimd.LoadInt16x8Slice(y)
		g := make([]int16, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt32x4Binary tests the simd binary method f against the expected behavior generated by want
func testInt32x4Binary(t *testing.T, f func(_, _ archsimd.Int32x4) archsimd.Int32x4, want func(_, _ []int32) []int32) {
	n := 4
	t.Helper()
	forSlicePair(t, int32s, n, func(x, y []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		b := archsimd.LoadInt32x4Slice(y)
		g := make([]int32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt64x2Binary tests the simd binary method f against the expected behavior generated by want
func testInt64x2Binary(t *testing.T, f func(_, _ archsimd.Int64x2) archsimd.Int64x2, want func(_, _ []int64) []int64) {
	n := 2
	t.Helper()
	forSlicePair(t, int64s, n, func(x, y []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		b := archsimd.LoadInt64x2Slice(y)
		g := make([]int64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint8x16Binary tests the simd binary method f against the expected behavior generated by want
func testUint8x16Binary(t *testing.T, f func(_, _ archsimd.Uint8x16) archsimd.Uint8x16, want func(_, _ []uint8) []uint8) {
	n := 16
	t.Helper()
	forSlicePair(t, uint8s, n, func(x, y []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		b := archsimd.LoadUint8x16Slice(y)
		g := make([]uint8, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint16x8Binary tests the simd binary method f against the expected behavior generated by want
func testUint16x8Binary(t *testing.T, f func(_, _ archsimd.Uint16x8) archsimd.Uint16x8, want func(_, _ []uint16) []uint16) {
	n := 8
	t.Helper()
	forSlicePair(t, uint16s, n, func(x, y []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		b := archsimd.LoadUint16x8Slice(y)
		g := make([]uint16, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint32x4Binary tests the simd binary method f against the expected behavior generated by want
func testUint32x4Binary(t *testing.T, f func(_, _ archsimd.Uint32x4) archsimd.Uint32x4, want func(_, _ []uint32) []uint32) {
	n := 4
	t.Helper()
	forSlicePair(t, uint32s, n, func(x, y []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		b := archsimd.LoadUint32x4Slice(y)
		g := make([]uint32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint64x2Binary tests the simd binary method f against the expected behavior generated by want
func testUint64x2Binary(t *testing.T, f func(_, _ archsimd.Uint64x2) archsimd.Uint64x2, want func(_, _ []uint64) []uint64) {
	n := 2
	t.Helper()
	forSlicePair(t, uint64s, n, func(x, y []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		b := archsimd.LoadUint64x2Slice(y)
		g := make([]uint64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat32x4Binary tests the simd binary method f against the expected behavior generated by want
func testFloat32x4Binary(t *testing.T, f func(_, _ archsimd.Float32x4) archsimd.Float32x4, want func(_, _ []float32) []float32) {
	n := 4
	t.Helper()
	forSlicePair(t, float32s, n, func(x, y []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		b := archsimd.LoadFloat32x4Slice(y)
		g := make([]float32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat64x2Binary tests the simd binary method f against the expected behavior generated by want
func testFloat64x2Binary(t *testing.T, f func(_, _ archsimd.Float64x2) archsimd.Float64x2, want func(_, _ []float64) []float64) {
	n := 2
	t.Helper()
	forSlicePair(t, float64s, n, func(x, y []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		b := archsimd.LoadFloat64x2Slice(y)
		g := make([]float64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt8x32Binary tests the simd binary method f against the expected behavior generated by want
func testInt8x32Binary(t *testing.T, f func(_, _ archsimd.Int8x32) archsimd.Int8x32, want func(_, _ []int8) []int8) {
	n := 32
	t.Helper()
	forSlicePair(t, int8s, n, func(x, y []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		b := archsimd.LoadInt8x32Slice(y)
		g := make([]int8, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt16x16Binary tests the simd binary method f against the expected behavior generated by want
func testInt16x16Binary(t *testing.T, f func(_, _ archsimd.Int16x16) archsimd.Int16x16, want func(_, _ []int16) []int16) {
	n := 16
	t.Helper()
	forSlicePair(t, int16s, n, func(x, y []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		b := archsimd.LoadInt16x16Slice(y)
		g := make([]int16, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt32x8Binary tests the simd binary method f against the expected behavior generated by want
func testInt32x8Binary(t *testing.T, f func(_, _ archsimd.Int32x8) archsimd.Int32x8, want func(_, _ []int32) []int32) {
	n := 8
	t.Helper()
	forSlicePair(t, int32s, n, func(x, y []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		b := archsimd.LoadInt32x8Slice(y)
		g := make([]int32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt64x4Binary tests the simd binary method f against the expected behavior generated by want
func testInt64x4Binary(t *testing.T, f func(_, _ archsimd.Int64x4) archsimd.Int64x4, want func(_, _ []int64) []int64) {
	n := 4
	t.Helper()
	forSlicePair(t, int64s, n, func(x, y []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		b := archsimd.LoadInt64x4Slice(y)
		g := make([]int64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint8x32Binary tests the simd binary method f against the expected behavior generated by want
func testUint8x32Binary(t *testing.T, f func(_, _ archsimd.Uint8x32) archsimd.Uint8x32, want func(_, _ []uint8) []uint8) {
	n := 32
	t.Helper()
	forSlicePair(t, uint8s, n, func(x, y []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		b := archsimd.LoadUint8x32Slice(y)
		g := make([]uint8, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint16x16Binary tests the simd binary method f against the expected behavior generated by want
func testUint16x16Binary(t *testing.T, f func(_, _ archsimd.Uint16x16) archsimd.Uint16x16, want func(_, _ []uint16) []uint16) {
	n := 16
	t.Helper()
	forSlicePair(t, uint16s, n, func(x, y []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		b := archsimd.LoadUint16x16Slice(y)
		g := make([]uint16, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint32x8Binary tests the simd binary method f against the expected behavior generated by want
func testUint32x8Binary(t *testing.T, f func(_, _ archsimd.Uint32x8) archsimd.Uint32x8, want func(_, _ []uint32) []uint32) {
	n := 8
	t.Helper()
	forSlicePair(t, uint32s, n, func(x, y []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		b := archsimd.LoadUint32x8Slice(y)
		g := make([]uint32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint64x4Binary tests the simd binary method f against the expected behavior generated by want
func testUint64x4Binary(t *testing.T, f func(_, _ archsimd.Uint64x4) archsimd.Uint64x4, want func(_, _ []uint64) []uint64) {
	n := 4
	t.Helper()
	forSlicePair(t, uint64s, n, func(x, y []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		b := archsimd.LoadUint64x4Slice(y)
		g := make([]uint64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat32x8Binary tests the simd binary method f against the expected behavior generated by want
func testFloat32x8Binary(t *testing.T, f func(_, _ archsimd.Float32x8) archsimd.Float32x8, want func(_, _ []float32) []float32) {
	n := 8
	t.Helper()
	forSlicePair(t, float32s, n, func(x, y []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		b := archsimd.LoadFloat32x8Slice(y)
		g := make([]float32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat64x4Binary tests the simd binary method f against the expected behavior generated by want
func testFloat64x4Binary(t *testing.T, f func(_, _ archsimd.Float64x4) archsimd.Float64x4, want func(_, _ []float64) []float64) {
	n := 4
	t.Helper()
	forSlicePair(t, float64s, n, func(x, y []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		b := archsimd.LoadFloat64x4Slice(y)
		g := make([]float64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt8x64Binary tests the simd binary method f against the expected behavior generated by want
func testInt8x64Binary(t *testing.T, f func(_, _ archsimd.Int8x64) archsimd.Int8x64, want func(_, _ []int8) []int8) {
	n := 64
	t.Helper()
	forSlicePair(t, int8s, n, func(x, y []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		b := archsimd.LoadInt8x64Slice(y)
		g := make([]int8, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt16x32Binary tests the simd binary method f against the expected behavior generated by want
func testInt16x32Binary(t *testing.T, f func(_, _ archsimd.Int16x32) archsimd.Int16x32, want func(_, _ []int16) []int16) {
	n := 32
	t.Helper()
	forSlicePair(t, int16s, n, func(x, y []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		b := archsimd.LoadInt16x32Slice(y)
		g := make([]int16, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt32x16Binary tests the simd binary method f against the expected behavior generated by want
func testInt32x16Binary(t *testing.T, f func(_, _ archsimd.Int32x16) archsimd.Int32x16, want func(_, _ []int32) []int32) {
	n := 16
	t.Helper()
	forSlicePair(t, int32s, n, func(x, y []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		b := archsimd.LoadInt32x16Slice(y)
		g := make([]int32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt64x8Binary tests the simd binary method f against the expected behavior generated by want
func testInt64x8Binary(t *testing.T, f func(_, _ archsimd.Int64x8) archsimd.Int64x8, want func(_, _ []int64) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, int64s, n, func(x, y []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		b := archsimd.LoadInt64x8Slice(y)
		g := make([]int64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint8x64Binary tests the simd binary method f against the expected behavior generated by want
func testUint8x64Binary(t *testing.T, f func(_, _ archsimd.Uint8x64) archsimd.Uint8x64, want func(_, _ []uint8) []uint8) {
	n := 64
	t.Helper()
	forSlicePair(t, uint8s, n, func(x, y []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		b := archsimd.LoadUint8x64Slice(y)
		g := make([]uint8, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint16x32Binary tests the simd binary method f against the expected behavior generated by want
func testUint16x32Binary(t *testing.T, f func(_, _ archsimd.Uint16x32) archsimd.Uint16x32, want func(_, _ []uint16) []uint16) {
	n := 32
	t.Helper()
	forSlicePair(t, uint16s, n, func(x, y []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		b := archsimd.LoadUint16x32Slice(y)
		g := make([]uint16, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint32x16Binary tests the simd binary method f against the expected behavior generated by want
func testUint32x16Binary(t *testing.T, f func(_, _ archsimd.Uint32x16) archsimd.Uint32x16, want func(_, _ []uint32) []uint32) {
	n := 16
	t.Helper()
	forSlicePair(t, uint32s, n, func(x, y []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		b := archsimd.LoadUint32x16Slice(y)
		g := make([]uint32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint64x8Binary tests the simd binary method f against the expected behavior generated by want
func testUint64x8Binary(t *testing.T, f func(_, _ archsimd.Uint64x8) archsimd.Uint64x8, want func(_, _ []uint64) []uint64) {
	n := 8
	t.Helper()
	forSlicePair(t, uint64s, n, func(x, y []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		b := archsimd.LoadUint64x8Slice(y)
		g := make([]uint64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat32x16Binary tests the simd binary method f against the expected behavior generated by want
func testFloat32x16Binary(t *testing.T, f func(_, _ archsimd.Float32x16) archsimd.Float32x16, want func(_, _ []float32) []float32) {
	n := 16
	t.Helper()
	forSlicePair(t, float32s, n, func(x, y []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		b := archsimd.LoadFloat32x16Slice(y)
		g := make([]float32, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat64x8Binary tests the simd binary method f against the expected behavior generated by want
func testFloat64x8Binary(t *testing.T, f func(_, _ archsimd.Float64x8) archsimd.Float64x8, want func(_, _ []float64) []float64) {
	n := 8
	t.Helper()
	forSlicePair(t, float64s, n, func(x, y []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		b := archsimd.LoadFloat64x8Slice(y)
		g := make([]float64, n)
		f(a, b).StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}
