// Code generated by 'tmplgen'; DO NOT EDIT.

//go:build goexperiment.simd

package archsimd

import "unsafe"

// LoadInt8x16Slice loads an Int8x16 from a slice of at least 16 int8s.
func LoadInt8x16Slice(s []int8) Int8x16 {
	return LoadInt8x16((*[16]int8)(s))
}

// StoreSlice stores x into a slice of at least 16 int8s.
func (x Int8x16) StoreSlice(s []int8) {
	x.Store((*[16]int8)(s))
}

// LoadInt16x8Slice loads an Int16x8 from a slice of at least 8 int16s.
func LoadInt16x8Slice(s []int16) Int16x8 {
	return LoadInt16x8((*[8]int16)(s))
}

// StoreSlice stores x into a slice of at least 8 int16s.
func (x Int16x8) StoreSlice(s []int16) {
	x.Store((*[8]int16)(s))
}

// LoadInt32x4Slice loads an Int32x4 from a slice of at least 4 int32s.
func LoadInt32x4Slice(s []int32) Int32x4 {
	return LoadInt32x4((*[4]int32)(s))
}

// StoreSlice stores x into a slice of at least 4 int32s.
func (x Int32x4) StoreSlice(s []int32) {
	x.Store((*[4]int32)(s))
}

// LoadInt64x2Slice loads an Int64x2 from a slice of at least 2 int64s.
func LoadInt64x2Slice(s []int64) Int64x2 {
	return LoadInt64x2((*[2]int64)(s))
}

// StoreSlice stores x into a slice of at least 2 int64s.
func (x Int64x2) StoreSlice(s []int64) {
	x.Store((*[2]int64)(s))
}

// LoadUint8x16Slice loads an Uint8x16 from a slice of at least 16 uint8s.
func LoadUint8x16Slice(s []uint8) Uint8x16 {
	return LoadUint8x16((*[16]uint8)(s))
}

// StoreSlice stores x into a slice of at least 16 uint8s.
func (x Uint8x16) StoreSlice(s []uint8) {
	x.Store((*[16]uint8)(s))
}

// LoadUint16x8Slice loads an Uint16x8 from a slice of at least 8 uint16s.
func LoadUint16x8Slice(s []uint16) Uint16x8 {
	return LoadUint16x8((*[8]uint16)(s))
}

// StoreSlice stores x into a slice of at least 8 uint16s.
func (x Uint16x8) StoreSlice(s []uint16) {
	x.Store((*[8]uint16)(s))
}

// LoadUint32x4Slice loads an Uint32x4 from a slice of at least 4 uint32s.
func LoadUint32x4Slice(s []uint32) Uint32x4 {
	return LoadUint32x4((*[4]uint32)(s))
}

// StoreSlice stores x into a slice of at least 4 uint32s.
func (x Uint32x4) StoreSlice(s []uint32) {
	x.Store((*[4]uint32)(s))
}

// LoadUint64x2Slice loads an Uint64x2 from a slice of at least 2 uint64s.
func LoadUint64x2Slice(s []uint64) Uint64x2 {
	return LoadUint64x2((*[2]uint64)(s))
}

// StoreSlice stores x into a slice of at least 2 uint64s.
func (x Uint64x2) StoreSlice(s []uint64) {
	x.Store((*[2]uint64)(s))
}

// LoadFloat32x4Slice loads a Float32x4 from a slice of at least 4 float32s.
func LoadFloat32x4Slice(s []float32) Float32x4 {
	return LoadFloat32x4((*[4]float32)(s))
}

// StoreSlice stores x into a slice of at least 4 float32s.
func (x Float32x4) StoreSlice(s []float32) {
	x.Store((*[4]float32)(s))
}

// LoadFloat64x2Slice loads a Float64x2 from a slice of at least 2 float64s.
func LoadFloat64x2Slice(s []float64) Float64x2 {
	return LoadFloat64x2((*[2]float64)(s))
}

// StoreSlice stores x into a slice of at least 2 float64s.
func (x Float64x2) StoreSlice(s []float64) {
	x.Store((*[2]float64)(s))
}

// LoadInt8x32Slice loads an Int8x32 from a slice of at least 32 int8s.
func LoadInt8x32Slice(s []int8) Int8x32 {
	return LoadInt8x32((*[32]int8)(s))
}

// StoreSlice stores x into a slice of at least 32 int8s.
func (x Int8x32) StoreSlice(s []int8) {
	x.Store((*[32]int8)(s))
}

// LoadInt16x16Slice loads an Int16x16 from a slice of at least 16 int16s.
func LoadInt16x16Slice(s []int16) Int16x16 {
	return LoadInt16x16((*[16]int16)(s))
}

// StoreSlice stores x into a slice of at least 16 int16s.
func (x Int16x16) StoreSlice(s []int16) {
	x.Store((*[16]int16)(s))
}

// LoadInt32x8Slice loads an Int32x8 from a slice of at least 8 int32s.
func LoadInt32x8Slice(s []int32) Int32x8 {
	return LoadInt32x8((*[8]int32)(s))
}

// StoreSlice stores x into a slice of at least 8 int32s.
func (x Int32x8) StoreSlice(s []int32) {
	x.Store((*[8]int32)(s))
}

// LoadInt64x4Slice loads an Int64x4 from a slice of at least 4 int64s.
func LoadInt64x4Slice(s []int64) Int64x4 {
	return LoadInt64x4((*[4]int64)(s))
}

// StoreSlice stores x into a slice of at least 4 int64s.
func (x Int64x4) StoreSlice(s []int64) {
	x.Store((*[4]int64)(s))
}

// LoadUint8x32Slice loads an Uint8x32 from a slice of at least 32 uint8s.
func LoadUint8x32Slice(s []uint8) Uint8x32 {
	return LoadUint8x32((*[32]uint8)(s))
}

// StoreSlice stores x into a slice of at least 32 uint8s.
func (x Uint8x32) StoreSlice(s []uint8) {
	x.Store((*[32]uint8)(s))
}

// LoadUint16x16Slice loads an Uint16x16 from a slice of at least 16 uint16s.
func LoadUint16x16Slice(s []uint16) Uint16x16 {
	return LoadUint16x16((*[16]uint16)(s))
}

// StoreSlice stores x into a slice of at least 16 uint16s.
func (x Uint16x16) StoreSlice(s []uint16) {
	x.Store((*[16]uint16)(s))
}

// LoadUint32x8Slice loads an Uint32x8 from a slice of at least 8 uint32s.
func LoadUint32x8Slice(s []uint32) Uint32x8 {
	return LoadUint32x8((*[8]uint32)(s))
}

// StoreSlice stores x into a slice of at least 8 uint32s.
func (x Uint32x8) StoreSlice(s []uint32) {
	x.Store((*[8]uint32)(s))
}

// LoadUint64x4Slice loads an Uint64x4 from a slice of at least 4 uint64s.
func LoadUint64x4Slice(s []uint64) Uint64x4 {
	return LoadUint64x4((*[4]uint64)(s))
}

// StoreSlice stores x into a slice of at least 4 uint64s.
func (x Uint64x4) StoreSlice(s []uint64) {
	x.Store((*[4]uint64)(s))
}

// LoadFloat32x8Slice loads a Float32x8 from a slice of at least 8 float32s.
func LoadFloat32x8Slice(s []float32) Float32x8 {
	return LoadFloat32x8((*[8]float32)(s))
}

// StoreSlice stores x into a slice of at least 8 float32s.
func (x Float32x8) StoreSlice(s []float32) {
	x.Store((*[8]float32)(s))
}

// LoadFloat64x4Slice loads a Float64x4 from a slice of at least 4 float64s.
func LoadFloat64x4Slice(s []float64) Float64x4 {
	return LoadFloat64x4((*[4]float64)(s))
}

// StoreSlice stores x into a slice of at least 4 float64s.
func (x Float64x4) StoreSlice(s []float64) {
	x.Store((*[4]float64)(s))
}

// LoadInt8x64Slice loads an Int8x64 from a slice of at least 64 int8s.
func LoadInt8x64Slice(s []int8) Int8x64 {
	return LoadInt8x64((*[64]int8)(s))
}

// StoreSlice stores x into a slice of at least 64 int8s.
func (x Int8x64) StoreSlice(s []int8) {
	x.Store((*[64]int8)(s))
}

// LoadInt16x32Slice loads an Int16x32 from a slice of at least 32 int16s.
func LoadInt16x32Slice(s []int16) Int16x32 {
	return LoadInt16x32((*[32]int16)(s))
}

// StoreSlice stores x into a slice of at least 32 int16s.
func (x Int16x32) StoreSlice(s []int16) {
	x.Store((*[32]int16)(s))
}

// LoadInt32x16Slice loads an Int32x16 from a slice of at least 16 int32s.
func LoadInt32x16Slice(s []int32) Int32x16 {
	return LoadInt32x16((*[16]int32)(s))
}

// StoreSlice stores x into a slice of at least 16 int32s.
func (x Int32x16) StoreSlice(s []int32) {
	x.Store((*[16]int32)(s))
}

// LoadInt64x8Slice loads an Int64x8 from a slice of at least 8 int64s.
func LoadInt64x8Slice(s []int64) Int64x8 {
	return LoadInt64x8((*[8]int64)(s))
}

// StoreSlice stores x into a slice of at least 8 int64s.
func (x Int64x8) StoreSlice(s []int64) {
	x.Store((*[8]int64)(s))
}

// LoadUint8x64Slice loads an Uint8x64 from a slice of at least 64 uint8s.
func LoadUint8x64Slice(s []uint8) Uint8x64 {
	return LoadUint8x64((*[64]uint8)(s))
}

// StoreSlice stores x into a slice of at least 64 uint8s.
func (x Uint8x64) StoreSlice(s []uint8) {
	x.Store((*[64]uint8)(s))
}

// LoadUint16x32Slice loads an Uint16x32 from a slice of at least 32 uint16s.
func LoadUint16x32Slice(s []uint16) Uint16x32 {
	return LoadUint16x32((*[32]uint16)(s))
}

// StoreSlice stores x into a slice of at least 32 uint16s.
func (x Uint16x32) StoreSlice(s []uint16) {
	x.Store((*[32]uint16)(s))
}

// LoadUint32x16Slice loads an Uint32x16 from a slice of at least 16 uint32s.
func LoadUint32x16Slice(s []uint32) Uint32x16 {
	return LoadUint32x16((*[16]uint32)(s))
}

// StoreSlice stores x into a slice of at least 16 uint32s.
func (x Uint32x16) StoreSlice(s []uint32) {
	x.Store((*[16]uint32)(s))
}

// LoadUint64x8Slice loads an Uint64x8 from a slice of at least 8 uint64s.
func LoadUint64x8Slice(s []uint64) Uint64x8 {
	return LoadUint64x8((*[8]uint64)(s))
}

// StoreSlice stores x into a slice of at least 8 uint64s.
func (x Uint64x8) StoreSlice(s []uint64) {
	x.Store((*[8]uint64)(s))
}

// LoadFloat32x16Slice loads a Float32x16 from a slice of at least 16 float32s.
func LoadFloat32x16Slice(s []float32) Float32x16 {
	return LoadFloat32x16((*[16]float32)(s))
}

// StoreSlice stores x into a slice of at least 16 float32s.
func (x Float32x16) StoreSlice(s []float32) {
	x.Store((*[16]float32)(s))
}

// LoadFloat64x8Slice loads a Float64x8 from a slice of at least 8 float64s.
func LoadFloat64x8Slice(s []float64) Float64x8 {
	return LoadFloat64x8((*[8]float64)(s))
}

// StoreSlice stores x into a slice of at least 8 float64s.
func (x Float64x8) StoreSlice(s []float64) {
	x.Store((*[8]float64)(s))
}

// LoadInt8x64SlicePart loads a Int8x64 from the slice s.
// If s has fewer than 64 elements, the remaining elements of the vector are filled with zeroes.
// If s has 64 or more elements, the function is equivalent to LoadInt8x64Slice.
func LoadInt8x64SlicePart(s []int8) Int8x64 {
	l := len(s)
	if l >= 64 {
		return LoadInt8x64Slice(s)
	}
	if l == 0 {
		var x Int8x64
		return x
	}
	mask := Mask8x64FromBits(0xffffffffffffffff >> (64 - l))
	return LoadMaskedInt8x64(paInt8x64(s), mask)
}

// StoreSlicePart stores the 64 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 64 or more elements, the method is equivalent to x.StoreSlice.
func (x Int8x64) StoreSlicePart(s []int8) {
	l := len(s)
	if l >= 64 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask8x64FromBits(0xffffffffffffffff >> (64 - l))
	x.StoreMasked(paInt8x64(s), mask)
}

// LoadInt16x32SlicePart loads a Int16x32 from the slice s.
// If s has fewer than 32 elements, the remaining elements of the vector are filled with zeroes.
// If s has 32 or more elements, the function is equivalent to LoadInt16x32Slice.
func LoadInt16x32SlicePart(s []int16) Int16x32 {
	l := len(s)
	if l >= 32 {
		return LoadInt16x32Slice(s)
	}
	if l == 0 {
		var x Int16x32
		return x
	}
	mask := Mask16x32FromBits(0xffffffff >> (32 - l))
	return LoadMaskedInt16x32(paInt16x32(s), mask)
}

// StoreSlicePart stores the 32 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 32 or more elements, the method is equivalent to x.StoreSlice.
func (x Int16x32) StoreSlicePart(s []int16) {
	l := len(s)
	if l >= 32 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask16x32FromBits(0xffffffff >> (32 - l))
	x.StoreMasked(paInt16x32(s), mask)
}

// LoadInt32x16SlicePart loads a Int32x16 from the slice s.
// If s has fewer than 16 elements, the remaining elements of the vector are filled with zeroes.
// If s has 16 or more elements, the function is equivalent to LoadInt32x16Slice.
func LoadInt32x16SlicePart(s []int32) Int32x16 {
	l := len(s)
	if l >= 16 {
		return LoadInt32x16Slice(s)
	}
	if l == 0 {
		var x Int32x16
		return x
	}
	mask := Mask32x16FromBits(0xffff >> (16 - l))
	return LoadMaskedInt32x16(paInt32x16(s), mask)
}

// StoreSlicePart stores the 16 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 16 or more elements, the method is equivalent to x.StoreSlice.
func (x Int32x16) StoreSlicePart(s []int32) {
	l := len(s)
	if l >= 16 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask32x16FromBits(0xffff >> (16 - l))
	x.StoreMasked(paInt32x16(s), mask)
}

// LoadInt64x8SlicePart loads a Int64x8 from the slice s.
// If s has fewer than 8 elements, the remaining elements of the vector are filled with zeroes.
// If s has 8 or more elements, the function is equivalent to LoadInt64x8Slice.
func LoadInt64x8SlicePart(s []int64) Int64x8 {
	l := len(s)
	if l >= 8 {
		return LoadInt64x8Slice(s)
	}
	if l == 0 {
		var x Int64x8
		return x
	}
	mask := Mask64x8FromBits(0xff >> (8 - l))
	return LoadMaskedInt64x8(paInt64x8(s), mask)
}

// StoreSlicePart stores the 8 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 8 or more elements, the method is equivalent to x.StoreSlice.
func (x Int64x8) StoreSlicePart(s []int64) {
	l := len(s)
	if l >= 8 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask64x8FromBits(0xff >> (8 - l))
	x.StoreMasked(paInt64x8(s), mask)
}

// LoadUint8x64SlicePart loads a Uint8x64 from the slice s.
// If s has fewer than 64 elements, the remaining elements of the vector are filled with zeroes.
// If s has 64 or more elements, the function is equivalent to LoadUint8x64Slice.
func LoadUint8x64SlicePart(s []uint8) Uint8x64 {
	l := len(s)
	if l >= 64 {
		return LoadUint8x64Slice(s)
	}
	if l == 0 {
		var x Uint8x64
		return x
	}
	mask := Mask8x64FromBits(0xffffffffffffffff >> (64 - l))
	return LoadMaskedUint8x64(paUint8x64(s), mask)
}

// StoreSlicePart stores the 64 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 64 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint8x64) StoreSlicePart(s []uint8) {
	l := len(s)
	if l >= 64 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask8x64FromBits(0xffffffffffffffff >> (64 - l))
	x.StoreMasked(paUint8x64(s), mask)
}

// LoadUint16x32SlicePart loads a Uint16x32 from the slice s.
// If s has fewer than 32 elements, the remaining elements of the vector are filled with zeroes.
// If s has 32 or more elements, the function is equivalent to LoadUint16x32Slice.
func LoadUint16x32SlicePart(s []uint16) Uint16x32 {
	l := len(s)
	if l >= 32 {
		return LoadUint16x32Slice(s)
	}
	if l == 0 {
		var x Uint16x32
		return x
	}
	mask := Mask16x32FromBits(0xffffffff >> (32 - l))
	return LoadMaskedUint16x32(paUint16x32(s), mask)
}

// StoreSlicePart stores the 32 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 32 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint16x32) StoreSlicePart(s []uint16) {
	l := len(s)
	if l >= 32 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask16x32FromBits(0xffffffff >> (32 - l))
	x.StoreMasked(paUint16x32(s), mask)
}

// LoadUint32x16SlicePart loads a Uint32x16 from the slice s.
// If s has fewer than 16 elements, the remaining elements of the vector are filled with zeroes.
// If s has 16 or more elements, the function is equivalent to LoadUint32x16Slice.
func LoadUint32x16SlicePart(s []uint32) Uint32x16 {
	l := len(s)
	if l >= 16 {
		return LoadUint32x16Slice(s)
	}
	if l == 0 {
		var x Uint32x16
		return x
	}
	mask := Mask32x16FromBits(0xffff >> (16 - l))
	return LoadMaskedUint32x16(paUint32x16(s), mask)
}

// StoreSlicePart stores the 16 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 16 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint32x16) StoreSlicePart(s []uint32) {
	l := len(s)
	if l >= 16 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask32x16FromBits(0xffff >> (16 - l))
	x.StoreMasked(paUint32x16(s), mask)
}

// LoadUint64x8SlicePart loads a Uint64x8 from the slice s.
// If s has fewer than 8 elements, the remaining elements of the vector are filled with zeroes.
// If s has 8 or more elements, the function is equivalent to LoadUint64x8Slice.
func LoadUint64x8SlicePart(s []uint64) Uint64x8 {
	l := len(s)
	if l >= 8 {
		return LoadUint64x8Slice(s)
	}
	if l == 0 {
		var x Uint64x8
		return x
	}
	mask := Mask64x8FromBits(0xff >> (8 - l))
	return LoadMaskedUint64x8(paUint64x8(s), mask)
}

// StoreSlicePart stores the 8 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 8 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint64x8) StoreSlicePart(s []uint64) {
	l := len(s)
	if l >= 8 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask64x8FromBits(0xff >> (8 - l))
	x.StoreMasked(paUint64x8(s), mask)
}

// LoadFloat32x16SlicePart loads a Float32x16 from the slice s.
// If s has fewer than 16 elements, the remaining elements of the vector are filled with zeroes.
// If s has 16 or more elements, the function is equivalent to LoadFloat32x16Slice.
func LoadFloat32x16SlicePart(s []float32) Float32x16 {
	l := len(s)
	if l >= 16 {
		return LoadFloat32x16Slice(s)
	}
	if l == 0 {
		var x Float32x16
		return x
	}
	mask := Mask32x16FromBits(0xffff >> (16 - l))
	return LoadMaskedFloat32x16(paFloat32x16(s), mask)
}

// StoreSlicePart stores the 16 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 16 or more elements, the method is equivalent to x.StoreSlice.
func (x Float32x16) StoreSlicePart(s []float32) {
	l := len(s)
	if l >= 16 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask32x16FromBits(0xffff >> (16 - l))
	x.StoreMasked(paFloat32x16(s), mask)
}

// LoadFloat64x8SlicePart loads a Float64x8 from the slice s.
// If s has fewer than 8 elements, the remaining elements of the vector are filled with zeroes.
// If s has 8 or more elements, the function is equivalent to LoadFloat64x8Slice.
func LoadFloat64x8SlicePart(s []float64) Float64x8 {
	l := len(s)
	if l >= 8 {
		return LoadFloat64x8Slice(s)
	}
	if l == 0 {
		var x Float64x8
		return x
	}
	mask := Mask64x8FromBits(0xff >> (8 - l))
	return LoadMaskedFloat64x8(paFloat64x8(s), mask)
}

// StoreSlicePart stores the 8 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 8 or more elements, the method is equivalent to x.StoreSlice.
func (x Float64x8) StoreSlicePart(s []float64) {
	l := len(s)
	if l >= 8 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := Mask64x8FromBits(0xff >> (8 - l))
	x.StoreMasked(paFloat64x8(s), mask)
}

// LoadInt32x4SlicePart loads a Int32x4 from the slice s.
// If s has fewer than 4 elements, the remaining elements of the vector are filled with zeroes.
// If s has 4 or more elements, the function is equivalent to LoadInt32x4Slice.
func LoadInt32x4SlicePart(s []int32) Int32x4 {
	l := len(s)
	if l >= 4 {
		return LoadInt32x4Slice(s)
	}
	if l == 0 {
		var x Int32x4
		return x
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	return LoadMaskedInt32x4(paInt32x4(s), LoadInt32x4Slice(mask).asMask())
}

// StoreSlicePart stores the 4 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 4 or more elements, the method is equivalent to x.StoreSlice.
func (x Int32x4) StoreSlicePart(s []int32) {
	l := len(s)
	if l >= 4 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	x.StoreMasked(paInt32x4(s), LoadInt32x4Slice(mask).asMask())
}

// LoadInt64x2SlicePart loads a Int64x2 from the slice s.
// If s has fewer than 2 elements, the remaining elements of the vector are filled with zeroes.
// If s has 2 or more elements, the function is equivalent to LoadInt64x2Slice.
func LoadInt64x2SlicePart(s []int64) Int64x2 {
	l := len(s)
	if l >= 2 {
		return LoadInt64x2Slice(s)
	}
	if l == 0 {
		var x Int64x2
		return x
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	return LoadMaskedInt64x2(paInt64x2(s), LoadInt64x2Slice(mask).asMask())
}

// StoreSlicePart stores the 2 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 2 or more elements, the method is equivalent to x.StoreSlice.
func (x Int64x2) StoreSlicePart(s []int64) {
	l := len(s)
	if l >= 2 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	x.StoreMasked(paInt64x2(s), LoadInt64x2Slice(mask).asMask())
}

// LoadUint32x4SlicePart loads a Uint32x4 from the slice s.
// If s has fewer than 4 elements, the remaining elements of the vector are filled with zeroes.
// If s has 4 or more elements, the function is equivalent to LoadUint32x4Slice.
func LoadUint32x4SlicePart(s []uint32) Uint32x4 {
	l := len(s)
	if l >= 4 {
		return LoadUint32x4Slice(s)
	}
	if l == 0 {
		var x Uint32x4
		return x
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	return LoadMaskedUint32x4(paUint32x4(s), LoadInt32x4Slice(mask).asMask())
}

// StoreSlicePart stores the 4 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 4 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint32x4) StoreSlicePart(s []uint32) {
	l := len(s)
	if l >= 4 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	x.StoreMasked(paUint32x4(s), LoadInt32x4Slice(mask).asMask())
}

// LoadUint64x2SlicePart loads a Uint64x2 from the slice s.
// If s has fewer than 2 elements, the remaining elements of the vector are filled with zeroes.
// If s has 2 or more elements, the function is equivalent to LoadUint64x2Slice.
func LoadUint64x2SlicePart(s []uint64) Uint64x2 {
	l := len(s)
	if l >= 2 {
		return LoadUint64x2Slice(s)
	}
	if l == 0 {
		var x Uint64x2
		return x
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	return LoadMaskedUint64x2(paUint64x2(s), LoadInt64x2Slice(mask).asMask())
}

// StoreSlicePart stores the 2 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 2 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint64x2) StoreSlicePart(s []uint64) {
	l := len(s)
	if l >= 2 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	x.StoreMasked(paUint64x2(s), LoadInt64x2Slice(mask).asMask())
}

// LoadFloat32x4SlicePart loads a Float32x4 from the slice s.
// If s has fewer than 4 elements, the remaining elements of the vector are filled with zeroes.
// If s has 4 or more elements, the function is equivalent to LoadFloat32x4Slice.
func LoadFloat32x4SlicePart(s []float32) Float32x4 {
	l := len(s)
	if l >= 4 {
		return LoadFloat32x4Slice(s)
	}
	if l == 0 {
		var x Float32x4
		return x
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	return LoadMaskedFloat32x4(paFloat32x4(s), LoadInt32x4Slice(mask).asMask())
}

// StoreSlicePart stores the 4 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 4 or more elements, the method is equivalent to x.StoreSlice.
func (x Float32x4) StoreSlicePart(s []float32) {
	l := len(s)
	if l >= 4 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	x.StoreMasked(paFloat32x4(s), LoadInt32x4Slice(mask).asMask())
}

// LoadFloat64x2SlicePart loads a Float64x2 from the slice s.
// If s has fewer than 2 elements, the remaining elements of the vector are filled with zeroes.
// If s has 2 or more elements, the function is equivalent to LoadFloat64x2Slice.
func LoadFloat64x2SlicePart(s []float64) Float64x2 {
	l := len(s)
	if l >= 2 {
		return LoadFloat64x2Slice(s)
	}
	if l == 0 {
		var x Float64x2
		return x
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	return LoadMaskedFloat64x2(paFloat64x2(s), LoadInt64x2Slice(mask).asMask())
}

// StoreSlicePart stores the 2 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 2 or more elements, the method is equivalent to x.StoreSlice.
func (x Float64x2) StoreSlicePart(s []float64) {
	l := len(s)
	if l >= 2 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	x.StoreMasked(paFloat64x2(s), LoadInt64x2Slice(mask).asMask())
}

// LoadInt32x8SlicePart loads a Int32x8 from the slice s.
// If s has fewer than 8 elements, the remaining elements of the vector are filled with zeroes.
// If s has 8 or more elements, the function is equivalent to LoadInt32x8Slice.
func LoadInt32x8SlicePart(s []int32) Int32x8 {
	l := len(s)
	if l >= 8 {
		return LoadInt32x8Slice(s)
	}
	if l == 0 {
		var x Int32x8
		return x
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	return LoadMaskedInt32x8(paInt32x8(s), LoadInt32x8Slice(mask).asMask())
}

// StoreSlicePart stores the 8 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 8 or more elements, the method is equivalent to x.StoreSlice.
func (x Int32x8) StoreSlicePart(s []int32) {
	l := len(s)
	if l >= 8 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	x.StoreMasked(paInt32x8(s), LoadInt32x8Slice(mask).asMask())
}

// LoadInt64x4SlicePart loads a Int64x4 from the slice s.
// If s has fewer than 4 elements, the remaining elements of the vector are filled with zeroes.
// If s has 4 or more elements, the function is equivalent to LoadInt64x4Slice.
func LoadInt64x4SlicePart(s []int64) Int64x4 {
	l := len(s)
	if l >= 4 {
		return LoadInt64x4Slice(s)
	}
	if l == 0 {
		var x Int64x4
		return x
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	return LoadMaskedInt64x4(paInt64x4(s), LoadInt64x4Slice(mask).asMask())
}

// StoreSlicePart stores the 4 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 4 or more elements, the method is equivalent to x.StoreSlice.
func (x Int64x4) StoreSlicePart(s []int64) {
	l := len(s)
	if l >= 4 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	x.StoreMasked(paInt64x4(s), LoadInt64x4Slice(mask).asMask())
}

// LoadUint32x8SlicePart loads a Uint32x8 from the slice s.
// If s has fewer than 8 elements, the remaining elements of the vector are filled with zeroes.
// If s has 8 or more elements, the function is equivalent to LoadUint32x8Slice.
func LoadUint32x8SlicePart(s []uint32) Uint32x8 {
	l := len(s)
	if l >= 8 {
		return LoadUint32x8Slice(s)
	}
	if l == 0 {
		var x Uint32x8
		return x
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	return LoadMaskedUint32x8(paUint32x8(s), LoadInt32x8Slice(mask).asMask())
}

// StoreSlicePart stores the 8 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 8 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint32x8) StoreSlicePart(s []uint32) {
	l := len(s)
	if l >= 8 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	x.StoreMasked(paUint32x8(s), LoadInt32x8Slice(mask).asMask())
}

// LoadUint64x4SlicePart loads a Uint64x4 from the slice s.
// If s has fewer than 4 elements, the remaining elements of the vector are filled with zeroes.
// If s has 4 or more elements, the function is equivalent to LoadUint64x4Slice.
func LoadUint64x4SlicePart(s []uint64) Uint64x4 {
	l := len(s)
	if l >= 4 {
		return LoadUint64x4Slice(s)
	}
	if l == 0 {
		var x Uint64x4
		return x
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	return LoadMaskedUint64x4(paUint64x4(s), LoadInt64x4Slice(mask).asMask())
}

// StoreSlicePart stores the 4 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 4 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint64x4) StoreSlicePart(s []uint64) {
	l := len(s)
	if l >= 4 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	x.StoreMasked(paUint64x4(s), LoadInt64x4Slice(mask).asMask())
}

// LoadFloat32x8SlicePart loads a Float32x8 from the slice s.
// If s has fewer than 8 elements, the remaining elements of the vector are filled with zeroes.
// If s has 8 or more elements, the function is equivalent to LoadFloat32x8Slice.
func LoadFloat32x8SlicePart(s []float32) Float32x8 {
	l := len(s)
	if l >= 8 {
		return LoadFloat32x8Slice(s)
	}
	if l == 0 {
		var x Float32x8
		return x
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	return LoadMaskedFloat32x8(paFloat32x8(s), LoadInt32x8Slice(mask).asMask())
}

// StoreSlicePart stores the 8 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 8 or more elements, the method is equivalent to x.StoreSlice.
func (x Float32x8) StoreSlicePart(s []float32) {
	l := len(s)
	if l >= 8 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask32[len(vecMask32)/2-l:]
	x.StoreMasked(paFloat32x8(s), LoadInt32x8Slice(mask).asMask())
}

// LoadFloat64x4SlicePart loads a Float64x4 from the slice s.
// If s has fewer than 4 elements, the remaining elements of the vector are filled with zeroes.
// If s has 4 or more elements, the function is equivalent to LoadFloat64x4Slice.
func LoadFloat64x4SlicePart(s []float64) Float64x4 {
	l := len(s)
	if l >= 4 {
		return LoadFloat64x4Slice(s)
	}
	if l == 0 {
		var x Float64x4
		return x
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	return LoadMaskedFloat64x4(paFloat64x4(s), LoadInt64x4Slice(mask).asMask())
}

// StoreSlicePart stores the 4 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 4 or more elements, the method is equivalent to x.StoreSlice.
func (x Float64x4) StoreSlicePart(s []float64) {
	l := len(s)
	if l >= 4 {
		x.StoreSlice(s)
		return
	}
	if l == 0 {
		return
	}
	mask := vecMask64[len(vecMask64)/2-l:]
	x.StoreMasked(paFloat64x4(s), LoadInt64x4Slice(mask).asMask())
}

// LoadUint8x16SlicePart loads a Uint8x16 from the slice s.
// If s has fewer than 16 elements, the remaining elements of the vector are filled with zeroes.
// If s has 16 or more elements, the function is equivalent to LoadUint8x16Slice.
func LoadUint8x16SlicePart(s []uint8) Uint8x16 {
	if len(s) == 0 {
		var zero Uint8x16
		return zero
	}
	t := unsafe.Slice((*int8)(unsafe.Pointer(&s[0])), len(s))
	return LoadInt8x16SlicePart(t).AsUint8x16()
}

// StoreSlicePart stores the 16 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 16 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint8x16) StoreSlicePart(s []uint8) {
	if len(s) == 0 {
		return
	}
	t := unsafe.Slice((*int8)(unsafe.Pointer(&s[0])), len(s))
	x.AsInt8x16().StoreSlicePart(t)
}

// LoadUint16x8SlicePart loads a Uint16x8 from the slice s.
// If s has fewer than 8 elements, the remaining elements of the vector are filled with zeroes.
// If s has 8 or more elements, the function is equivalent to LoadUint16x8Slice.
func LoadUint16x8SlicePart(s []uint16) Uint16x8 {
	if len(s) == 0 {
		var zero Uint16x8
		return zero
	}
	t := unsafe.Slice((*int16)(unsafe.Pointer(&s[0])), len(s))
	return LoadInt16x8SlicePart(t).AsUint16x8()
}

// StoreSlicePart stores the 8 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 8 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint16x8) StoreSlicePart(s []uint16) {
	if len(s) == 0 {
		return
	}
	t := unsafe.Slice((*int16)(unsafe.Pointer(&s[0])), len(s))
	x.AsInt16x8().StoreSlicePart(t)
}

// LoadUint8x32SlicePart loads a Uint8x32 from the slice s.
// If s has fewer than 32 elements, the remaining elements of the vector are filled with zeroes.
// If s has 32 or more elements, the function is equivalent to LoadUint8x32Slice.
func LoadUint8x32SlicePart(s []uint8) Uint8x32 {
	if len(s) == 0 {
		var zero Uint8x32
		return zero
	}
	t := unsafe.Slice((*int8)(unsafe.Pointer(&s[0])), len(s))
	return LoadInt8x32SlicePart(t).AsUint8x32()
}

// StoreSlicePart stores the 32 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 32 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint8x32) StoreSlicePart(s []uint8) {
	if len(s) == 0 {
		return
	}
	t := unsafe.Slice((*int8)(unsafe.Pointer(&s[0])), len(s))
	x.AsInt8x32().StoreSlicePart(t)
}

// LoadUint16x16SlicePart loads a Uint16x16 from the slice s.
// If s has fewer than 16 elements, the remaining elements of the vector are filled with zeroes.
// If s has 16 or more elements, the function is equivalent to LoadUint16x16Slice.
func LoadUint16x16SlicePart(s []uint16) Uint16x16 {
	if len(s) == 0 {
		var zero Uint16x16
		return zero
	}
	t := unsafe.Slice((*int16)(unsafe.Pointer(&s[0])), len(s))
	return LoadInt16x16SlicePart(t).AsUint16x16()
}

// StoreSlicePart stores the 16 elements of x into the slice s.
// It stores as many elements as will fit in s.
// If s has 16 or more elements, the method is equivalent to x.StoreSlice.
func (x Uint16x16) StoreSlicePart(s []uint16) {
	if len(s) == 0 {
		return
	}
	t := unsafe.Slice((*int16)(unsafe.Pointer(&s[0])), len(s))
	x.AsInt16x16().StoreSlicePart(t)
}
