"""Generated message classes for hypercomputecluster version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'hypercomputecluster'


class AnalyzerReport(_messages.Message):
  r"""A detailed report from a specific analyzer.

  Enums:
    AnalyzerIdentityValueValuesEnum: Required. The identity of the analyzer
      that found the issue.

  Fields:
    analyzerIdentity: Required. The identity of the analyzer that found the
      issue.
    confidenceScore: Optional. Confidence score of the analysis. The value is
      between 0.0 and 1.0.
    recommendedActions: Optional. Recommended actions to take.
    rootCauseFound: Optional. Indicates whether a root cause was found for the
      event.
    thermalDetails: Optional. Thermal analysis details.
  """

  class AnalyzerIdentityValueValuesEnum(_messages.Enum):
    r"""Required. The identity of the analyzer that found the issue.

    Values:
      ANALYZER_IDENTITY_UNSPECIFIED: Analyzer identity is not specified.
    """
    ANALYZER_IDENTITY_UNSPECIFIED = 0

  analyzerIdentity = _messages.EnumField('AnalyzerIdentityValueValuesEnum', 1)
  confidenceScore = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  recommendedActions = _messages.MessageField('RecommendedAction', 3, repeated=True)
  rootCauseFound = _messages.BooleanField(4)
  thermalDetails = _messages.MessageField('ThermalAnalysisDetails', 5)


class Artifacts(_messages.Message):
  r"""Represents information about the artifacts of the Machine Learning Run.

  Fields:
    gcsPath: Required. The Cloud Storage path where the artifacts of the run
      are stored. Example: `gs://my-bucket/my-run-directory`.
  """

  gcsPath = _messages.StringField(1)


class AtmTag(_messages.Message):
  r"""Unstable: Contact hypercompute-service-eng@ before using.

  Fields:
    key: Required. Unstable: Contact hypercompute-service-eng@ before using.
    value: Required. Unstable: Contact hypercompute-service-eng@ before using.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class BootDisk(_messages.Message):
  r"""A [Persistent disk](https://cloud.google.com/compute/docs/disks) used as
  the boot disk for a Compute Engine VM instance.

  Fields:
    effectiveImage: Output only. The specific image family that will be used
      for new VM instances using this disk. If image is non-empty, this field
      will be set to the same value as `image`. Otherwise, this field will be
      set to a system-selected image.
    image: Optional. Source image family used to create this disk. Must be a
      supported disk family for the VM instance's machine type. If no family
      is specified, the system will select a supported image family based on
      the machine type. If this field is cleared, the system will continue to
      use the current image family.
    sizeGb: Required. Immutable. Size of the disk in gigabytes. Must be at
      least 10GB.
    type: Required. Immutable. [Persistent disk
      type](https://cloud.google.com/compute/docs/disks#disk-types), in the
      format `projects/{project}/zones/{zone}/diskTypes/{disk_type}`.
  """

  effectiveImage = _messages.StringField(1)
  image = _messages.StringField(2)
  sizeGb = _messages.IntegerField(3)
  type = _messages.StringField(4)


class BucketReference(_messages.Message):
  r"""A reference to a [Google Cloud
  Storage](https://cloud.google.com/storage) bucket.

  Fields:
    bucket: Output only. Name of the bucket.
  """

  bucket = _messages.StringField(1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CheckClusterHealth(_messages.Message):
  r"""When set in OperationStep, indicates that cluster health check should be
  performed.
  """



class Cluster(_messages.Message):
  r"""A collection of virtual machines and connected resources forming a high-
  performance computing cluster capable of running large-scale, tightly
  coupled workloads. A cluster combines a set a compute resources that perform
  computations, storage resources that contain inputs and store outputs, an
  orchestrator that is responsible for assigning jobs to compute resources,
  and network resources that connect everything together.

  Messages:
    ComputeResourcesValue: Optional. Compute resources available to the
      cluster. Keys specify the ID of the compute resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    LabelsValue: Optional.
      [Labels](https://cloud.google.com/compute/docs/labeling-resources)
      applied to the cluster. Labels can be used to organize clusters and to
      filter them in queries.
    NetworkResourcesValue: Optional. Network resources available to the
      cluster. Must contain at most one value. Keys specify the ID of the
      network resource by which it can be referenced elsewhere, and must
      conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
      (lower-case, alphanumeric, and at most 63 characters).
    StorageResourcesValue: Optional. Storage resources available to the
      cluster. Keys specify the ID of the storage resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).

  Fields:
    compute: Optional. Deprecated. Use compute_resources instead.
    computeResources: Optional. Compute resources available to the cluster.
      Keys specify the ID of the compute resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    createTime: Output only. Time that the cluster was originally created.
    description: Optional. User-provided description of the cluster.
    labels: Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
      resources) applied to the cluster. Labels can be used to organize
      clusters and to filter them in queries.
    name: Identifier. [Relative resource name](https://google.aip.dev/122) of
      the cluster, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
    networkResources: Optional. Network resources available to the cluster.
      Must contain at most one value. Keys specify the ID of the network
      resource by which it can be referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    networks: Optional. Deprecated. Use network_resources instead.
    orchestrator: Optional. Orchestrator that is responsible for scheduling
      and running jobs on the cluster.
    reconciling: Output only. Indicates whether changes to the cluster are
      currently in flight. If this is `true`, then the current state might not
      match the cluster's intended state.
    storageResources: Optional. Storage resources available to the cluster.
      Keys specify the ID of the storage resource by which it can be
      referenced elsewhere, and must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    storages: Optional. Deprecated. Use storage_resources instead.
    updateTime: Output only. Time that the cluster was most recently updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ComputeResourcesValue(_messages.Message):
    r"""Optional. Compute resources available to the cluster. Keys specify the
    ID of the compute resource by which it can be referenced elsewhere, and
    must conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
    (lower-case, alphanumeric, and at most 63 characters).

    Messages:
      AdditionalProperty: An additional property for a ComputeResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ComputeResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ComputeResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A ComputeResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ComputeResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
    resources) applied to the cluster. Labels can be used to organize clusters
    and to filter them in queries.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NetworkResourcesValue(_messages.Message):
    r"""Optional. Network resources available to the cluster. Must contain at
    most one value. Keys specify the ID of the network resource by which it
    can be referenced elsewhere, and must conform to
    [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
    alphanumeric, and at most 63 characters).

    Messages:
      AdditionalProperty: An additional property for a NetworkResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        NetworkResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NetworkResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A NetworkResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('NetworkResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StorageResourcesValue(_messages.Message):
    r"""Optional. Storage resources available to the cluster. Keys specify the
    ID of the storage resource by which it can be referenced elsewhere, and
    must conform to [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034)
    (lower-case, alphanumeric, and at most 63 characters).

    Messages:
      AdditionalProperty: An additional property for a StorageResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        StorageResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StorageResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A StorageResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('StorageResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  compute = _messages.MessageField('Compute', 1)
  computeResources = _messages.MessageField('ComputeResourcesValue', 2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  networkResources = _messages.MessageField('NetworkResourcesValue', 7)
  networks = _messages.MessageField('Network', 8, repeated=True)
  orchestrator = _messages.MessageField('Orchestrator', 9)
  reconciling = _messages.BooleanField(10)
  storageResources = _messages.MessageField('StorageResourcesValue', 11)
  storages = _messages.MessageField('Storage', 12, repeated=True)
  updateTime = _messages.StringField(13)


class Compute(_messages.Message):
  r"""Message describing Compute object

  Fields:
    atmTags: Optional. ATM Tags to attach to compute VM instances
    resourceRequests: Required. Source of compute resource
  """

  atmTags = _messages.MessageField('AtmTag', 1, repeated=True)
  resourceRequests = _messages.MessageField('ResourceRequest', 2, repeated=True)


class ComputeInstance(_messages.Message):
  r"""Details about a Compute Engine
  [instance](https://cloud.google.com/compute/docs/instances).

  Fields:
    instance: Output only. Name of the VM instance, in the format
      `projects/{project}/zones/{zone}/instances/{instance}`.
  """

  instance = _messages.StringField(1)


class ComputeInstanceSlurmNodeSet(_messages.Message):
  r"""When set in a SlurmNodeSet, indicates that the nodeset should be backed
  by Compute Engine VM instances.

  Messages:
    LabelsValue: Optional.
      [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
      should be applied to each VM instance in the nodeset.

  Fields:
    bootDisk: Optional. Boot disk for the compute instance
    labels: Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
      resources) that should be applied to each VM instance in the nodeset.
    startupScript: Optional. [Startup
      script](https://cloud.google.com/compute/docs/instances/startup-
      scripts/linux) to be run on each VM instance in the nodeset. Max 256KB.
    startupScriptTimeout: Optional. The maximum time to wait for the startup
      script to complete. If the script exceeds this duration, the instance
      setup will be considered failed. This value must be positive. If this
      value is unset, a default timeout of 5 minutes (300 seconds) will be
      used by the system.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
    resources) that should be applied to each VM instance in the nodeset.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bootDisk = _messages.MessageField('BootDisk', 1)
  labels = _messages.MessageField('LabelsValue', 2)
  startupScript = _messages.StringField(3)
  startupScriptTimeout = _messages.StringField(4)


class ComputeResource(_messages.Message):
  r"""A resource defining how virtual machines and accelerators should be
  provisioned for the cluster.

  Fields:
    config: Required. Immutable. Configuration for this compute resource,
      which describes how it should be created at runtime.
    newOnDemandInstances: Deprecated: Use config.
  """

  config = _messages.MessageField('ComputeResourceConfig', 1)
  newOnDemandInstances = _messages.MessageField('NewOnDemandInstancesConfig', 2)


class ComputeResourceConfig(_messages.Message):
  r"""Describes how a compute resource should be created at runtime.

  Fields:
    newFlexStartInstances: Optional. Immutable. If set, indicates that this
      resource should use flex-start VMs.
    newOnDemandInstances: Optional. Immutable. If set, indicates that this
      resource should use on-demand VMs.
    newReservedInstances: Optional. Immutable. If set, indicates that this
      resource should use reserved VMs.
    newSpotInstances: Optional. Immutable. If set, indicates that this
      resource should use spot VMs.
  """

  newFlexStartInstances = _messages.MessageField('NewFlexStartInstancesConfig', 1)
  newOnDemandInstances = _messages.MessageField('NewOnDemandInstancesConfig', 2)
  newReservedInstances = _messages.MessageField('NewReservedInstancesConfig', 3)
  newSpotInstances = _messages.MessageField('NewSpotInstancesConfig', 4)


class Configs(_messages.Message):
  r"""Configuration for a Machine Learning run.

  Messages:
    HardwareConfigsValue: Optional. Hardware configs.
    SoftwareConfigsValue: Optional. Software configs.
    UserConfigsValue: Optional. User defined configs.

  Fields:
    hardwareConfigs: Optional. Hardware configs.
    softwareConfigs: Optional. Software configs.
    userConfigs: Optional. User defined configs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HardwareConfigsValue(_messages.Message):
    r"""Optional. Hardware configs.

    Messages:
      AdditionalProperty: An additional property for a HardwareConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type HardwareConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HardwareConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SoftwareConfigsValue(_messages.Message):
    r"""Optional. Software configs.

    Messages:
      AdditionalProperty: An additional property for a SoftwareConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SoftwareConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SoftwareConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserConfigsValue(_messages.Message):
    r"""Optional. User defined configs.

    Messages:
      AdditionalProperty: An additional property for a UserConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type UserConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  hardwareConfigs = _messages.MessageField('HardwareConfigsValue', 1)
  softwareConfigs = _messages.MessageField('SoftwareConfigsValue', 2)
  userConfigs = _messages.MessageField('UserConfigsValue', 3)


class ContainerNodePoolSlurmNodeSet(_messages.Message):
  r"""When set in a SlurmNodeSet, indicates that the nodeset should be backed
  by a Kubernetes Engine node pool.

  Messages:
    ResourceLabelsValue: Optional. Resource labels that are applied to the
      underlying Google Compute Engine resources.

  Fields:
    resourceLabels: Optional. Resource labels that are applied to the
      underlying Google Compute Engine resources.
    startupScript: Optional. Script to run in each pod in the nodeset when it
      first starts. Max 256KB.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceLabelsValue(_messages.Message):
    r"""Optional. Resource labels that are applied to the underlying Google
    Compute Engine resources.

    Messages:
      AdditionalProperty: An additional property for a ResourceLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  resourceLabels = _messages.MessageField('ResourceLabelsValue', 1)
  startupScript = _messages.StringField(2)


class CreateFilestoreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a new filestore instance
  should be created.

  Fields:
    filestore: Output only. Name of the Filestore instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class CreateGKECluster(_messages.Message):
  r"""When set in OperationStep, indicates that a new GKE cluster should be
  created.

  Fields:
    cluster: Output only. Name of the GKE cluster.
  """

  cluster = _messages.StringField(1)


class CreateLoginNode(_messages.Message):
  r"""When set in OperationStep, indicates that a login node should be
  created.
  """



class CreateLustreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a new lustre instance should
  be created.

  Fields:
    lustre: Output only. Name of the Managed Lustre instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class CreateNetwork(_messages.Message):
  r"""When set in OperationStep, indicates that a new network should be
  created.

  Fields:
    network: Output only. Name of the network to create, in the format
      `projects/{project}/global/networks/{network}`.
  """

  network = _messages.StringField(1)


class CreateNodeset(_messages.Message):
  r"""When set in OperationStep, indicates that a nodeset should be created.

  Fields:
    nodesets: Output only. Name of the nodeset to create
  """

  nodesets = _messages.StringField(1, repeated=True)


class CreateOrchestrator(_messages.Message):
  r"""When set in OperationStep, indicates that an orchestrator should be
  created.
  """



class CreatePartition(_messages.Message):
  r"""When set in OperationStep, indicates that a partition should be created.

  Fields:
    partitions: Output only. Name of the partition to create
  """

  partitions = _messages.StringField(1, repeated=True)


class CreatePrivateServiceAccess(_messages.Message):
  r"""When set in OperationStep, indicates that a new private service access
  should be created.
  """



class CreateStorageBucket(_messages.Message):
  r"""When set in OperationStep, indicates that a new storage bucket should be
  created.

  Fields:
    bucket: Output only. Name of the bucket.
  """

  bucket = _messages.StringField(1)


class DeleteFilestoreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a Filestore instance should be
  deleted.

  Fields:
    filestore: Output only. Name of the Filestore instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class DeleteGKECluster(_messages.Message):
  r"""When set in OperationStep, indicates that a GKE cluster should be
  deleted.

  Fields:
    cluster: Output only. Name of the GKE cluster.
  """

  cluster = _messages.StringField(1)


class DeleteLoginNode(_messages.Message):
  r"""When set in OperationStep, indicates that a login node should be
  deleted.
  """



class DeleteLustreInstance(_messages.Message):
  r"""When set in OperationStep, indicates that a Lustre instance should be
  deleted.

  Fields:
    lustre: Output only. Name of the Managed Lustre instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class DeleteNetwork(_messages.Message):
  r"""When set in OperationStep, indicates network deletion step with the
  resource name.

  Fields:
    network: Output only. Name of the network to delete, in the format
      `projects/{project}/global/networks/{network}`.
  """

  network = _messages.StringField(1)


class DeleteNodeset(_messages.Message):
  r"""When set in OperationStep, indicates that a nodeset should be deleted.

  Fields:
    nodesets: Output only. Name of the nodeset to delete
  """

  nodesets = _messages.StringField(1, repeated=True)


class DeleteOrchestrator(_messages.Message):
  r"""When set in OperationStep, indicates that an orchestrator should be
  deleted.
  """



class DeletePartition(_messages.Message):
  r"""When set in OperationStep, indicates that a partition should be deleted.

  Fields:
    partitions: Output only. Name of the partition to delete
  """

  partitions = _messages.StringField(1, repeated=True)


class DeletePrivateServiceAccess(_messages.Message):
  r"""When set in OperationStep, indicates private service access deletion
  step.
  """



class DeleteStorageBucket(_messages.Message):
  r"""When set in OperationStep, indicates that Cloud Storage bucket should be
  deleted.

  Fields:
    bucket: Output only. Name of the bucket.
  """

  bucket = _messages.StringField(1)


class Disk(_messages.Message):
  r"""Deprecated: Do not use.

  Fields:
    boot: Optional. Immutable. Unstable: Contact hypercompute-service-eng@
      before using.
    sizeGb: Required. Immutable. Unstable: Contact hypercompute-service-eng@
      before using.
    sourceImage: Optional. Immutable. Unstable: Contact hypercompute-service-
      eng@ before using.
    type: Required. Immutable. Unstable: Contact hypercompute-service-eng@
      before using.
  """

  boot = _messages.BooleanField(1)
  sizeGb = _messages.IntegerField(2)
  sourceImage = _messages.StringField(3)
  type = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ExistingBucketConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that an existing [Google
  Cloud Storage](https://cloud.google.com/storage) bucket should be imported.

  Fields:
    bucket: Required. Immutable. Name of the Cloud Storage bucket to import.
  """

  bucket = _messages.StringField(1)


class ExistingFilestoreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that an existing
  [Filestore](https://cloud.google.com/filestore) instance should be imported.

  Fields:
    filestore: Required. Immutable. Name of the Filestore instance to import,
      in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class ExistingLustreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that an existing [Managed
  Lustre](https://cloud.google.com/products/managed-lustre) instance should be
  imported.

  Fields:
    lustre: Required. Immutable. Name of the Managed Lustre instance to
      import, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class ExistingNetworkConfig(_messages.Message):
  r"""When set in a NetworkResourceConfig, indicates that an existing network
  should be imported.

  Fields:
    network: Required. Immutable. Name of the network to import, in the format
      `projects/{project}/global/networks/{network}`.
    subnetwork: Required. Immutable. Particular subnetwork to use, in the
      format `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class FileShareConfig(_messages.Message):
  r"""Message describing filestore configuration

  Fields:
    capacityGb: Required. Size of the filestore in GB. Must be between 1024
      and 102400, and must meet scalability requirements described at
      https://cloud.google.com/filestore/docs/service-tiers.
    fileShare: Required. Filestore share location
  """

  capacityGb = _messages.IntegerField(1)
  fileShare = _messages.StringField(2)


class FilestoreInitializeParams(_messages.Message):
  r"""Message describing initialize params for filestore

  Enums:
    ProtocolValueValuesEnum: Optional. The protocol of the filestore
    TierValueValuesEnum: Required. The service tier of the filestore

  Fields:
    description: Optional. Description of the filestore
    fileShares: Required. File share configuration
    filestore: Required. Name of the filestore
    protocol: Optional. The protocol of the filestore
    tier: Required. The service tier of the filestore
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. The protocol of the filestore

    Values:
      PROTOCOL_UNSPECIFIED: Unspecified filestore protocol
      PROTOCOL_NFSV3: NFSv3
      PROTOCOL_NFSV41: NFSv4.1
    """
    PROTOCOL_UNSPECIFIED = 0
    PROTOCOL_NFSV3 = 1
    PROTOCOL_NFSV41 = 2

  class TierValueValuesEnum(_messages.Enum):
    r"""Required. The service tier of the filestore

    Values:
      TIER_UNSPECIFIED: Unspecified filestore tier
      TIER_BASIC_HDD: Basic HDD filestore tier
      TIER_BASIC_SSD: Basic SSD filestore tier
      TIER_HIGH_SCALE_SSD: High scale SSD filestore tier
      TIER_ZONAL: Zonal filestore tier
      TIER_ENTERPRISE: Enterprise filestore tier
      TIER_REGIONAL: Regional filestore tier
    """
    TIER_UNSPECIFIED = 0
    TIER_BASIC_HDD = 1
    TIER_BASIC_SSD = 2
    TIER_HIGH_SCALE_SSD = 3
    TIER_ZONAL = 4
    TIER_ENTERPRISE = 5
    TIER_REGIONAL = 6

  description = _messages.StringField(1)
  fileShares = _messages.MessageField('FileShareConfig', 2, repeated=True)
  filestore = _messages.StringField(3)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 4)
  tier = _messages.EnumField('TierValueValuesEnum', 5)


class FilestoreReference(_messages.Message):
  r"""A reference to a [Filestore](https://cloud.google.com/filestore)
  instance.

  Fields:
    filestore: Output only. Name of the Filestore instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  filestore = _messages.StringField(1)


class GKEWorkloadDetails(_messages.Message):
  r"""Workload details for the GKE orchestrator.

  Messages:
    LabelsValue: Optional. labels for the workload. Example: {"type":
      "workload", "app": "simulation"}.

  Fields:
    cluster: Required. The cluster of the workload. Example -
      /projects//locations//clusters/
    id: Required. The identifier of the workload. Example - jobset-abcd
    kind: Required. The kind of the workload. Example - JobSet
    labels: Optional. labels for the workload. Example: {"type": "workload",
      "app": "simulation"}.
    namespace: Required. The namespace of the workload. Example - default
    parentWorkload: Optional. The parent workload. Example - JobSet for a Job,
      RayJob, LeaderWorkerSet etc. If a workload is a part of a RunSet, this
      field is populate as `RunSet` and if it was ray job, it will be set to
      `RayJob` etc. This will be an additional field to representing a
      workload.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. labels for the workload. Example: {"type": "workload",
    "app": "simulation"}.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cluster = _messages.StringField(1)
  id = _messages.StringField(2)
  kind = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  namespace = _messages.StringField(5)
  parentWorkload = _messages.StringField(6)


class GcsAutoclassConfig(_messages.Message):
  r"""Message describing Google Cloud Storage autoclass configuration

  Enums:
    TerminalStorageClassValueValuesEnum: Optional. Terminal storage class of
      the autoclass bucket

  Fields:
    enabled: Required. Enables Auto-class feature.
    terminalStorageClass: Optional. Terminal storage class of the autoclass
      bucket
  """

  class TerminalStorageClassValueValuesEnum(_messages.Enum):
    r"""Optional. Terminal storage class of the autoclass bucket

    Values:
      TERMINAL_STORAGE_CLASS_UNSPECIFIED: Unspecified terminal storage class
      TERMINAL_STORAGE_CLASS_NEARLINE: Nearline terminal storage class
      TERMINAL_STORAGE_CLASS_ARCHIVE: Archive terminal storage class
    """
    TERMINAL_STORAGE_CLASS_UNSPECIFIED = 0
    TERMINAL_STORAGE_CLASS_NEARLINE = 1
    TERMINAL_STORAGE_CLASS_ARCHIVE = 2

  enabled = _messages.BooleanField(1)
  terminalStorageClass = _messages.EnumField('TerminalStorageClassValueValuesEnum', 2)


class GcsHierarchicalNamespaceConfig(_messages.Message):
  r"""Message describing Google Cloud Storage hierarchical namespace
  configuration

  Fields:
    enabled: Required. Enables hierarchical namespace setup for the bucket.
  """

  enabled = _messages.BooleanField(1)


class GcsInitializeParams(_messages.Message):
  r"""Message describing initialize params for Google Cloud Storage

  Enums:
    StorageClassValueValuesEnum: Default storage class for objects in the
      bucket.

  Fields:
    autoclass: Autoclass configuration for objects in the bucket.
    bucket: Required. Name of the bucket
    hierarchicalNamespace: Optional. The hierarchical namespace configuration
      of the bucket
    storageClass: Default storage class for objects in the bucket.
  """

  class StorageClassValueValuesEnum(_messages.Enum):
    r"""Default storage class for objects in the bucket.

    Values:
      STORAGE_CLASS_UNSPECIFIED: Unspecified storage class
      STORAGE_CLASS_STANDARD: Standard storage class
      STORAGE_CLASS_NEARLINE: Nearline storage class
      STORAGE_CLASS_COLDLINE: Coldline storage class
      STORAGE_CLASS_ARCHIVE: Archive storage class
    """
    STORAGE_CLASS_UNSPECIFIED = 0
    STORAGE_CLASS_STANDARD = 1
    STORAGE_CLASS_NEARLINE = 2
    STORAGE_CLASS_COLDLINE = 3
    STORAGE_CLASS_ARCHIVE = 4

  autoclass = _messages.MessageField('GcsAutoclassConfig', 1)
  bucket = _messages.StringField(2)
  hierarchicalNamespace = _messages.MessageField('GcsHierarchicalNamespaceConfig', 3)
  storageClass = _messages.EnumField('StorageClassValueValuesEnum', 4)


class HypercomputeclusterProjectsLocationsClustersCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. ID of the cluster to create. Must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    parent: Required. Parent location in which the cluster should be created,
      in the format `projects/{project}/locations/{location}`.
    requestId: Optional. A unique identifier for this request. A random UUID
      is recommended. This request is idempotent if and only if `request_id`
      is provided.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class HypercomputeclusterProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersDeleteRequest object.

  Fields:
    name: Required. Name of the cluster to delete, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
    requestId: Optional. A unique identifier for this request. A random UUID
      is recommended. This request is idempotent if and only if `request_id`
      is provided.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class HypercomputeclusterProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersGetRequest object.

  Fields:
    name: Required. Name of the cluster to retrieve, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsClustersListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersListRequest object.

  Fields:
    filter: Optional. [Filter](https://google.aip.dev/160) to apply to the
      returned results.
    orderBy: Optional. How to order the resulting clusters. Must be one of the
      following strings: * `name` * `name desc` * `create_time` * `create_time
      desc` If not specified, clusters will be returned in an arbitrary order.
    pageSize: Optional. Maximum number of clusters to return. The service may
      return fewer than this value.
    pageToken: Optional. A page token received from a previous `ListClusters`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListClusters` must match the call that
      provided the page token.
    parent: Required. Parent location of the clusters to list, in the format
      `projects/{project}/locations/{location}`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class HypercomputeclusterProjectsLocationsClustersPatchRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Identifier. [Relative resource name](https://google.aip.dev/122) of
      the cluster, in the format
      `projects/{project}/locations/{location}/clusters/{cluster}`.
    requestId: Optional. A unique identifier for this request. A random UUID
      is recommended. This request is idempotent if and only if `request_id`
      is provided.
    updateMask: Optional. Mask specifying which fields in the cluster to
      update. All paths must be specified explicitly - wildcards are not
      supported. At least one path must be provided.
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class HypercomputeclusterProjectsLocationsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class HypercomputeclusterProjectsLocationsMachineLearningRunsCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsCreateRequest
  object.

  Fields:
    machineLearningRun: A MachineLearningRun resource to be passed as the
      request body.
    machineLearningRunId: Optional. The ID of the Machine Learning Run to
      create.
    parent: Required. Parent format: projects/{project}/locations/{location}
  """

  machineLearningRun = _messages.MessageField('MachineLearningRun', 1)
  machineLearningRunId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsDeleteRequest
  object.

  Fields:
    etag: Optional. Etag for the run. Etag gets updated with every
      update/create operation. If provided, it must match the server's etag.
    force: Optional. If force=false and if a user tries to delete an ml run
      resource that still has child resources (e.g., ProfilerTarget), the
      request should fail with a FAILED_PRECONDITION error. If force=true, the
      delete request should delete both parent and child resources that exist.
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machineLearningRun}
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsGetRequest
  object.

  Fields:
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machineLearningRun}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Supported filter fields are: - run_id (string): The ID of the run (e.g.,
      "run-1"). - run_set (string): The run set (e.g., "run-set-1"). -
      display_name (string): The display name of the run (e.g., "display-
      name-1"). - state (enum): The state of the run (e.g.,
      "STATE_COMPLETED"). - region (string): The region of the run (e.g., "us-
      central1"). - orchestrator (enum): The orchestrator used for the run
      (e.g., "ORCHESTRATOR_GKE"). - create_time (timestamp): The creation
      timestamp of the run. - update_time (timestamp): The last update
      timestamp of the run. - etag (string): The ETag of the run. Filter
      expressions can be combined using "AND" and "OR" operators. Examples: To
      filter by a single field: `run_set = "run-set-1"` `state =
      "STATE_ACTIVE"` To filter by multiple fields: `run_set = "run-set-1" AND
      state = "STATE_ACTIVE"` `region = "us-central1" AND orchestrator =
      "ORCHESTRATOR_GKE"` To filter by timestamp: `create_time >
      "2025-05-26T10:00:00Z"`
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      fields: * `run_id` * `run_set` * `display_name` * `region` *
      `orchestrator` * `state` * `create_time` * `update_time` Example:
      `update_time desc, create_time`.
    pageSize: Optional. The maximum number of Machine Learning Runs to return.
      The service may return fewer than this value. If unspecified, at most 10
      Machine Learning Runs will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000. Please refer to
      https://google.aip.dev/158 for more details.
    pageToken: Optional. A page token, received from a previous
      `ListMachineLearningRuns` call. Provide this to retrieve the subsequent
      page. Please refer to https://google.aip.dev/158 for more details.
    parent: Required. projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEventsCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEvents
  CreateRequest object.

  Fields:
    monitoredEvent: A MonitoredEvent resource to be passed as the request
      body.
    monitoredEventId: Optional. Optional ID for the event.
    parent: Required. Parent resource where the event will be created. Format:
      projects/{project}/locations/{location}/machineLearningRuns/{machine_lea
      rning_run}
  """

  monitoredEvent = _messages.MessageField('MonitoredEvent', 1)
  monitoredEventId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEventsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEvents
  DeleteRequest object.

  Fields:
    name: Required. The name of the monitored event to delete. Format: project
      s/{project}/locations/{location}/machineLearningRuns/{machine_learning_r
      un}/monitoredEvents/{monitored_event}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEventsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEvents
  GetRequest object.

  Fields:
    name: Required. The name of the monitored event to retrieve. Format: proje
      cts/{project}/locations/{location}/machineLearningRuns/{machine_learning
      _run}/monitoredEvents/{monitored_event}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEventsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEvents
  ListRequest object.

  Fields:
    filter: Optional. A filter expression for filtering results.
    orderBy: Optional. Order by field for sorting results.
    pageSize: Optional. The maximum number of events to return. The service
      may return fewer than this value. If unspecified, at most 50 events will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListMonitoredEvents` call. Provide this to retrieve the subsequent
      page. When paginating, all other parameters provided to
      `ListMonitoredEvents` must match the call that provided the page token.
    parent: Required. Parent resource to list events from. Format: projects/{p
      roject}/locations/{location}/machineLearningRuns/{machine_learning_run}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEventsPatchRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsMonitoredEvents
  PatchRequest object.

  Fields:
    monitoredEvent: A MonitoredEvent resource to be passed as the request
      body.
    name: Identifier. Resource name of the monitored event. Format: projects/{
      project}/locations/{location}/machineLearningRuns/{machine_learning_run}
      /monitoredEvents/{monitored_event}
    updateMask: Optional. The list of fields to be updated.
  """

  monitoredEvent = _messages.MessageField('MonitoredEvent', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HypercomputeclusterProjectsLocationsMachineLearningRunsPatchRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsPatchRequest
  object.

  Fields:
    machineLearningRun: A MachineLearningRun resource to be passed as the
      request body.
    name: Identifier. The name of the Machine Learning run.
    updateMask: Optional. Used to identify fields to be updated. Allowed
      fields is *, we don't support partial updates.
  """

  machineLearningRun = _messages.MessageField('MachineLearningRun', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessionsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessions
  GetRequest object.

  Fields:
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machineLearningRun}/profileSessions/{profileSession}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessionsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessions
  ListRequest object.

  Fields:
    pageSize: Optional. The maximum number of Profile Sessions to return. The
      service may return fewer than this value. If unspecified, at most 50
      Profile Sessions will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListProfileSessions` call. Provide this to retrieve the subsequent
      page.
    parent: Required. Parent format: projects/{project}/locations/{location}/m
      achineLearningRuns/{machineLearningRun}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSessionsCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSession
  sCreateRequest object.

  Fields:
    parent: Required. projects/{project}/locations/{location}/machineLearningR
      uns/{machineLearningRun}
    profilerSession: A ProfilerSession resource to be passed as the request
      body.
    profilerSessionId: Optional. ID for the profiler session.
  """

  parent = _messages.StringField(1, required=True)
  profilerSession = _messages.MessageField('ProfilerSession', 2)
  profilerSessionId = _messages.StringField(3)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSessionsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSession
  sDeleteRequest object.

  Fields:
    name: Required. The name of the profiler session to delete. Format: projec
      ts/{project}/locations/{location}/machineLearningRuns/{ml_run}/profilerT
      argets/{profiler_target}/profilerSessions/{profiler_session}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSessionsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSession
  sGetRequest object.

  Fields:
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machine_learning_run}/profilerTargets/{profiler_target}/profilerSessi
      ons/{profiler_session}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSessionsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerSession
  sListRequest object.

  Fields:
    pageSize: Optional. The maximum number of profiler sessions to return. The
      service may return fewer than this value. If unspecified, at most 10
      profiler sessions will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000. Please refer to
      https://google.aip.dev/158 for more details.
    pageToken: Optional. A page token, received from a previous
      `ListProfilerSessions` call. Provide this to retrieve the subsequent
      page. Please refer to https://google.aip.dev/158 for more details.
    parent: Required. projects/{project}/locations/{location}/machineLearningR
      uns/{machineLearningRun}/profilerTargets/{profiler_target}/
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargetsCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargets
  CreateRequest object.

  Fields:
    parent: Required. projects/{project}/locations/{location}/machineLearningR
      uns/{machineLearningRun}
    profilerTarget: A ProfilerTarget resource to be passed as the request
      body.
    profilerTargetId: Optional. If not provided, the server will generate an
      ID based on hostname and node_index. Example: "myhost-0"
  """

  parent = _messages.StringField(1, required=True)
  profilerTarget = _messages.MessageField('ProfilerTarget', 2)
  profilerTargetId = _messages.StringField(3)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargetsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargets
  DeleteRequest object.

  Fields:
    etag: Optional. Etag for the profiler target. Etag gets updated with every
      update/create operation. If provided, it must match the server's etag.
    name: Required. The name of the profiler target to delete. Format: project
      s/{project}/locations/{location}/machineLearningRuns/{ml_run}/profilerTa
      rgets/{profiler_target}
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargetsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargets
  GetRequest object.

  Fields:
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machineLearningRun}/profilerTargets/{profiler_target}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargetsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfilerTargets
  ListRequest object.

  Fields:
    pageSize: Optional. The maximum number of profiler targets to return. The
      service may return fewer than this value. If unspecified, at most 10
      profiler targets will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000. Please refer to
      https://google.aip.dev/158 for more details.
    pageToken: Optional. A page token, received from a previous
      `ListProfilerTargets` call. Provide this to retrieve the subsequent
      page. Please refer to https://google.aip.dev/158 for more details.
    parent: Required. projects/{project}/locations/{location}/machineLearningR
      uns/{machineLearningRun}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class HypercomputeclusterProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class ListClustersResponse(_messages.Message):
  r"""Response message for ListClusters.

  Fields:
    clusters: Clusters in the specified location.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page. If this field is absent, there are no subsequent pages.
    unreachable: Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMachineLearningRunsResponse(_messages.Message):
  r"""Response message for MachineLearningRuns.ListMachineLearningRuns.

  Fields:
    machineLearningRuns: The Machine Learning Runs.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  machineLearningRuns = _messages.MessageField('MachineLearningRun', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMonitoredEventsResponse(_messages.Message):
  r"""Response message for ListMonitoredEvents.

  Fields:
    monitoredEvents: The list of monitored events.
    nextPageToken: Token to retrieve the next page of results.
  """

  monitoredEvents = _messages.MessageField('MonitoredEvent', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListProfileSessionsResponse(_messages.Message):
  r"""Response message for MachineLearningRuns.ListProfileSessions.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    profileSessions: A list of profile sessions.
  """

  nextPageToken = _messages.StringField(1)
  profileSessions = _messages.MessageField('ProfileSession', 2, repeated=True)


class ListProfilerSessionsResponse(_messages.Message):
  r"""Response message for list profiler sessions.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    profilerSessions: A list of profiler sessions.
  """

  nextPageToken = _messages.StringField(1)
  profilerSessions = _messages.MessageField('ProfilerSession', 2, repeated=True)


class ListProfilerTargetsResponse(_messages.Message):
  r"""Response message for list profiler targets.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    profilerTargets: A list of profiler targets.
  """

  nextPageToken = _messages.StringField(1)
  profilerTargets = _messages.MessageField('ProfilerTarget', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LustreInitializeParams(_messages.Message):
  r"""Message describing initialize params for lustre

  Fields:
    capacityGb: Required. Size of the lustre instance in GB
    description: Optional. Description of the lustre instance
    filesystem: Required. Immutable. Filesystem of the lustre instance
    lustre: Required. Name of the lustre instance
  """

  capacityGb = _messages.IntegerField(1)
  description = _messages.StringField(2)
  filesystem = _messages.StringField(3)
  lustre = _messages.StringField(4)


class LustreReference(_messages.Message):
  r"""A reference to a [Managed
  Lustre](https://cloud.google.com/products/managed-lustre) instance.

  Fields:
    lustre: Output only. Name of the Managed Lustre instance, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
  """

  lustre = _messages.StringField(1)


class MachineLearningRun(_messages.Message):
  r"""A Machine Learning run.

  Enums:
    OrchestratorValueValuesEnum: Required. The orchestrator used for the run.
    RunPhaseValueValuesEnum: Optional. RunPhase defines the phase of the run.
    StateValueValuesEnum: Output only. State of the run.

  Messages:
    LabelsValue: Optional. Any custom labels for this run Example:
      type:workload, type:simulation etc.

  Fields:
    artifacts: Optional. Artifacts for the run.
    configs: Optional. Tracks configuration for this run, example: batch_size,
      jax_version, tpu_generation etc.
    createTime: Output only. Time when the run was created.
    displayName: Optional. Display name for the run.
    endTime: Output only. Time when the run was completed. This field is set
      when the run is completed or failed.
    errorDetails: Optional. Error details for the run. This field is set when
      the run is failed.
    etag: Optional. ETag for the run. It must be provided for update/delete
      operations and must match the server's etag.
    labels: Optional. Any custom labels for this run Example: type:workload,
      type:simulation etc.
    metrics: Optional. Metrics for the run.
    name: Identifier. The name of the Machine Learning run.
    orchestrator: Required. The orchestrator used for the run.
    runPhase: Optional. RunPhase defines the phase of the run.
    runSet: Required. Allows grouping of similar runs. * Helps improving UI
      rendering performance. * Allows comparing similar runs via fast filters.
    state: Output only. State of the run.
    tools: Required. List of tools enabled for this run example: XProf, NSys
    updateTime: Output only. Time when the run was last updated.
    workloadDetails: Optional. The metadata for the workload associated with
      the run.
  """

  class OrchestratorValueValuesEnum(_messages.Enum):
    r"""Required. The orchestrator used for the run.

    Values:
      ORCHESTRATOR_UNSPECIFIED: Orchestrator type is not specified.
      GCE: Google Compute Engine orchestrator.
      GKE: Google Kubernetes Engine orchestrator.
      SLURM: Slurm cluster orchestrator.
    """
    ORCHESTRATOR_UNSPECIFIED = 0
    GCE = 1
    GKE = 2
    SLURM = 3

  class RunPhaseValueValuesEnum(_messages.Enum):
    r"""Optional. RunPhase defines the phase of the run.

    Values:
      RUN_PHASE_UNSPECIFIED: State is not specified.
      ACTIVE: Run is active.
      COMPLETED: Run is completed.
      FAILED: Run is failed.
    """
    RUN_PHASE_UNSPECIFIED = 0
    ACTIVE = 1
    COMPLETED = 2
    FAILED = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the run.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      STATE_ACTIVE: Run is active.
      STATE_COMPLETED: Run is completed.
      STATE_FAILED: Run is failed.
    """
    STATE_UNSPECIFIED = 0
    STATE_ACTIVE = 1
    STATE_COMPLETED = 2
    STATE_FAILED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Any custom labels for this run Example: type:workload,
    type:simulation etc.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifacts = _messages.MessageField('Artifacts', 1)
  configs = _messages.MessageField('Configs', 2)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  endTime = _messages.StringField(5)
  errorDetails = _messages.StringField(6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  metrics = _messages.MessageField('Metrics', 9)
  name = _messages.StringField(10)
  orchestrator = _messages.EnumField('OrchestratorValueValuesEnum', 11)
  runPhase = _messages.EnumField('RunPhaseValueValuesEnum', 12)
  runSet = _messages.StringField(13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  tools = _messages.MessageField('Tool', 15, repeated=True)
  updateTime = _messages.StringField(16)
  workloadDetails = _messages.MessageField('WorkloadDetails', 17)


class Metrics(_messages.Message):
  r"""Metrics for a Machine Learning run.

  Fields:
    avgHbmUtilization: Output only. Average HBM (High Bandwidth Memory)
      utilization.
    avgLatency: Output only. Average latency.
    avgMfu: Output only. Average Model Flops Utilization (MFU).
    avgStep: Output only. Average step time.
    avgThroughput: Output only. Average throughput. Value depends on the kind
      of workload ran on TPU.
    avgTpuTensorcoreUtilization: Output only. Average TPU TensorCore
      utilization.
  """

  avgHbmUtilization = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  avgLatency = _messages.StringField(2)
  avgMfu = _messages.FloatField(3, variant=_messages.Variant.FLOAT)
  avgStep = _messages.StringField(4)
  avgThroughput = _messages.FloatField(5, variant=_messages.Variant.FLOAT)
  avgTpuTensorcoreUtilization = _messages.FloatField(6, variant=_messages.Variant.FLOAT)


class MonitoredEvent(_messages.Message):
  r"""Represents a single Monitored Event (Incident) detected by the system.

  Enums:
    SeverityValueValuesEnum: Optional. Severity of the event.
    TypeValueValuesEnum: Optional. High-level type of the event.

  Fields:
    analyzerReports: Optional. Detailed reports from one or more analyzers
      regarding this event.
    displayName: Optional. Display name of the event. If not provided, this
      will default to the Monitored Event ID from the resource name.
    endTime: Optional. Exclusive timestamp when the event ended. If unset, the
      event is ongoing.
    name: Identifier. Resource name of the monitored event. Format: projects/{
      project}/locations/{location}/machineLearningRuns/{machine_learning_run}
      /monitoredEvents/{monitored_event}
    performanceDegradation: Optional. Performance degradation event details.
    severity: Optional. Severity of the event.
    startTime: Optional. Inclusive timestamp when the event started.
    summary: Optional. High-level summary (e.g., "Thermal Throttling
      Detected"). The summary can be up to 512 characters long.
    type: Optional. High-level type of the event.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Optional. Severity of the event.

    Values:
      SEVERITY_UNSPECIFIED: Severity is not specified.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3
    CRITICAL = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. High-level type of the event.

    Values:
      EVENT_TYPE_UNSPECIFIED: Event type not specified.
      PERFORMANCE_DEGRADATION: Performance degradation event.
    """
    EVENT_TYPE_UNSPECIFIED = 0
    PERFORMANCE_DEGRADATION = 1

  analyzerReports = _messages.MessageField('AnalyzerReport', 1, repeated=True)
  displayName = _messages.StringField(2)
  endTime = _messages.StringField(3)
  name = _messages.StringField(4)
  performanceDegradation = _messages.MessageField('PerformanceDegradationEvent', 5)
  severity = _messages.EnumField('SeverityValueValuesEnum', 6)
  startTime = _messages.StringField(7)
  summary = _messages.StringField(8)
  type = _messages.EnumField('TypeValueValuesEnum', 9)


class Network(_messages.Message):
  r"""Message describing Network object

  Fields:
    initializeParams: Immutable. Parameters to initialize the network
    network: Output only. Name of the network
    networkSource: Immutable. Reference of existing network resource name
    subnetwork: Output only. Name of the subnetwork
  """

  initializeParams = _messages.MessageField('NetworkInitializeParams', 1)
  network = _messages.StringField(2)
  networkSource = _messages.MessageField('NetworkSource', 3)
  subnetwork = _messages.StringField(4)


class NetworkInitializeParams(_messages.Message):
  r"""Message describing initialize params for network object

  Fields:
    description: Optional. Description of the network
    network: Required. Name of the network
  """

  description = _messages.StringField(1)
  network = _messages.StringField(2)


class NetworkReference(_messages.Message):
  r"""A reference to a [VPC network](https://cloud.google.com/vpc/docs/vpc) in
  Google Compute Engine.

  Fields:
    network: Output only. Name of the network, in the format
      `projects/{project}/global/networks/{network}`.
    subnetwork: Output only. Name of the particular subnetwork being used by
      the cluster, in the format
      `projects/{project}/regions/{region}/subnetworks/{subnetwork}`.
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class NetworkResource(_messages.Message):
  r"""A resource representing a network that connects the various components
  of a cluster together.

  Fields:
    config: Immutable. Configuration for this network resource, which
      describes how it should be created or imported. This field only controls
      how the network resource is initially created or imported. Subsequent
      changes to the network resource should be made via the resource's API
      and will not be reflected in the configuration.
    network: Reference to a network in Google Compute Engine.
  """

  config = _messages.MessageField('NetworkResourceConfig', 1)
  network = _messages.MessageField('NetworkReference', 2)


class NetworkResourceConfig(_messages.Message):
  r"""Describes how a network resource should be initialized. Each network
  resource can either be imported from an existing Google Cloud resource or
  initialized when the cluster is created.

  Fields:
    existingNetwork: Optional. Immutable. If set, indicates that an existing
      network should be imported.
    newNetwork: Optional. Immutable. If set, indicates that a new network
      should be created.
  """

  existingNetwork = _messages.MessageField('ExistingNetworkConfig', 1)
  newNetwork = _messages.MessageField('NewNetworkConfig', 2)


class NetworkSource(_messages.Message):
  r"""Message describing network source for network object

  Fields:
    network: Required. Immutable. Name of the network
    subnetwork: Required. Subnetwork of the network
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class NewBucketConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that a new [Google Cloud
  Storage](https://cloud.google.com/storage) bucket should be created.

  Enums:
    StorageClassValueValuesEnum: Optional. Immutable. If set, uses the
      provided storage class as the bucket's default storage class.

  Fields:
    autoclass: Optional. Immutable. If set, indicates that the bucket should
      use [Autoclass](https://cloud.google.com/storage/docs/autoclass).
    bucket: Required. Immutable. Name of the Cloud Storage bucket to create.
    hierarchicalNamespace: Optional. Immutable. If set, indicates that the
      bucket should use [hierarchical
      namespaces](https://cloud.google.com/storage/docs/hns-overview).
    storageClass: Optional. Immutable. If set, uses the provided storage class
      as the bucket's default storage class.
  """

  class StorageClassValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. If set, uses the provided storage class as the
    bucket's default storage class.

    Values:
      STORAGE_CLASS_UNSPECIFIED: Not set.
      STANDARD: Best for data that is frequently accessed.
      NEARLINE: Low-cost storage for data that is accessed less frequently.
      COLDLINE: Very low-cost storage for infrequently accessed data.
      ARCHIVE: Lowest-cost storage for data archiving, online backup, and
        disaster recovery.
    """
    STORAGE_CLASS_UNSPECIFIED = 0
    STANDARD = 1
    NEARLINE = 2
    COLDLINE = 3
    ARCHIVE = 4

  autoclass = _messages.MessageField('GcsAutoclassConfig', 1)
  bucket = _messages.StringField(2)
  hierarchicalNamespace = _messages.MessageField('GcsHierarchicalNamespaceConfig', 3)
  storageClass = _messages.EnumField('StorageClassValueValuesEnum', 4)


class NewFilestoreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that a new
  [Filestore](https://cloud.google.com/filestore) instance should be created.

  Enums:
    ProtocolValueValuesEnum: Optional. Immutable. Access protocol to use for
      all file shares in the instance. Defaults to NFS V3 if not set.
    TierValueValuesEnum: Required. Immutable. Service tier to use for the
      instance.

  Fields:
    description: Optional. Immutable. Description of the instance. Maximum of
      2048 characters.
    fileShares: Required. Immutable. File system shares on the instance.
      Exactly one file share must be specified.
    filestore: Required. Immutable. Name of the Filestore instance to create,
      in the format
      `projects/{project}/locations/{location}/instances/{instance}`
    protocol: Optional. Immutable. Access protocol to use for all file shares
      in the instance. Defaults to NFS V3 if not set.
    tier: Required. Immutable. Service tier to use for the instance.
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. Access protocol to use for all file shares in the
    instance. Defaults to NFS V3 if not set.

    Values:
      PROTOCOL_UNSPECIFIED: Not set.
      NFSV3: NFS 3.0.
      NFSV41: NFS 4.1.
    """
    PROTOCOL_UNSPECIFIED = 0
    NFSV3 = 1
    NFSV41 = 2

  class TierValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. Service tier to use for the instance.

    Values:
      TIER_UNSPECIFIED: Not set.
      ZONAL: Offers expanded capacity and performance scaling capabilities
        suitable for high-performance computing application requirements.
      REGIONAL: Offers features and availability needed for mission-critical,
        high-performance computing workloads.
      BASIC_HDD: Deprecated: Use a different tier instead.
    """
    TIER_UNSPECIFIED = 0
    ZONAL = 1
    REGIONAL = 2
    BASIC_HDD = 3

  description = _messages.StringField(1)
  fileShares = _messages.MessageField('FileShareConfig', 2, repeated=True)
  filestore = _messages.StringField(3)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 4)
  tier = _messages.EnumField('TierValueValuesEnum', 5)


class NewFlexStartInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that VM instances should
  be created using [Flex
  Start](https://cloud.google.com/compute/docs/instances/provisioning-models).

  Enums:
    TerminationActionValueValuesEnum: Optional. Immutable. Deprecated: Do not
      use.

  Messages:
    AtmTagsValue: Optional. Immutable. Unstable: Contact hypercompute-service-
      eng@ before using.

  Fields:
    atmTags: Optional. Immutable. Unstable: Contact hypercompute-service-eng@
      before using.
    bootDisk: Optional. Immutable. Deprecated: set disks in node config
      instead.
    machineType: Required. Immutable. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use,
      e.g. `n2-standard-2`.
    maxDuration: Required. Immutable. Specifies the time limit for created
      instances. Instances will be terminated at the end of this duration.
    terminationAction: Optional. Immutable. Deprecated: Do not use.
    zone: Required. Immutable. Name of the zone in which VM instances should
      run, e.g., `us-central1-a`. Must be in the same region as the cluster,
      and must match the zone of any other resources specified in the cluster.
  """

  class TerminationActionValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. Deprecated: Do not use.

    Values:
      TERMINATION_ACTION_UNSPECIFIED: Deprecated: Do not use.
      STOP: Deprecated: Do not use.
      DELETE: Deprecated: Do not use.
    """
    TERMINATION_ACTION_UNSPECIFIED = 0
    STOP = 1
    DELETE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Optional. Immutable. Unstable: Contact hypercompute-service-eng@
    before using.

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  bootDisk = _messages.MessageField('Disk', 2)
  machineType = _messages.StringField(3)
  maxDuration = _messages.StringField(4)
  terminationAction = _messages.EnumField('TerminationActionValueValuesEnum', 5)
  zone = _messages.StringField(6)


class NewLustreConfig(_messages.Message):
  r"""When set in a StorageResourceConfig, indicates that a new [Managed
  Lustre](https://cloud.google.com/products/managed-lustre) instance should be
  created.

  Fields:
    capacityGb: Required. Immutable. Storage capacity of the instance in
      gibibytes (GiB). Allowed values are between 18000 and 7632000.
    description: Optional. Immutable. Description of the Managed Lustre
      instance. Maximum of 2048 characters.
    filesystem: Required. Immutable. Filesystem name for this instance. This
      name is used by client-side tools, including when mounting the instance.
      Must be 8 characters or less and can only contain letters and numbers.
    lustre: Required. Immutable. Name of the Managed Lustre instance to
      create, in the format
      `projects/{project}/locations/{location}/instances/{instance}`
    perUnitStorageThroughput: Optional. Immutable. Throughput of the instance
      in MB/s/TiB. Valid values are 125, 250, 500, 1000. See [Performance
      tiers and maximum storage capacities](https://cloud.google.com/managed-
      lustre/docs/create-instance#performance-tiers) for more information.
  """

  capacityGb = _messages.IntegerField(1)
  description = _messages.StringField(2)
  filesystem = _messages.StringField(3)
  lustre = _messages.StringField(4)
  perUnitStorageThroughput = _messages.IntegerField(5)


class NewNetworkConfig(_messages.Message):
  r"""When set in a NetworkResourceConfig, indicates that a new network should
  be created.

  Fields:
    description: Optional. Immutable. Description of the network. Maximum of
      2048 characters.
    network: Required. Immutable. Name of the network to create, in the format
      `projects/{project}/global/networks/{network}`.
  """

  description = _messages.StringField(1)
  network = _messages.StringField(2)


class NewOnDemandInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that on-demand (i.e.,
  using the standard provisioning model) VM instances should be created.

  Messages:
    AtmTagsValue: Optional. Immutable. Unstable: Contact hypercompute-service-
      eng@ before using.

  Fields:
    atmTags: Optional. Immutable. Unstable: Contact hypercompute-service-eng@
      before using.
    bootDisk: Immutable. Deprecated: set disks in node config instead.
    machineType: Required. Immutable. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use,
      e.g. `n2-standard-2`.
    zone: Required. Immutable. Name of the zone in which VM instances should
      run, e.g., `us-central1-a`. Must be in the same region as the cluster,
      and must match the zone of any other resources specified in the cluster.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Optional. Immutable. Unstable: Contact hypercompute-service-eng@
    before using.

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  bootDisk = _messages.MessageField('Disk', 2)
  machineType = _messages.StringField(3)
  zone = _messages.StringField(4)


class NewReservedInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that VM instances should
  be created from a
  [reservation](https://cloud.google.com/compute/docs/instances/reservations-
  overview).

  Enums:
    TypeValueValuesEnum: Optional. Immutable. Deprecated: Do not use.

  Messages:
    AtmTagsValue: Optional. Immutable. Unstable: Contact hypercompute-service-
      eng@ before using.

  Fields:
    atmTags: Optional. Immutable. Unstable: Contact hypercompute-service-eng@
      before using.
    bootDisk: Optional. Immutable. Deprecated: set disks in node config
      instead.
    machineType: Optional. Immutable. Deprecated: Do not use.
    reservation: Optional. Immutable. Name of the reservation from which VM
      instances should be created, in the format
      `projects/{project}/zones/{zone}/reservations/{reservation}`.
    reservationBlock: Optional. Immutable. Name of the reservation block from
      which VM instances should be created, in the format `projects/{project}/
      zones/{zone}/reservations/{reservation}/reservationBlocks/{reservation_b
      lock}`.
    reservationSubBlock: Optional. Immutable. Name of the reservation sub
      block from which VM instances should be created, in the format `projects
      /{project}/zones/{zone}/reservations/{reservation}/reservationBlocks/{re
      servation_block}/reservationSubBlocks/{reservation_sub_block}`.
    type: Optional. Immutable. Deprecated: Do not use.
    zone: Optional. Immutable. Deprecated: Do not use.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. Deprecated: Do not use.

    Values:
      RESERVATION_TYPE_UNSPECIFIED: Deprecated: Do not use.
      NO_RESERVATION: Deprecated: Do not use.
      ANY_RESERVATION: Deprecated: Do not use.
      SPECIFIC_RESERVATION: Deprecated: Do not use.
    """
    RESERVATION_TYPE_UNSPECIFIED = 0
    NO_RESERVATION = 1
    ANY_RESERVATION = 2
    SPECIFIC_RESERVATION = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Optional. Immutable. Unstable: Contact hypercompute-service-eng@
    before using.

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  bootDisk = _messages.MessageField('Disk', 2)
  machineType = _messages.StringField(3)
  reservation = _messages.StringField(4)
  reservationBlock = _messages.StringField(5)
  reservationSubBlock = _messages.StringField(6)
  type = _messages.EnumField('TypeValueValuesEnum', 7)
  zone = _messages.StringField(8)


class NewSpotInstancesConfig(_messages.Message):
  r"""When set in a ComputeResourceConfig, indicates that [spot
  VM](https://cloud.google.com/compute/docs/instances/spot) instances should
  be created.

  Enums:
    TerminationActionValueValuesEnum: Optional. Specifies the termination
      action of the instance

  Messages:
    AtmTagsValue: Optional. Immutable. Unstable: Contact hypercompute-service-
      eng@ before using.

  Fields:
    atmTags: Optional. Immutable. Unstable: Contact hypercompute-service-eng@
      before using.
    bootDisk: Immutable. Deprecated: set disks in node config instead.
    machineType: Required. Immutable. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use,
      e.g. `n2-standard-2`.
    terminationAction: Optional. Specifies the termination action of the
      instance
    zone: Required. Immutable. Name of the zone in which VM instances should
      run, e.g., `us-central1-a`. Must be in the same region as the cluster,
      and must match the zone of any other resources specified in the cluster.
  """

  class TerminationActionValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the termination action of the instance

    Values:
      TERMINATION_ACTION_UNSPECIFIED: Unspecified termination action
      STOP: Stop the instance
      DELETE: Delete the instance
    """
    TERMINATION_ACTION_UNSPECIFIED = 0
    STOP = 1
    DELETE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Optional. Immutable. Unstable: Contact hypercompute-service-eng@
    before using.

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  bootDisk = _messages.MessageField('Disk', 2)
  machineType = _messages.StringField(3)
  terminationAction = _messages.EnumField('TerminationActionValueValuesEnum', 4)
  zone = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    progress: Output only. Progress of the operation.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have google.longrunning.Operation.error value
      with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  progress = _messages.MessageField('OperationProgress', 4)
  requestedCancellation = _messages.BooleanField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class OperationProgress(_messages.Message):
  r"""Message describing the progress of a cluster mutation long-running
  operation. operation.

  Fields:
    steps: Output only. Steps and status of the operation.
  """

  steps = _messages.MessageField('OperationStep', 1, repeated=True)


class OperationStep(_messages.Message):
  r"""Message describing the status of a single step in a cluster mutation
  long-running operation.

  Enums:
    StateValueValuesEnum: Output only. State of the operation step.

  Fields:
    checkClusterHealth: Output only. If set, indicates that cluster health
      check is part of the operation.
    createFilestoreInstance: Output only. If set, indicates that new Filestore
      instance creation is part of the operation.
    createGkeCluster: Output only. If set, indicates that new GKE cluster
      creation is part of the operation.
    createLoginNode: Output only. If set, indicates that new login node
      creation is part of the operation.
    createLustreInstance: Output only. If set, indicates that new Lustre
      instance creation is part of the operation.
    createNetwork: Output only. If set, indicates that new network creation is
      part of the operation.
    createNodeset: Output only. If set, indicates that new nodeset creation is
      part of the operation.
    createOrchestrator: Output only. If set, indicates that orchestrator
      creation is part of the operation.
    createPartition: Output only. If set, indicates that new partition
      creation is part of the operation.
    createPrivateServiceAccess: Output only. If set, indicates that new
      private service access creation is part of the operation.
    createStorageBucket: Output only. If set, indicates that new Cloud Storage
      bucket creation is part of the operation.
    deleteFilestoreInstance: Output only. If set, indicates that Filestore
      instance deletion is part of the operation.
    deleteGkeCluster: Output only. If set, indicates that GKE cluster deletion
      is part of the operation.
    deleteLoginNode: Output only. If set, indicates that login node deletion
      is part of the operation.
    deleteLustreInstance: Output only. If set, indicates that Lustre instance
      deletion is part of the operation.
    deleteNetwork: Output only. If set, indicates that network deletion is
      part of the operation.
    deleteNodeset: Output only. If set, indicates that nodeset deletion is
      part of the operation.
    deleteOrchestrator: Output only. If set, indicates that orchestrator
      deletion is part of the operation.
    deletePartition: Output only. If set, indicates that partition deletion is
      part of the operation.
    deletePrivateServiceAccess: Output only. If set, indicates that private
      service access deletion is part of the operation.
    deleteStorageBucket: Output only. If set, indicates that Cloud Storage
      bucket deletion is part of the operation.
    state: Output only. State of the operation step.
    updateLoginNode: Output only. If set, indicates that login node update is
      part of the operation.
    updateNodeset: Output only. If set, indicates that nodeset update is part
      of the operation.
    updateOrchestrator: Output only. If set, indicates that an orchestrator
      update is part of the operation.
    updatePartition: Output only. If set, indicates that partition update is
      part of the operation.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the operation step.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      WAITING: Initial state before step execution starts.
      IN_PROGRESS: Step execution is running in progress.
      DONE: Step execution is completed.
    """
    STATE_UNSPECIFIED = 0
    WAITING = 1
    IN_PROGRESS = 2
    DONE = 3

  checkClusterHealth = _messages.MessageField('CheckClusterHealth', 1)
  createFilestoreInstance = _messages.MessageField('CreateFilestoreInstance', 2)
  createGkeCluster = _messages.MessageField('CreateGKECluster', 3)
  createLoginNode = _messages.MessageField('CreateLoginNode', 4)
  createLustreInstance = _messages.MessageField('CreateLustreInstance', 5)
  createNetwork = _messages.MessageField('CreateNetwork', 6)
  createNodeset = _messages.MessageField('CreateNodeset', 7)
  createOrchestrator = _messages.MessageField('CreateOrchestrator', 8)
  createPartition = _messages.MessageField('CreatePartition', 9)
  createPrivateServiceAccess = _messages.MessageField('CreatePrivateServiceAccess', 10)
  createStorageBucket = _messages.MessageField('CreateStorageBucket', 11)
  deleteFilestoreInstance = _messages.MessageField('DeleteFilestoreInstance', 12)
  deleteGkeCluster = _messages.MessageField('DeleteGKECluster', 13)
  deleteLoginNode = _messages.MessageField('DeleteLoginNode', 14)
  deleteLustreInstance = _messages.MessageField('DeleteLustreInstance', 15)
  deleteNetwork = _messages.MessageField('DeleteNetwork', 16)
  deleteNodeset = _messages.MessageField('DeleteNodeset', 17)
  deleteOrchestrator = _messages.MessageField('DeleteOrchestrator', 18)
  deletePartition = _messages.MessageField('DeletePartition', 19)
  deletePrivateServiceAccess = _messages.MessageField('DeletePrivateServiceAccess', 20)
  deleteStorageBucket = _messages.MessageField('DeleteStorageBucket', 21)
  state = _messages.EnumField('StateValueValuesEnum', 22)
  updateLoginNode = _messages.MessageField('UpdateLoginNode', 23)
  updateNodeset = _messages.MessageField('UpdateNodeset', 24)
  updateOrchestrator = _messages.MessageField('UpdateOrchestrator', 25)
  updatePartition = _messages.MessageField('UpdatePartition', 26)


class Orchestrator(_messages.Message):
  r"""The component responsible for scheduling and running workloads on the
  cluster as well as providing the user interface for interacting with the
  cluster at runtime.

  Fields:
    slurm: Optional. If set, indicates that the cluster should use Slurm as
      the orchestrator.
  """

  slurm = _messages.MessageField('SlurmOrchestrator', 1)


class PerformanceDegradationEvent(_messages.Message):
  r"""Metadata specific to Performance Degradation events. Reserved for future
  degradation-specific metadata.
  """



class ProfileSession(_messages.Message):
  r"""Represents a single profiling session.

  Fields:
    createTime: Output only. The creation time of the session.
    dashboardUrl: Output only. The URL to dashboard to see session specific
      data. Not specified if URL is not ready yet. Currently represents only
      Xprof. Form https://? Could contains user information like bucket name
      etc.
    gcsPath: Output only. The cloud storage path of the session. Example:
      `gs://my-bucket/my-run-directory/session-1`.
    name: Identifier. The name of the profile session. Format: projects/{proje
      ct}/locations/{location}/machineLearningRuns/{machine_learning_run}/prof
      ileSessions/{profile_session}
  """

  createTime = _messages.StringField(1)
  dashboardUrl = _messages.StringField(2)
  gcsPath = _messages.StringField(3)
  name = _messages.StringField(4)


class ProfilerSession(_messages.Message):
  r"""Represents a single profiler session.

  Enums:
    DeviceTracerLevelValueValuesEnum: Optional. Device tracer level for the
      session. If the field is not set or unspecified, the default is
      `DEVICE_TRACER_LEVEL_ENABLED`.
    HostTracerLevelValueValuesEnum: Optional. Host tracer level for the
      session. If the field is not set or unspecified, the default is
      `HOST_TRACER_LEVEL_INFO`.
    PythonTracerLevelValueValuesEnum: Optional. Python tracer level for the
      session. If the field is not set or unspecified, the default is
      `PYTHON_TRACER_LEVEL_DISABLED`.

  Fields:
    createTime: Output only. The creation time of the session.
    dashboardUri: Output only. The URI to dashboard to see session specific
      data. Not specified if URI is not ready yet. Form https://? Could
      contain user information like bucket name etc.
    deviceTracerLevel: Optional. Device tracer level for the session. If the
      field is not set or unspecified, the default is
      `DEVICE_TRACER_LEVEL_ENABLED`.
    duration: Optional. Duration for the profiler session.
    etag: Optional. Etag for optimistic concurrency control.
    hostTracerLevel: Optional. Host tracer level for the session. If the field
      is not set or unspecified, the default is `HOST_TRACER_LEVEL_INFO`.
    isTraceEnabled: Optional. Customer setting to enable trace level details
      for the session.
    name: Identifier. The name of the profiler session. Format: projects/{proj
      ect}/locations/{location}/machineLearningRuns/{machine_learning_run}/pro
      filerSessions/{profiler_session}
    profilerTargets: Optional. List of profiler targets. Targets on which
      profiler session to be started. If empty, control plan shall start
      profiler session on all the targets associated with ML Run.
    pythonTracerLevel: Optional. Python tracer level for the session. If the
      field is not set or unspecified, the default is
      `PYTHON_TRACER_LEVEL_DISABLED`.
    storageFolderUri: Output only. The cloud storage path of the session.
      Example: `gs://my-bucket/my-run-directory/session-1`.
  """

  class DeviceTracerLevelValueValuesEnum(_messages.Enum):
    r"""Optional. Device tracer level for the session. If the field is not set
    or unspecified, the default is `DEVICE_TRACER_LEVEL_ENABLED`.

    Values:
      DEVICE_TRACER_LEVEL_UNSPECIFIED: Tracer level is unspecified.
      DEVICE_TRACER_LEVEL_DISABLED: Tracer level is disabled.
      DEVICE_TRACER_LEVEL_ENABLED: Tracer level is enabled.
    """
    DEVICE_TRACER_LEVEL_UNSPECIFIED = 0
    DEVICE_TRACER_LEVEL_DISABLED = 1
    DEVICE_TRACER_LEVEL_ENABLED = 2

  class HostTracerLevelValueValuesEnum(_messages.Enum):
    r"""Optional. Host tracer level for the session. If the field is not set
    or unspecified, the default is `HOST_TRACER_LEVEL_INFO`.

    Values:
      HOST_TRACER_LEVEL_UNSPECIFIED: Tracer level is unspecified.
      HOST_TRACER_LEVEL_DISABLED: Tracer level is disabled.
      HOST_TRACER_LEVEL_CRITICAL: Tracer level is critical.
      HOST_TRACER_LEVEL_INFO: Tracer level is info.
      HOST_TRACER_LEVEL_VERBOSE: Tracer level is verbose.
    """
    HOST_TRACER_LEVEL_UNSPECIFIED = 0
    HOST_TRACER_LEVEL_DISABLED = 1
    HOST_TRACER_LEVEL_CRITICAL = 2
    HOST_TRACER_LEVEL_INFO = 3
    HOST_TRACER_LEVEL_VERBOSE = 4

  class PythonTracerLevelValueValuesEnum(_messages.Enum):
    r"""Optional. Python tracer level for the session. If the field is not set
    or unspecified, the default is `PYTHON_TRACER_LEVEL_DISABLED`.

    Values:
      PYTHON_TRACER_LEVEL_UNSPECIFIED: Tracer level is unspecified.
      PYTHON_TRACER_LEVEL_DISABLED: Tracer level is disabled.
      PYTHON_TRACER_LEVEL_ENABLED: Tracer level is enabled.
    """
    PYTHON_TRACER_LEVEL_UNSPECIFIED = 0
    PYTHON_TRACER_LEVEL_DISABLED = 1
    PYTHON_TRACER_LEVEL_ENABLED = 2

  createTime = _messages.StringField(1)
  dashboardUri = _messages.StringField(2)
  deviceTracerLevel = _messages.EnumField('DeviceTracerLevelValueValuesEnum', 3)
  duration = _messages.StringField(4)
  etag = _messages.StringField(5)
  hostTracerLevel = _messages.EnumField('HostTracerLevelValueValuesEnum', 6)
  isTraceEnabled = _messages.BooleanField(7)
  name = _messages.StringField(8)
  profilerTargets = _messages.StringField(9, repeated=True)
  pythonTracerLevel = _messages.EnumField('PythonTracerLevelValueValuesEnum', 10)
  storageFolderUri = _messages.StringField(11)


class ProfilerTarget(_messages.Message):
  r"""A Profiler Target.

  Fields:
    etag: Optional. Etag for the profiler target
    hostname: Required. Host name of the node / target.
    isMaster: Optional. Whether this node is the master node in the cluster.
    name: Identifier. The resource name of the ProfilerTarget. Format: project
      s/{project}/locations/{location}/machineLearningRuns/{machine_learning_r
      un}/profilerTargets/{profiler_target}
    nodeIndex: Required. Index of the node in the cluster.
  """

  etag = _messages.StringField(1)
  hostname = _messages.StringField(2)
  isMaster = _messages.BooleanField(3)
  name = _messages.StringField(4)
  nodeIndex = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class RecommendedAction(_messages.Message):
  r"""Represents a recommended action.

  Fields:
    description: Optional. Description of the recommended action. The
      description can be up to 1024 characters long.
    documentationUrl: Optional. Optional link to documentation or more details
      about the action.
  """

  description = _messages.StringField(1)
  documentationUrl = _messages.StringField(2)


class ReservationAffinity(_messages.Message):
  r"""Deprecated: Do not use.

  Enums:
    TypeValueValuesEnum: Required. Deprecated: Do not use.

  Fields:
    key: Optional. Deprecated: Do not use.
    type: Required. Deprecated: Do not use.
    values: Optional. Deprecated: Do not use.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Deprecated: Do not use.

    Values:
      RESERVATION_TYPE_UNSPECIFIED: Deprecated: Do not use.
      RESERVATION_TYPE_NO_RESERVATION: Deprecated: Do not use.
      RESERVATION_TYPE_ANY_RESERVATION: Deprecated: Do not use.
      RESERVATION_TYPE_SPECIFIC_RESERVATION: Deprecated: Do not use.
    """
    RESERVATION_TYPE_UNSPECIFIED = 0
    RESERVATION_TYPE_NO_RESERVATION = 1
    RESERVATION_TYPE_ANY_RESERVATION = 2
    RESERVATION_TYPE_SPECIFIC_RESERVATION = 3

  key = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)
  values = _messages.StringField(3, repeated=True)


class ResourceRequest(_messages.Message):
  r"""Message describing resource request object

  Enums:
    ProvisioningModelValueValuesEnum: Optional. Specifies the provisioning
      model of the instance
    TerminationActionValueValuesEnum: Optional. Specifies the termination
      action of the instance

  Fields:
    disks: Optional. Array of disks associated with this instance
    id: Required. Id of resource request
    machineType: Required. Type of the machine e.g. c2-standard-60
    maxRunDuration: Optional. Max amount of time instance is allowed to run
    provisioningModel: Optional. Specifies the provisioning model of the
      instance
    reservationAffinity: Optional. Reservations this instance can consume from
    terminationAction: Optional. Specifies the termination action of the
      instance
    zone: Required. Zone of the selected locations
  """

  class ProvisioningModelValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the provisioning model of the instance

    Values:
      PROVISIONING_MODEL_UNSPECIFIED: Unspecified provisioning model
      PROVISIONING_MODEL_STANDARD: Standard provisioning model
      PROVISIONING_MODEL_SPOT: Spot provisioning model
      PROVISIONING_MODEL_FLEX_START: Flex Start provisioning model
      PROVISIONING_MODEL_RESERVATION_BOUND: Reservation Bound provisioning
        model
    """
    PROVISIONING_MODEL_UNSPECIFIED = 0
    PROVISIONING_MODEL_STANDARD = 1
    PROVISIONING_MODEL_SPOT = 2
    PROVISIONING_MODEL_FLEX_START = 3
    PROVISIONING_MODEL_RESERVATION_BOUND = 4

  class TerminationActionValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the termination action of the instance

    Values:
      TERMINATION_ACTION_UNSPECIFIED: Unspecified termination action
      TERMINATION_ACTION_STOP: Stop the instance
      TERMINATION_ACTION_DELETE: Delete the instance
    """
    TERMINATION_ACTION_UNSPECIFIED = 0
    TERMINATION_ACTION_STOP = 1
    TERMINATION_ACTION_DELETE = 2

  disks = _messages.MessageField('Disk', 1, repeated=True)
  id = _messages.StringField(2)
  machineType = _messages.StringField(3)
  maxRunDuration = _messages.IntegerField(4)
  provisioningModel = _messages.EnumField('ProvisioningModelValueValuesEnum', 5)
  reservationAffinity = _messages.MessageField('ReservationAffinity', 6)
  terminationAction = _messages.EnumField('TerminationActionValueValuesEnum', 7)
  zone = _messages.StringField(8)


class ServiceAccount(_messages.Message):
  r"""Service account email and scopes

  Fields:
    email: Optional. Service account email
    scopes: Optional. Service account scopes
  """

  email = _messages.StringField(1)
  scopes = _messages.StringField(2, repeated=True)


class SlurmConfig(_messages.Message):
  r"""Slurm orchestrator configuration. Values correspond to a subset of those
  found in https://slurm.schedmd.com/slurm.conf.html.

  Enums:
    AccountingStorageEnforceFlagsValueListEntryValuesEnum:
    PreemptModeValueListEntryValuesEnum:
    PreemptTypeValueValuesEnum: Optional. Specifies the plugin used to
      identify which jobs can be preempted in order to start a pending job.
    PriorityTypeValueValuesEnum: Optional. Specifies the plugin to be used in
      establishing a job's scheduling priority. Set this value to
      "priority/multifactor" to enable the Multifactor Job Priority Plugin.
    PrologFlagsValueListEntryValuesEnum:

  Fields:
    accountingStorageEnforceFlags: Optional. Flags to control the level of
      association to impose on job submissions. By default no flags are set.
      Corresponds to AccountingStorageEnforce.
    healthCheckInterval: Optional. The interval in seconds between executions
      of HealthCheckProgram. If provided, must be > 0. To disable health
      checks, use disable_health_check_program instead.
    healthCheckNodeState: Optional. The node state to check for. Allowed
      values are "ALLOC", "ANY", "CYCLE", "IDLE", "NONDRAINED_IDLE", "MIXED",
      and "START_ONLY". Multiple state values may be specified with a comma
      separator.
    healthCheckProgram: Optional. The fully-qualified path to the health check
      program to be executed.
    preemptExemptTime: Optional. Specifies minimum run time of jobs before
      they are considered for preemption.
    preemptMode: Optional. Specifies the mechanism used to preempt jobs or
      enable gang scheduling.
    preemptType: Optional. Specifies the plugin used to identify which jobs
      can be preempted in order to start a pending job.
    priorityType: Optional. Specifies the plugin to be used in establishing a
      job's scheduling priority. Set this value to "priority/multifactor" to
      enable the Multifactor Job Priority Plugin.
    priorityWeightAge: Optional. An unsigned integer that scales the
      contribution of the age factor.
    priorityWeightAssoc: Optional. An unsigned integer that scales the
      contribution of the association factor.
    priorityWeightFairshare: Optional. An unsigned integer that scales the
      contribution of the fair-share factor.
    priorityWeightJobSize: Optional. An unsigned integer that scales the
      contribution of the job size factor.
    priorityWeightPartition: Optional. An unsigned integer that scales the
      contribution of the partition factor.
    priorityWeightQos: Optional. An unsigned integer that scales the
      contribution of the quality of service factor.
    priorityWeightTres: Optional. A comma-separated list of TRES Types and
      weights that sets the degree that each TRES Type contributes to the
      job's priority.
    prologEpilogTimeout: Optional. The interval Slurm waits for Prolog and
      Epilog before terminating them. Default is 65534 seconds. Corresponds to
      PrologEpilogTimeout.
    prologFlags: Optional. Flags to control the Prolog behavior. By default no
      flags are set. Corresponds to PrologFlags.
    requeueExitCodes: Optional. Enables automatic requeue for batch jobs which
      exit with the specified values. Default is empty. Corresponds to
      RequeueExit.
    requeueHoldExitCodes: Optional. Enables automatic requeue for batch jobs
      which exit with the specified values, with these jobs being held until
      released manually by the user. Default is empty. Corresponds to
      RequeueExitHold.
  """

  class AccountingStorageEnforceFlagsValueListEntryValuesEnum(_messages.Enum):
    r"""AccountingStorageEnforceFlagsValueListEntryValuesEnum enum type.

    Values:
      ACCOUNTING_STORAGE_ENFORCE_FLAG_UNSPECIFIED: Unspecified accounting
        storage enforce flag.
      ALL: Implies all other available options except nojobs and nosteps.
      ASSOCIATIONS: No new job will be allowed to run unless a corresponding
        association exists in the system.
      LIMITS: Users will be limited by association to whatever job size or run
        time limits are defined. Implies associations.
      NOJOBS: Slurm will not account for any jobs or steps on the system.
        Implies nosteps.
      NOSTEPS: Slurm will not account for any steps that have run.
      QOS: Jobs will not be scheduled unless a valid qos is specified. Implies
        associations.
      SAFE: A job will only be launched against an association or qos that has
        a TRES-minutes limit set if the job will be able to run to completion.
        Without this option set, jobs will be launched as long as their usage
        hasn't reached the TRES-minutes limit. This can lead to jobs being
        launched but then killed when the limit is reached. With this option,
        a job won't be killed due to limits, even if the limits are changed
        after the job was started and the association or qos violates the
        updated limits. Implies limits and associations.
      WCKEYS: Jobs will not be scheduled unless a valid workload
        characterization key is specified. Implies associations and TrackWCKey
        (a separate configuration option).
    """
    ACCOUNTING_STORAGE_ENFORCE_FLAG_UNSPECIFIED = 0
    ALL = 1
    ASSOCIATIONS = 2
    LIMITS = 3
    NOJOBS = 4
    NOSTEPS = 5
    QOS = 6
    SAFE = 7
    WCKEYS = 8

  class PreemptModeValueListEntryValuesEnum(_messages.Enum):
    r"""PreemptModeValueListEntryValuesEnum enum type.

    Values:
      PREEMPT_MODE_UNSPECIFIED: Unspecified preempt mode.
      OFF: Is the default value and disables job preemption and gang
        scheduling.
      CANCEL: The preempted job will be cancelled
      GANG: Enables gang scheduling (time slicing) of jobs in the same
        partition, and allows the resuming of suspended jobs.
      REQUEUE: Preempts jobs by requeuing them (if possible) or canceling
        them.
      SUSPEND: The preempted jobs will be suspended, and later the Gang
        scheduler will resume them.
      PRIORITY: Allow preemption only if the preemptor's job priority is
        higher than the preemptee's job priority.
      WITHIN: Allow jobs within the same qos to preempt one another.
    """
    PREEMPT_MODE_UNSPECIFIED = 0
    OFF = 1
    CANCEL = 2
    GANG = 3
    REQUEUE = 4
    SUSPEND = 5
    PRIORITY = 6
    WITHIN = 7

  class PreemptTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the plugin used to identify which jobs can be
    preempted in order to start a pending job.

    Values:
      PREEMPT_TYPE_UNSPECIFIED: Unspecified preempt type.
      PREEMPT_NONE: Job preemption is disabled (default).
      PREEMPT_PARTITION_PRIO: Job preemption is based upon partition
        PriorityTier.
      PREEMPT_QOS: Job preemption rules are specified by Quality Of Service
        (QOS) specifications in the Slurm database.
    """
    PREEMPT_TYPE_UNSPECIFIED = 0
    PREEMPT_NONE = 1
    PREEMPT_PARTITION_PRIO = 2
    PREEMPT_QOS = 3

  class PriorityTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the plugin to be used in establishing a job's
    scheduling priority. Set this value to "priority/multifactor" to enable
    the Multifactor Job Priority Plugin.

    Values:
      PRIORITY_TYPE_UNSPECIFIED: Unspecified priority type.
      PRIORITY_BASIC: Jobs are evaluated in a First In, First Out (FIFO)
        manner.
      PRIORITY_MULTIFACTOR: Jobs are assigned a priority based upon a variety
        of factors that include size, age, Fairshare, etc.
    """
    PRIORITY_TYPE_UNSPECIFIED = 0
    PRIORITY_BASIC = 1
    PRIORITY_MULTIFACTOR = 2

  class PrologFlagsValueListEntryValuesEnum(_messages.Enum):
    r"""PrologFlagsValueListEntryValuesEnum enum type.

    Values:
      PROLOG_FLAG_UNSPECIFIED: Unspecified prolog flag.
      ALLOC: Prolog script will be executed at job allocation. NOTE: increases
        the time required to start jobs. Corresponds to Alloc.
      CONTAIN: Use the ProcTrack plugin to create a job container on all
        allocated compute nodes. Corresponds to Contain.
      DEFER_BATCH: Slurmctld will wait until the prolog completes on all
        allocated nodes before sending the batch job launch request.
        Corresponds to DeferBatch.
      NO_HOLD: If set, the ALLOC flag should also be set. This will allow for
        salloc to not block until the prolog is finished on each node.
        Corresponds to NoHold.
      FORCE_REQUEUE_ON_FAIL: Always requeue it automatically even if the job
        requested no requeues. NOTE: Setting this flag implicitly sets the
        ALLOC flag. Corresponds to ForceRequeueOnFail.
      RUN_IN_JOB: Make the Prolog/Epilog run in the extern slurmstepd.
        Corresponds to RunInJob.
      SERIAL: Force prolog and epilog scripts to run serially within each
        node. NOTE: This is incompatible with Serial.
      X11: Enable Slurm's built-in X11 forwarding capabilities. Corresponds to
        X11.
    """
    PROLOG_FLAG_UNSPECIFIED = 0
    ALLOC = 1
    CONTAIN = 2
    DEFER_BATCH = 3
    NO_HOLD = 4
    FORCE_REQUEUE_ON_FAIL = 5
    RUN_IN_JOB = 6
    SERIAL = 7
    X11 = 8

  accountingStorageEnforceFlags = _messages.EnumField('AccountingStorageEnforceFlagsValueListEntryValuesEnum', 1, repeated=True)
  healthCheckInterval = _messages.IntegerField(2)
  healthCheckNodeState = _messages.StringField(3)
  healthCheckProgram = _messages.StringField(4)
  preemptExemptTime = _messages.StringField(5)
  preemptMode = _messages.EnumField('PreemptModeValueListEntryValuesEnum', 6, repeated=True)
  preemptType = _messages.EnumField('PreemptTypeValueValuesEnum', 7)
  priorityType = _messages.EnumField('PriorityTypeValueValuesEnum', 8)
  priorityWeightAge = _messages.IntegerField(9)
  priorityWeightAssoc = _messages.IntegerField(10)
  priorityWeightFairshare = _messages.IntegerField(11)
  priorityWeightJobSize = _messages.IntegerField(12)
  priorityWeightPartition = _messages.IntegerField(13)
  priorityWeightQos = _messages.IntegerField(14)
  priorityWeightTres = _messages.StringField(15)
  prologEpilogTimeout = _messages.StringField(16)
  prologFlags = _messages.EnumField('PrologFlagsValueListEntryValuesEnum', 17, repeated=True)
  requeueExitCodes = _messages.IntegerField(18, repeated=True)
  requeueHoldExitCodes = _messages.IntegerField(19, repeated=True)


class SlurmLoginNodes(_messages.Message):
  r"""Configuration for Slurm [login
  nodes](https://slurm.schedmd.com/quickstart_admin.html#login) in the
  cluster. Login nodes are Compute Engine VM instances that allow users to
  access the cluster over SSH.

  Messages:
    LabelsValue: Optional.
      [Labels](https://cloud.google.com/compute/docs/labeling-resources) that
      should be applied to each login node instance.

  Fields:
    bootDisk: Optional. Boot disk for the login node.
    count: Required. Number of login node instances to create.
    disks: Optional. Deprecated: Use boot_disk instead.
    enableOsLogin: Optional. Whether [OS
      Login](https://cloud.google.com/compute/docs/oslogin) should be enabled
      on login node instances.
    enablePublicIps: Optional. Whether login node instances should be assigned
      [external IP addresses](https://cloud.google.com/compute/docs/ip-
      addresses#externaladdresses).
    instances: Output only. Information about the login node instances that
      were created in Compute Engine.
    labels: Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
      resources) that should be applied to each login node instance.
    machineType: Required. Name of the Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-resource) to use for
      login nodes, e.g. `n2-standard-2`.
    serviceAccount: Optional. Unstable: Contact hypercompute-service-eng@
      before using.
    startupScript: Optional. [Startup
      script](https://cloud.google.com/compute/docs/instances/startup-
      scripts/linux) to be run on each login node instance. Max 256KB. The
      script must complete within the system-defined default timeout of 5
      minutes. For tasks that require more time, consider running them in the
      background using methods such as `&` or `nohup`.
    storageConfigs: Optional. How storage resources should be mounted on each
      login node.
    zone: Required. Name of the zone in which login nodes should run, e.g.,
      `us-central1-a`. Must be in the same region as the cluster, and must
      match the zone of any other resources specified in the cluster.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. [Labels](https://cloud.google.com/compute/docs/labeling-
    resources) that should be applied to each login node instance.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bootDisk = _messages.MessageField('BootDisk', 1)
  count = _messages.IntegerField(2)
  disks = _messages.MessageField('Disk', 3, repeated=True)
  enableOsLogin = _messages.BooleanField(4)
  enablePublicIps = _messages.BooleanField(5)
  instances = _messages.MessageField('ComputeInstance', 6, repeated=True)
  labels = _messages.MessageField('LabelsValue', 7)
  machineType = _messages.StringField(8)
  serviceAccount = _messages.MessageField('ServiceAccount', 9)
  startupScript = _messages.StringField(10)
  storageConfigs = _messages.MessageField('StorageConfig', 11, repeated=True)
  zone = _messages.StringField(12)


class SlurmNodeSet(_messages.Message):
  r"""Configuration for Slurm nodesets in the cluster. Nodesets are groups of
  compute nodes used by Slurm that are responsible for running workloads
  submitted to the cluster.

  Messages:
    LabelsValue: Optional. Deprecated: Use ComputeInstanceSlurmNodeSet.labels
      instead.

  Fields:
    bootDisk: Optional. Deprecated: Use compute_instance.boot_disk instead.
    canIpForward: Optional. Deprecated: Do not use.
    computeId: Optional. ID of the compute resource on which this nodeset will
      run. Must match a key in the cluster's
      [compute_resources](Cluster.compute_resources).
    computeInstance: Optional. If set, indicates that the nodeset should be
      backed by Compute Engine instances.
    containerNodePool: Optional. If set, indicates that the nodeset should be
      backed by a Kubernetes Engine node pool.
    enableOsLogin: Optional. Deprecated: Do not use.
    enablePublicIps: Optional. Deprecated: Do not use.
    id: Required. Identifier for the nodeset, which allows it to be referenced
      by partitions. Must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    labels: Optional. Deprecated: Use ComputeInstanceSlurmNodeSet.labels
      instead.
    maxDynamicNodeCount: Optional. Controls how many additional nodes a
      cluster can bring online to handle workloads. Set this value to enable
      dynamic node creation and limit the number of additional nodes the
      cluster can bring online. Leave empty if you do not want the cluster to
      create nodes dynamically, and instead rely only on static nodes.
    resourceRequestId: Optional. Deprecated: Use compute_id instead.
    serviceAccount: Optional. Unstable: Contact hypercompute-service-eng@
      before using.
    startupScript: Optional. Deprecated: Use
      ComputeInstanceSlurmNodeSet.startup_script instead.
    staticNodeCount: Optional. Number of nodes to be statically created for
      this nodeset. The cluster will attempt to ensure that at least this many
      nodes exist at all times.
    storageConfigs: Optional. How storage resources should be mounted on each
      compute node.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Deprecated: Use ComputeInstanceSlurmNodeSet.labels instead.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bootDisk = _messages.MessageField('Disk', 1)
  canIpForward = _messages.BooleanField(2)
  computeId = _messages.StringField(3)
  computeInstance = _messages.MessageField('ComputeInstanceSlurmNodeSet', 4)
  containerNodePool = _messages.MessageField('ContainerNodePoolSlurmNodeSet', 5)
  enableOsLogin = _messages.BooleanField(6)
  enablePublicIps = _messages.BooleanField(7)
  id = _messages.StringField(8)
  labels = _messages.MessageField('LabelsValue', 9)
  maxDynamicNodeCount = _messages.IntegerField(10)
  resourceRequestId = _messages.StringField(11)
  serviceAccount = _messages.MessageField('ServiceAccount', 12)
  startupScript = _messages.StringField(13)
  staticNodeCount = _messages.IntegerField(14)
  storageConfigs = _messages.MessageField('StorageConfig', 15, repeated=True)


class SlurmOrchestrator(_messages.Message):
  r"""When set in Orchestrator, indicates that the cluster should use
  [Slurm](https://slurm.schedmd.com/) as the orchestrator.

  Fields:
    config: Optional. Unstable: Contact hypercompute-service-eng@ before
      using.
    defaultPartition: Optional. Default partition to use for submitted jobs
      that do not explicitly specify a partition. Required if and only if
      there is more than one partition, in which case it must match the id of
      one of the partitions.
    disableHealthCheckProgram: Optional. Unstable: Contact hypercompute-
      service-eng@ before using. If true, health checking is disabled, and
      health_check_interval, health_check_node_state, and health_check_program
      should not be passed in.
    epilogBashScripts: Optional. Slurm [epilog
      scripts](https://slurm.schedmd.com/prolog_epilog.html), which will be
      executed by compute nodes whenever a node finishes running a job. Values
      must not be empty.
    loginNodes: Required. Configuration for login nodes, which allow users to
      access the cluster over SSH.
    nodeSets: Required. Configuration of Slurm nodesets, which define groups
      of compute resources that can be used by Slurm. At least one compute
      node is required.
    partitions: Required. Configuration of Slurm partitions, which group one
      or more nodesets. Acts as a queue against which jobs can be submitted.
      At least one partition is required.
    prologBashScripts: Optional. Slurm [prolog
      scripts](https://slurm.schedmd.com/prolog_epilog.html), which will be
      executed by compute nodes before a node begins running a new job. Values
      must not be empty.
    taskEpilogBashScripts: Optional. Unstable: Contact hypercompute-service-
      eng@ before using.
    taskPrologBashScripts: Optional. Unstable: Contact hypercompute-service-
      eng@ before using.
  """

  config = _messages.MessageField('SlurmConfig', 1)
  defaultPartition = _messages.StringField(2)
  disableHealthCheckProgram = _messages.BooleanField(3)
  epilogBashScripts = _messages.StringField(4, repeated=True)
  loginNodes = _messages.MessageField('SlurmLoginNodes', 5)
  nodeSets = _messages.MessageField('SlurmNodeSet', 6, repeated=True)
  partitions = _messages.MessageField('SlurmPartition', 7, repeated=True)
  prologBashScripts = _messages.StringField(8, repeated=True)
  taskEpilogBashScripts = _messages.StringField(9, repeated=True)
  taskPrologBashScripts = _messages.StringField(10, repeated=True)


class SlurmPartition(_messages.Message):
  r"""Configuration for Slurm partitions in the cluster. Partitions are groups
  of nodesets, and are how clients specify where their workloads should be
  run.

  Fields:
    exclusive: Optional. Unstable: Contact hypercompute-service-eng@ before
      using.
    id: Required. ID of the partition, which is how users will identify it.
      Must conform to
      [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
      alphanumeric, and at most 63 characters).
    nodeSetIds: Required. IDs of the nodesets that make up this partition.
      Values must match SlurmNodeSet.id.
  """

  exclusive = _messages.BooleanField(1)
  id = _messages.StringField(2)
  nodeSetIds = _messages.StringField(3, repeated=True)


class Smon(_messages.Message):
  r"""Smon Tool Metadata

  Enums:
    WorstSeverityValueValuesEnum: Output only. The worst severity among all
      active monitored events.

  Fields:
    monitoringSummary: Output only. A summary of the monitoring findings.
    worstSeverity: Output only. The worst severity among all active monitored
      events.
  """

  class WorstSeverityValueValuesEnum(_messages.Enum):
    r"""Output only. The worst severity among all active monitored events.

    Values:
      SEVERITY_UNSPECIFIED: Severity is not specified.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    LOW = 1
    MEDIUM = 2
    HIGH = 3
    CRITICAL = 4

  monitoringSummary = _messages.StringField(1)
  worstSeverity = _messages.EnumField('WorstSeverityValueValuesEnum', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Storage(_messages.Message):
  r"""Message describing Storage object

  Fields:
    id: Required. Storage id
    initializeParams: Immutable. Parameters to initialize the storage
    storage: Output only. Storage name
    storageSource: Immutable. Reference of existing storage
  """

  id = _messages.StringField(1)
  initializeParams = _messages.MessageField('StorageInitializeParams', 2)
  storage = _messages.StringField(3)
  storageSource = _messages.MessageField('StorageSource', 4)


class StorageConfig(_messages.Message):
  r"""Description of how a storage resource should be mounted on a VM
  instance.

  Fields:
    id: Required. ID of the storage resource to mount, which must match a key
      in the cluster's [storage_resources](Cluster.storage_resources).
    localMount: Required. A directory inside the VM instance's file system
      where the storage resource should be mounted (e.g., `/mnt/share`).
  """

  id = _messages.StringField(1)
  localMount = _messages.StringField(2)


class StorageInitializeParams(_messages.Message):
  r"""Message describing initialize params for storage object

  Fields:
    filestore: FileStore initialize params
    gcs: Google Cloud Storage initialize params
    lustre: Lustre initialize params
  """

  filestore = _messages.MessageField('FilestoreInitializeParams', 1)
  gcs = _messages.MessageField('GcsInitializeParams', 2)
  lustre = _messages.MessageField('LustreInitializeParams', 3)


class StorageResource(_messages.Message):
  r"""A resource representing a form of persistent storage that is accessible
  to compute resources in the cluster.

  Fields:
    bucket: Reference to a Google Cloud Storage bucket. Populated if and only
      if the storage resource was configured to use Google Cloud Storage.
    config: Required. Immutable. Configuration for this storage resource,
      which describes how it should be created or imported. This field only
      controls how the storage resource is initially created or imported.
      Subsequent changes to the storage resource should be made via the
      resource's API and will not be reflected in the configuration.
    filestore: Reference to a Filestore instance. Populated if and only if the
      storage resource was configured to use Filestore.
    lustre: Reference to a Managed Lustre instance. Populated if and only if
      the storage resource was configured to use Managed Lustre.
  """

  bucket = _messages.MessageField('BucketReference', 1)
  config = _messages.MessageField('StorageResourceConfig', 2)
  filestore = _messages.MessageField('FilestoreReference', 3)
  lustre = _messages.MessageField('LustreReference', 4)


class StorageResourceConfig(_messages.Message):
  r"""Describes how a storage resource should be initialized. Each storage
  resource can either be imported from an existing Google Cloud resource or
  initialized when the cluster is created.

  Fields:
    existingBucket: Optional. Immutable. If set, indicates that an existing
      Cloud Storage bucket should be imported.
    existingFilestore: Optional. Immutable. If set, indicates that an existing
      Filestore instance should be imported.
    existingLustre: Optional. Immutable. If set, indicates that an existing
      Managed Lustre instance should be imported.
    newBucket: Optional. Immutable. If set, indicates that a new Cloud Storage
      bucket should be created.
    newFilestore: Optional. Immutable. If set, indicates that a new Filestore
      instance should be created.
    newLustre: Optional. Immutable. If set, indicates that a new Managed
      Lustre instance should be created.
  """

  existingBucket = _messages.MessageField('ExistingBucketConfig', 1)
  existingFilestore = _messages.MessageField('ExistingFilestoreConfig', 2)
  existingLustre = _messages.MessageField('ExistingLustreConfig', 3)
  newBucket = _messages.MessageField('NewBucketConfig', 4)
  newFilestore = _messages.MessageField('NewFilestoreConfig', 5)
  newLustre = _messages.MessageField('NewLustreConfig', 6)


class StorageSource(_messages.Message):
  r"""Message describing source of storage

  Fields:
    bucket: Name of the existing Google Cloud Storage bucket
    filestore: Name of the existing filestore
    lustre: Name of the existing Lustre instance
  """

  bucket = _messages.StringField(1)
  filestore = _messages.StringField(2)
  lustre = _messages.StringField(3)


class ThermalAnalysisDetails(_messages.Message):
  r"""Metadata specific to Thermal Analysis. Placeholder for thermal sensor
  readings and thresholds.
  """



class Tool(_messages.Message):
  r"""A tool for a Machine Learning run.

  Fields:
    smon: Optional. Smon (System Monitored) tool Signifies that the workload
      is under active monitoring.
    xprof: Optional. XProf related metadata
  """

  smon = _messages.MessageField('Smon', 1)
  xprof = _messages.MessageField('Xprof', 2)


class UpdateLoginNode(_messages.Message):
  r"""When set in OperationStep, indicates that a login node should be
  updated.
  """



class UpdateNodeset(_messages.Message):
  r"""When set in OperationStep, indicates that a nodeset should be updated.

  Fields:
    nodesets: Output only. Name of the nodeset to update
  """

  nodesets = _messages.StringField(1, repeated=True)


class UpdateOrchestrator(_messages.Message):
  r"""When set in OperationStep, indicates that an orchestrator should be
  updated.
  """



class UpdatePartition(_messages.Message):
  r"""When set in OperationStep, indicates that a partition should be updated.

  Fields:
    partitions: Output only. Name of the partition to update
  """

  partitions = _messages.StringField(1, repeated=True)


class WorkloadDetails(_messages.Message):
  r"""Workload details associated for the Machine Learning Run. Workload have
  different metadata based on the orchestrator like GKE cluster, Slurm
  cluster, Google Compute Engine instance etc.

  Fields:
    gke: GKE Workload metadata.
  """

  gke = _messages.MessageField('GKEWorkloadDetails', 1)


class Xprof(_messages.Message):
  r"""XProf related metadata

  Fields:
    sessionId: Required. XProf session id
  """

  sessionId = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
