/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.internal.component.external.model.ExternalModuleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.jspecify.annotations.Nullable;

public class MavenDependencyMetadata
extends ExternalModuleDependencyMetadata {
    private final MavenDependencyDescriptor dependencyDescriptor;

    public MavenDependencyMetadata(MavenDependencyDescriptor dependencyDescriptor) {
        this(dependencyDescriptor, null, false);
    }

    public MavenDependencyMetadata(MavenDependencyDescriptor dependencyDescriptor, @Nullable String reason, boolean endorsing) {
        this(dependencyDescriptor, reason, endorsing, (List<IvyArtifactName>)dependencyDescriptor.getConfigurationArtifacts());
    }

    private MavenDependencyMetadata(MavenDependencyDescriptor dependencyDescriptor, @Nullable String reason, boolean endorsing, List<IvyArtifactName> artifacts) {
        super(reason, endorsing, artifacts);
        this.dependencyDescriptor = dependencyDescriptor;
    }

    @Override
    public MavenDependencyDescriptor getDependencyDescriptor() {
        return this.dependencyDescriptor;
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.getDependencyDescriptor().getConfigurationExcludes();
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        return new MavenDependencyMetadata(this.dependencyDescriptor, reason, this.isEndorsingStrictVersions(), this.getArtifacts());
    }

    @Override
    public ModuleDependencyMetadata withEndorseStrictVersions(boolean endorse) {
        return new MavenDependencyMetadata(this.dependencyDescriptor, this.getReason(), endorse, this.getArtifacts());
    }

    @Override
    protected ModuleDependencyMetadata withRequested(ModuleComponentSelector newSelector) {
        MavenDependencyDescriptor newDescriptor = this.dependencyDescriptor.withRequested(newSelector);
        return new MavenDependencyMetadata(newDescriptor, this.getReason(), this.isEndorsingStrictVersions(), this.getArtifacts());
    }

    @Override
    protected ModuleDependencyMetadata withArtifacts(List<IvyArtifactName> newArtifacts) {
        return new MavenDependencyMetadata(this.dependencyDescriptor, this.getReason(), this.isEndorsingStrictVersions(), newArtifacts);
    }

    @Override
    protected ModuleDependencyMetadata withRequestedAndArtifacts(ModuleComponentSelector newSelector, List<IvyArtifactName> newArtifacts) {
        MavenDependencyDescriptor newDelegate = this.dependencyDescriptor.withRequested(newSelector);
        return new MavenDependencyMetadata(newDelegate, this.getReason(), this.isEndorsingStrictVersions(), newArtifacts);
    }
}

