/*
 * Decompiled with CFR 0.152.
 */
package jflex.dfa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import jflex.core.Action;
import jflex.core.EOFActions;
import jflex.core.LexParse;
import jflex.core.LexScan;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;

public class DFA {
    private static final int STATES = 500;
    public static final int NO_TARGET = -1;
    static final boolean DFA_DEBUG = false;
    int[][] table;
    boolean[] isFinal;
    private final int numInput;
    private final int numLexStates;
    private int numStates;
    int[] entryState;
    private Action[] action;
    private final Map<Action, Action> usedActions = new HashMap<Action, Action>();
    private boolean lookaheadUsed;
    private boolean minimized;

    public DFA(int numEntryStates, int numInputs, int numLexStates) {
        this(numEntryStates, numInputs, numLexStates, 0);
    }

    DFA(int numEntryStates, int numInputs, int numLexStates, int numStates) {
        this.numInput = numInputs;
        this.numLexStates = numLexStates;
        this.numStates = numStates;
        int statesNeeded = Math.max(numEntryStates, 500);
        this.table = new int[statesNeeded][this.numInput];
        this.isFinal = new boolean[statesNeeded];
        this.action = new Action[statesNeeded];
        this.entryState = new int[numEntryStates];
        for (int i = 0; i < statesNeeded; ++i) {
            for (int j = 0; j < this.numInput; ++j) {
                this.table[i][j] = -1;
            }
        }
    }

    public void setEntryState(int eState, int trueState) {
        this.entryState[eState] = trueState;
        this.minimized = false;
    }

    private void ensureStateCapacity(int newNumStates) {
        int newLength;
        int oldLength = this.isFinal.length;
        if (newNumStates < oldLength) {
            return;
        }
        for (newLength = oldLength * 2; newLength <= newNumStates; newLength *= 2) {
        }
        boolean[] newFinal = new boolean[newLength];
        Action[] newAction = new Action[newLength];
        int[][] newTable = new int[newLength][this.numInput];
        System.arraycopy(this.isFinal, 0, newFinal, 0, this.numStates);
        System.arraycopy(this.action, 0, newAction, 0, this.numStates);
        System.arraycopy(this.table, 0, newTable, 0, oldLength);
        for (int i = oldLength; i < newLength; ++i) {
            for (int j = 0; j < this.numInput; ++j) {
                newTable[i][j] = -1;
            }
        }
        this.isFinal = newFinal;
        this.action = newAction;
        this.table = newTable;
        this.minimized = false;
    }

    public void setAction(int state, Action stateAction) {
        this.action[state] = stateAction;
        if (stateAction != null) {
            this.usedActions.put(stateAction, stateAction);
            this.lookaheadUsed |= stateAction.isGenLookAction();
            this.minimized = false;
        }
    }

    public void setFinal(int state, boolean isFinalState) {
        this.isFinal[state] = isFinalState;
        this.minimized = false;
    }

    public void addTransition(int start, int input, int dest) {
        int max = Math.max(start, dest) + 1;
        this.ensureStateCapacity(max);
        if (max > this.numStates) {
            this.numStates = max;
        }
        this.table[start][input] = dest;
        this.minimized = false;
    }

    public boolean lookaheadUsed() {
        return this.lookaheadUsed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.numStates; ++i) {
            result.append("State ");
            if (this.isFinal[i]) {
                result.append("[FINAL");
                String l = this.action[i].lookString();
                if (!Objects.equals(l, "")) {
                    result.append(", ");
                    result.append(l);
                }
                result.append("] ");
            }
            result.append(i).append(":").append(Out.NL);
            for (int j = 0; j < this.numInput; ++j) {
                if (this.table[i][j] < 0) continue;
                result.append("  with ").append(j).append(" in ").append(this.table[i][j]).append(Out.NL);
            }
        }
        return result.toString();
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.table);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DFA)) {
            return false;
        }
        return Arrays.equals(this.isFinal, ((DFA)obj).isFinal) && Arrays.equals(this.entryState, ((DFA)obj).entryState) && Arrays.equals(this.action, ((DFA)obj).action) && Objects.equals(this.usedActions, ((DFA)obj).usedActions) && DFA.tableEquals(this.table, ((DFA)obj).table);
    }

    private static boolean tableEquals(int[][] a, int[][] b) {
        for (int i = 0; i < a.length; ++i) {
            if (Arrays.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public void writeDot(File file) {
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            writer.println(this.dotFormat());
            writer.close();
        }
        catch (IOException e) {
            Out.error(ErrorMessages.FILE_WRITE, file);
            throw new GeneratorException(e);
        }
    }

    private String dotFormat() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("digraph DFA {").append(Out.NL);
        result.append("rankdir = LR").append(Out.NL);
        for (i = 0; i < this.numStates; ++i) {
            if (!this.isFinal[i]) continue;
            result.append(i);
            result.append(" [shape = doublecircle]");
            result.append(Out.NL);
        }
        for (i = 0; i < this.numStates; ++i) {
            for (int input = 0; input < this.numInput; ++input) {
                if (this.table[i][input] < 0) continue;
                result.append(i).append(" -> ").append(this.table[i][input]);
                result.append(" [label=\"[").append(input).append("]\"]").append(Out.NL);
            }
        }
        result.append("}").append(Out.NL);
        return result.toString();
    }

    public void checkActions(LexScan scanner, LexParse parser) {
        EOFActions eofActions = parser.getEOFActions();
        for (Action a : scanner.actions()) {
            if (Objects.equals(a, this.usedActions.get(a)) || eofActions.isEOFAction(a)) continue;
            Out.warning(scanner.file(), ErrorMessages.NEVER_MATCH, a.priority - 1, -1);
        }
    }

    public void minimize() {
        int i;
        int c;
        int last;
        int B_i;
        if (this.minimized) {
            return;
        }
        if (this.numStates == 0) {
            Out.error(ErrorMessages.ZERO_STATES);
            throw new GeneratorException(new IllegalStateException("DFA has 0 states"));
        }
        if (Options.no_minimize) {
            Out.println("minimization skipped.");
            return;
        }
        int n = this.numStates + 1;
        int[] block = new int[2 * n];
        int[] b_forward = new int[2 * n];
        int[] b_backward = new int[2 * n];
        int lastBlock = n;
        int b0 = n;
        int[] l_forward = new int[n * this.numInput + 1];
        int[] l_backward = new int[n * this.numInput + 1];
        int anchorL = n * this.numInput;
        int[][] inv_delta = new int[n][this.numInput];
        int[] inv_delta_set = new int[2 * n * this.numInput];
        int[] twin = new int[2 * n];
        int[] SD = new int[2 * n];
        int[] D = new int[n];
        int lastDelta = 0;
        int[] inv_lists = new int[n];
        int[] inv_list_last = new int[n];
        for (int c2 = 0; c2 < this.numInput; ++c2) {
            int s;
            for (s = 0; s < n; ++s) {
                inv_list_last[s] = -1;
                inv_delta[s][c2] = -1;
            }
            inv_delta[0][c2] = 0;
            inv_list_last[0] = 0;
            for (s = 1; s < n; ++s) {
                int t = this.table[s - 1][c2] + 1;
                if (inv_list_last[t] == -1) {
                    inv_delta[t][c2] = s;
                    inv_list_last[t] = s;
                    continue;
                }
                inv_lists[inv_list_last[t]] = s;
                inv_list_last[t] = s;
            }
            for (s = 0; s < n; ++s) {
                boolean go_on;
                int i2 = inv_delta[s][c2];
                inv_delta[s][c2] = lastDelta;
                int j = inv_list_last[s];
                boolean bl = go_on = i2 != -1;
                while (go_on) {
                    go_on = i2 != j;
                    inv_delta_set[lastDelta++] = i2;
                    i2 = inv_lists[i2];
                }
                inv_delta_set[lastDelta++] = -1;
            }
        }
        b_forward[b0] = 0;
        b_backward[b0] = 0;
        b_forward[0] = b0;
        b_backward[0] = b0;
        block[0] = b0;
        block[b0] = 1;
        for (int s = 1; s < n; ++s) {
            int b;
            boolean found = false;
            for (b = b0 + 1; !found && b <= lastBlock; ++b) {
                int t = b_forward[b];
                if (this.isFinal[s - 1]) {
                    found = this.isFinal[t - 1] && this.action[s - 1].isEquiv(this.action[t - 1]);
                } else {
                    boolean bl = found = !this.isFinal[t - 1];
                }
                if (!found) continue;
                block[s] = b;
                int n2 = b;
                block[n2] = block[n2] + 1;
                int last2 = b_backward[b];
                b_forward[last2] = s;
                b_forward[s] = b;
                b_backward[b] = s;
                b_backward[s] = last2;
            }
            if (found) continue;
            block[s] = b;
            int n3 = b;
            block[n3] = block[n3] + 1;
            b_forward[b] = s;
            b_forward[s] = b;
            b_backward[b] = s;
            b_backward[s] = b;
            ++lastBlock;
        }
        int B_max = b0;
        for (B_i = b0 + 1; B_i <= lastBlock; ++B_i) {
            if (block[B_max] >= block[B_i]) continue;
            B_max = B_i;
        }
        l_forward[anchorL] = anchorL;
        l_backward[anchorL] = anchorL;
        B_i = B_max == b0 ? b0 + 1 : b0;
        int index = (B_i - b0) * this.numInput;
        while (index < (B_i + 1 - b0) * this.numInput) {
            last = l_backward[anchorL];
            l_forward[last] = index;
            l_forward[index] = anchorL;
            l_backward[index] = last;
            l_backward[anchorL] = index++;
        }
        while (B_i <= lastBlock) {
            if (B_i != B_max) {
                index = (B_i - b0) * this.numInput;
                while (index < (B_i + 1 - b0) * this.numInput) {
                    last = l_backward[anchorL];
                    l_forward[last] = index;
                    l_forward[index] = anchorL;
                    l_backward[index] = last;
                    l_backward[anchorL] = index++;
                }
            }
            ++B_i;
        }
        while (l_forward[anchorL] != anchorL) {
            int B_k;
            int indexD;
            int B_j_a = l_forward[anchorL];
            l_forward[anchorL] = l_forward[B_j_a];
            l_backward[l_forward[anchorL]] = anchorL;
            l_forward[B_j_a] = 0;
            int B_j = b0 + B_j_a / this.numInput;
            int a = B_j_a % this.numInput;
            int numD = 0;
            int s = b_forward[B_j];
            while (s != B_j) {
                int t = inv_delta[s][a];
                while (inv_delta_set[t] != -1) {
                    D[numD++] = inv_delta_set[t++];
                }
                s = b_forward[s];
            }
            int numSplit = 0;
            for (indexD = 0; indexD < numD; ++indexD) {
                s = D[indexD];
                B_i = block[s];
                SD[B_i] = -1;
                twin[B_i] = 0;
            }
            for (indexD = 0; indexD < numD; ++indexD) {
                s = D[indexD];
                B_i = block[s];
                if (SD[B_i] >= 0) continue;
                SD[B_i] = 0;
                int t = b_forward[B_i];
                while (!(t == B_i || t == 0 && block[0] != B_j || t != 0 && block[this.table[t - 1][a] + 1] != B_j)) {
                    int n4 = B_i;
                    SD[n4] = SD[n4] + 1;
                    t = b_forward[t];
                }
            }
            for (indexD = 0; indexD < numD; ++indexD) {
                s = D[indexD];
                B_i = block[s];
                if (SD[B_i] == block[B_i]) continue;
                B_k = twin[B_i];
                if (B_k == 0) {
                    b_forward[B_k] = B_k = ++lastBlock;
                    b_backward[B_k] = B_k;
                    twin[B_i] = B_k;
                    twin[numSplit++] = B_i;
                }
                b_forward[b_backward[s]] = b_forward[s];
                b_backward[b_forward[s]] = b_backward[s];
                int last3 = b_backward[B_k];
                b_forward[last3] = s;
                b_forward[s] = B_k;
                b_backward[s] = last3;
                b_backward[B_k] = s;
                block[s] = B_k;
                int n5 = B_k;
                block[n5] = block[n5] + 1;
                int n6 = B_i;
                block[n6] = block[n6] - 1;
                int n7 = B_i;
                SD[n7] = SD[n7] - 1;
            }
            for (int indexTwin = 0; indexTwin < numSplit; ++indexTwin) {
                B_i = twin[indexTwin];
                B_k = twin[B_i];
                for (c = 0; c < this.numInput; ++c) {
                    int last4;
                    int B_i_c = (B_i - b0) * this.numInput + c;
                    int B_k_c = (B_k - b0) * this.numInput + c;
                    if (l_forward[B_i_c] > 0) {
                        last4 = l_backward[anchorL];
                        l_backward[anchorL] = B_k_c;
                        l_forward[last4] = B_k_c;
                        l_backward[B_k_c] = last4;
                        l_forward[B_k_c] = anchorL;
                        continue;
                    }
                    if (block[B_i] <= block[B_k]) {
                        last4 = l_backward[anchorL];
                        l_backward[anchorL] = B_i_c;
                        l_forward[last4] = B_i_c;
                        l_backward[B_i_c] = last4;
                        l_forward[B_i_c] = anchorL;
                        continue;
                    }
                    last4 = l_backward[anchorL];
                    l_backward[anchorL] = B_k_c;
                    l_forward[last4] = B_k_c;
                    l_backward[B_k_c] = last4;
                    l_forward[B_k_c] = anchorL;
                }
            }
        }
        int[] trans = new int[this.numStates];
        boolean[] kill = new boolean[this.numStates];
        int[] move = new int[this.numStates];
        for (int b = n + 1; b <= lastBlock; ++b) {
            int s;
            int min_s = s = b_forward[b];
            while (s != b) {
                if (min_s > s) {
                    min_s = s;
                }
                s = b_forward[s];
            }
            --min_s;
            s = b_forward[b] - 1;
            while (s != b - 1) {
                trans[s] = min_s;
                kill[s] = s != min_s;
                s = b_forward[s + 1] - 1;
            }
        }
        int amount = 0;
        for (i = 0; i < this.numStates; ++i) {
            if (kill[i]) {
                ++amount;
                continue;
            }
            move[i] = amount;
        }
        int j = 0;
        for (i = 0; i < this.numStates; ++i) {
            if (kill[i]) continue;
            for (c = 0; c < this.numInput; ++c) {
                if (this.table[i][c] >= 0) {
                    this.table[j][c] = trans[this.table[i][c]];
                    int[] nArray = this.table[j];
                    int n8 = c;
                    nArray[n8] = nArray[n8] - move[this.table[j][c]];
                    continue;
                }
                this.table[j][c] = this.table[i][c];
            }
            this.isFinal[j] = this.isFinal[i];
            this.action[j] = this.action[i];
            ++j;
        }
        this.numStates = j;
        for (i = 0; i < this.entryState.length; ++i) {
            this.entryState[i] = trans[this.entryState[i]];
            int n9 = i;
            this.entryState[n9] = this.entryState[n9] - move[this.entryState[i]];
        }
        this.minimized = true;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public String toString(int[] a) {
        StringBuilder r = new StringBuilder("{");
        for (int i = 0; i < a.length - 1; ++i) {
            r.append(a[i]).append(",");
        }
        if (a.length > 0) {
            r.append(a[a.length - 1]);
        }
        r.append("}");
        return r.toString();
    }

    private void printBlocks(int[] b, int[] b_f, int[] b_b, int last) {
        int n;
        Out.dump("block     : " + this.toString(b));
        Out.dump("b_forward : " + this.toString(b_f));
        Out.dump("b_backward: " + this.toString(b_b));
        Out.dump("lastBlock : " + last);
        for (int i = n = this.numStates + 1; i <= last; ++i) {
            Out.dump("Block " + (i - n) + " (size " + b[i] + "):");
            String line = "{";
            int s = b_f[i];
            while (s != i) {
                line = line + (s - 1);
                int t = s;
                if ((s = b_f[s]) != i) {
                    line = line + ",";
                    if (b[s] != i) {
                        Out.dump("consistency error for state " + (s - 1) + " (block " + b[s] + ")");
                    }
                }
                if (b_b[s] == t) continue;
                Out.dump("consistency error for b_back in state " + (s - 1) + " (back = " + b_b[s] + ", should be = " + t + ")");
            }
            Out.dump(line + "}");
        }
    }

    private void printL(int[] l_f, int[] l_b, int anchor) {
        String l = "L = {";
        int bc = l_f[anchor];
        while (bc != anchor) {
            int b = bc / this.numInput;
            int c = bc % this.numInput;
            l = l + "(" + b + "," + c + ")";
            int old_bc = bc;
            if ((bc = l_f[bc]) != anchor) {
                l = l + ",";
            }
            if (l_b[bc] == old_bc) continue;
            Out.dump("consistency error for (" + b + "," + c + ")");
        }
        Out.dump(l + "}");
    }

    private void printInvDelta(int[][] inv_delta, int[] inv_delta_set) {
        Out.dump("Inverse of transition table: ");
        for (int s = 0; s < this.numStates + 1; ++s) {
            Out.dump("State [" + (s - 1) + "]");
            for (int c = 0; c < this.numInput; ++c) {
                String line = "With <" + c + "> in {";
                int t = inv_delta[s][c];
                while (inv_delta_set[t] != -1) {
                    line = line + (inv_delta_set[t++] - 1);
                    if (inv_delta_set[t] == -1) continue;
                    line = line + ",";
                }
                if (inv_delta_set[inv_delta[s][c]] == -1) continue;
                Out.dump(line + "}");
            }
        }
    }

    public int numInput() {
        return this.numInput;
    }

    public int numStates() {
        return this.numStates;
    }

    public int numLexStates() {
        return this.numLexStates;
    }

    public int entryState(int i) {
        return this.entryState[i];
    }

    public boolean isFinal(int i) {
        return this.isFinal[i];
    }

    public int table(int i, int j) {
        return this.table[i][j];
    }

    public Action action(int i) {
        return this.action[i];
    }
}

