/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.common;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.util.Errors;

public final class MatrixValidator {
    private MatrixValidator() {
    }

    public static void validateMatrix(JReleaserContext context, Matrix matrix, String key, Errors errors) {
        if (matrix.isEmpty()) {
            return;
        }
        context.getLogger().debug(key);
        if (matrix.hasVars() && matrix.hasRows()) {
            errors.configuration(RB.$((String)"validation_matrix_vars_and_rows", (Object[])new Object[]{key}));
            return;
        }
        if (matrix.hasVars()) {
            matrix.getVars().forEach((k, v) -> {
                if (null == v || v.isEmpty()) {
                    errors.configuration(RB.$((String)"validation_matrix_invalid_var", (Object[])new Object[]{key, k}));
                }
            });
        }
        if (matrix.hasRows()) {
            List<Map<String, String>> rows = matrix.getRows();
            long variants = rows.stream().mapToInt(Map::size).distinct().count();
            if (variants != 1L) {
                errors.configuration(RB.$((String)"validation_matrix_column_count", (Object[])new Object[]{key}));
            }
            Set<String> keys = rows.get(0).keySet();
            for (int i = 0; i < rows.size(); ++i) {
                Set<String> target = rows.get(i).keySet();
                if (target.containsAll(keys) || target.size() != keys.size()) continue;
                errors.configuration(RB.$((String)"validation_matrix_different_keys", (Object[])new Object[]{key, i}));
            }
        }
    }
}

