/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyRange;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuildRangeInstr
extends TwoOperandResultBaseInstr {
    private final boolean exclusive;

    public BuildRangeInstr(Variable result2, Operand begin2, Operand end2, boolean exclusive) {
        super(Operation.BUILD_RANGE, result2, begin2, end2);
        this.exclusive = exclusive;
    }

    public Operand getBegin() {
        return this.getOperand1();
    }

    public Operand getEnd() {
        return this.getOperand2();
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"type: " + (this.exclusive ? "exclusive" : "inclusive")};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildRangeInstr(ii.getRenamedVariable(this.result), this.getBegin().cloneForInlining(ii), this.getEnd().cloneForInlining(ii), this.exclusive);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getBegin());
        e.encode(this.getEnd());
        e.encode(this.isExclusive());
    }

    public static BuildRangeInstr decode(IRReaderDecoder d) {
        return new BuildRangeInstr(d.decodeVariable(), d.decodeOperand(), d.decodeOperand(), d.decodeBoolean());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        return RubyRange.newRange(context, (IRubyObject)this.getBegin().retrieve(context, self2, currScope, currDynScope, temp), (IRubyObject)this.getEnd().retrieve(context, self2, currScope, currDynScope, temp), this.exclusive);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildRangeInstr(this);
    }
}

