/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.internal.runtime.methods.NativeCallMethod;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.ir.JIT;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.SiteTracker;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.indy.JavaBootstrap;
import org.jruby.ir.targets.indy.SelfInvokeSite;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.InvocationLinker;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class InvokeSite
extends MutableCallSite {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeSite.class);
    private static final String[] GENERIC_CALL_PERMUTE = new String[]{"context", "self", "arg.*"};
    private static final boolean LOG_BINDING;
    static final MethodHandles.Lookup LOOKUP;
    public final Signature signature;
    public final Signature fullSignature;
    public final int arity;
    protected final String methodName;
    final MethodHandle fallback;
    private final SiteTracker tracker = new SiteTracker();
    private final long siteID = JRubyCallSite.SITE_ID.getAndIncrement();
    public final int argOffset;
    public final boolean functional;
    protected final String file;
    protected final int line;
    protected final int flags;
    private boolean boundOnce;
    private boolean literalClosure;
    protected CacheEntry cache = CacheEntry.NULL_CACHE;
    public final CallType callType;
    private static final MethodHandle ESCAPE_BLOCK;
    private static final Map<Signature, MethodHandle> BLOCK_ESCAPES;
    public static final MethodHandle NEGATE;
    private static final MethodHandle TEST_CLASS;

    public static boolean testType(RubyClass original, IRubyObject self2) {
        return original == RubyBasicObject.getMetaClass(self2);
    }

    MethodHandle buildIndyHandle(CacheEntry entry) {
        MethodHandle mh = null;
        Signature siteToDyncall = this.signature.insertArgs(this.argOffset, Helpers.arrayOf("class", "name"), Helpers.arrayOf(RubyModule.class, String.class));
        DynamicMethod method2 = entry.method;
        if (method2 instanceof HandleMethod) {
            boolean blockGiven;
            HandleMethod handleMethod = (HandleMethod)method2;
            boolean bl = blockGiven = this.signature.lastArgType() == Block.class;
            if (this.arity >= 0) {
                mh = handleMethod.getHandle(this.arity);
                if (mh != null) {
                    if (!blockGiven) {
                        mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                    }
                    if (!this.functional) {
                        mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                    }
                } else {
                    mh = handleMethod.getHandle(-1);
                    if (!this.functional) {
                        mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                    }
                    if (this.arity == 0) {
                        mh = !blockGiven ? MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK) : MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, new Object[]{IRubyObject.NULL_ARRAY});
                    } else {
                        if (!blockGiven) {
                            mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                        }
                        mh = SmartBinder.from(MethodHandles.lookup(), siteToDyncall).collect("args", "arg.*", Helpers.constructObjectArrayHandle(this.arity)).invoke(mh).handle();
                    }
                }
            } else {
                mh = handleMethod.getHandle(-1);
                if (mh != null) {
                    if (!this.functional) {
                        mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                    }
                    if (!blockGiven) {
                        mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                    }
                    mh = SmartBinder.from(MethodHandles.lookup(), siteToDyncall).invoke(mh).handle();
                }
            }
            if (mh != null) {
                mh = MethodHandles.insertArguments(mh, this.argOffset, entry.sourceModule, this.name());
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound directly to handle " + Bootstrap.logMethod(method2), new Object[0]);
                }
            }
        }
        return mh;
    }

    MethodHandle buildGenericHandle(CacheEntry entry) {
        DynamicMethod method2 = entry.method;
        SmartBinder binder = SmartBinder.from(this.signature);
        binder = InvokeSite.permuteForGenericCall(binder, method2, GENERIC_CALL_PERMUTE);
        binder = binder.insert(2, new String[]{"rubyClass", "name"}, new Class[]{RubyModule.class, String.class}, entry.sourceModule, this.name()).insert(0, "method", DynamicMethod.class, (Object)method2);
        if (this.arity > 3) {
            binder = binder.collect("args", "arg.*", Helpers.constructObjectArrayHandle(this.arity));
        }
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(this.name() + "\tbound indirectly " + String.valueOf(method2) + ", " + Bootstrap.logMethod(method2), new Object[0]);
        }
        return binder.invokeVirtualQuiet(LOOKUP, "call").handle();
    }

    private static SmartBinder permuteForGenericCall(SmartBinder binder, DynamicMethod method2, String ... basePermutes) {
        binder = InvokeSite.methodWantsBlock(method2) ? binder.permute(Helpers.arrayOf(basePermutes, "block", String[]::new)) : binder.permute(basePermutes);
        return binder;
    }

    private static boolean methodWantsBlock(DynamicMethod method2) {
        Class[] nativeSignature;
        DynamicMethod.NativeCall nativeCall;
        boolean wantsBlock = true;
        if (method2 instanceof NativeCallMethod && (nativeCall = ((NativeCallMethod)((Object)method2)).getNativeCall()) != null && !nativeCall.isJava() && ((nativeSignature = nativeCall.getNativeSignature()).length == 0 || nativeSignature[nativeSignature.length - 1] != Block.class)) {
            wantsBlock = false;
        }
        return wantsBlock;
    }

    static MethodHandle buildMethodMissingHandle(InvokeSite site, CacheEntry entry, IRubyObject self2) {
        SmartBinder binder;
        DynamicMethod method2 = entry.method;
        if (site.arity >= 0) {
            binder = SmartBinder.from(site.signature);
            binder = InvokeSite.permuteForGenericCall(binder, method2, GENERIC_CALL_PERMUTE).insert(2, new String[]{"rubyClass", "name", "argName"}, new Class[]{RubyModule.class, String.class, IRubyObject.class}, entry.sourceModule, site.name(), RubySymbol.newSymbol(self2.getRuntime(), site.methodName)).insert(0, "method", DynamicMethod.class, (Object)method2).collect("args", "arg.*", Helpers.constructObjectArrayHandle(site.arity + 1));
        } else {
            SmartHandle fold = SmartBinder.from(site.signature.permute("context", "self", "args", "block").changeReturn(IRubyObject[].class)).permute("args").insert(0, "argName", IRubyObject.class, (Object)RubySymbol.newSymbol(self2.getRuntime(), site.methodName)).invokeStaticQuiet(LOOKUP, Helpers.class, "arrayOf");
            binder = SmartBinder.from(site.signature);
            binder = InvokeSite.permuteForGenericCall(binder, method2, "context", "self", "args").fold("args2", fold);
            binder = InvokeSite.permuteForGenericCall(binder, method2, "context", "self", "args2").insert(2, new String[]{"rubyClass", "name"}, new Class[]{RubyModule.class, String.class}, entry.sourceModule, site.name()).insert(0, "method", DynamicMethod.class, (Object)method2);
        }
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.info(site.name() + "\tbound to method_missing for " + String.valueOf(method2) + ", " + Bootstrap.logMethod(method2), new Object[0]);
        }
        return binder.invokeVirtualQuiet(LOOKUP, "call").handle();
    }

    MethodHandle buildAttrHandle(CacheEntry entry, IRubyObject self2) {
        DynamicMethod method2 = entry.method;
        if (method2 instanceof AttrReaderMethod && this.arity == 0) {
            AttrReaderMethod attrReader = (AttrReaderMethod)method2;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = self2.getType().getVariableAccessorForWrite(varName);
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(this.name() + "\tbound as field attr reader " + Bootstrap.logMethod(method2) + ":" + ((AttrReaderMethod)method2).getVariableName(), new Object[0]);
                } else {
                    LOG.info(this.name() + "\tbound as attr reader " + Bootstrap.logMethod(method2) + ":" + ((AttrReaderMethod)method2).getVariableName(), new Object[0]);
                }
            }
            return this.createAttrReaderHandle(self2, self2.getType(), accessor);
        }
        if (method2 instanceof AttrWriterMethod && this.arity == 1) {
            AttrWriterMethod attrReader = (AttrWriterMethod)method2;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = self2.getType().getVariableAccessorForWrite(varName);
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(this.name() + "\tbound as field attr writer " + Bootstrap.logMethod(method2) + ":" + ((AttrWriterMethod)method2).getVariableName(), new Object[0]);
                } else {
                    LOG.info(this.name() + "\tbound as attr writer " + Bootstrap.logMethod(method2) + ":" + ((AttrWriterMethod)method2).getVariableName(), new Object[0]);
                }
            }
            return this.createAttrWriterHandle(self2, self2.getType(), accessor);
        }
        return null;
    }

    private MethodHandle createAttrReaderHandle(IRubyObject self2, RubyClass cls, VariableAccessor accessor) {
        MethodHandle getValue2;
        MethodHandle filter = cls.getClassRuntime().getNullToNilHandle();
        SmartBinder binder = SmartBinder.from(this.signature).permute("self");
        if (accessor instanceof FieldVariableAccessor) {
            MethodHandle getter = ((FieldVariableAccessor)accessor).getGetter();
            getValue2 = binder.filterReturn(filter).cast(Object.class, self2.getClass()).invoke(getter).handle();
        } else {
            getValue2 = binder.filterReturn(filter).cast(Object.class, Object.class).prepend("accessor", accessor).invokeVirtualQuiet(LOOKUP, "get").handle();
        }
        return getValue2;
    }

    private MethodHandle createAttrWriterHandle(IRubyObject self2, RubyClass cls, VariableAccessor accessor) {
        MethodHandle setValue2;
        MethodHandle filter = Binder.from(IRubyObject.class, Object.class, new Class[0]).drop(0).constant(cls.getRuntime().getNil());
        SmartBinder binder = SmartBinder.from(this.signature).permute("self", "arg0");
        if (accessor instanceof FieldVariableAccessor) {
            MethodHandle setter = ((FieldVariableAccessor)accessor).getSetter();
            setValue2 = binder.filterReturn(filter).cast(Void.TYPE, self2.getClass(), Object.class).invoke(setter).handle();
        } else {
            setValue2 = binder.filterReturn(filter).cast(Void.TYPE, Object.class, Object.class).prepend("accessor", accessor).invokeVirtualQuiet(LOOKUP, "set").handle();
        }
        return setValue2;
    }

    MethodHandle buildJittedHandle(CacheEntry entry, boolean blockGiven) {
        MethodHandle mh = null;
        CompiledIRMethod compiledIRMethod = null;
        DynamicMethod method2 = entry.method;
        RubyModule sourceModule = entry.sourceModule;
        if (method2 instanceof CompiledIRMethod) {
            compiledIRMethod = (CompiledIRMethod)method2;
        } else if (method2 instanceof MixedModeIRMethod) {
            DynamicMethod actualMethod = ((MixedModeIRMethod)method2).getActualMethod();
            if (actualMethod instanceof CompiledIRMethod) {
                compiledIRMethod = (CompiledIRMethod)actualMethod;
            } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tfailed direct binding due to unjitted method " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        if (compiledIRMethod != null) {
            SmartBinder binder = SmartBinder.from(this.signature).permute("context", "self", "arg.*", "block");
            if (this.arity == -1) {
                mh = (MethodHandle)compiledIRMethod.getHandle();
            } else if (this.arity == 0) {
                specific = compiledIRMethod.getHandleFor(this.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.insert(2, "args", IRubyObject.NULL_ARRAY);
                }
            } else {
                specific = compiledIRMethod.getHandleFor(this.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.collect("args", "arg.*", Helpers.constructObjectArrayHandle(this.arity));
                }
            }
            if (!blockGiven) {
                binder = binder.append("block", Block.class, (Object)Block.NULL_BLOCK);
            }
            binder = binder.insert(1, "scope", StaticScope.class, (Object)compiledIRMethod.getStaticScope()).append("class", RubyModule.class, (Object)sourceModule).append("frameName", String.class, (Object)this.name());
            mh = binder.invoke(mh).handle();
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tbound directly to jitted method " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    MethodHandle buildNativeHandle(CacheEntry entry, boolean blockGiven) {
        MethodHandle mh = null;
        SmartBinder binder = null;
        DynamicMethod method2 = entry.method;
        if (method2 instanceof NativeCallMethod && ((NativeCallMethod)((Object)method2)).getNativeCall() != null) {
            NativeCallMethod nativeMethod = (NativeCallMethod)((Object)method2);
            DynamicMethod.NativeCall nativeCall = nativeMethod.getNativeCall();
            if (nativeCall.isJava()) {
                return JavaBootstrap.createJavaHandle(this, method2);
            }
            DynamicMethod.NativeCall exactNativeCall = InvokeSite.buildExactNativeCall(nativeCall, this.arity);
            if (exactNativeCall != null) {
                binder = SmartBinder.from(MethodHandles.lookup(), this.signature);
                nativeCall = exactNativeCall;
            } else {
                int nativeArgCount = InvokeSite.getArgCount(nativeCall.getNativeSignature(), nativeCall.isStatic());
                if (nativeArgCount >= 0) {
                    if (nativeArgCount == this.arity) {
                        binder = SmartBinder.from(MethodHandles.lookup(), this.signature);
                    } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                        LOG.info(this.name() + "\tdid not match the primary arity for a native method " + Bootstrap.logMethod(method2), new Object[0]);
                    }
                } else {
                    binder = this.arity == -1 ? SmartBinder.from(MethodHandles.lookup(), this.signature) : (this.arity == 0 ? SmartBinder.from(MethodHandles.lookup(), this.signature).insert(this.argOffset, "args", IRubyObject.NULL_ARRAY) : SmartBinder.from(MethodHandles.lookup(), this.signature).collect("args", "arg.*", Helpers.constructObjectArrayHandle(this.arity)));
                }
            }
            if (binder != null) {
                JRubyMethod anno;
                if (!nativeCall.hasContext()) {
                    binder = binder.drop("context");
                }
                if (nativeCall.hasBlock() && !blockGiven) {
                    binder = binder.append("block", Block.NULL_BLOCK);
                } else if (!nativeCall.hasBlock() && blockGiven) {
                    binder = binder.drop("block");
                }
                mh = nativeCall.isStatic() ? binder.permute("context", "self", "arg.*", "block").cast(nativeCall.getNativeReturn(), nativeCall.getNativeSignature()).invoke(nativeCall.getHandleQuiet(LOOKUP)).handle() : binder.permute("self", "context", "arg.*", "block").castArg("self", nativeCall.getNativeTarget()).castVirtual(nativeCall.getNativeReturn(), nativeCall.getNativeTarget(), nativeCall.getNativeSignature()).invoke(nativeCall.getHandleQuiet(LOOKUP)).handle();
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound directly to JVM method " + Bootstrap.logMethod(method2), new Object[0]);
                }
                if ((anno = nativeCall.getMethod().getAnnotation(JRubyMethod.class)) != null && anno.frame()) {
                    mh = InvocationLinker.wrapWithFrameOnly(this.signature, entry.sourceModule, this.name(), mh);
                }
            }
        }
        return mh;
    }

    private static DynamicMethod.NativeCall buildExactNativeCall(DynamicMethod.NativeCall nativeCall, int arity2) {
        DynamicMethod.NativeCall exactNativeCall;
        Method method2;
        Class[] args2 = nativeCall.getNativeSignature();
        int rubyArgCount = args2.length;
        boolean hasContext = false;
        boolean hasBlock = false;
        if (nativeCall.isStatic()) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --rubyArgCount;
                hasContext = true;
            }
            assert (args2.length >= 1);
            --rubyArgCount;
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --rubyArgCount;
                hasBlock = true;
            }
            if (rubyArgCount == 1) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    return null;
                }
                if (args2[1] == IRubyObject[].class) {
                    return null;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --rubyArgCount;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --rubyArgCount;
                hasBlock = true;
            }
            if (rubyArgCount == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    return null;
                }
                if (args2[0] == IRubyObject[].class) {
                    return null;
                }
            }
        }
        Class[] params2 = null;
        if (nativeCall.isStatic()) {
            if (hasContext) {
                if (hasBlock) {
                    if (arity2 == -1) {
                        params2 = CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
                    } else if (arity2 <= 3) {
                        params2 = CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, arity2, Block.class);
                    }
                } else if (arity2 == -1) {
                    params2 = CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class);
                } else if (arity2 <= 3) {
                    params2 = CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, arity2);
                }
            } else if (hasBlock) {
                if (arity2 == -1) {
                    params2 = CodegenUtils.params(IRubyObject.class, IRubyObject[].class, Block.class);
                } else if (arity2 <= 3) {
                    params2 = CodegenUtils.params(IRubyObject.class, IRubyObject.class, arity2, Block.class);
                }
            } else if (arity2 == -1) {
                params2 = CodegenUtils.params(IRubyObject.class, IRubyObject[].class);
            } else if (arity2 <= 3) {
                params2 = CodegenUtils.params(IRubyObject.class, IRubyObject.class, arity2);
            }
        } else if (hasContext) {
            if (hasBlock) {
                if (arity2 == -1) {
                    params2 = CodegenUtils.params(ThreadContext.class, IRubyObject[].class, Block.class);
                } else if (arity2 <= 3) {
                    params2 = CodegenUtils.params(ThreadContext.class, IRubyObject.class, arity2, Block.class);
                }
            } else if (arity2 == -1) {
                params2 = CodegenUtils.params(ThreadContext.class, IRubyObject[].class);
            } else if (arity2 <= 3) {
                params2 = CodegenUtils.params(ThreadContext.class, IRubyObject.class, arity2);
            }
        } else if (hasBlock) {
            if (arity2 == -1) {
                params2 = CodegenUtils.params(IRubyObject[].class, Block.class);
            } else if (arity2 <= 3) {
                params2 = CodegenUtils.params(IRubyObject.class, arity2, Block.class);
            }
        } else if (arity2 == -1) {
            params2 = CodegenUtils.params(IRubyObject[].class);
        } else if (arity2 <= 3) {
            params2 = CodegenUtils.params(IRubyObject.class, arity2);
        }
        if (params2 != null && (method2 = (exactNativeCall = new DynamicMethod.NativeCall(nativeCall.getNativeTarget(), nativeCall.getNativeName(), nativeCall.getNativeReturn(), params2, nativeCall.isStatic(), false)).getMethodQuiet()) != null && method2.getAnnotation(JRubyMethod.class) != null) {
            return exactNativeCall;
        }
        return null;
    }

    private static int getArgCount(Class[] args2, boolean isStatic) {
        int length2 = args2.length;
        boolean hasContext = false;
        if (isStatic) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            assert (args2.length >= 1);
            --length2;
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[1] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[0] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        }
        return length2;
    }

    public String name() {
        return this.methodName;
    }

    public InvokeSite(MethodType type2, String name2, CallType callType, boolean literalClosure, int flags2, String file2, int line) {
        super(type2);
        int arity2;
        Signature startSig;
        this.methodName = name2;
        this.callType = callType;
        this.literalClosure = literalClosure;
        this.file = file2;
        this.line = line;
        this.flags = flags2;
        if (callType == CallType.SUPER) {
            startSig = JRubyCallSite.STANDARD_SUPER_SIG;
            this.functional = false;
            this.argOffset = 4;
        } else if (callType == CallType.FUNCTIONAL || callType == CallType.VARIABLE) {
            startSig = JRubyCallSite.STANDARD_FSITE_SIG;
            this.functional = true;
            this.argOffset = 2;
        } else {
            startSig = JRubyCallSite.STANDARD_SITE_SIG;
            this.functional = false;
            this.argOffset = 3;
        }
        if (type2.parameterType(type2.parameterCount() - 1) == Block.class) {
            arity2 = type2.parameterCount() - (this.argOffset + 1);
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i2 = 0; i2 < arity2; ++i2) {
                    startSig = startSig.appendArg("arg" + i2, IRubyObject.class);
                }
            }
            this.fullSignature = this.signature = (startSig = startSig.appendArg("block", Block.class));
        } else {
            arity2 = type2.parameterCount() - this.argOffset;
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i3 = 0; i3 < arity2; ++i3) {
                    startSig = startSig.appendArg("arg" + i3, IRubyObject.class);
                }
            }
            this.signature = startSig;
            this.fullSignature = startSig.appendArg("block", Block.class);
        }
        this.arity = arity2;
        this.fallback = this.prepareBinder(true).invokeVirtualQuiet(LOOKUP, "invoke");
    }

    public static CallSite bootstrap(InvokeSite site, MethodHandles.Lookup lookup) {
        site.setInitialTarget(site.fallback);
        return site;
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        MethodHandle mh;
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        String methodName = this.methodName;
        CacheEntry entry = selfClass.searchWithCache(methodName);
        boolean passSymbol = false;
        if (this.methodMissing(entry, caller2)) {
            entry = this.methodMissingEntry(context, selfClass, methodName, entry);
            passSymbol = !(entry.method instanceof RubyKernel.MethodMissingMethod) && !(entry.method instanceof Helpers.MethodMissingWrapper);
            mh = this.buildGenericHandle(entry);
        } else {
            mh = this.getHandle(context, self2, entry);
        }
        this.finishBinding(entry, mh, self2, selfClass, switchPoint);
        return this.performIndirectCall(context, self2, args2, block, methodName, passSymbol, entry);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        MethodHandle mh;
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        String methodName = this.methodName;
        CacheEntry entry = selfClass.searchWithCache(methodName);
        boolean passSymbol = false;
        if (this.methodMissing(entry)) {
            entry = this.methodMissingEntry(context, selfClass, methodName, entry);
            passSymbol = !(entry.method instanceof RubyKernel.MethodMissingMethod) && !(entry.method instanceof Helpers.MethodMissingWrapper);
            mh = this.buildGenericHandle(entry);
        } else {
            mh = this.getHandle(context, self2, entry);
        }
        this.finishBinding(entry, mh, self2, selfClass, switchPoint);
        return this.performIndirectCall(context, self2, args2, block, methodName, passSymbol, entry);
    }

    private CacheEntry methodMissingEntry(ThreadContext context, RubyClass selfClass, String methodName, CacheEntry entry) {
        if (this.testThresholds(selfClass) == CacheAction.FAIL) {
            this.logFail();
            this.failHandle();
        } else {
            this.logMethodMissing();
        }
        Visibility visibility = entry.method.getVisibility();
        return Helpers.createMethodMissingEntry(context, selfClass, this.callType, visibility, entry.token, methodName);
    }

    private void finishBinding(CacheEntry entry, MethodHandle mh, IRubyObject self2, RubyClass selfClass, SwitchPoint switchPoint) {
        boolean acceptsKeywords;
        if (this.literalClosure) {
            mh = Binder.from(mh.type()).tryFinally(InvokeSite.getBlockEscape(this.signature)).invoke(mh);
        }
        SmartBinder baseBinder = SmartBinder.from(this.signature.changeReturn(Void.TYPE)).permute("context");
        DynamicMethod method2 = entry.method;
        if (method2 instanceof AbstractIRMethod) {
            AbstractIRMethod irMethod = (AbstractIRMethod)method2;
            acceptsKeywords = true;
        } else {
            DynamicMethod.NativeCall nativeCall;
            JRubyMethod jrubyMethod;
            NativeCallMethod nativeMethod;
            acceptsKeywords = method2 instanceof NativeCallMethod && (nativeMethod = (NativeCallMethod)((Object)method2)).getNativeCall() != null ? ((jrubyMethod = (nativeCall = nativeMethod.getNativeCall()).getMethod().getAnnotation(JRubyMethod.class)) != null ? jrubyMethod.keywords() : false) : true;
        }
        SmartHandle callInfoWrapper = this.flags == 0 || !acceptsKeywords ? baseBinder.invokeStaticQuiet(LOOKUP, ThreadContext.class, "clearCallInfo") : baseBinder.append("flags", this.flags).invokeStaticQuiet(LOOKUP, IRRuntimeHelpers.class, "setCallInfo");
        mh = MethodHandles.foldArguments(mh, callInfoWrapper.handle());
        this.updateInvocationTarget(mh, self2, selfClass, entry.method, switchPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject performIndirectCall(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, String methodName, boolean passSymbol, CacheEntry entry) {
        RubyModule sourceModule = entry.sourceModule;
        DynamicMethod method2 = entry.method;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (this.literalClosure) {
            try {
                if (passSymbol) {
                    IRubyObject iRubyObject = method2.call(context, self2, sourceModule, "method_missing", Helpers.arrayOf((IRubyObject)Convert.asSymbol(context, methodName), args2), block);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = method2.call(context, self2, sourceModule, methodName, args2, block);
                return iRubyObject;
            }
            finally {
                block.escape();
            }
        }
        return method2.call(context, self2, sourceModule, methodName, passSymbol ? Helpers.arrayOf((IRubyObject)Convert.asSymbol(context, methodName), args2) : args2, block);
    }

    private static MethodHandle getBlockEscape(Signature signature) {
        Signature voidSignature = signature.changeReturn(Void.TYPE);
        MethodHandle escape = BLOCK_ESCAPES.get(voidSignature);
        if (escape == null) {
            escape = SmartBinder.from(voidSignature).permute("block").invoke(ESCAPE_BLOCK).handle();
            BLOCK_ESCAPES.put(voidSignature, escape);
        }
        return escape;
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, args2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, args2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public IRubyObject failf(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, args2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, args2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) throws Throwable {
        return this.fail(context, caller2, self2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject failf(ThreadContext context, IRubyObject self2, Block block) throws Throwable {
        return this.failf(context, self2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, block);
    }

    public IRubyObject failf(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, arg1, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public IRubyObject failf(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, arg1, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, arg1, arg2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject failf(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        IRRuntimeHelpers.setCallInfo(context, this.flags);
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, arg1, arg2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    public Binder prepareBinder(boolean varargs) {
        SmartBinder binder = SmartBinder.from(this.signature);
        if ((varargs || this.arity > 3) && this.arity != -1) {
            binder = this.arity == 0 ? binder.insert(this.argOffset, "args", IRubyObject.NULL_ARRAY) : binder.collect("args", "arg[0-9]+", Helpers.constructObjectArrayHandle(this.arity));
        }
        if (this.signature.lastArgType() != Block.class) {
            binder = binder.append("block", Block.NULL_BLOCK);
        }
        binder = binder.insert(0, "site", this);
        return binder.binder();
    }

    protected MethodHandle getHandle(ThreadContext context, IRubyObject self2, CacheEntry entry) throws Throwable {
        boolean blockGiven = this.signature.lastArgType() == Block.class;
        MethodHandle mh = this.buildNewInstanceHandle(entry, self2);
        if (mh == null) {
            mh = this.buildNotEqualHandle(context, entry, self2);
        }
        if (mh == null) {
            mh = this.buildNativeHandle(entry, blockGiven);
        }
        if (mh == null) {
            mh = this.buildJavaFieldHandle(entry, self2);
        }
        if (mh == null) {
            mh = this.buildIndyHandle(entry);
        }
        if (mh == null) {
            mh = this.buildJittedHandle(entry, blockGiven);
        }
        if (mh == null) {
            mh = this.buildAttrHandle(entry, self2);
        }
        if (mh == null) {
            mh = this.buildAliasHandle(context, entry, self2);
        }
        if (mh == null) {
            mh = this.buildStructHandle(entry);
        }
        if (mh == null) {
            mh = this.buildGenericHandle(entry);
        }
        assert (mh != null) : "we should have a method handle of some sort by now";
        return mh;
    }

    MethodHandle buildJavaFieldHandle(CacheEntry entry, IRubyObject self2) throws Throwable {
        DynamicMethod method2 = entry.method;
        if (method2 instanceof InstanceFieldGetter) {
            if (this.arity != 0 || this.signature.lastArgType() == Block.class) {
                return null;
            }
            Field field = ((InstanceFieldGetter)method2).getField();
            if (!IRubyObject.class.isAssignableFrom(field.getType())) {
                return null;
            }
            MethodHandle fieldHandle = (MethodHandle)method2.getHandle();
            if (fieldHandle != null) {
                return fieldHandle;
            }
            fieldHandle = LOOKUP.unreflectGetter(field);
            MethodHandle filter = self2.getRuntime().getNullToNilHandle();
            MethodHandle receiverConverter = Binder.from(field.getDeclaringClass(), IRubyObject.class, new Class[0]).cast(Object.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy");
            fieldHandle = Binder.from(this.type()).permute(2).filter(0, receiverConverter).filterReturn(filter).cast(fieldHandle.type()).invoke(fieldHandle);
            method2.setHandle(fieldHandle);
            return fieldHandle;
        }
        if (method2 instanceof InstanceFieldSetter) {
            if (this.arity != 1 || this.signature.lastArgType() == Block.class) {
                return null;
            }
            Field field = ((InstanceFieldSetter)method2).getField();
            if (!IRubyObject.class.isAssignableFrom(field.getType())) {
                return null;
            }
            MethodHandle fieldHandle = (MethodHandle)method2.getHandle();
            if (fieldHandle != null) {
                return fieldHandle;
            }
            fieldHandle = LOOKUP.unreflectSetter(field);
            MethodHandle receiverConverter = Binder.from(field.getDeclaringClass(), IRubyObject.class, new Class[0]).cast(Object.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy");
            fieldHandle = Binder.from(this.type()).permute(2, 3).filter(0, receiverConverter).filterReturn(MethodHandles.constant(IRubyObject.class, self2.getRuntime().getNil())).cast(fieldHandle.type()).invoke(fieldHandle);
            method2.setHandle(fieldHandle);
            return fieldHandle;
        }
        return null;
    }

    MethodHandle buildNewInstanceHandle(CacheEntry entry, IRubyObject self2) {
        RubyClass recvClass;
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        if (method2 == self2.getRuntime().getBaseNewMethod() && self2 instanceof RubyClass && (recvClass = (RubyClass)self2).getAllocator() != null) {
            MethodType type2 = this.type();
            if (!this.functional) {
                type2 = type2.dropParameterTypes(1, 2);
            }
            CallSite initSite = SelfInvokeSite.bootstrap(LOOKUP, "callFunctional:initialize", type2, this.literalClosure ? 1 : 0, this.flags, this.file, this.line);
            MethodHandle initHandle = initSite.dynamicInvoker();
            if (!this.functional) {
                initHandle = MethodHandles.dropArguments(initHandle, 1, new Class[]{IRubyObject.class});
            }
            MethodHandle allocFilter = Binder.from(IRubyObject.class, IRubyObject.class, new Class[0]).cast(IRubyObject.class, RubyClass.class).insert(0, new Class[]{ObjectAllocator.class, Ruby.class}, new Object[]{recvClass.getAllocator(), self2.getRuntime()}).invokeVirtualQuiet(LOOKUP, "allocate");
            mh = SmartBinder.from(LOOKUP, this.signature).filter("self", allocFilter).fold("dummy", initHandle).permute("self").identity().handle();
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tbound as new instance creation " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    MethodHandle buildNotEqualHandle(ThreadContext context, CacheEntry entry, IRubyObject self2) {
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        if (method2.isBuiltin()) {
            String negatedCall;
            MethodType type2 = this.type();
            if (!this.functional) {
                type2 = type2.dropParameterTypes(1, 2);
            }
            if (method2.getImplementationClass() == Access.basicObjectClass(context) && this.name().equals("!=")) {
                negatedCall = "callFunctional:==";
            } else if (method2.getImplementationClass() == Access.kernelModule(context) && this.name().equals("!~")) {
                negatedCall = "callFunctional:=~";
            } else {
                return null;
            }
            CallSite equalSite = SelfInvokeSite.bootstrap(LOOKUP, negatedCall, type2, this.literalClosure ? 1 : 0, this.flags, this.file, this.line);
            if (equalSite != null) {
                MethodHandle equalHandle = equalSite.dynamicInvoker();
                if (!this.functional) {
                    equalHandle = MethodHandles.dropArguments(equalHandle, 1, new Class[]{IRubyObject.class});
                }
                MethodHandle filter = MethodHandles.insertArguments(NEGATE, 1, context.nil, context.tru, context.fals);
                mh = MethodHandles.filterReturnValue(equalHandle, filter);
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound as specialized " + this.name() + ":" + Bootstrap.logMethod(method2), new Object[0]);
                }
            }
        }
        return mh;
    }

    public static IRubyObject negate(IRubyObject object, RubyNil nil, RubyBoolean.True tru, RubyBoolean.False fals) {
        return object == nil || object == fals ? tru : fals;
    }

    MethodHandle buildAliasHandle(ThreadContext context, CacheEntry entry, IRubyObject self2) throws Throwable {
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        if (method2 instanceof PartialDelegatingMethod) {
            PartialDelegatingMethod delegate = (PartialDelegatingMethod)method2;
            DynamicMethod innerMethod = delegate.getRealMethod();
            mh = this.getHandle(context, self2, new CacheEntry(innerMethod, entry.sourceModule, entry.token));
        } else if (method2 instanceof AliasMethod) {
            AliasMethod alias = (AliasMethod)method2;
            DynamicMethod innerMethod = alias.getRealMethod();
            String name2 = alias.getName();
            MethodType type2 = this.type();
            if (!this.functional) {
                type2 = type2.dropParameterTypes(1, 2);
            }
            InvokeSite innerSite = (InvokeSite)SelfInvokeSite.bootstrap(LOOKUP, "callFunctional:" + name2, type2, this.literalClosure ? 1 : 0, this.flags, this.file, this.line);
            mh = innerSite.getHandle(context, self2, new CacheEntry(innerMethod, entry.sourceModule, entry.token));
            if (!this.functional) {
                mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
            }
            alias.setHandle(mh);
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tbound directly through alias to " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    MethodHandle buildStructHandle(CacheEntry entry) throws Throwable {
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        if (method2 instanceof RubyStruct.Accessor) {
            if (this.arity == 0) {
                RubyStruct.Accessor accessor = (RubyStruct.Accessor)method2;
                int index2 = accessor.getIndex();
                mh = SmartBinder.from(this.signature).cast(this.signature.replaceArg("self", "self", RubyStruct.class)).permute("self").append("index", index2).invokeVirtualQuiet(LOOKUP, "get").handle();
                method2.setHandle(mh);
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound directly as Struct accessor " + Bootstrap.logMethod(method2), new Object[0]);
                }
            } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tcalled struct accessor with arity > 0 " + Bootstrap.logMethod(method2), new Object[0]);
            }
        } else if (method2 instanceof RubyStruct.Mutator) {
            if (this.arity == 1) {
                RubyStruct.Mutator mutator = (RubyStruct.Mutator)method2;
                int index3 = mutator.getIndex();
                mh = SmartBinder.from(this.signature).cast(this.signature.replaceArg("self", "self", RubyStruct.class)).permute("self", "arg0").append("index", index3).invokeVirtualQuiet(LOOKUP, "set").handle();
                method2.setHandle(mh);
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound directly as Struct mutator " + Bootstrap.logMethod(method2), new Object[0]);
                }
            } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tcalled struct mutator with arity > 1 " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    protected void updateInvocationTarget(MethodHandle target2, IRubyObject self2, RubyModule testClass, DynamicMethod method2, SwitchPoint switchPoint) {
        CacheAction cacheAction = this.testThresholds(testClass);
        this.setTarget(switch (cacheAction.ordinal()) {
            case 0 -> {
                this.logFail();
                yield this.failHandle();
            }
            case 3 -> {
                this.logPic(method2);
                yield this.wrapWithGuards(target2, self2, testClass, switchPoint, this.getTarget());
            }
            case 1, 2 -> {
                this.logBind(cacheAction);
                yield this.wrapWithGuards(target2, self2, testClass, switchPoint, this.fallback);
            }
            default -> throw new RuntimeException("invalid cache action: " + String.valueOf((Object)cacheAction));
        });
    }

    private MethodHandle wrapWithGuards(MethodHandle target2, IRubyObject self2, RubyModule testClass, SwitchPoint switchPoint, MethodHandle fallback) {
        SmartHandle test2 = this.testTarget(self2, testClass);
        MethodHandle result2 = MethodHandles.guardWithTest(test2.handle(), target2, fallback);
        result2 = switchPoint.guardWithTest(result2, fallback);
        this.tracker.addType(testClass.id);
        return result2;
    }

    protected SmartHandle testTarget(IRubyObject self2, RubyModule testClass) {
        if (self2 instanceof RubySymbol || self2 instanceof RubyFixnum || self2 instanceof RubyFloat || self2 instanceof RubyNil || self2 instanceof RubyBoolean.True || self2 instanceof RubyBoolean.False) {
            return SmartBinder.from(this.signature.asFold(Boolean.TYPE)).permute("self").insert(1, "selfJavaType", self2.getClass()).cast(Boolean.TYPE, Object.class, Class.class).invoke(TEST_CLASS);
        }
        return SmartBinder.from(this.signature.changeReturn(Boolean.TYPE)).permute("self").insert(0, "selfClass", RubyClass.class, (Object)testClass).invokeStaticQuiet(LOOKUP, InvokeSite.class, "testType");
    }

    private void logMethodMissing() {
        if (LOG_BINDING) {
            LOG.debug(this.methodName + "\ttriggered site #" + this.siteID + " method_missing (" + this.file + ":" + this.line + ")", new Object[0]);
        }
    }

    private void logBind(CacheAction action) {
        if (LOG_BINDING) {
            LOG.debug(this.methodName + "\ttriggered site #" + this.siteID + " " + String.valueOf((Object)action) + " (" + this.file + ":" + this.line + ")", new Object[0]);
        }
    }

    private void logPic(DynamicMethod method2) {
        if (LOG_BINDING) {
            LOG.debug(this.methodName + "\tsite #" + this.siteID + " added to PIC " + InvokeSite.logMethod(method2), new Object[0]);
        }
    }

    private void logFail() {
        if (LOG_BINDING) {
            if (this.tracker.clearCount() > Options.INVOKEDYNAMIC_MAXFAIL.load()) {
                LOG.info(this.methodName + "\tat site #" + this.siteID + " failed more than " + String.valueOf(Options.INVOKEDYNAMIC_MAXFAIL.load()) + " times; bailing out (" + this.file + ":" + this.line + ")", new Object[0]);
            } else if (this.tracker.seenTypesCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
                LOG.info(this.methodName + "\tat site #" + this.siteID + " encountered more than " + String.valueOf(Options.INVOKEDYNAMIC_MAXPOLY.load()) + " types; bailing out (" + this.file + ":" + this.line + ")", new Object[0]);
            }
        }
    }

    private MethodHandle failHandle() {
        return this.prepareBinder(false).invokeVirtualQuiet(LOOKUP, this.functional ? "failf" : "fail");
    }

    CacheAction testThresholds(RubyModule testClass) {
        if (this.tracker.clearCount() > Options.INVOKEDYNAMIC_MAXFAIL.load() || !this.tracker.hasSeenType(testClass.id) && this.tracker.seenTypesCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            return CacheAction.FAIL;
        }
        if (this.tracker.seenTypesCount() > 0 && this.getTarget() != null && !this.tracker.hasSeenType(testClass.id)) {
            return CacheAction.PIC;
        }
        this.tracker.clearTypes();
        return this.boundOnce ? CacheAction.REBIND : CacheAction.BIND;
    }

    public static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self2) {
        context.callThreadPoll();
        return RubyBasicObject.getMetaClass(self2);
    }

    @Override
    public void setTarget(MethodHandle target2) {
        super.setTarget(target2);
        this.boundOnce = true;
    }

    public void setInitialTarget(MethodHandle target2) {
        super.setTarget(target2);
    }

    public boolean methodMissing(CacheEntry entry, IRubyObject caller2) {
        DynamicMethod method2 = entry.method;
        return method2.isUndefined() || !this.methodName.equals("method_missing") && !method2.isCallableFrom(caller2, this.callType);
    }

    public boolean methodMissing(CacheEntry entry) {
        DynamicMethod method2 = entry.method;
        return method2.isUndefined();
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject[] args2, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, args2, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject arg0, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, arg0, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, arg0, arg1, arg2, block);
    }

    private static String logMethod(DynamicMethod method2) {
        return "[#" + method2.getSerialNumber() + " " + String.valueOf(method2.getImplementationClass()) + "]";
    }

    @JIT
    public static boolean testClass(Object object, Class clazz) {
        return object.getClass() == clazz;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name() + ",arity=" + this.arity + ",type=" + String.valueOf(this.type()) + ",file=" + this.file + ",line=" + this.line + "]";
    }

    static {
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.setDebugEnable(true);
        }
        LOG_BINDING = LOG.isDebugEnabled();
        LOOKUP = MethodHandles.lookup();
        ESCAPE_BLOCK = Binder.from(Void.TYPE, Block.class, new Class[0]).invokeVirtualQuiet(LOOKUP, "escape");
        BLOCK_ESCAPES = Collections.synchronizedMap(new HashMap());
        NEGATE = Binder.from(IRubyObject.class, IRubyObject.class, RubyNil.class, RubyBoolean.True.class, RubyBoolean.False.class).invokeStaticQuiet(LOOKUP, InvokeSite.class, "negate");
        TEST_CLASS = Binder.from(Boolean.TYPE, Object.class, Class.class).invokeStaticQuiet(LOOKUP, InvokeSite.class, "testClass");
    }

    static enum CacheAction {
        FAIL,
        BIND,
        REBIND,
        PIC;

    }
}

