# Community-built tools around Jujutsu

Many of these tools are not complete yet, just like Jujutsu itself. But they
already simplify many workflows and can improve your experience.

!!! warning
    The listed tools are community‑maintained; the Jujutsu project does not
    review, endorse, or guarantee their quality or security.

## Diffedit3

Diffedit3 is a web-based alternate to Meld, as it no longer is packaged and
available for all Distros. Its creator is also a frequent contributor.

Find it [here][diffedit3]

## GG - GUI for JJ

GG is a cross platform GUI for Jujutsu which makes all graph manipulating
workflows quite easy. Take a look at its README.md as it quite descriptive.

Find it [here][gg].

## Hunk.nvim

Hunk.nvim is a Neovim based diff-editor for Jujutsu which can be used as an
alternative to the default `:builtin` diff-editor.

Find it [here][hunk.nvim].

## JJ-FZF

Centered around the `jj log` graph view, jj-fzf provides previews of diffs, the
evolution-log, browses the op log and offers a large number of key bindings for
commonly used `jj` operations from rebase to undo, and helps with divergent commits.

Find it [here][jj-fzf].

## JJ TUI

This is TUI for Jujutsu built in Ocaml, it is unopiniated and its creator is
open to feedback.

Find it [here][jj_tui].

## Jujutsu Kaizen

Jujutsu Kaizen is a plugin for Visual Studio Code. The goal of this extension is to bring the great UX of Jujutsu into the VS Code UI.
Its developers are currently focused on achieving parity for commonly used features of VS Code's built-in Git extension, such as the various operations possible via the Source Control view.

Find it [here][jjk].

## LazyJJ

lazyjj is a lazygit inspired TUI for Jujutsu.

Find it [here][lazyjj].

## Visual Jujutsu

VJJ is a fzf (fuzzy finder) wrapper for Jujutsu, which is meant to be used
interactively in the terminal.

Find it [here][vjj].

## VisualJJ

VisualJJ is a plugin for Visual Studio Code which provides native integration
for Jujutsu, not relying on Git colocation. Unlike other tools on this page,
VisualJJ is not open-source.

Find it [here][visualjj].

## Jujutsu UI

jjui is a terminal user interface for working with Jujutsu version control system.

Find it [here][jjui].

## Selvejj

Selvejj is a JetBrains plugin for integrating Jujutsu as a first-class VCS within the IDE.

Find it [here][selvejj].

## PSCompletions

PSCompletions is a completion manager for a better and simpler tab-completion experience in PowerShell.

It can provide completions via `psc add jj`, or offer a better completion menu for the official completions.

Find it [here][PSCompletions].

## Finding other integrations

You can find other community contributed tools and integrations in our
[Wiki].

[diffedit3]: https://github.com/ilyagr/diffedit3
[gg]: https://github.com/gulbanana/gg
[hunk.nvim]: https://github.com/julienvincent/hunk.nvim
[jj-fzf]: https://github.com/tim-janik/jj-fzf
[jj_tui]: https://github.com/faldor20/jj_tui
[jjk]: https://github.com/keanemind/jjk
[jjui]: https://github.com/idursun/jjui
[lazyjj]: https://github.com/Cretezy/lazyjj
[PSCompletions]: https://github.com/abgox/PSCompletions
[selvejj]: https://selvejj.com
[visualjj]: https://www.visualjj.com
[vjj]: https://github.com/noahmayr/vjj
[Wiki]: https://github.com/jj-vcs/jj/wiki
