'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const internals = require('../internals.cjs');

function remoteProperty(definition) {
  return (target, context) => {
    const property = context.name;
    context.addInitializer(function defineProperty() {
      this.constructor.createProperty(property, definition);
    });
    return {
      set(value) {
        target.set.call(this, value);
        internals.updateRemoteElementProperty(this, property, value);
      },
      init(value) {
        internals.updateRemoteElementProperty(this, property, value);
        return value;
      }
    };
  };
}

exports.remoteProperty = remoteProperty;
