/**
 * Adds an event handler function to any kind of object capable of
 * handling events. This includes DOM `EventTarget`s and Node `EventEmitter`s.
 */
function addEventHandler(target, event, handler, flags) {
  if (typeof target === 'function') {
    target(event, handler, flags);
    return;
  }
  if (typeof target.addEventListener === 'function') {
    target.addEventListener(event, handler, flags);
    return;
  }
  if (typeof target.on === 'function') {
    const signalAbort = new AbortController();
    const teardown = () => {
      signalAbort.abort();
      target.off(event, normalizedListener);
    };
    const normalizedListener = flags?.once ? (...args) => {
      teardown();
      return handler(...args);
    } : handler;
    target.on(event, normalizedListener);
    flags?.signal?.addEventListener('abort', teardown, {
      signal: signalAbort.signal
    });
  }

  // TODO throw error
}

export { addEventHandler };
