import { signal } from '@preact/signals-core';

function eventTargetSignal(eventTarget, options) {
  return new EventTargetSignal(eventTarget, options);
}
class EventTargetSignal {
  #signal;
  get value() {
    return this.#signal.value;
  }
  peek() {
    return this.#signal.peek();
  }
  constructor(eventTarget, {
    initial,
    signal: abortSignal,
    event = 'change',
    value
  } = {}) {
    this.#signal = signal(initial);
    eventTarget.addEventListener(event, event => {
      this.#signal.value = value ? value(event) : 'detail' in event ? event.detail : event.data;
    }, {
      signal: abortSignal
    });
  }
}

export { EventTargetSignal, eventTargetSignal };
