/**
 * Returns a promise that resolves after a given amount of time.
 */
function sleep(time, {
  signal
} = {}) {
  let timeout;
  let resolvePromise;
  signal?.addEventListener('abort', () => {
    if (resolvePromise == null || timeout == null) return;
    clearTimeout(timeout);
    resolvePromise();
  });
  return new Promise(resolve => {
    resolvePromise = resolve;
    timeout = setTimeout(() => resolve(), time);
  });
}

export { sleep };
