import type { AnyThread, ThreadSerialization, ThreadSerializationOptions } from '../Thread.ts';
/**
 * A thread serialization that can transfer an extended set of JavaScript types, by converting
 * them to a simpler, JSON-compatible representation. Aside from the types natively supported
 * by JSON, this serializer can also serialize and deserialize the following types:
 *
 * - `Date`
 * - `Error`
 * - `RegExp`
 * - `Map`
 * - `Set`
 * - `Uint8Array`
 */
export declare class ThreadSerializationJSON implements ThreadSerialization {
    #private;
    constructor(options?: ThreadSerializationOptions);
    /**
     * Serializes a value into a JSON-compatible format that can be transferred between threads.
     */
    serialize(value: unknown, thread: AnyThread, transferable?: any[]): any;
    /**
     * Deserializes a JSON-compatible value from another thread.
     */
    deserialize(value: unknown, thread: AnyThread): any;
}
//# sourceMappingURL=ThreadSerializationJSON.d.ts.map