'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const RemoteElement = require('./elements/RemoteElement.cjs');
const RemoteFragmentElement = require('./elements/RemoteFragmentElement.cjs');
const RemoteRootElement = require('./elements/RemoteRootElement.cjs');
const RemoteReceiverElement = require('./elements/RemoteReceiverElement.cjs');
const RemoteEvent = require('./elements/RemoteEvent.cjs');
const RemoteMutationObserver = require('./elements/RemoteMutationObserver.cjs');
const internals = require('./elements/internals.cjs');
const remoteSlots = require('./elements/decorators/remote-slots.cjs');
const remoteProperties = require('./elements/decorators/remote-properties.cjs');
const remoteProperty = require('./elements/decorators/remote-property.cjs');
const customElement = require('./elements/decorators/custom-element.cjs');
const BooleanOrString = require('./elements/property-types/BooleanOrString.cjs');
const connection = require('./elements/connection.cjs');



exports.RemoteElement = RemoteElement.RemoteElement;
exports.createRemoteElement = RemoteElement.createRemoteElement;
exports.RemoteFragmentElement = RemoteFragmentElement.RemoteFragmentElement;
exports.RemoteRootElement = RemoteRootElement.RemoteRootElement;
exports.RemoteReceiverElement = RemoteReceiverElement.RemoteReceiverElement;
exports.RemoteEvent = RemoteEvent.RemoteEvent;
exports.RemoteMutationObserver = RemoteMutationObserver.RemoteMutationObserver;
exports.callRemoteElementMethod = internals.callRemoteElementMethod;
exports.connectRemoteNode = internals.connectRemoteNode;
exports.disconnectRemoteNode = internals.disconnectRemoteNode;
exports.remoteId = internals.remoteId;
exports.serializeRemoteNode = internals.serializeRemoteNode;
exports.setRemoteId = internals.setRemoteId;
exports.updateRemoteElementAttribute = internals.updateRemoteElementAttribute;
exports.updateRemoteElementEventListener = internals.updateRemoteElementEventListener;
exports.updateRemoteElementProperty = internals.updateRemoteElementProperty;
exports.remoteSlots = remoteSlots.remoteSlots;
exports.remoteProperties = remoteProperties.remoteProperties;
exports.remoteProperty = remoteProperty.remoteProperty;
exports.customElement = customElement.customElement;
exports.BooleanOrString = BooleanOrString.BooleanOrString;
exports.BatchingRemoteConnection = connection.BatchingRemoteConnection;
