import type { RemoteConnection } from '../types.ts';
/**
 * Builds on the browser’s [`MutationObserver`](https://developer.mozilla.org/en-US/docs/Web/API/MutationObserver)
 * to detect changes in a remote element, and to communicate those changes in a way
 * that Remote DOM can understand. You create this object from a “remote
 * connection”, which you’ll generally get from the [`@remote-dom/core/receiver`](/packages/core#remote-domcorereceiver)
 * package. Then, you’ll observe changes in the HTML element that contains your
 * tree of remote elements.
 *
 * @example
 * import {RemoteMutationObserver} from '@remote-dom/core/elements';
 *
 * const observer = new RemoteMutationObserver(connection);
 *
 * // Now, any changes to the `body` element will be communicated
 * // to the host environment.
 * observer.observe(document.body);
 */
export declare class RemoteMutationObserver extends MutationObserver {
    #private;
    readonly connection: RemoteConnection;
    constructor(connection: RemoteConnection);
    /**
     * Starts watching changes to the element, and communicates changes to the
     * host environment. By default, this method will also communicate any initial
     * children of the element to the host environment.
     */
    observe(target: Node, options?: MutationObserverInit & {
        /**
         * The ID of the root element. If you do not provide an ID, a default value
         * considered to be the “root” element will be used. This means that its remote
         * attributes, properties, event listeners, and children will all be sent as the root
         * element to the remote receiver.
         *
         * You need to override the default behavior if you are wanting to observe a set of
         * nodes, and send each of them to the remote receiver. This may be needed when observing
         * a `DocumentFragment` or `<template>` element, which allow for multiple children.
         */
        id?: string;
        /**
         * Whether to send the initial state of the tree to the mutation
         * callback.
         *
         * @default true
         */
        initial?: boolean;
    }): void;
    disconnect({ empty }?: {
        empty?: boolean;
    }): void;
}
//# sourceMappingURL=RemoteMutationObserver.d.ts.map