import { NodeType, NS, NEXT, OWNER_ELEMENT, NAME, VALUE, HOOKS } from './constants.mjs';
import { Node } from './Node.mjs';

class Attr extends Node {
  nodeType = (() => NodeType.ATTRIBUTE_NODE)();
  [NS] = null;
  [NEXT] = null;
  [OWNER_ELEMENT] = null;
  constructor(name, value, namespace) {
    super();
    this[NAME] = name;
    this[VALUE] = value;
    if (namespace) this[NS] = namespace;
  }
  get nodeName() {
    return this[NAME];
  }
  set nodeName(_readonly) {}
  get name() {
    return this[NAME];
  }
  set name(_readonly) {}
  get value() {
    return this[VALUE];
  }
  set value(value) {
    const str = String(value);
    this[VALUE] = str;
    const ownerElement = this[OWNER_ELEMENT];
    if (!ownerElement) return;
    this[HOOKS].setAttribute?.(ownerElement, this[NAME], str, this[NS]);
  }
  get nodeValue() {
    return this.value;
  }
  set nodeValue(value) {
    this.value = value;
  }
  get ownerElement() {
    return this[OWNER_ELEMENT];
  }
  get namespaceURI() {
    return this[NS];
  }
  get specified() {
    return true;
  }
}

export { Attr };
