import { DATA, HOOKS } from './constants.mjs';
import { ChildNode } from './ChildNode.mjs';

class CharacterData extends ChildNode {
  [DATA] = '';
  constructor(data) {
    super();
    this[DATA] = data == null ? '' : String(data);
  }
  setData(data) {
    let str = '';
    if (data != null) {
      str = typeof data === 'string' ? data : String(data);
    }
    this[DATA] = str;
    this[HOOKS].setText?.(this, str);
  }
  get data() {
    return this[DATA];
  }
  set data(data) {
    this.setData(data);
  }
}

export { CharacterData };
