import { CHILD, NEXT, NodeType, DATA, NAME, ATTRIBUTES, VALUE } from './constants.mjs';

// const voidElements = {
//   img: true,
//   image: true,
// };
// const elementTokenizer =
//   /(?:<([a-z][a-z0-9-:]*)( [^<>'"\n=\s]+=(['"])[^>'"\n]*\3)*\s*(\/?)\s*>|<\/([a-z][a-z0-9-:]*)>|([^&<>]+))/gi;
// const attributeTokenizer = / ([^<>'"\n=\s]+)=(['"])([^>'"\n]*)\2/g;

const elementTokenizer = /(?:<([a-z][a-z0-9-:]*)((?:[\s]+[^<>'"=\s]+(?:=(['"])[^]*?\3|=[^>'"\s]*|))*)[\s]*(\/?)\s*>|<\/([a-z][a-z0-9-:]*)>|<!--(.*?)-->|([^&<>]+))/gi;
const attributeTokenizer = /\s([^<>'"=\n\s]+)(?:=(["'])([\s\S]*?)\2|=([^>'"\n\s]*)|)/g;
function parseHtml(html, contextNode) {
  const document = contextNode.ownerDocument;
  const root = document.createDocumentFragment();
  const stack = [root];
  let parent = root;
  let token;
  elementTokenizer.lastIndex = 0;
  while (token = elementTokenizer.exec(html)) {
    const tag = token[1];
    if (tag) {
      const node = document.createElement(tag);
      const attrs = token[2];
      attributeTokenizer.lastIndex = 0;
      let t;
      while (t = attributeTokenizer.exec(attrs)) {
        node.setAttribute(t[1], t[3] || t[4] || '');
      }
      parent.append(node);
      // if (voidElements[tag] === true) continue;
      stack.push(parent);
      parent = node;
    } else if (token[5]) {
      parent = stack.pop() || root;
    } else if (token[6]) {
      parent.append(document.createComment(token[6]));
    } else {
      parent.append(token[7]);
    }
  }
  return root;
}
function serializeChildren(parentNode) {
  let out = '';
  let child = parentNode[CHILD];
  while (child) {
    out += serializeNode(child);
    child = child[NEXT];
  }
  return out;
}
function serializeNode(node) {
  switch (node.nodeType) {
    case NodeType.ELEMENT_NODE:
      {
        const el = node;
        let out = `<${el[NAME]}`;
        let attr = el[ATTRIBUTES]?.[CHILD];
        while (attr) {
          out += ` ${attr[NAME]}`;
          let value = attr[VALUE];
          if (value !== '') {
            value = String(value).replace(/&/g, '&amp;').replace(/"/g, '&quot;');
            out += `="${value}"`;
          }
          attr = attr[NEXT];
        }
        out += '>';
        out += serializeChildren(el);
        // let child = el[CHILD];
        // while (child) {
        //   out += serialize(child);
        //   child = child[NEXT];
        // }
        out += `</${el[NAME]}>`;
        return out;
      }
    case NodeType.TEXT_NODE:
      {
        const text = node;
        return text[DATA].replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
      }
    case NodeType.COMMENT_NODE:
      {
        const text = node;
        return `<!--${text[DATA]}-->`;
      }
  }
  return '';
}

export { parseHtml, serializeChildren, serializeNode };
