import { NAME, NamespaceURI, NodeType, IS_CONNECTED } from './constants.ts';
import type { Window } from './Window.ts';
import type { Node } from './Node.ts';
import { Event } from './Event.ts';
import { ParentNode } from './ParentNode.ts';
import { Element } from './Element.ts';
import { Text } from './Text.ts';
import { Comment } from './Comment.ts';
import { DocumentFragment } from './DocumentFragment.ts';
import { HTMLBodyElement } from './HTMLBodyElement.ts';
import { HTMLHeadElement } from './HTMLHeadElement.ts';
import { HTMLHtmlElement } from './HTMLHtmlElement.ts';
export declare class Document extends ParentNode {
    nodeType: NodeType;
    [NAME]: string;
    body: HTMLBodyElement;
    head: HTMLHeadElement;
    documentElement: HTMLHtmlElement;
    defaultView: Window;
    [IS_CONNECTED]: boolean;
    constructor(defaultView: Window);
    createElement(localName: string): Element;
    createElementNS(namespaceURI: NamespaceURI, localName: string): Element;
    createTextNode(data: any): Text;
    createComment(data: any): Comment;
    createDocumentFragment(): DocumentFragment;
    createEvent(): Event;
    importNode(node: Node, deep?: boolean): Node;
    adoptNode(node: Node): Node;
}
export declare function createNode<T extends Node>(node: T, ownerDocument: Document): T;
export declare function createElement<T extends Element>(ownerDocument: Document, name: string, namespace?: NamespaceURI): T;
export declare function setupElement<T extends Element>(element: T, ownerDocument: Document, name: string, namespace?: NamespaceURI): T;
export declare function adoptNode(node: Node, document: Document): void;
//# sourceMappingURL=Document.d.ts.map