import { PATH, IS_TRUSTED, STOP_IMMEDIATE_PROPAGATION } from './constants.ts';
import type { EventTarget } from './EventTarget.ts';
export declare const enum EventPhase {
    NONE = 0,
    CAPTURING_PHASE = 1,
    AT_TARGET = 2,
    BUBBLING_PHASE = 3
}
export declare const CAPTURE_MARKER = "@";
export interface EventInit {
    bubbles?: boolean;
    cancelable?: boolean;
    composed?: boolean;
}
export declare class Event {
    type: string;
    static NONE: EventPhase;
    static CAPTURING_PHASE: EventPhase;
    static AT_TARGET: EventPhase;
    static BUBBLING_PHASE: EventPhase;
    timeStamp: number;
    target: EventTarget | null;
    currentTarget: EventTarget | null;
    srcElement: EventTarget | null;
    bubbles: boolean;
    cancelable: boolean;
    composed: boolean;
    defaultPrevented: boolean;
    cancelBubble: boolean;
    eventPhase: EventPhase;
    data?: any;
    [PATH]: EventTarget[];
    [IS_TRUSTED]: boolean;
    [STOP_IMMEDIATE_PROPAGATION]: boolean;
    constructor(type: string, options?: EventInit);
    get isTrusted(): boolean;
    composedPath(): EventTarget[];
    stopPropagation(): void;
    stopImmediatePropagation(): void;
    preventDefault(): void;
    set returnValue(value: boolean);
    get returnValue(): boolean;
    /** @deprecated */
    initEvent(type: string, bubbles?: boolean, cancelable?: boolean): void;
}
export declare function fireEvent(event: Event, currentTarget: EventTarget, phase: EventPhase.BUBBLING_PHASE | EventPhase.CAPTURING_PHASE): void;
//# sourceMappingURL=Event.d.ts.map