import type { Element } from './Element.ts';
import type { ParentNode } from './ParentNode.ts';
declare const enum Combinator {
    Descendant = 0,
    Child = 1,
    Sibling = 2,
    Adjacent = 3,
    Inner = 4
}
declare const enum MatcherType {
    Unknown = 0,
    Element = 1,
    Id = 2,
    Class = 3,
    Attribute = 4,
    Pseudo = 5,
    Function = 6
}
interface Part {
    combinator: Combinator;
    matchers: Matcher[];
}
interface Matcher {
    type: MatcherType;
    name: string;
    value?: string;
}
export declare function querySelector(within: ParentNode, selector: string): null;
export declare function querySelectorAll(within: ParentNode, selector: string): Element[];
export declare function parseSelector(selector: string): Part[];
export {};
//# sourceMappingURL=selectors.d.ts.map