import { useRemoteReceived } from './hooks/remote-received.mjs';
import { jsx, Fragment } from 'react/jsx-runtime';

/**
 * Renders a remote React element to the host using React.
 */
function RemoteTextRenderer({
  remote,
  receiver
}) {
  const text = useRemoteReceived(remote, receiver);
  return text ? /*#__PURE__*/jsx(Fragment, {
    children: text.data
  }) : null;
}

export { RemoteTextRenderer };
